﻿/*
Run this script to update the MET/CONNECT database from 3.4.0 to 3.5.0

You are recommended to back up your database before running this script

*/
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
IF EXISTS (SELECT * FROM tempdb..sysobjects WHERE id=OBJECT_ID('tempdb..#tmpErrors')) DROP TABLE #tmpErrors
GO
CREATE TABLE #tmpErrors (Error int)
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL SERIALIZABLE
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '2.3.0' )
BEGIN
	RAISERROR(N'*** Database script for version 2.3.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.0.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.0.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.1.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.1.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.2.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.2.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.3.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.3.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.4.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.4.0 is missing. ***', 20,-1) WITH LOG
END
GO

-- set database compatibility level to SQL Server 2012
DECLARE @comp NVARCHAR(max);
SET @comp = N'ALTER DATABASE [' + (SELECT DB_NAME()) + ']
SET COMPATIBILITY_LEVEL = 110 '
EXEC sp_executesql @comp
GO

-- No need to process if we have a 3.5.0 version record
IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE nVersionUID = 'E78E3F09-F7D1-4517-8228-8B91401054C3' )
BEGIN
	BEGIN TRANSACTION

	-- get the current collation and switch it to case-sensitive
	DECLARE @sql NVARCHAR(max);
	DECLARE @coll_cs NVARCHAR(100);
	SELECT @coll_cs = collation_name FROM sys.databases WHERE name = (SELECT DB_NAME());
	SELECT @coll_cs = REPLACE(@coll_cs, N'CI', N'CS');


	TRUNCATE TABLE [dbo].[Translations]

    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	-->>MTM-5003/MTM-5013/MTM-6199<<-- 
	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_MCRT]', 'IF') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GetMETCAL_Results_MCRT]'
		DROP FUNCTION [dbo].[udf_GetMETCAL_Results_MCRT]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_MCRT]', 'IF') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GetMETCAL_Results_MCRT]'

		EXEC sp_executesql N'

			/********************************************************************************
				udf_GetMETCAL_Results_MCRT
				Gets the MET/CAL results data for the Runtime view

				Parameters:
				@nCallSheetResultUID - UID for call sheet result record

				(C) 2016-2021 Fluke Calibration
			-----------------------------------------------------------------
				CHANGE HISTORY
				09/21/2016  MM      Initially created
				11/30/2021  AC      Account for Marginal condition in RESULT column
				12/15/2021  AC      Changed PERCENT_TOL field to return >500 % when nToleranceErrorPercent > 500
			*********************************************************************************/

				CREATE FUNCTION [dbo].[udf_GetMETCAL_Results_MCRT] ( @nCallSheetResultUID [uniqueidentifier] = ''4CA22A04-0079-4033-84A5-E5968C7F3F17'' )      -- new record GUID
				RETURNS TABLE
				AS
				RETURN
				(
					SELECT
						p.nPointUID,
						p.nPointOrdinal AS [ROW NUMBER],
						COALESCE(p.cPointPassFailStatus,'''') + '' '' + COALESCE(p.cCondition,'''') AS [RESULT],
						pes.cField009 AS [NO],
						COALESCE([dbo].[udf_GET_FormattedValueEx](p.nUUTRange, p.nUUTRangeFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nUUTRangeUnitUID),'''') AS [RANGE],
						COALESCE([dbo].[udf_GET_FormattedValueEx](p.nUUT, p.nUUTFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nUUTUnitUID),'''') AS [UUT_INDICATED],
						COALESCE([dbo].[udf_GET_FormattedValueEx](p.nReference, p.nReferenceFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nReferenceUnitUID),'''') AS [SYSTEM_ACTUAL],
						pel.lField001 AS [C],
						COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nModifier1, pun.nModifier1FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nModifier1UnitUID),'''') AS [MODIFIER],
						COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nError, tol.nErrorFormatUID) + '' '' + [dbo].[udf_GET_Unit](tol.nErrorUnitUID),'''') AS [ERROR],
						CASE WHEN tol.nToleranceErrorPercent > ''500'' THEN ''>500 %''
							 ELSE COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nToleranceErrorPercent, [dbo].[udf_GET_nFormatUIDFromScale](0)),'''') + CASE WHEN tol.nToleranceErrorPercent IS NULL THEN '''' ELSE '' %'' END
						END AS [PERCENT_TOL]
					FROM
						CallSheetResults csr
						LEFT JOIN Points p ON p.nCallSheetResultUID = csr.nCallSheetResultUID
						LEFT JOIN PointExStrings pes ON pes.nPointUID = p.nPointUID
						LEFT JOIN PointUncertainties pun ON pun.nPointUID = p.nPointUID
						LEFT JOIN PointTolerances tol ON tol.nPointUID = p.nPointUID
						LEFT JOIN PointExLogicals pel ON pel.nPointUID = p.nPointUID
					WHERE
						csr.nCallSheetResultUID = @nCallSheetResultUID
					AND
						p.lDeleted = 0 AND p.lActive <> 0
					AND
						csr.lDeleted = 0 AND csr.lActive <> 0
				);'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	-->>MTM-5013/MTM-6199<<-- 
	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_FullData]', 'IF') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GetMETCAL_Results_FullData]'
		DROP FUNCTION [dbo].[udf_GetMETCAL_Results_FullData]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_FullData]', 'IF') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GetMETCAL_Results_FullData]'

		EXEC sp_executesql N'
	/****************************************************************
        udf_GetMETCAL_Results_FullData
        Gets the MET/CAL results for the Full Data view

        Parameters:
        @nCallSheetResultUID - UID for call sheet result record

        (C) 2011-2021 Fluke Calibration
        -----------------------------------------------------------------
        CHANGE HISTORY
        05/22/2012  EdW     Initially created
        06/08/2012  EdW     Added p.nPointUID and modifed WHERE
        08/17/2012  MM      Excluded deleted records
        09/04/2012  MM      COALESCE point ordinal, nClaim (may be NULL now)
        09/11/2012  MM      COALESCE nSetTime,nCoverageFactor,nSystemCoverageFactor,
                            nConfidenceLevel,nReadingErrorPercent,nReadingErrorReferencePercent,
                            nFullScaleErrorPercent,nFullScaleErrorReferencePercent,nSetErrorPercent,
                            nSetFullScaleErrorPercent,nToleranceErrorPercent,nChiSquared
        04/08/2013  MM      Return numbers as numbers
                            Return NULL values as NULL
        08/14/2013  MM      Changed parameter to be work order result
        05/16/2014  MM      References for ftol3 and utol3 were crossed
        07/02/2014  MM      Format numeric values with the correct separator
        10/22/2015  MM      Added ManualTemplateRow
        02/25/2016  MM      Added Data Condition
        04/04/2016  MM      Changed for GUIDs
        09/21/2016  MM      Removed parent record fields from the data
        12/15/2021  AC      Changed ToleranceErrorPercent field to return >500 % when nToleranceErrorPercent > 500
	*******************************************************************************/

	CREATE FUNCTION [dbo].[udf_GetMETCAL_Results_FullData] (
		@nCallSheetResultUID [uniqueidentifier] = ''4CA22A04-0079-4033-84A5-E5968C7F3F17''      -- new record GUID
	    )
	RETURNS TABLE
	AS
	RETURN
	(
		SELECT
			p.nPointUID,
			COALESCE(mt.cTemplateName, '''') + ''  '' + COALESCE(mtr.cDescription, '''') AS [ManualTemplateRow],
			COALESCE([dbo].[udf_GET_FormattedValueEx](p.nUUT, p.nUUTFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nUUTUnitUID),'''') AS [UUT],
			COALESCE([dbo].[udf_GET_FormattedValueEx](p.nReference, p.nReferenceFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nReferenceUnitUID),'''') AS [Reference],
			COALESCE([dbo].[udf_GET_FormattedValueEx](p.nCardinalPoint, p.nCardinalPointFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nCardinalPointUnitUID),'''') AS [CardinalPoint],
			COALESCE([dbo].[udf_GET_FormattedValueEx](p.nCorrection, p.nCorrectionFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nCorrectionUnitUID),'''') AS [Correction],
			COALESCE([dbo].[udf_GET_FormattedValueEx](p.nUUTRange, p.nUUTRangeFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nUUTRangeUnitUID),'''') AS [UUTRange],
			COALESCE([dbo].[udf_GET_FormattedValueEx](p.nSystemAccuracy, p.nSystemAccuracyFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nSystemAccuracyUnitUID),'''') AS [SystemAccuracy],
			p.nPointOrdinal,
			p.tPointDateTime,
			p.cPointLabel,
			p.cPointStatusFlags,
			p.cPointPassFailStatus,
			p.cFunctionSelectCode,
			p.cPointDescription,
			p.cRemarks,
			p.cOverrideRemarks,
			p.cDesignation,
			p.cTagId,
			p.nSetTime,
			p.cCondition,
			p.nClaim,
			p.lAccredited,
			p.lPrinted,
			p.lUUTIsFixed,
			p.lOverride,
			p.lHeader,
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField001, pen.nField001FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField001UnitUID),'''') AS [Field001],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField002, pen.nField002FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField002UnitUID),'''') AS [Field002],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField003, pen.nField003FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField003UnitUID),'''') AS [Field003],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField004, pen.nField004FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField004UnitUID),'''') AS [Field004],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField005, pen.nField005FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField005UnitUID),'''') AS [Field005],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField006, pen.nField006FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField006UnitUID),'''') AS [Field006],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField007, pen.nField007FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField007UnitUID),'''') AS [Field007],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField008, pen.nField008FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField008UnitUID),'''') AS [Field008],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField009, pen.nField009FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField009UnitUID),'''') AS [Field009],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField010, pen.nField010FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField010UnitUID),'''') AS [Field010],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField011, pen.nField011FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField011UnitUID),'''') AS [Field011],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField012, pen.nField012FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField012UnitUID),'''') AS [Field012],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField013, pen.nField013FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField013UnitUID),'''') AS [Field013],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField014, pen.nField014FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField014UnitUID),'''') AS [Field014],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField015, pen.nField015FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField015UnitUID),'''') AS [Field015],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField016, pen.nField016FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField016UnitUID),'''') AS [Field016],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField017, pen.nField017FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField017UnitUID),'''') AS [Field017],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField018, pen.nField018FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField018UnitUID),'''') AS [Field018],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField019, pen.nField019FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField019UnitUID),'''') AS [Field019],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField020, pen.nField020FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField020UnitUID),'''') AS [Field020],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField021, pen.nField021FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField021UnitUID),'''') AS [Field021],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField022, pen.nField022FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField022UnitUID),'''') AS [Field022],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField023, pen.nField023FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField023UnitUID),'''') AS [Field023],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField024, pen.nField024FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField024UnitUID),'''') AS [Field024],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField025, pen.nField025FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField025UnitUID),'''') AS [Field025],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField026, pen.nField026FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField026UnitUID),'''') AS [Field026],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField027, pen.nField027FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField027UnitUID),'''') AS [Field027],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField028, pen.nField028FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField028UnitUID),'''') AS [Field028],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField029, pen.nField029FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField029UnitUID),'''') AS [Field029],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField030, pen.nField030FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField030UnitUID),'''') AS [Field030],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField031, pen.nField031FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField031UnitUID),'''') AS [Field031],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField032, pen.nField032FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField032UnitUID),'''') AS [Field032],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField033, pen.nField033FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField033UnitUID),'''') AS [Field033],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField034, pen.nField034FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField034UnitUID),'''') AS [Field034],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField035, pen.nField035FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField035UnitUID),'''') AS [Field035],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField036, pen.nField036FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField036UnitUID),'''') AS [Field036],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField037, pen.nField037FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField037UnitUID),'''') AS [Field037],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField038, pen.nField038FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField038UnitUID),'''') AS [Field038],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField039, pen.nField039FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField039UnitUID),'''') AS [Field039],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField040, pen.nField040FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField040UnitUID),'''') AS [Field040],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField041, pen.nField041FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField041UnitUID),'''') AS [Field041],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField042, pen.nField042FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField042UnitUID),'''') AS [Field042],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField043, pen.nField043FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField043UnitUID),'''') AS [Field043],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField044, pen.nField044FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField044UnitUID),'''') AS [Field044],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField045, pen.nField045FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField045UnitUID),'''') AS [Field045],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField046, pen.nField046FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField046UnitUID),'''') AS [Field046],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField047, pen.nField047FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField047UnitUID),'''') AS [Field047],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField048, pen.nField048FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField048UnitUID),'''') AS [Field048],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField049, pen.nField049FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField049UnitUID),'''') AS [Field049],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField050, pen.nField050FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField050UnitUID),'''') AS [Field050],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField051, pen.nField051FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField051UnitUID),'''') AS [Field051],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField052, pen.nField052FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField052UnitUID),'''') AS [Field052],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField053, pen.nField053FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField053UnitUID),'''') AS [Field053],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField054, pen.nField054FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField054UnitUID),'''') AS [Field054],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField055, pen.nField055FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField055UnitUID),'''') AS [Field055],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField056, pen.nField056FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField056UnitUID),'''') AS [Field056],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField057, pen.nField057FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField057UnitUID),'''') AS [Field057],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField058, pen.nField058FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField058UnitUID),'''') AS [Field058],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField059, pen.nField059FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField059UnitUID),'''') AS [Field059],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField060, pen.nField060FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField060UnitUID),'''') AS [Field060],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nGuardBandLower, pun.nGuardBandLowerFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nGuardBandLowerUnitUID),'''') AS [GuardBandLower],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nGuardBandUpper, pun.nGuardBandUpperFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nGuardBandUpperUnitUID),'''') AS [GuardBandUpper],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertainty, pun.nUncertaintyFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyUnitUID),'''') AS [Uncertainty],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyExpanded, pun.nUncertaintyExpandedFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyExpandedUnitUID),'''') AS [UncertaintyExpanded],
		    COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyDominant, pun.nUncertaintyDominantFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyDominantUnitUID),'''') AS [UncertaintyDominant],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyStandard, pun.nUncertaintyStandardFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyStandardUnitUID),'''') AS [UncertaintyStandard],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nLowerLimit, pun.nLowerLimitFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nLowerLimitUnitUID),'''') AS [LOWER_LIMIT],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUpperLimit, pun.nUpperLimitFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUpperLimitUnitUID),'''') AS [UPPER_LIMIT],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter1, pun.nUncertaintyParameter1FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter1UnitUID),'''') AS [UncertaintyParameter1],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter2, pun.nUncertaintyParameter2FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter2UnitUID),'''') AS [UncertaintyParameter2],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter3, pun.nUncertaintyParameter3FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter3UnitUID),'''') AS [UncertaintyParameter3],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter4, pun.nUncertaintyParameter4FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter4UnitUID),'''') AS [UncertaintyParameter4],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter5, pun.nUncertaintyParameter5FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter5UnitUID),'''') AS [UncertaintyParameter5],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter6, pun.nUncertaintyParameter6FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter6UnitUID),'''') AS [UncertaintyParameter6],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter7, pun.nUncertaintyParameter7FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter7UnitUID),'''') AS [UncertaintyParameter7],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter8, pun.nUncertaintyParameter8FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter8UnitUID),'''') AS [UncertaintyParameter8],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter9, pun.nUncertaintyParameter9FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter9UnitUID),'''') AS [UncertaintyParameter9],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter10, pun.nUncertaintyParameter10FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter10UnitUID),'''') AS [UncertaintyParameter10],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nModifier1, pun.nModifier1FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nModifier1UnitUID),'''') AS [Modifier1],
			COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nModifier2, pun.nModifier2FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nModifier2UnitUID),'''') AS [Modifier2],
		    COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nS1, pun.nS1FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nS1UnitUID),'''') AS [S1],
		    COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nS2, pun.nS2FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nS2UnitUID),'''') AS [S2],
			pun.cGuardBandMethod,
			pun.cUncertaintyMethod,
			pun.nCoverageFactor,
			pun.nSystemCoverageFactor,
			pun.nConfidenceLevel,
			pun.cStudentsT,
			pun.cSensitivity1,
			pun.cSensitivity2,
			pun.cSensitivity3,
			pun.cSensitivity4,
			pun.cSensitivity5,
			pun.cSensitivity6,
			pun.cSensitivity7,
			pun.cSensitivity8,
			pun.cSensitivity9,
			pun.cSensitivity10,
			pun.cDegreesOfFreedom1,
			pun.cDegreesOfFreedom2,
			pun.cDegreesOfFreedom3,
			pun.cDegreesOfFreedom4,
			pun.cDegreesOfFreedom5,
			pun.cDegreesOfFreedom6,
			pun.cDegreesOfFreedom7,
			pun.cDegreesOfFreedom8,
			pun.cDegreesOfFreedom9,
			pun.cDegreesOfFreedom10,
			pun.cEquilibrationParameters,
			pun.lStudentsT,
			pun.lDominant,
			pun.lWelchSatterthwaite,
			pel.lField001,
			pel.lField002,
			pel.lField003,
			pel.lField004,
			pel.lField005,
			pel.lField006,
			pel.lField007,
			pel.lField008,
			pel.lField009,
			pel.lField010,
			pel.lField011,
			pel.lField012,
			pel.lField013,
			pel.lField014,
			pel.lField015,
			pel.lField016,
			pel.lField017,
			pel.lField018,
			pel.lField019,
			pel.lField020,
			pel.lField021,
			pel.lField022,
			pel.lField023,
			pel.lField024,
			pel.lField025,
			pel.lField026,
			pel.lField027,
			pel.lField028,
			pel.lField029,
			pel.lField030,
			pel.lField031,
			pel.lField032,
			pel.lField033,
			pel.lField034,
			pel.lField035,
			pel.lField036,
			pel.lField037,
			pel.lField038,
			pel.lField039,
			pel.lField040,
			pel.lField041,
			pel.lField042,
			pel.lField043,
			pel.lField044,
			pel.lField045,
			pel.lField046,
			pel.lField047,
			pel.lField048,
			pel.lField049,
			pel.lField050,
			pel.lField051,
			pel.lField052,
			pel.lField053,
			pel.lField054,
			pel.lField055,
			pel.lField056,
			pel.lField057,
			pel.lField058,
			pel.lField059,
			pel.lField060,
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nTolerance, tol.nToleranceFormatUID) + '' '' + [dbo].[udf_GET_Unit](tol.nToleranceUnitUID),'''') AS [Tolerance],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nTolerancePositive, tol.nTolerancePositiveFormatUID) + '' '' + [dbo].[udf_GET_Unit](tol.nTolerancePositiveUnitUID),'''') AS [TolerancePositive],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nToleranceNegative, tol.nToleranceNegativeFormatUID) + '' '' + [dbo].[udf_GET_Unit](tol.nToleranceNegativeUnitUID),'''') AS [ToleranceNegative],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nReferenceTolerance, tol.nReferenceToleranceFormatUID) + '' '' + [dbo].[udf_GET_Unit](tol.nReferenceToleranceUnitUID),'''') AS [ReferenceTolerance],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nError, tol.nErrorFormatUID) + '' '' + [dbo].[udf_GET_Unit](tol.nErrorUnitUID),'''') AS [Error],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nToleranceError, tol.nToleranceErrorFormatUID) + '' '' + [dbo].[udf_GET_Unit](tol.nToleranceErrorUnitUID),'''') AS [ToleranceError],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nReadingErrorPercent, [dbo].[udf_GET_nFormatUIDFromScale](0)),'''') + CASE WHEN tol.nReadingErrorPercent IS NULL THEN '''' ELSE '' %'' END AS [ReadingErrorPercent],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nReadingErrorReferencePercent, [dbo].[udf_GET_nFormatUIDFromScale](0)),'''') + CASE WHEN tol.nReadingErrorReferencePercent IS NULL THEN '''' ELSE '' %'' END AS [ReadingErrorReferencePercent],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nFullScaleErrorPercent, [dbo].[udf_GET_nFormatUIDFromScale](0)),'''') + CASE WHEN tol.nFullScaleErrorPercent IS NULL THEN '''' ELSE '' %'' END AS [FullScaleErrorPercent],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nFullScaleErrorReferencePercent, [dbo].[udf_GET_nFormatUIDFromScale](0)),'''') + CASE WHEN tol.nFullScaleErrorReferencePercent IS NULL THEN '''' ELSE '' %'' END AS [FullScaleErrorReferencePercent],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nSetErrorPercent, [dbo].[udf_GET_nFormatUIDFromScale](0)),'''') + CASE WHEN tol.nSetErrorPercent IS NULL THEN '''' ELSE '' %'' END AS [SetErrorPercent],
			COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nSetFullScaleErrorPercent, [dbo].[udf_GET_nFormatUIDFromScale](0)),'''') + CASE WHEN tol.nSetFullScaleErrorPercent IS NULL THEN '''' ELSE '' %'' END AS [SetFullScaleErrorPercent],
			CASE WHEN tol.nToleranceErrorPercent > ''500'' THEN ''>500 %''
					ELSE COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nToleranceErrorPercent, [dbo].[udf_GET_nFormatUIDFromScale](0)),'''') + CASE WHEN tol.nToleranceErrorPercent IS NULL THEN '''' ELSE '' %'' END
			END AS [ToleranceErrorPercent],
			tol.cToleranceReference,
			pes.cField001,
			pes.cField002,
			pes.cField003,
			pes.cField004,
			pes.cField005,
			pes.cField006,
			pes.cField007,
			pes.cField008,
			pes.cField009,
			pes.cField010,
			pes.cField011,
			pes.cField012,
			pes.cField013,
			pes.cField014,
			pes.cField015,
			pes.cField016,
			pes.cField017,
			pes.cField018,
			pes.cField019,
			pes.cField020,
			pes.cField021,
			pes.cField022,
			pes.cField023,
			pes.cField024,
			pes.cField025,
			pes.cField026,
			pes.cField027,
			pes.cField028,
			pes.cField029,
			pes.cField030,
			pes.cField031,
			pes.cField032,
			pes.cField033,
			pes.cField034,
			pes.cField035,
			pes.cField036,
			pes.cField037,
			pes.cField038,
			pes.cField039,
			pes.cField040,
			pes.cField041,
			pes.cField042,
			pes.cField043,
			pes.cField044,
			pes.cField045,
			pes.cField046,
			pes.cField047,
			pes.cField048,
			pes.cField049,
			pes.cField050,
			pes.cField051,
			pes.cField052,
			pes.cField053,
			pes.cField054,
			pes.cField055,
			pes.cField056,
			pes.cField057,
			pes.cField058,
			pes.cField059,
			pes.cField060,
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nMinimumUUT, stat.nMinimumUUTFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nMinimumUUTUnitUID),'''') AS [MinimumUUT],
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nMaximumUUT, stat.nMaximumUUTFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nMaximumUUTUnitUID),'''') AS [MaximumUUT],
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nMinimumReference, stat.nMinimumReferenceFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nMinimumReferenceUnitUID),'''') AS [MinimumReference],
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nMaximumReference, stat.nMaximumReferenceFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nMaximumReferenceUnitUID),'''') AS [MaximumReference],
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nUUTStandardDeviation, stat.nUUTStandardDeviationFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nUUTStandardDeviationUnitUID),'''') AS [UUTStandardDeviation],
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nUUTRawStandardDeviation, stat.nUUTRawStandardDeviationFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nUUTRawStandardDeviationUnitUID),'''') AS [UUTRawStandardDeviation],
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nReferenceStandardDeviation, stat.nReferenceStandardDeviationFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nReferenceStandardDeviationUnitUID),'''') AS [ReferenceStandardDeviation],
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nReference2StandardDeviation, stat.nReference2StandardDeviationFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nReference2StandardDeviationUnitUID),'''') AS [Reference2StandardDeviation],
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nReferenceRawStandardDeviation, stat.nReferenceRawStandardDeviationFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nReferenceRawStandardDeviationUnitUID),'''') AS [ReferenceRawStandardDeviation],
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nReferenceRaw2StandardDeviation, stat.nReferenceRaw2StandardDeviationFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nReferenceRaw2StandardDeviationUnitUID),'''') AS [ReferenceRaw2StandardDeviation],
			COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nSampleRate, stat.nSampleRateFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nSampleRateUnitUID),'''') AS [SampleRate],
			stat.nNumberOfSamplesReference,
			stat.nNumberOfSamplesUUT,
			stat.nNumberOfSamplesDiscarded,
			stat.nChiSquared,
			stat.lNoisy,
			stat.lReliable
		FROM
			CallSheetResults csr
			LEFT JOIN Points p ON p.nCallSheetResultUID = csr.nCallSheetResultUID
			LEFT JOIN PointExNumerics pen ON pen.nPointUID = p.nPointUID
			LEFT JOIN PointUncertainties pun ON pun.nPointUID = p.nPointUID
			LEFT JOIN PointExLogicals pel ON pel.nPointUID = p.nPointUID
			LEFT JOIN PointTolerances tol ON tol.nPointUID = p.nPointUID
			LEFT JOIN PointExStrings pes ON pes.nPointUID = p.nPointUID
			LEFT JOIN PointStatistics stat ON stat.nPointUID = p.nPointUID
			LEFT JOIN ManualTemplateRows mtr ON p.nManualTemplateRowUID = mtr.nManualTemplateRowUID
			LEFT JOIN ManualTemplates mt ON mtr.nManualTemplateUID = mt.nManualTemplateUID
		WHERE
			csr.nCallSheetResultUID = @nCallSheetResultUID
		AND
			p.lDeleted = 0 AND p.lActive <> 0
	);'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	-->>MTM-3973<<--
	IF OBJECT_ID(N'[dbo].[spl_ToolAssignments_DELETE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_ToolAssignments_DELETE]'
		DROP PROCEDURE [dbo].[spl_ToolAssignments_DELETE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_ToolAssignments_DELETE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_ToolAssignments_DELETE]'

		EXEC sp_executesql N'	
/****************************************************************
	spl_ToolAssignments_DELETE
	Deletes a single record by ID from the ToolAssignments table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 6/8/2021 (D)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_ToolAssignments_DELETE]

	@nToolAssignmentUID uniqueidentifier,
	@nUpdateUserUID 		[uniqueidentifier],
	@nUpdateFacilityUID		[uniqueidentifier],
	@retMsg					tinyint OUTPUT
	
AS
BEGIN

	DECLARE @recordID nvarchar(50)
	DECLARE @userID nvarchar(50)
	DECLARE @facilityUID nvarchar(50)
	DECLARE @now nvarchar(50)

	SELECT
		@recordID = CONVERT( nvarchar(50), @nToolAssignmentUID ),
		@now = CONVERT( nvarchar(50), GetUTCDate() ),
		@userID = CONVERT( nvarchar(50), @nUpdateUserUID ),
		@facilityUID = CONVERT( nvarchar(50), @nUpdateFacilityUID ) 

	EXEC sp_CheckAndDelete
		1,							-- MarkDeleted
		''ToolAssignments'',		-- TableName
		@recordID,					-- PrimaryKeyValue
		1,							-- IsPrimaryKeyString
		''ToolAssignmentEx ToolAssignmentFiles '',	-- TableExceptions
		1,							-- ExceptDeletions
		@facilityUID,				-- FacilityUID
		@userID,					-- UpdateUserUID
		@now,						-- UpdateTime
		@retMsg OUTPUT
	
	RETURN @retMsg
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	

	-->>MTM-4480<<--
	IF OBJECT_ID(N'[dbo].[spl_Assets_DELETE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Assets_DELETE]'
		DROP PROCEDURE [dbo].[spl_Assets_DELETE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Assets_DELETE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Assets_DELETE]'

		EXEC sp_executesql N'	
/****************************************************************
	spl_Assets_DELETE
	Deletes a single record by ID from the Assets table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 6/21/2021 (D)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_Assets_DELETE]

	@nAssetUID uniqueidentifier,
	@nUpdateUserUID 		[uniqueidentifier],
	@nUpdateFacilityUID		[uniqueidentifier],
	@retMsg					tinyint OUTPUT
	
AS
BEGIN

	DECLARE @recordID nvarchar(50)
	DECLARE @userID nvarchar(50)
	DECLARE @facilityUID nvarchar(50)
	DECLARE @now nvarchar(50)

	SELECT
		@recordID = CONVERT( nvarchar(50), @nAssetUID ),
		@now = CONVERT( nvarchar(50), GetUTCDate() ),
		@userID = CONVERT( nvarchar(50), @nUpdateUserUID ),
		@facilityUID = CONVERT( nvarchar(50), @nUpdateFacilityUID ) 

	EXEC sp_CheckAndDelete
		1,							-- MarkDeleted
		''Assets'',		-- TableName
		@recordID,					-- PrimaryKeyValue
		1,							-- IsPrimaryKeyString
		''AssetEx AssetLog AssetServices AssetFiles '',	-- TableExceptions
		1,							-- ExceptDeletions
		@facilityUID,				-- FacilityUID
		@userID,					-- UpdateUserUID
		@now,						-- UpdateTime
		@retMsg OUTPUT
	
	RETURN @retMsg
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-4398<<--
	IF EXISTS( SELECT * FROM sysobjects WHERE type='V' AND name='vw_Facilities' )
	BEGIN
		PRINT N'Dropping [dbo].[vw_Facilities]'

		DROP VIEW [dbo].[vw_Facilities]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[vw_Facilities]', 'V') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[vw_Facilities]'

		EXEC sp_executesql N'
/*
	10/24/2005	EdW	Added notes fields Casted as Text to prevent Crystal truncation issue 
	07/21/2014  MM  Fixed cast and quoted identifiers
	06/29/2021  MM  Add nTaxRate, lHandHeldUse, lNoRecall, lNoTax, lInspectionRate, FacilityEX
*/
CREATE VIEW [dbo].[vw_Facilities]
AS
SELECT
fac.nFacilityUID,
fac.nCategoryUID,
fac.nSubCategoryUID,
fac.nParentFacilityUID,
fac.nRate1,
fac.nRate2,
fac.nRate3,
fac.nTaxRate,
fac.cFacilityName,
fac.cFacilityType,
fac.cFacilityNumber,
fac.cFacilityWebSite,
fac.cTaxNumber,
fac.cIndustryCode,
fac.cCompanyCode,
fac.cDivision,
fac.cDistrict,
fac.cAccountNumber,
fac.cFedNumber,
fac.mNotes,
fac.lManufacturer,
fac.lCustomer,
fac.lSubContractor,
fac.lLab,
fac.lHandHeldUse,
fac.lNoRecall,
fac.lNoTax,
fac.lInspectionRate,
fac.lActive,
fac.lDeleted,
fac.lApproved,
fac.lAdded,
fac.nAddFacilityUID,
fac.nAddUserUID,
fac.tAddTime,
fac.nUpdateFacilityUID,
fac.nUpdateUserUID,
fac.tUpdateTime,
fac.tMobileTime,
cat.cDescription AS [cCategory],
scat.cDescription AS [cSubCategory],
parent.cFacilityName AS [cParentName],
parent.cFacilityNumber AS [cParentNumber],
CAST(fac.mNotes AS NTEXT) AS [mNotesText],
ex.nFacilityEXUID,
ex.cField1,
ex.cField2,
ex.cField3,
ex.cField4,
ex.cField5,
ex.cField6,
ex.cField7,
ex.cField8,
ex.cField9,
ex.cField10,
ex.cField11,
ex.cField12,
ex.cField13,
ex.cField14,
ex.cField15,
ex.cField16,
ex.cField17,
ex.cField18,
ex.cField19,
ex.cField20,
ex.cField21,
ex.cField22,
ex.cField23,
ex.cField24,
ex.cField25,
ex.tField1,
ex.tField2,
ex.tField3,
ex.tField4,
ex.tField5,
ex.tField6,
ex.tField7,
ex.tField8,
ex.tField9,
ex.tField10,
ex.nField1,
ex.nField2,
ex.nField3,
ex.nField4,
ex.nField5,
ex.nField6,
ex.nField7,
ex.nField8,
ex.nField9,
ex.nField10,
COALESCE(ex.lField1, 0) AS [lField1],
COALESCE(ex.lField2, 0) AS [lField2],
COALESCE(ex.lField3, 0) AS [lField3],
COALESCE(ex.lField4, 0) AS [lField4],
COALESCE(ex.lField5, 0) AS [lField5],
COALESCE(ex.lField6, 0) AS [lField6],
COALESCE(ex.lField7, 0) AS [lField7],
COALESCE(ex.lField8, 0) AS [lField8],
COALESCE(ex.lField9, 0) AS [lField9],
COALESCE(ex.lField10, 0) AS [lField10],
ex.mField1,
ex.mField2

FROM Facilities fac
LEFT JOIN Category AS cat ON fac.nCategoryUID = cat.nCategoryUID
LEFT JOIN SubCategory AS scat ON fac.nSubCategoryUID = scat.nSubCategoryUID
LEFT JOIN Facilities AS parent ON fac.nParentFacilityUID = parent.nFacilityUID
LEFT JOIN FacilityEX AS ex ON fac.nFacilityUID = ex.nFacilityUID
'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '33004c90-6aba-4ee9-b12d-e83bce6ae1dd')
	BEGIN
	    PRINT N'Adding Context Element for nRate1'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('33004c90-6aba-4ee9-b12d-e83bce6ae1dd','CA37CC2B-8CE2-4F1D-8457-8C94BE6D6B6E',N'Field',N'fac.nRate1',N'Rate 1',67,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '6d191566-413c-4f1b-a031-29b272d6771a')
	BEGIN
	    PRINT N'Adding Context Element Link for nRate1'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('6d191566-413c-4f1b-a031-29b272d6771a','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','33004c90-6aba-4ee9-b12d-e83bce6ae1dd',N'AND',9,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '77e8c19b-dd66-4e73-924d-636154fc5a44')
	BEGIN
	    PRINT N'Adding Context Element for nRate2'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('77e8c19b-dd66-4e73-924d-636154fc5a44','F87280FA-6A0B-4B1F-881C-987CEABDA179',N'Field',N'fac.nRate2',N'Rate 2',67,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '0803d8da-307e-449d-9d96-a061ca8aa177')
	BEGIN
	    PRINT N'Adding Context Element Link for nRate2'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('0803d8da-307e-449d-9d96-a061ca8aa177','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','77e8c19b-dd66-4e73-924d-636154fc5a44',N'AND',10,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'be167896-c806-4768-8fc6-94bbdd0f5346')
	BEGIN
	    PRINT N'Adding Context Element for nRate3'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('be167896-c806-4768-8fc6-94bbdd0f5346','CE9A3900-BF12-4563-BF85-359552117660',N'Field',N'fac.nRate3',N'Rate 3',67,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '8e4e69eb-854b-48ee-8153-f2151a1fbcdd')
	BEGIN
	    PRINT N'Adding Context Element Link for nRate3'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('8e4e69eb-854b-48ee-8153-f2151a1fbcdd','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','be167896-c806-4768-8fc6-94bbdd0f5346',N'AND',11,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'ff2499be-e6d1-403b-91f7-aaa7c8c8570a')
	BEGIN
	    PRINT N'Adding Context Element for nTaxRate'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('ff2499be-e6d1-403b-91f7-aaa7c8c8570a','377C9348-8108-40CC-9AAE-6401177D7E2E',N'Field',N'fac.nTaxRate',N'Tax Rate',79,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'b1ed7a77-1518-44b4-92be-a1eaa8e6b849')
	BEGIN
	    PRINT N'Adding Context Element Link for nTaxRate'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('b1ed7a77-1518-44b4-92be-a1eaa8e6b849','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','ff2499be-e6d1-403b-91f7-aaa7c8c8570a',N'AND',12,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '837d6018-278e-403d-86d4-7522e2f90a8a')
	BEGIN
	    PRINT N'Adding Context Element for cFacilityType'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('837d6018-278e-403d-86d4-7522e2f90a8a','E348F4CD-C373-478C-95B1-0708836B1C1B',N'Field',N'fac.cFacilityType',N'Facility Type',100,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'c99db210-697c-452b-a7f7-e37ffcb89bf9')
	BEGIN
	    PRINT N'Adding Context Element Link for cFacilityType'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('c99db210-697c-452b-a7f7-e37ffcb89bf9','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','837d6018-278e-403d-86d4-7522e2f90a8a',N'AND',13,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '0d83f724-2cee-489f-bb26-2a2fb8c063ca')
	BEGIN
	    PRINT N'Adding Context Element for cFacilityWebSite'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('0d83f724-2cee-489f-bb26-2a2fb8c063ca','ADE0FADC-4DA9-4226-A906-264261E16FFC',N'Field',N'fac.cFacilityWebSite',N'Facility Web Site',111,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '2ab3852e-afb0-4926-a5ff-cc35f3144b76')
	BEGIN
	    PRINT N'Adding Context Element Link for cFacilityWebSite'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('2ab3852e-afb0-4926-a5ff-cc35f3144b76','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','0d83f724-2cee-489f-bb26-2a2fb8c063ca',N'AND',14,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '110284ff-101e-497f-98e7-6bd73d5cd924')
	BEGIN
	    PRINT N'Adding Context Element for cTaxNumber'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('110284ff-101e-497f-98e7-6bd73d5cd924','AF1245E3-5979-43BE-A1FC-7E205347886C',N'Field',N'fac.cTaxNumber',N'Tax Number',93,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '166c1697-a7e5-415d-8fd0-8cc2440bd754')
	BEGIN
	    PRINT N'Adding Context Element Link for cTaxNumber'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('166c1697-a7e5-415d-8fd0-8cc2440bd754','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','110284ff-101e-497f-98e7-6bd73d5cd924',N'AND',15,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '9800ffe0-56e9-4fb0-8f37-24c31df85307')
	BEGIN
	    PRINT N'Adding Context Element for cDivision'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('9800ffe0-56e9-4fb0-8f37-24c31df85307','7D523EE3-E5DE-41E9-B4C0-31C70A3E5FED',N'Field',N'fac.cDivision',N'Division',75,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'f1fedb0a-a287-4fca-ac5e-f6f4964ead35')
	BEGIN
	    PRINT N'Adding Context Element Link for cDivision'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('f1fedb0a-a287-4fca-ac5e-f6f4964ead35','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','9800ffe0-56e9-4fb0-8f37-24c31df85307',N'AND',16,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '769abd7e-978d-47c0-8244-496715a23178')
	BEGIN
	    PRINT N'Adding Context Element for cDistrict'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('769abd7e-978d-47c0-8244-496715a23178','FFD18DEA-1F5B-466C-831F-0F23BB04B156',N'Field',N'fac.cDistrict',N'District',70,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '65d944be-f073-4d11-aa6e-0193a6c5641f')
	BEGIN
	    PRINT N'Adding Context Element Link for cDistrict'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('65d944be-f073-4d11-aa6e-0193a6c5641f','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','769abd7e-978d-47c0-8244-496715a23178',N'AND',17,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '0d6449a7-ce25-4297-9505-cc2111ff121d')
	BEGIN
	    PRINT N'Adding Context Element for cAccountNumber'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('0d6449a7-ce25-4297-9505-cc2111ff121d','4B18E1C2-E863-44CA-9073-2FB49447FA0E',N'Field',N'fac.cAccountNumber',N'Account Number',115,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'cb58ce67-a62b-42bf-8266-e22792e77c0e')
	BEGIN
	    PRINT N'Adding Context Element Link for cAccountNumber'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('cb58ce67-a62b-42bf-8266-e22792e77c0e','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','0d6449a7-ce25-4297-9505-cc2111ff121d',N'AND',18,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '83bbea78-a1c5-4131-80ed-105da8bd5ebc')
	BEGIN
	    PRINT N'Adding Context Element for cFedNumber'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('83bbea78-a1c5-4131-80ed-105da8bd5ebc','E65FCDE5-A55B-47A8-B999-F56E2C9CDA28',N'Field',N'fac.cFedNumber',N'Fed Number',93,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '0d8d6e68-0f26-4498-94c0-d2b60fb26117')
	BEGIN
	    PRINT N'Adding Context Element Link for cFedNumber'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('0d8d6e68-0f26-4498-94c0-d2b60fb26117','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','83bbea78-a1c5-4131-80ed-105da8bd5ebc',N'AND',19,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '207dfbb4-da65-440a-b29c-fca07f35fda6')
	BEGIN
	    PRINT N'Adding Context Element for mNotes'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('207dfbb4-da65-440a-b29c-fca07f35fda6','54A73E4A-7417-4E4F-9749-A808D33A1E84',N'Field',N'fac.mNotes',N'Notes',272,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '2f32a4a7-23e8-4004-9020-aa8608482bde')
	BEGIN
	    PRINT N'Adding Context Element Link for mNotes'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('2f32a4a7-23e8-4004-9020-aa8608482bde','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','207dfbb4-da65-440a-b29c-fca07f35fda6',N'AND',20,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '57eeb7ff-2965-488e-aa07-58af1d5c94b6')
	BEGIN
	    PRINT N'Adding Context Element for lManufacturer'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('57eeb7ff-2965-488e-aa07-58af1d5c94b6','5C83F062-1D78-41EB-826C-15C8FBBD77DB',N'Field',N'fac.lManufacturer',N'Manufacturer',97,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'cfc74e7a-9ad2-482a-b2c5-da7e5abf2862')
	BEGIN
	    PRINT N'Adding Context Element Link for lManufacturer'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('cfc74e7a-9ad2-482a-b2c5-da7e5abf2862','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','57eeb7ff-2965-488e-aa07-58af1d5c94b6',N'AND',21,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'd530e7c4-b882-49c2-afc2-0e8b474af37a')
	BEGIN
	    PRINT N'Adding Context Element for lCustomer'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('d530e7c4-b882-49c2-afc2-0e8b474af37a','3C27B72A-C7B3-4AED-B3D7-0D0D70CD79B2',N'Field',N'fac.lCustomer',N'Customer',78,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'bd041604-63d6-4947-885b-945a28bd9d16')
	BEGIN
	    PRINT N'Adding Context Element Link for lCustomer'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('bd041604-63d6-4947-885b-945a28bd9d16','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','d530e7c4-b882-49c2-afc2-0e8b474af37a',N'AND',22,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'd8f4e105-ec6d-450e-8b5b-6b362f47ad23')
	BEGIN
	    PRINT N'Adding Context Element for lSubContractor'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('d8f4e105-ec6d-450e-8b5b-6b362f47ad23','1F058A70-1B0F-4BE5-B3E5-5875D73A2052',N'Field',N'fac.lSubContractor',N'Sub Contractor',102,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '567471b8-aad5-4919-8ba1-49fda0508772')
	BEGIN
	    PRINT N'Adding Context Element Link for lSubContractor'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('567471b8-aad5-4919-8ba1-49fda0508772','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','d8f4e105-ec6d-450e-8b5b-6b362f47ad23',N'AND',23,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'c3b9c7c7-e234-440b-9350-2b7e0138015e')
	BEGIN
	    PRINT N'Adding Context Element for lLab'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('c3b9c7c7-e234-440b-9350-2b7e0138015e','A819A736-9674-45CE-B021-E3C6A99C4AFC',N'Field',N'fac.lLab',N'Lab',52,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '12fcacb8-c176-4ba0-9215-d7414bec26af')
	BEGIN
	    PRINT N'Adding Context Element Link for lLab'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('12fcacb8-c176-4ba0-9215-d7414bec26af','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','c3b9c7c7-e234-440b-9350-2b7e0138015e',N'AND',24,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'a4f7715b-1889-4a17-a07d-22683e901e9b')
	BEGIN
	    PRINT N'Adding Context Element for lHandHeldUse'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('a4f7715b-1889-4a17-a07d-22683e901e9b','5A4191EF-46A2-4267-8E1B-7868CD842D6F',N'Field',N'fac.lHandHeldUse',N'Hand Held Use',101,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'a3d4cd9e-cd7e-4759-a0aa-f6b7086d255b')
	BEGIN
	    PRINT N'Adding Context Element Link for lHandHeldUse'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('a3d4cd9e-cd7e-4759-a0aa-f6b7086d255b','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','a4f7715b-1889-4a17-a07d-22683e901e9b',N'AND',25,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'a57304aa-9d79-4cf6-ac6c-3226b199fb44')
	BEGIN
	    PRINT N'Adding Context Element for lNoRecall'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('a57304aa-9d79-4cf6-ac6c-3226b199fb44','186378C5-128F-4C61-A503-778943984926',N'Field',N'fac.lNoRecall',N'No Recall',78,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '95af429d-501b-4e92-9f1c-e55daff8cf9b')
	BEGIN
	    PRINT N'Adding Context Element Link for lNoRecall'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('95af429d-501b-4e92-9f1c-e55daff8cf9b','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','a57304aa-9d79-4cf6-ac6c-3226b199fb44',N'AND',26,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '392f2bf4-782f-4aca-aa84-1af7d8348747')
	BEGIN
	    PRINT N'Adding Context Element for lNoTax'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('392f2bf4-782f-4aca-aa84-1af7d8348747','316D97BE-9C49-40FC-A530-5E606C3ABD92',N'Field',N'fac.lNoTax',N'No Tax',66,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '9e13b678-c8ea-4eec-90fe-769d0d0bee68')
	BEGIN
	    PRINT N'Adding Context Element Link for lNoTax'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('9e13b678-c8ea-4eec-90fe-769d0d0bee68','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','392f2bf4-782f-4aca-aa84-1af7d8348747',N'AND',27,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '3be4ff25-1b77-49c3-8ec5-7979a33ecb33')
	BEGIN
	    PRINT N'Adding Context Element for lInspectionRate'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('3be4ff25-1b77-49c3-8ec5-7979a33ecb33','FB83EBEB-BF20-4DFB-AC52-FE53B87FA6F4',N'Field',N'fac.lInspectionRate',N'Inspection Rate',106,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'e6edfe48-aa82-4a04-86b4-9411729837ec')
	BEGIN
	    PRINT N'Adding Context Element Link for lInspectionRate'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('e6edfe48-aa82-4a04-86b4-9411729837ec','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','3be4ff25-1b77-49c3-8ec5-7979a33ecb33',N'AND',28,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'bca41a8e-2d63-413b-ae1e-40481aa28c9f')
	BEGIN
	    PRINT N'Adding UCI Data Item for cParentName'
	    
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('BCA41A8E-2D63-413B-AE1E-40481AA28C9F', N'Facilities', N'cParentName', N'Label', N'Parent Name',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'D193D17E-445A-4BA0-AB61-1CF334E0D46D')
	BEGIN

		IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'D193D17E-445A-4BA0-AB61-1CF334E0D46D' AND nUCIDataUID = 'BCA41A8E-2D63-413B-AE1E-40481AA28C9F')
		BEGIN
		    PRINT N'Updating Context Element for cParentName'

			UPDATE
				[dbo].[ContextElements]
			SET
				[nUCIDataUID] = 'BCA41A8E-2D63-413B-AE1E-40481AA28C9F',
				[tUpdateTime] = '20210629 16:08:32.000',
				[nUpdateUserUID] = '915F9722-3175-4E4D-A571-4A478E8E5172'
			WHERE
				[nContextElementUID] = 'D193D17E-445A-4BA0-AB61-1CF334E0D46D'

		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '20c78005-4f5c-49a3-9c58-feab7790616b')
	BEGIN
	    PRINT N'Adding UCI Data Item for cParentNumber'
	    
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('20c78005-4f5c-49a3-9c58-feab7790616b', N'Facilities', N'cParentNumber', N'Label', N'Parent Number',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'ea85d15a-45e4-4520-bb48-a9405896e5b5')
	BEGIN
	    PRINT N'Adding Context Element for cParentNumber'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('ea85d15a-45e4-4520-bb48-a9405896e5b5','20c78005-4f5c-49a3-9c58-feab7790616b',N'Field',N'fac.cParentNumber',N'Parent Number',106,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '0b84d278-1001-4ac6-8826-3e1e02755370')
	BEGIN
	    PRINT N'Adding Context Element Link for cParentNumber'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('0b84d278-1001-4ac6-8826-3e1e02755370','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','ea85d15a-45e4-4520-bb48-a9405896e5b5',N'AND',29,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'c2963b7a-1fd8-4d16-91a6-76a48795e878')
	BEGIN
	    PRINT N'Adding Context Element for cField1'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('c2963b7a-1fd8-4d16-91a6-76a48795e878',NULL,N'Field',N'fac.cField1',N'FacilityEX.cField1',66,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '5524555c-3de4-4ce7-9b87-38fbe2ac0a40')
	BEGIN
	    PRINT N'Adding Context Element Link for cField1'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('5524555c-3de4-4ce7-9b87-38fbe2ac0a40','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','c2963b7a-1fd8-4d16-91a6-76a48795e878',N'AND',30,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '29a5ffec-025a-4c94-bcc3-ef7526070246')
	BEGIN
	    PRINT N'Adding Context Element for cField2'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('29a5ffec-025a-4c94-bcc3-ef7526070246',NULL,N'Field',N'fac.cField2',N'FacilityEX.cField2',66,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '5f21a0aa-5823-4e71-95e8-009f68019c4e')
	BEGIN
	    PRINT N'Adding Context Element Link for cField2'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('5f21a0aa-5823-4e71-95e8-009f68019c4e','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','29a5ffec-025a-4c94-bcc3-ef7526070246',N'AND',31,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'bf218093-fa01-459c-a368-ef03a79536ff')
	BEGIN
	    PRINT N'Adding Context Element for cField3'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('bf218093-fa01-459c-a368-ef03a79536ff',NULL,N'Field',N'fac.cField3',N'FacilityEX.cField3',66,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'e5d1ae83-80af-4195-91c7-4e3bdc26230a')
	BEGIN
	    PRINT N'Adding Context Element Link for cField3'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('e5d1ae83-80af-4195-91c7-4e3bdc26230a','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','bf218093-fa01-459c-a368-ef03a79536ff',N'AND',32,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'c4ebd999-7311-42a3-927f-2316fc93ce33')
	BEGIN
	    PRINT N'Adding Context Element for cField4'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('c4ebd999-7311-42a3-927f-2316fc93ce33',NULL,N'Field',N'fac.cField4',N'FacilityEX.cField4',66,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'd2b0417f-fd5e-4dae-bee0-220e1aab17c7')
	BEGIN
	    PRINT N'Adding Context Element Link for cField4'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('d2b0417f-fd5e-4dae-bee0-220e1aab17c7','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','c4ebd999-7311-42a3-927f-2316fc93ce33',N'AND',33,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '4eea39f2-0709-49e0-b3cd-e2cdbaa328c8')
	BEGIN
	    PRINT N'Adding Context Element for cField5'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('4eea39f2-0709-49e0-b3cd-e2cdbaa328c8',NULL,N'Field',N'fac.cField5',N'FacilityEX.cField5',66,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'bd5ffc4f-5c3e-478f-a917-fedbb4f69fac')
	BEGIN
	    PRINT N'Adding Context Element Link for cField5'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('bd5ffc4f-5c3e-478f-a917-fedbb4f69fac','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','4eea39f2-0709-49e0-b3cd-e2cdbaa328c8',N'AND',34,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '08c30eb6-1f5c-4b2d-9fd5-664a793c6f2f')
	BEGIN
	    PRINT N'Adding Context Element for cField6'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('08c30eb6-1f5c-4b2d-9fd5-664a793c6f2f',NULL,N'Field',N'fac.cField6',N'FacilityEX.cField6',66,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '85eeaac3-891b-43d1-8663-4b0ab022ac7a')
	BEGIN
	    PRINT N'Adding Context Element Link for cField6'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('85eeaac3-891b-43d1-8663-4b0ab022ac7a','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','08c30eb6-1f5c-4b2d-9fd5-664a793c6f2f',N'AND',35,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '6f3cbb01-0464-4181-8f15-c03cb47f6f5e')
	BEGIN
	    PRINT N'Adding Context Element for cField7'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('6f3cbb01-0464-4181-8f15-c03cb47f6f5e',NULL,N'Field',N'fac.cField7',N'FacilityEX.cField7',66,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'f339dff0-ff5e-405b-ba82-3ddc8f978359')
	BEGIN
	    PRINT N'Adding Context Element Link for cField7'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('f339dff0-ff5e-405b-ba82-3ddc8f978359','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','6f3cbb01-0464-4181-8f15-c03cb47f6f5e',N'AND',36,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'a2559435-d1f0-4283-a43e-b3f1ead5935f')
	BEGIN
	    PRINT N'Adding Context Element for cField8'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('a2559435-d1f0-4283-a43e-b3f1ead5935f',NULL,N'Field',N'fac.cField8',N'FacilityEX.cField8',66,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '1a41a196-d83f-43fc-b37f-86b5508416d7')
	BEGIN
	    PRINT N'Adding Context Element Link for cField8'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('1a41a196-d83f-43fc-b37f-86b5508416d7','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','a2559435-d1f0-4283-a43e-b3f1ead5935f',N'AND',37,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '17581558-b2d2-434f-a587-0ab909858cc7')
	BEGIN
	    PRINT N'Adding Context Element for cField9'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('17581558-b2d2-434f-a587-0ab909858cc7',NULL,N'Field',N'fac.cField9',N'FacilityEX.cField9',66,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'dd88872a-a394-43ae-8b19-22ae2d0e4ab9')
	BEGIN
	    PRINT N'Adding Context Element Link for cField9'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('dd88872a-a394-43ae-8b19-22ae2d0e4ab9','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','17581558-b2d2-434f-a587-0ab909858cc7',N'AND',38,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '8e3b82e7-3da8-4b4f-972f-825c796e647c')
	BEGIN
	    PRINT N'Adding Context Element for cField10'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('8e3b82e7-3da8-4b4f-972f-825c796e647c',NULL,N'Field',N'fac.cField10',N'FacilityEX.cField10',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '1a350fe3-4b0f-471b-a1d8-518fe85dcf6f')
	BEGIN
	    PRINT N'Adding Context Element Link for cField10'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('1a350fe3-4b0f-471b-a1d8-518fe85dcf6f','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','8e3b82e7-3da8-4b4f-972f-825c796e647c',N'AND',39,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'dbf3f8be-4ce0-4017-b773-62fe42323bc5')
	BEGIN
	    PRINT N'Adding Context Element for cField11'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('dbf3f8be-4ce0-4017-b773-62fe42323bc5',NULL,N'Field',N'fac.cField11',N'FacilityEX.cField11',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'b2735980-6a12-4b13-adb9-eb083c663bcc')
	BEGIN
	    PRINT N'Adding Context Element Link for cField11'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('b2735980-6a12-4b13-adb9-eb083c663bcc','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','dbf3f8be-4ce0-4017-b773-62fe42323bc5',N'AND',40,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '0e083592-c086-4277-87fa-dbd80d893c79')
	BEGIN
	    PRINT N'Adding Context Element for cField12'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('0e083592-c086-4277-87fa-dbd80d893c79',NULL,N'Field',N'fac.cField12',N'FacilityEX.cField12',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '38f628f1-dae8-4dae-a881-9acf19f0d3fe')
	BEGIN
	    PRINT N'Adding Context Element Link for cField12'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('38f628f1-dae8-4dae-a881-9acf19f0d3fe','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','0e083592-c086-4277-87fa-dbd80d893c79',N'AND',41,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'ee6ee2f3-0bb0-4880-af30-2c5c126130d1')
	BEGIN
	    PRINT N'Adding Context Element for cField13'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('ee6ee2f3-0bb0-4880-af30-2c5c126130d1',NULL,N'Field',N'fac.cField13',N'FacilityEX.cField13',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'ce03dcce-165e-4b3e-b482-c28f603a1b97')
	BEGIN
	    PRINT N'Adding Context Element Link for cField13'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('ce03dcce-165e-4b3e-b482-c28f603a1b97','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','ee6ee2f3-0bb0-4880-af30-2c5c126130d1',N'AND',42,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '240f9e69-c86d-42c2-ad59-4d5fda221a09')
	BEGIN
	    PRINT N'Adding Context Element for cField14'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('240f9e69-c86d-42c2-ad59-4d5fda221a09',NULL,N'Field',N'fac.cField14',N'FacilityEX.cField14',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '3371ef50-c29d-4422-b304-5f4783f40b01')
	BEGIN
	    PRINT N'Adding Context Element Link for cField14'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('3371ef50-c29d-4422-b304-5f4783f40b01','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','240f9e69-c86d-42c2-ad59-4d5fda221a09',N'AND',43,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'a41f0d98-68dc-4d67-8d90-e5869026d5b8')
	BEGIN
	    PRINT N'Adding Context Element for cField15'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('a41f0d98-68dc-4d67-8d90-e5869026d5b8',NULL,N'Field',N'fac.cField15',N'FacilityEX.cField15',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '6e02be4f-0392-4cce-8867-b504978f293f')
	BEGIN
	    PRINT N'Adding Context Element Link for cField15'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('6e02be4f-0392-4cce-8867-b504978f293f','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','a41f0d98-68dc-4d67-8d90-e5869026d5b8',N'AND',44,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'b9678451-75f2-4efd-a41c-b119afa6febb')
	BEGIN
	    PRINT N'Adding Context Element for cField16'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('b9678451-75f2-4efd-a41c-b119afa6febb',NULL,N'Field',N'fac.cField16',N'FacilityEX.cField16',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'c0374359-4846-4c07-b16d-fced9c15c070')
	BEGIN
	    PRINT N'Adding Context Element Link for cField16'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('c0374359-4846-4c07-b16d-fced9c15c070','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','b9678451-75f2-4efd-a41c-b119afa6febb',N'AND',45,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '37b816c6-8d15-4059-bf8c-b92fa87dfc28')
	BEGIN
	    PRINT N'Adding Context Element for cField17'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('37b816c6-8d15-4059-bf8c-b92fa87dfc28',NULL,N'Field',N'fac.cField17',N'FacilityEX.cField17',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'cc50981f-686d-42ce-8784-68a408073cea')
	BEGIN
	    PRINT N'Adding Context Element Link for cField17'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('cc50981f-686d-42ce-8784-68a408073cea','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','37b816c6-8d15-4059-bf8c-b92fa87dfc28',N'AND',46,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '03df9ce4-3db8-4eb2-bce9-1f2919dff013')
	BEGIN
	    PRINT N'Adding Context Element for cField18'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('03df9ce4-3db8-4eb2-bce9-1f2919dff013',NULL,N'Field',N'fac.cField18',N'FacilityEX.cField18',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '642b5ad1-0e72-4233-ad03-e52339f2d0bd')
	BEGIN
	    PRINT N'Adding Context Element Link for cField18'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('642b5ad1-0e72-4233-ad03-e52339f2d0bd','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','03df9ce4-3db8-4eb2-bce9-1f2919dff013',N'AND',47,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'f23a76bf-d329-4bb1-baac-3cb56b84788e')
	BEGIN
	    PRINT N'Adding Context Element for cField19'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('f23a76bf-d329-4bb1-baac-3cb56b84788e',NULL,N'Field',N'fac.cField19',N'FacilityEX.cField19',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'dd3abc5d-ba95-4cbe-ac6e-eb0552b49d7c')
	BEGIN
	    PRINT N'Adding Context Element Link for cField19'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('dd3abc5d-ba95-4cbe-ac6e-eb0552b49d7c','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','f23a76bf-d329-4bb1-baac-3cb56b84788e',N'AND',48,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '377e6262-df8e-4b98-9a46-36f3a7150eda')
	BEGIN
	    PRINT N'Adding Context Element for cField20'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('377e6262-df8e-4b98-9a46-36f3a7150eda',NULL,N'Field',N'fac.cField20',N'FacilityEX.cField20',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '4333f555-f11d-4edf-be17-0d2980d67dda')
	BEGIN
	    PRINT N'Adding Context Element Link for cField20'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('4333f555-f11d-4edf-be17-0d2980d67dda','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','377e6262-df8e-4b98-9a46-36f3a7150eda',N'AND',49,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'a1a34fc0-8e90-4afc-b89a-6bdf9814823d')
	BEGIN
	    PRINT N'Adding Context Element for cField21'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('a1a34fc0-8e90-4afc-b89a-6bdf9814823d',NULL,N'Field',N'fac.cField21',N'FacilityEX.cField21',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '36956fae-3389-4f4d-a5c0-1a1edac9c6c2')
	BEGIN
	    PRINT N'Adding Context Element Link for cField21'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('36956fae-3389-4f4d-a5c0-1a1edac9c6c2','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','a1a34fc0-8e90-4afc-b89a-6bdf9814823d',N'AND',50,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '89be11a8-9fba-48e4-a115-1e99a49d4ec7')
	BEGIN
	    PRINT N'Adding Context Element for cField22'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('89be11a8-9fba-48e4-a115-1e99a49d4ec7',NULL,N'Field',N'fac.cField22',N'FacilityEX.cField22',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'ceb75396-e5f9-438e-b46b-4362fbc3f323')
	BEGIN
	    PRINT N'Adding Context Element Link for cField22'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('ceb75396-e5f9-438e-b46b-4362fbc3f323','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','89be11a8-9fba-48e4-a115-1e99a49d4ec7',N'AND',51,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '1517a3bb-c14d-4cb4-ab52-51b026c4ed7f')
	BEGIN
	    PRINT N'Adding Context Element for cField23'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('1517a3bb-c14d-4cb4-ab52-51b026c4ed7f',NULL,N'Field',N'fac.cField23',N'FacilityEX.cField23',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '7208c7e1-c376-4d79-929c-39fd5d5a1383')
	BEGIN
	    PRINT N'Adding Context Element Link for cField23'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('7208c7e1-c376-4d79-929c-39fd5d5a1383','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','1517a3bb-c14d-4cb4-ab52-51b026c4ed7f',N'AND',52,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '226132a2-e20f-47f1-89a8-e6f1a6eb35d2')
	BEGIN
	    PRINT N'Adding Context Element for cField24'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('226132a2-e20f-47f1-89a8-e6f1a6eb35d2',NULL,N'Field',N'fac.cField24',N'FacilityEX.cField24',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '821ab629-2acf-4258-b704-e5258e3001fe')
	BEGIN
	    PRINT N'Adding Context Element Link for cField24'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('821ab629-2acf-4258-b704-e5258e3001fe','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','226132a2-e20f-47f1-89a8-e6f1a6eb35d2',N'AND',53,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '13cb2229-cb3c-4084-b8a8-247a84869a85')
	BEGIN
	    PRINT N'Adding Context Element for cField25'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('13cb2229-cb3c-4084-b8a8-247a84869a85',NULL,N'Field',N'fac.cField25',N'FacilityEX.cField25',72,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'c2a115ca-52de-460c-87aa-b9ae392f6f72')
	BEGIN
	    PRINT N'Adding Context Element Link for cField25'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('c2a115ca-52de-460c-87aa-b9ae392f6f72','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','13cb2229-cb3c-4084-b8a8-247a84869a85',N'AND',54,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '7b8352b7-7f55-4b6d-9af8-aa55e1aca844')
	BEGIN
	    PRINT N'Adding Context Element for tField1'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('7b8352b7-7f55-4b6d-9af8-aa55e1aca844',NULL,N'Field',N'fac.tField1',N'FacilityEX.tField1',63,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '73d85e5c-cc33-4450-a483-3d26bdfc4c39')
	BEGIN
	    PRINT N'Adding Context Element Link for tField1'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('73d85e5c-cc33-4450-a483-3d26bdfc4c39','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','7b8352b7-7f55-4b6d-9af8-aa55e1aca844',N'AND',55,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'd9e9f521-54fb-439f-b680-8b48f6bd3769')
	BEGIN
	    PRINT N'Adding Context Element for tField2'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('d9e9f521-54fb-439f-b680-8b48f6bd3769',NULL,N'Field',N'fac.tField2',N'FacilityEX.tField2',63,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '37a80b2a-c533-4b67-8b0a-3032c146ddc1')
	BEGIN
	    PRINT N'Adding Context Element Link for tField2'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('37a80b2a-c533-4b67-8b0a-3032c146ddc1','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','d9e9f521-54fb-439f-b680-8b48f6bd3769',N'AND',56,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'df2d99ca-ce81-4de1-99f5-8ddd7ea6ffc4')
	BEGIN
	    PRINT N'Adding Context Element for tField3'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('df2d99ca-ce81-4de1-99f5-8ddd7ea6ffc4',NULL,N'Field',N'fac.tField3',N'FacilityEX.tField3',63,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '5018e284-9863-40aa-b8a2-de917458354d')
	BEGIN
	    PRINT N'Adding Context Element Link for tField3'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('5018e284-9863-40aa-b8a2-de917458354d','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','df2d99ca-ce81-4de1-99f5-8ddd7ea6ffc4',N'AND',57,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '30d109c4-1b19-4a53-a6ac-0e4e54651462')
	BEGIN
	    PRINT N'Adding Context Element for tField4'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('30d109c4-1b19-4a53-a6ac-0e4e54651462',NULL,N'Field',N'fac.tField4',N'FacilityEX.tField4',63,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '32231c45-221e-48c8-aaf6-68b33f9e04cf')
	BEGIN
	    PRINT N'Adding Context Element Link for tField4'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('32231c45-221e-48c8-aaf6-68b33f9e04cf','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','30d109c4-1b19-4a53-a6ac-0e4e54651462',N'AND',58,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '378f3cb2-e84a-433a-919f-86cac040cb8f')
	BEGIN
	    PRINT N'Adding Context Element for tField5'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('378f3cb2-e84a-433a-919f-86cac040cb8f',NULL,N'Field',N'fac.tField5',N'FacilityEX.tField5',63,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '451d9851-ead1-482e-bb7e-04b4c55305a1')
	BEGIN
	    PRINT N'Adding Context Element Link for tField5'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('451d9851-ead1-482e-bb7e-04b4c55305a1','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','378f3cb2-e84a-433a-919f-86cac040cb8f',N'AND',59,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '5f542ca9-3a8b-47e3-8b96-4078a718bed3')
	BEGIN
	    PRINT N'Adding Context Element for tField6'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('5f542ca9-3a8b-47e3-8b96-4078a718bed3',NULL,N'Field',N'fac.tField6',N'FacilityEX.tField6',63,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '0271fe33-2f16-4d16-b26b-7857f5cf059e')
	BEGIN
	    PRINT N'Adding Context Element Link for tField6'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('0271fe33-2f16-4d16-b26b-7857f5cf059e','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','5f542ca9-3a8b-47e3-8b96-4078a718bed3',N'AND',60,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'ea5c641d-8971-4e2a-b8a0-bbbe62098d51')
	BEGIN
	    PRINT N'Adding Context Element for tField7'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('ea5c641d-8971-4e2a-b8a0-bbbe62098d51',NULL,N'Field',N'fac.tField7',N'FacilityEX.tField7',63,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '76873cc4-9339-4756-beb4-f140b43d20ab')
	BEGIN
	    PRINT N'Adding Context Element Link for tField7'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('76873cc4-9339-4756-beb4-f140b43d20ab','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','ea5c641d-8971-4e2a-b8a0-bbbe62098d51',N'AND',61,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '75f8312c-ae7a-4d97-a083-cdf4b105508c')
	BEGIN
	    PRINT N'Adding Context Element for tField8'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('75f8312c-ae7a-4d97-a083-cdf4b105508c',NULL,N'Field',N'fac.tField8',N'FacilityEX.tField8',63,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'aea3b687-6ad2-4464-99fe-bb72f1300b6c')
	BEGIN
	    PRINT N'Adding Context Element Link for tField8'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('aea3b687-6ad2-4464-99fe-bb72f1300b6c','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','75f8312c-ae7a-4d97-a083-cdf4b105508c',N'AND',62,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '0eadcbae-feb1-4c94-aa4e-586d50445d38')
	BEGIN
	    PRINT N'Adding Context Element for tField9'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('0eadcbae-feb1-4c94-aa4e-586d50445d38',NULL,N'Field',N'fac.tField9',N'FacilityEX.tField9',63,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '2cd06933-b7e6-4488-81f3-adb0e457a515')
	BEGIN
	    PRINT N'Adding Context Element Link for tField9'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('2cd06933-b7e6-4488-81f3-adb0e457a515','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','0eadcbae-feb1-4c94-aa4e-586d50445d38',N'AND',63,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'f695e9ea-d4bb-4313-a83e-f09ff0244463')
	BEGIN
	    PRINT N'Adding Context Element for tField10'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('f695e9ea-d4bb-4313-a83e-f09ff0244463',NULL,N'Field',N'fac.tField10',N'FacilityEX.tField10',69,NULL,NULL,NULL,8,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'bc68c0d9-4867-4e44-91a6-f1b64609a796')
	BEGIN
	    PRINT N'Adding Context Element Link for tField10'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('bc68c0d9-4867-4e44-91a6-f1b64609a796','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','f695e9ea-d4bb-4313-a83e-f09ff0244463',N'AND',64,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'a7e2836e-3bc1-4193-b8a4-2328b016392b')
	BEGIN
	    PRINT N'Adding Context Element for nField1'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('a7e2836e-3bc1-4193-b8a4-2328b016392b',NULL,N'Field',N'fac.nField1',N'FacilityEX.nField1',66,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '6bf4be6c-3f6d-48f4-8a1a-f37707ceaffd')
	BEGIN
	    PRINT N'Adding Context Element Link for nField1'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('6bf4be6c-3f6d-48f4-8a1a-f37707ceaffd','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','a7e2836e-3bc1-4193-b8a4-2328b016392b',N'AND',65,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '5a403b09-e8fb-4932-9a4b-78dd3fb1bd96')
	BEGIN
	    PRINT N'Adding Context Element for nField2'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('5a403b09-e8fb-4932-9a4b-78dd3fb1bd96',NULL,N'Field',N'fac.nField2',N'FacilityEX.nField2',66,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '3c7ce56b-8710-41dc-ab35-f1f9edfbc39a')
	BEGIN
	    PRINT N'Adding Context Element Link for nField2'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('3c7ce56b-8710-41dc-ab35-f1f9edfbc39a','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','5a403b09-e8fb-4932-9a4b-78dd3fb1bd96',N'AND',66,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'c8a01949-e131-4ba0-827c-b7c1e693ab8d')
	BEGIN
	    PRINT N'Adding Context Element for nField3'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('c8a01949-e131-4ba0-827c-b7c1e693ab8d',NULL,N'Field',N'fac.nField3',N'FacilityEX.nField3',66,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '1991e681-8fe5-460e-85b6-31622061f637')
	BEGIN
	    PRINT N'Adding Context Element Link for nField3'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('1991e681-8fe5-460e-85b6-31622061f637','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','c8a01949-e131-4ba0-827c-b7c1e693ab8d',N'AND',67,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'f4b78892-c731-4efc-a81f-b92c83017f13')
	BEGIN
	    PRINT N'Adding Context Element for nField4'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('f4b78892-c731-4efc-a81f-b92c83017f13',NULL,N'Field',N'fac.nField4',N'FacilityEX.nField4',66,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '2e416379-75dd-4394-8d32-f21733040069')
	BEGIN
	    PRINT N'Adding Context Element Link for nField4'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('2e416379-75dd-4394-8d32-f21733040069','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','f4b78892-c731-4efc-a81f-b92c83017f13',N'AND',68,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'b97dae66-90d2-444b-bc2b-d88ca68be069')
	BEGIN
	    PRINT N'Adding Context Element for nField5'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('b97dae66-90d2-444b-bc2b-d88ca68be069',NULL,N'Field',N'fac.nField5',N'FacilityEX.nField5',66,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '579ec4e9-041a-408d-a72e-b83f0357bfdb')
	BEGIN
	    PRINT N'Adding Context Element Link for nField5'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('579ec4e9-041a-408d-a72e-b83f0357bfdb','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','b97dae66-90d2-444b-bc2b-d88ca68be069',N'AND',69,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '1257d37a-6f6b-423b-9f8d-11371c64ce47')
	BEGIN
	    PRINT N'Adding Context Element for nField6'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('1257d37a-6f6b-423b-9f8d-11371c64ce47',NULL,N'Field',N'fac.nField6',N'FacilityEX.nField6',66,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'd6c6f7c5-c4b3-4cb5-942a-a2b87385c2f0')
	BEGIN
	    PRINT N'Adding Context Element Link for nField6'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('d6c6f7c5-c4b3-4cb5-942a-a2b87385c2f0','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','1257d37a-6f6b-423b-9f8d-11371c64ce47',N'AND',70,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '4f140640-c8ae-4f91-8313-6a89d7f14a04')
	BEGIN
	    PRINT N'Adding Context Element for nField7'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('4f140640-c8ae-4f91-8313-6a89d7f14a04',NULL,N'Field',N'fac.nField7',N'FacilityEX.nField7',66,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '313e1aec-e5d8-442a-9663-ec122637b70d')
	BEGIN
	    PRINT N'Adding Context Element Link for nField7'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('313e1aec-e5d8-442a-9663-ec122637b70d','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','4f140640-c8ae-4f91-8313-6a89d7f14a04',N'AND',71,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '6f4f75aa-cbb0-49f4-8465-e4fb25982b6a')
	BEGIN
	    PRINT N'Adding Context Element for nField8'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('6f4f75aa-cbb0-49f4-8465-e4fb25982b6a',NULL,N'Field',N'fac.nField8',N'FacilityEX.nField8',66,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '8a54329c-1de4-438d-b198-f8b40be3eee3')
	BEGIN
	    PRINT N'Adding Context Element Link for nField8'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('8a54329c-1de4-438d-b198-f8b40be3eee3','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','6f4f75aa-cbb0-49f4-8465-e4fb25982b6a',N'AND',72,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'b9883f19-cb68-485f-b801-157a72c89cc6')
	BEGIN
	    PRINT N'Adding Context Element for nField9'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('b9883f19-cb68-485f-b801-157a72c89cc6',NULL,N'Field',N'fac.nField9',N'FacilityEX.nField9',66,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '641da7df-fbfd-4a69-a020-4e579dafe303')
	BEGIN
	    PRINT N'Adding Context Element Link for nField9'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('641da7df-fbfd-4a69-a020-4e579dafe303','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','b9883f19-cb68-485f-b801-157a72c89cc6',N'AND',73,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '6846704b-e725-4c4b-bd3c-53bc7c34ecc8')
	BEGIN
	    PRINT N'Adding Context Element for nField10'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('6846704b-e725-4c4b-bd3c-53bc7c34ecc8',NULL,N'Field',N'fac.nField10',N'FacilityEX.nField10',72,NULL,NULL,NULL,2,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '60ef0512-4370-49e0-ae75-853014f6fed0')
	BEGIN
	    PRINT N'Adding Context Element Link for nField10'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('60ef0512-4370-49e0-ae75-853014f6fed0','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','6846704b-e725-4c4b-bd3c-53bc7c34ecc8',N'AND',74,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '5c0d117c-a207-4f9a-b29d-d07cdac1f897')
	BEGIN
	    PRINT N'Adding Context Element for lField1'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('5c0d117c-a207-4f9a-b29d-d07cdac1f897',NULL,N'Field',N'fac.lField1',N'FacilityEX.lField1',62,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '179d8139-1af7-40d7-8037-18bec37a2efa')
	BEGIN
	    PRINT N'Adding Context Element Link for lField1'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('179d8139-1af7-40d7-8037-18bec37a2efa','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','5c0d117c-a207-4f9a-b29d-d07cdac1f897',N'AND',75,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'c28f0cd6-9fa0-4b96-bcaa-6f780758a95e')
	BEGIN
	    PRINT N'Adding Context Element for lField2'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('c28f0cd6-9fa0-4b96-bcaa-6f780758a95e',NULL,N'Field',N'fac.lField2',N'FacilityEX.lField2',62,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'a733ece4-27b1-4dec-be6a-fdd5a33c6558')
	BEGIN
	    PRINT N'Adding Context Element Link for lField2'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('a733ece4-27b1-4dec-be6a-fdd5a33c6558','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','c28f0cd6-9fa0-4b96-bcaa-6f780758a95e',N'AND',76,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '5054cd72-6437-4bf5-b18f-832e203cd48c')
	BEGIN
	    PRINT N'Adding Context Element for lField3'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('5054cd72-6437-4bf5-b18f-832e203cd48c',NULL,N'Field',N'fac.lField3',N'FacilityEX.lField3',62,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '1cb40f1f-e4cf-4205-ac2a-5ed665364cbb')
	BEGIN
	    PRINT N'Adding Context Element Link for lField3'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('1cb40f1f-e4cf-4205-ac2a-5ed665364cbb','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','5054cd72-6437-4bf5-b18f-832e203cd48c',N'AND',77,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '352875a5-01e7-4c4e-a4b1-d89fb19bd07a')
	BEGIN
	    PRINT N'Adding Context Element for lField4'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('352875a5-01e7-4c4e-a4b1-d89fb19bd07a',NULL,N'Field',N'fac.lField4',N'FacilityEX.lField4',62,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '33f77141-6954-4813-99d8-63349b42290e')
	BEGIN
	    PRINT N'Adding Context Element Link for lField4'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('33f77141-6954-4813-99d8-63349b42290e','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','352875a5-01e7-4c4e-a4b1-d89fb19bd07a',N'AND',78,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '26bbc2e1-6066-48c8-9706-40b19b8bbed3')
	BEGIN
	    PRINT N'Adding Context Element for lField5'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('26bbc2e1-6066-48c8-9706-40b19b8bbed3',NULL,N'Field',N'fac.lField5',N'FacilityEX.lField5',62,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '62ae833c-96d8-4f07-bbdd-8a2323ee47ec')
	BEGIN
	    PRINT N'Adding Context Element Link for lField5'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('62ae833c-96d8-4f07-bbdd-8a2323ee47ec','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','26bbc2e1-6066-48c8-9706-40b19b8bbed3',N'AND',79,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '05025737-616b-448e-a033-8d57db57d2ab')
	BEGIN
	    PRINT N'Adding Context Element for lField6'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('05025737-616b-448e-a033-8d57db57d2ab',NULL,N'Field',N'fac.lField6',N'FacilityEX.lField6',62,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'ced09155-6531-40cd-972b-a268bd1d2c7b')
	BEGIN
	    PRINT N'Adding Context Element Link for lField6'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('ced09155-6531-40cd-972b-a268bd1d2c7b','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','05025737-616b-448e-a033-8d57db57d2ab',N'AND',80,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'd0ed6530-9bd7-479b-8220-2035334eaf04')
	BEGIN
	    PRINT N'Adding Context Element for lField7'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('d0ed6530-9bd7-479b-8220-2035334eaf04',NULL,N'Field',N'fac.lField7',N'FacilityEX.lField7',62,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'f2bfd51a-2e33-4e9c-9a4e-c51512ac968e')
	BEGIN
	    PRINT N'Adding Context Element Link for lField7'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('f2bfd51a-2e33-4e9c-9a4e-c51512ac968e','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','d0ed6530-9bd7-479b-8220-2035334eaf04',N'AND',81,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'ac0036de-10a7-4e31-80e4-969ef9f9d90a')
	BEGIN
	    PRINT N'Adding Context Element for lField8'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('ac0036de-10a7-4e31-80e4-969ef9f9d90a',NULL,N'Field',N'fac.lField8',N'FacilityEX.lField8',62,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '2d2db5b6-3140-41ca-bd12-84c2701bdaec')
	BEGIN
	    PRINT N'Adding Context Element Link for lField8'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('2d2db5b6-3140-41ca-bd12-84c2701bdaec','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','ac0036de-10a7-4e31-80e4-969ef9f9d90a',N'AND',82,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '93932af6-6d3e-4404-b3eb-e7a6788cc1ba')
	BEGIN
	    PRINT N'Adding Context Element for lField9'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('93932af6-6d3e-4404-b3eb-e7a6788cc1ba',NULL,N'Field',N'fac.lField9',N'FacilityEX.lField9',62,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'd768f3ba-5a4d-450f-8064-e7583cf7df6b')
	BEGIN
	    PRINT N'Adding Context Element Link for lField9'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('d768f3ba-5a4d-450f-8064-e7583cf7df6b','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','93932af6-6d3e-4404-b3eb-e7a6788cc1ba',N'AND',83,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '9c60f596-7e15-401e-8ebf-c0a863c87feb')
	BEGIN
	    PRINT N'Adding Context Element for lField10'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('9c60f596-7e15-401e-8ebf-c0a863c87feb',NULL,N'Field',N'fac.lField10',N'FacilityEX.lField10',68,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'cbbe4828-4702-454f-a60c-2b9d8a8be84a')
	BEGIN
	    PRINT N'Adding Context Element Link for lField10'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('cbbe4828-4702-454f-a60c-2b9d8a8be84a','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','9c60f596-7e15-401e-8ebf-c0a863c87feb',N'AND',84,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '6ce4deed-3428-4c97-be25-fa0b4095266a')
	BEGIN
	    PRINT N'Adding Context Element for mField1'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('6ce4deed-3428-4c97-be25-fa0b4095266a',NULL,N'Field',N'fac.mField1',N'FacilityEX.mField1',95,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'd6ba597d-0bc5-4da2-829c-6a91a6b51f88')
	BEGIN
	    PRINT N'Adding Context Element Link for mField1'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('d6ba597d-0bc5-4da2-829c-6a91a6b51f88','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','6ce4deed-3428-4c97-be25-fa0b4095266a',N'AND',85,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'a313f11a-4638-43d4-8344-c3e2f34528eb')
	BEGIN
	    PRINT N'Adding Context Element for mField2'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('a313f11a-4638-43d4-8344-c3e2f34528eb',NULL,N'Field',N'fac.mField2',N'FacilityEX.mField2',68,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '4646b396-33e5-4ea1-9dc9-f63776081fa1')
	BEGIN
	    PRINT N'Adding Context Element Link for mField2'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('4646b396-33e5-4ea1-9dc9-f63776081fa1','EB1F5039-8859-4E1A-829F-94FA6C17B0B2','a313f11a-4638-43d4-8344-c3e2f34528eb',N'AND',86,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210629 16:08:32.000','20210629 16:08:32.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-4701<<--
	IF EXISTS( SELECT * FROM sysobjects WHERE type='P' AND name='Ver_8_Cert_Sp' )
	BEGIN
		PRINT N'Dropping [dbo].[Ver_8_Cert_Sp]'

		DROP PROCEDURE [dbo].[Ver_8_Cert_Sp]
		
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[Ver_8_Cert_Sp]', 'V') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[Ver_8_Cert_Sp]'

		EXEC sp_executesql N'
    -- ==============================================================================
    -- Author:      Fluke Calibration
    -- Create date: 20120504
    -- Description: MET/TEAM Certificates Stored Procedure
    -- Notes:       Compatibility with MET/TRACK report fields
    --
    -- Updated:     20120716 Parameter name changed, re-runnable script
    --              20120720 Bug fixes in mapping, remove cfg view link
    --              20120730 Bug fixes in mapping
    --              20120801 Remove N/A
    --              20120809 Add CallSheetResults workstation and description
    --                       Order by nCallSheetResultUID, then nPointOrdinal
    --              20120814 Added procedure used in CallSheetResults
    --                       Added nCallSheetResultUID, for breaking down points
    --              20120817 Added cPointPassFailStatus
    --              20120817 Exclude deleted points
    --              20120904 COALESCE point ordinal (may be NULL now)
    --              20130325 fixed manufacturer linkage (nManufacturerUID)
    --              20130329 Added Procedure .cVersion and .cRevision
    --              20130724 Use udf_GET_FormattedValue to format values
    --              20130806 Callsheet notes sometimes truncated after 32 characters
    --              20130822 Add data condition (cCallSheetResultType)
    --                       and a few more fields from CallSheetResults
    --              20140515 Use udf_GET_FormattedValueEx for getting values
    --                       Use udf_GET_Unit for getting units, eliminating 61 JOINs
    --                       Use udf_GET_User and udf_GET_UserFull for getting users
    --                       eliminating another 11 JOINs
    --              20150129 Only include tool assignment records where the
    --                       return date is null
    --              20150119 C2341 was truncated at 30 chars
    --              20150218 Exclude deleted work order results
    --              20150715 Remove obsolete columns from Assets table
    --              20150911 Fixed incorrect returned column for meas_flag
    --              20160317 Filter out inactive and deleted addresses
    --              20160317 Filter out deleted tool assignments
    --              20160526 changes for GUIDs, adjust conversions to NVARCHAR
    --              20190718 Added nPointUID
    --              20210720 Remap C2321 to CallSheetEx.cField5
    -- ==============================================================================
    CREATE PROCEDURE [dbo].[Ver_8_Cert_Sp]
        @nCallSheetUID [uniqueidentifier]
    AS
    BEGIN
        -- SET NOCOUNT ON added to prevent extra result sets from
        -- interfering with SELECT statements.
        SET NOCOUNT ON;
    SELECT
    CONVERT(NVARCHAR(36), cs.nCallSheetUID) AS [Calibration_CTAG]
    ,COALESCE(CONVERT(NVARCHAR(36),csr.nCallSheetUID),'''') AS [Results_ctag]
    ,COALESCE(p.nPointOrdinal, 0) AS [row_num]
    ,cs.tMaintDate AS [C2301]
    ,COALESCE(cs.cInterval, '''') AS [C2302]
    ,cs.tMaintNextDate AS [C2303]
    ,COALESCE(cs.cCallSheetNumber, '''') AS [C2304]
    ,COALESCE(csx.cField1, '''') AS [C2306]
    ,[dbo].[udf_GET_User](cs.nAssignedTechUID) AS [C2307]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField1),'''') AS [C2309]
    ,COALESCE(CONVERT(NVARCHAR,cs.nCost),'''') AS [C2310]
    ,COALESCE(cs.cTemperature, '''') AS [C2311]
    ,COALESCE(cs.cHumidity, '''') AS [C2312]
    ,COALESCE(wf.cFacilityName, '''') AS [C2313]
    ,COALESCE(csx.cField2, '''') AS [C2314]
    ,cs.tOpenDate AS [C2316]
    ,COALESCE(pr.cProcedureName, '''') AS [C2320]
    ,COALESCE(csx.cField5, '''') AS [C2321]
    ,COALESCE(CONVERT(NVARCHAR,csx.lField4),'''') AS [C2322]
    ,COALESCE(cs.cWorkOrderResults,'''') AS [C2323]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField4),'''') AS [C2324]
    ,COALESCE(cs.mOOTNotes, '''') AS [C2326]
    ,[dbo].[udf_GET_User](cs.nTechnicianUID) AS [C2327]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField5),'''') AS [C2328]
    ,COALESCE(csx.cField6, '''') AS [C2329]
    ,COALESCE(csx.cField7, '''') AS [C2330]
    ,COALESCE(cs.cIntervalUOM,'''') AS [C2331]
    ,''NOT IMPLEMENTED'' AS [C2332]
    ,cs.tMaintDate AS [C2333]
    ,cs.tMaintNextDate AS [C2334]
    ,cs.tAddTime AS [C2335]
    ,[dbo].[udf_GET_User](cs.nTechnicianUID) AS [C2336]
    ,cs.tUpdateTime AS [C2337]
    ,[dbo].[udf_GET_User](cs.nUpdateUserUID) AS [C2338]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField6),'''') AS [C2339]
    ,RTRIM(SUBSTRING(COALESCE(cs.mCallSheetNotes,''''),0,254)) AS [C2341]
    ,COALESCE(CONVERT(NVARCHAR(36),cs.nAssetUID),'''') AS [Calibration_MTAG]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField15),'''') AS [C2362]
    ,COALESCE(cs.cInitialCondition, '''') AS [C2308]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField3), '''') AS [C2315]
    ,COALESCE(CONVERT(NVARCHAR,csx.tField6), '''') AS [C2342]
    ,COALESCE(CONVERT(NVARCHAR,csx.tField6), '''') AS [C2343]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField29),'''') AS [C2317]
    ,COALESCE(csx.cField4, '''') AS [C2318]
    ,COALESCE(CONVERT(NVARCHAR,csx.lField3),'''') AS [C2319]
    ,COALESCE(CONVERT(NVARCHAR,csx.lField6),'''') AS [C2325]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField11),'''') AS [C2350]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField12),'''') AS [C2351]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField13),'''') AS [C2352]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField14),'''') AS [C2353]
    ,COALESCE(csx.cField17, '''') AS [C2354]
    ,COALESCE(csx.cField18, '''') AS [C2355]
    ,COALESCE(csx.cField19, '''') AS [C2356]
    ,COALESCE(csx.cField20, '''') AS [C2357]
    ,COALESCE(csx.cField21, '''') AS [C2358]
    ,COALESCE(csx.cField22, '''') AS [C2359]
    ,COALESCE(csx.cField23, '''') AS [C2360]
    ,COALESCE(csx.cField24, '''') AS [C2361]
    ,COALESCE(CONVERT(NVARCHAR,cs.lCancelled),'''') AS [C2363]
    ,COALESCE(csx.cField3, '''') AS [cdsrc]
    ,COALESCE(CONVERT(NVARCHAR,csx.tField5), '''') AS [C2381]
    ,COALESCE(CONVERT(NVARCHAR,csx.lField7),'''') AS [C2382]
    ,COALESCE(csx.cField8, '''') AS [C2364]
    ,COALESCE(csx.cField9, '''') AS [C2365]
    ,COALESCE(csx.cField10, '''') AS [C2366]
    ,COALESCE(csx.cField11, '''') AS [C2367]
    ,COALESCE(csx.cField12, '''') AS [C2368]
    ,COALESCE(csx.cField13, '''') AS [C2369]
    ,COALESCE(csx.cField14, '''') AS [C2370]
    ,COALESCE(CONVERT(NVARCHAR,csx.tField1), '''') AS [C2371]
    ,COALESCE(CONVERT(NVARCHAR,csx.tField2), '''') AS [C2372]
    ,COALESCE(CONVERT(NVARCHAR,csx.tField3), '''') AS [C2373]
    ,COALESCE(CONVERT(NVARCHAR,csx.tField4), '''') AS [C2374]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField16),'''') AS [C2375]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField17),'''') AS [C2376]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField18),'''') AS [C2377]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField19),'''') AS [C2378]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField20),'''') AS [C2379]
    ,COALESCE(CONVERT(NVARCHAR,csx.tField5), '''') AS [C2380]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField21),'''') AS [C2383]
    ,COALESCE(csx.mField1, '''') AS [C2384]
    ,COALESCE(csx.cField26, '''') AS [C2385]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField7),'''') AS [C2344]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField8),'''') AS [C2345]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField9),'''') AS [C2346]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField10),'''') AS [C2347]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField22),'''') AS [C2386]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField23),'''') AS [C2387]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField24),'''') AS [C2388]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField25),'''') AS [C2389]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField26),'''') AS [C2390]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField27),'''') AS [C2391]
    ,COALESCE(CONVERT(NVARCHAR,csx.nField28),'''') AS [C2392]
    ,COALESCE(CONVERT(NVARCHAR,csx.lField8),'''') AS [C2393]
    ,COALESCE(CONVERT(NVARCHAR,csx.lField9),'''') AS [C2394]
    ,COALESCE(cs.cCertificationNumber, '''') AS [C2395]
    ,COALESCE(jn.cJobOrderNumber, '''') AS [C2396]
    ,CONVERT(NVARCHAR(36), cust.nFacilityUID) AS [Customers_KTAG]
    ,COALESCE(cust.cFacilityNumber, '''') AS [K4601]
    ,COALESCE(cust.cFacilityName, '''') AS [K4602]
    ,COALESCE(da.cAddress1, '''') AS [K4603]
    ,COALESCE(da.cCity, '''') AS [K4604]
    ,COALESCE(da.cState, '''') AS [K4605]
    ,COALESCE(da.cZip, '''') AS [K4606]
    ,COALESCE(da.cAddress1, '''') AS [K4607]
    ,COALESCE(da.cCity, '''') AS [K4608]
    ,COALESCE(da.cState, '''') AS [K4609]
    ,COALESCE(da.cZip, '''') AS [K4610]
    ,COALESCE(CONVERT(NVARCHAR,cust.lNoTax),'''') AS [K4611]
    ,COALESCE(custEx.cField1, '''') AS [K4612]
    ,COALESCE(custEx.cField2, '''') AS [K4613]
    ,COALESCE(custEx.cField3, '''') AS [K4614]
    ,COALESCE(custEx.cField4, '''') AS [K4615]
    ,COALESCE(custEx.cField5, '''') AS [K4616]
    ,COALESCE(custEx.cField6, '''') AS [K4617]
    ,COALESCE(custEx.cField7, '''') AS [K4618]
    ,COALESCE(custEx.cField8, '''') AS [K4619]
    ,COALESCE(custEx.cField9, '''') AS [K4620]
    ,COALESCE(CONVERT(NVARCHAR,custEx.tField1), '''') AS [K4621]
    ,COALESCE(CONVERT(NVARCHAR,custEx.tField2), '''') AS [K4622]
    ,COALESCE(CONVERT(NVARCHAR,custEx.tField3), '''') AS [K4623]
    ,COALESCE(CONVERT(NVARCHAR,custEx.tField4), '''') AS [K4624]
    ,COALESCE(CONVERT(NVARCHAR,custEx.nField1),'''') AS [K4625]
    ,COALESCE(CONVERT(NVARCHAR,custEx.nField2),'''') AS [K4626]
    ,COALESCE(CONVERT(NVARCHAR,custEx.nField3),'''') AS [K4627]
    ,COALESCE(CONVERT(NVARCHAR,custEx.nField4),'''') AS [K4628]
    ,COALESCE(CONVERT(NVARCHAR(36),cust.nParentFacilityUID),'''') AS [K4640]
    ,cust.tAddTime AS [K4629]
    ,[dbo].[udf_GET_User](cust.nAddUserUID) AS [K4630]
    ,cust.tUpdateTime AS [K4631]
    ,[dbo].[udf_GET_User](cust.nUpdateUserUID) AS [K4632]
    ,COALESCE(custEx.cField15, '''') AS [KDSRC]
    ,COALESCE(CONVERT(NVARCHAR,custEx.lField1),'''') AS [kreplic]
    ,COALESCE(custEx.cField10, '''') AS [K4633]
    ,COALESCE(custEx.cField11, '''') AS [K4634]
    ,COALESCE(custEx.cField12, '''') AS [K4635]
    ,COALESCE(custEx.cField13, '''') AS [K4636]
    ,COALESCE(custEx.cField14, '''') AS [K4637]
    ,COALESCE(ass.cID, '''') AS [I4201]
    ,COALESCE(assg.cFacilityName, '''') AS [I4202]
    ,COALESCE(ass.cModelNumber, '''') AS [I4203]
    ,COALESCE(ass.cDescription, '''') AS [I4204]
    ,COALESCE(assx.cField14, '''') AS [I4205]
    ,COALESCE(ass.cSerialNumber, '''') AS [I4206]
    ,COALESCE(assx.cField15, '''') AS [I4207]
    ,COALESCE(assx.cField16, '''') AS [I4208]
    ,COALESCE(assx.cField33, '''') AS [I4209]
    ,COALESCE(assx.cField17, '''') AS [I4210]
    ,COALESCE(assx.cField18, '''') AS [I4211]
    ,COALESCE(CONVERT(NVARCHAR,assx.tField5), '''') AS [I4212]
    ,COALESCE(assx.cField19, '''') AS [I4213]
    ,COALESCE(ass.cPhysicalLocation, '''') AS [I4214]
    ,COALESCE(assx.cField20, '''') AS [I4215]
    ,COALESCE(assx.cField21, '''') AS [I4216]
    ,COALESCE(assx.cField22, '''') AS [I4217]
    ,COALESCE(dept.cFacilityName, '''') AS [I4218]
    ,COALESCE(CONVERT(NVARCHAR,ass.nItemCost),'''') AS [I4219]
    ,COALESCE(assx.cField6, '''') AS [I4220]
    ,ass.tPurchaseDate AS [I4221]
    ,COALESCE(assx.cField7, '''') AS [I4222]
    ,COALESCE(assx.cField25, '''') AS [I4223]
    ,COALESCE(CONVERT(NVARCHAR,assx.tField5), '''') AS [I4224]
    ,COALESCE(ass.cStatus, '''') AS [I4225]
    ,COALESCE(assx.lField1, '''') AS [I4226]
    ,'''' AS [I4228]
    ,'''' AS [I4229]
    ,COALESCE(CONVERT(NVARCHAR,ass.nUseCount),'''') AS [I4230]
    ,COALESCE(assx.cField1, '''') AS [I4231]
    ,COALESCE(assx.cField2, '''') AS [I4232]
    ,COALESCE(assx.cField3, '''') AS [I4233]
    ,COALESCE(assx.cField4, '''') AS [I4234]
    ,COALESCE(assx.cField5, '''') AS [I4235]
    ,ass.tAddTime AS [I4236]
    ,[dbo].[udf_GET_User](ass.nAddUserUID) AS [I4237]
    ,ass.tUpdateTime AS [I4238]
    ,[dbo].[udf_GET_User](ass.nUpdateUserUID) AS [I4239]
    ,COALESCE(lab.cFacilityName, '''') AS [I4240]
    ,COALESCE(ass.cDisposition, '''') AS [I4299]
    ,COALESCE(CONVERT(NVARCHAR(36),ass.nAssetUID),'''') AS [Inventory_MTAG]
    ,COALESCE(assx.cField23, '''') AS [I4241]
    ,COALESCE(assx.cField24, '''') AS [I4242]
    ,COALESCE(assx.cField26, '''') AS [I4243]
    ,COALESCE(assx.cField29, '''') AS [idsrc]
    ,COALESCE(CONVERT(NVARCHAR(36),ass.nFacilityUID),'''') AS [Inventory_ktag]
    ,COALESCE(assx.cField27, '''') AS [replic]
    ,COALESCE(CONVERT(NVARCHAR,ass.lInAbeyance),'''') AS [I4258]
    ,COALESCE(assx.cField8, '''') AS [I4244]
    ,COALESCE(assx.cField9, '''') AS [I4245]
    ,COALESCE(assx.cField10, '''') AS [I4246]
    ,COALESCE(assx.cField11, '''') AS [I4247]
    ,COALESCE(assx.cField12, '''') AS [I4248]
    ,COALESCE(assx.cField13, '''') AS [I4249]
    ,COALESCE(CONVERT(NVARCHAR,assx.tField1), '''') AS [I4250]
    ,COALESCE(CONVERT(NVARCHAR,assx.tField2), '''') AS [I4251]
    ,COALESCE(CONVERT(NVARCHAR,assx.tField3), '''') AS [I4252]
    ,COALESCE(CONVERT(NVARCHAR,assx.tField4), '''') AS [I4253]
    ,COALESCE(CONVERT(NVARCHAR,assx.nField1),'''') AS [I4254]
    ,COALESCE(CONVERT(NVARCHAR,assx.nField2),'''') AS [I4255]
    ,COALESCE(CONVERT(NVARCHAR,assx.nField3),'''') AS [I4256]
    ,COALESCE(CONVERT(NVARCHAR,assx.nField4),'''') AS [I4257]
    ,COALESCE(CONVERT(NVARCHAR,ass.nAbeyanceInterval),'''') AS [I4259]
    ,COALESCE(ass.mNotes, '''') AS [I4260]
    ,COALESCE(assx.cField31, '''') AS [I4261]
    ,COALESCE(assx.cField32, '''') AS [I4262]
    ,COALESCE(tac.cFirstName, '''') + '' '' + COALESCE(tac.cMiddleName, '''') + '' '' + COALESCE(tac.cLastName, '''') AS [L2801]
    ,COALESCE(ta.cAssignedLocation, '''') AS [L2802]
    ,COALESCE(tax.cField11, '''') AS [L2803]
    ,COALESCE(tax.cField12, '''') AS [L2804]
    ,COALESCE(tax.cField13, '''') AS [L2805]
    ,ta.tReturnDate AS [L2806]
    ,COALESCE(CONVERT(NVARCHAR,tax.tField5), '''') AS [L2807]
    ,COALESCE(CONVERT(NVARCHAR,ta.nUseCount),'''') AS [L2808]
    ,ta.tLoanDate AS [L2809]
    ,ta.tLoanDate AS [L2810]
    ,ta.tAddTime AS [L2811]
    ,[dbo].[udf_GET_User](ta.nAddUserUID) AS [L2812]
    ,ta.tUpdateTime AS [L2813]
    ,[dbo].[udf_GET_User](ta.nUpdateUserUID) AS [L2814]
    ,COALESCE(CONVERT(NVARCHAR,ta.lActive),'''') AS [L2815]
    ,COALESCE(CONVERT(NVARCHAR(36),ta.nAssetUID),'''') AS [Location_MTAG]
    ,COALESCE(CONVERT(NVARCHAR(36),ta.nToolAssignmentUID),'''') AS [ltag]
    ,COALESCE(tax.cField15, '''') AS [ldsrc]
    ,COALESCE(tax.cField14, '''') AS [L2816]
    ,COALESCE(CONVERT(NVARCHAR,tax.nField5),'''') AS [L2817]
    ,COALESCE(CONVERT(NVARCHAR,tax.nField1),'''') AS [L2818]
    ,COALESCE(CONVERT(NVARCHAR,tax.nField2),'''') AS [L2819]
    ,COALESCE(CONVERT(NVARCHAR,tax.nField3),'''') AS [L2820]
    ,COALESCE(CONVERT(NVARCHAR,tax.nField4),'''') AS [L2821]
    ,COALESCE(CONVERT(NVARCHAR,tax.tField1), '''') AS [L2822]
    ,COALESCE(CONVERT(NVARCHAR,tax.tField2), '''') AS [L2823]
    ,COALESCE(CONVERT(NVARCHAR,tax.tField3), '''') AS [L2824]
    ,COALESCE(CONVERT(NVARCHAR,tax.tField4), '''') AS [L2825]
    ,COALESCE(tax.cField1, '''') AS [L2826]
    ,COALESCE(tax.cField2, '''') AS [L2827]
    ,COALESCE(tax.cField3, '''') AS [L2828]
    ,COALESCE(tax.cField4, '''') AS [L2829]
    ,COALESCE(tax.cField5, '''') AS [L2830]
    ,COALESCE(tax.cField6, '''') AS [L2831]
    ,COALESCE(tax.cField7, '''') AS [L2832]
    ,COALESCE(tax.cField8, '''') AS [L2833]
    ,COALESCE(tax.cField9, '''') AS [L2834]
    ,COALESCE(tax.cField10, '''') AS [L2835]
    ,COALESCE(tax.mField1, '''') AS [L2836]
    ,COALESCE(tax.cField21, '''') AS [L2837]
    ,COALESCE(p.cPointDescription, '''') AS [test_desc]
    ,COALESCE(p.cPointPassFailStatus, '''') AS [PointPassFail]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField010, pen.nField010FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField010UnitUID),'''') AS [fixq]
    ,'''' AS [fixq_p]
    ,'''' AS [fixq_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField029, pen.nField029FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField029UnitUID),'''') AS [varq]
    ,'''' AS [varq_p]
    ,'''' AS [varq_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nLowerLimit, pun.nLowerLimitFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nLowerLimitUnitUID),'''') AS [lower_limit]
    ,'''' AS [lower_limit_p]
    ,'''' AS [lower_limit_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUpperLimit, pun.nUpperLimitFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUpperLimitUnitUID),'''') AS [upper_limit]
    ,'''' AS [upper_limit_p]
    ,'''' AS [upper_limit_u]
    ,COALESCE(csr.cStatus, '''') AS [test_status]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyExpanded, pun.nUncertaintyExpandedFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyExpandedUnitUID),'''') AS [exp_uncert]
    ,'''' AS [exp_uncert_p]
    ,'''' AS [exp_uncert_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyStandard, pun.nUncertaintyStandardFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyStandardUnitUID),'''') AS [std_uncert]
    ,'''' AS [std_uncert_p]
    ,'''' AS [std_uncert_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nCoverageFactor, [dbo].[udf_GET_nFormatUID](1.11)),'''') AS [cov_fac]
    ,COALESCE(p.cCondition, '''') AS [condition]
    ,COALESCE(p.cRemarks, '''') AS [remark]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](p.nCardinalPoint, p.nCardinalPointFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nCardinalPointUnitUID),'''') AS [cpt]
    ,'''' AS [cpt_p]
    ,'''' AS [cpt_u]
    ,COALESCE(CONVERT(NVARCHAR,p.lUUTIsFixed),'''') AS [fix_flag]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField015, pen.nField015FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField015UnitUID),'''') AS [nominal]
    ,'''' AS [nominal_p]
    ,'''' AS [nominal_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nModifier1, pun.nModifier1FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nModifier1UnitUID),'''') AS [mod1]
    ,'''' AS [mod1_p]
    ,'''' AS [mod1_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](p.nReference, p.nReferenceFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nReferenceUnitUID),'''') AS [sys_actual]
    ,'''' AS [sys_actual_p]
    ,'''' AS [sys_actual_u]
    ,COALESCE(CONVERT(NVARCHAR,pel.lField001),'''') AS [corr_flag]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField027, pen.nField027FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField027UnitUID),'''') AS [uut_ind]
    ,'''' AS [uut_ind_p]
    ,'''' AS [uut_ind_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField008, pen.nField008FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField008UnitUID),'''') AS [expv]
    ,'''' AS [expv_p]
    ,'''' AS [expv_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](p.nUUT, p.nUUTFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nUUTUnitUID),'''') AS [measurement]
    ,'''' AS [measurement_p]
    ,'''' AS [measurement_u]
    ,COALESCE(CONVERT(NVARCHAR,pel.lField002),'''') AS [meas_flag]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField006, pen.nField006FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField006UnitUID),'''') AS [dev]
    ,'''' AS [dev_p]
    ,'''' AS [dev_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nError, tol.nErrorFormatUID) + '' '' + [dbo].[udf_GET_Unit](tol.nErrorUnitUID),'''') AS [error]
    ,'''' AS [error_p]
    ,'''' AS [error_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nReadingErrorPercent, NULL),'''') AS [rel_err]
    ,'''' AS [rel_err_p]
    ,'''' AS [rel_err_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](p.nCorrection, p.nCorrectionFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nCorrectionUnitUID),'''') AS [corr]
    ,'''' AS [corr_p]
    ,'''' AS [corr_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField004, pen.nField004FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField004UnitUID),'''') AS [corr_unc]
    ,'''' AS [corr_unc_p]
    ,'''' AS [corr_unc_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nReferenceTolerance, tol.nReferenceToleranceFormatUID) + '' '' + [dbo].[udf_GET_Unit](tol.nReferenceToleranceUnitUID),'''') AS [tol_ref]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nToleranceNegative, tol.nToleranceNegativeFormatUID) + '' '' + [dbo].[udf_GET_Unit](tol.nToleranceNegativeUnitUID),'''') AS [tol_neg]
    ,'''' AS [tol_neg_p]
    ,'''' AS [tol_neg_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nTolerancePositive, tol.nTolerancePositiveFormatUID) + '' '' + [dbo].[udf_GET_Unit](tol.nTolerancePositiveUnitUID),'''') AS [tol_pos]
    ,'''' AS [tol_pos_p]
    ,'''' AS [tol_pos_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nTolerance, tol.nToleranceFormatUID) + '' '' + [dbo].[udf_GET_Unit](tol.nToleranceUnitUID),'''') AS [tol]
    ,'''' AS [tol_p]
    ,'''' AS [tol_u]
    ,COALESCE(pes.cField011,'''') AS [tur]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](tol.nToleranceErrorPercent, NULL),'''') AS [tol_err]
    ,'''' AS [tol_err_p]
    ,'''' AS [tol_err_u]
    ,COALESCE(pun.cUncertaintyMethod,'''') AS [uncert_method]
    ,COALESCE(CONVERT(NVARCHAR,stat.nNumberOfSamplesDiscarded),'''') AS [nthrow]
    ,COALESCE(CONVERT(NVARCHAR,stat.nNumberOfSamplesUUT),'''') AS [num_meas]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](stat.nUUTStandardDeviation, stat.nUUTStandardDeviationFormatUID) + '' '' + [dbo].[udf_GET_Unit](stat.nUUTStandardDeviationUnitUID),'''') AS [sdev]
    ,'''' AS [sdev_p]
    ,'''' AS [sdev_u]
    ,COALESCE(CONVERT(NVARCHAR,stat.lNoisy),'''') AS [noisy_flag]
    ,COALESCE(CONVERT(NVARCHAR,stat.lReliable),'''') AS [reliable_flag]
    ,COALESCE(pun.cStudentsT,'''') AS [st_t]
    ,COALESCE(CONVERT(NVARCHAR,pun.lStudentsT),'''') AS [st_t_flag]
    ,COALESCE(CONVERT(NVARCHAR,pel.lField003),'''') AS [ws_flag]
    ,COALESCE(CONVERT(NVARCHAR,pun.lDominant),'''') AS [dominant]
    ,COALESCE(pun.cDegreesOfFreedom1,'''') AS [df1]
    ,COALESCE(pun.cDegreesOfFreedom2,'''') AS [df2]
    ,COALESCE(pun.cDegreesOfFreedom3,'''') AS [df3]
    ,COALESCE(pun.cDegreesOfFreedom4,'''') AS [df4]
    ,COALESCE(pun.cDegreesOfFreedom5,'''') AS [df5]
    ,COALESCE(pun.cDegreesOfFreedom6,'''') AS [df6]
    ,COALESCE(pun.cDegreesOfFreedom7,'''') AS [df7]
    ,COALESCE(pun.cDegreesOfFreedom8,'''') AS [df8]
    ,COALESCE(pun.cDegreesOfFreedom9,'''') AS [df9]
    ,COALESCE(pun.cDegreesOfFreedom10,'''') AS [df10]
    ,COALESCE(pes.cField001,'''') AS [deg_free]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter1, pun.nUncertaintyParameter1FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter1UnitUID),'''') AS [u1]
    ,'''' AS [u1_p]
    ,'''' AS [u1_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter2, pun.nUncertaintyParameter2FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter2UnitUID),'''') AS [u2]
    ,'''' AS [u2_p]
    ,'''' AS [u2_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter3, pun.nUncertaintyParameter3FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter3UnitUID),'''') AS [u3]
    ,'''' AS [u3_p]
    ,'''' AS [u3_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter4, pun.nUncertaintyParameter4FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter4UnitUID),'''') AS [u4]
    ,'''' AS [u4_p]
    ,'''' AS [u4_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter5, pun.nUncertaintyParameter5FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter5UnitUID),'''') AS [u5]
    ,'''' AS [u5_p]
    ,'''' AS [u5_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter6, pun.nUncertaintyParameter6FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter6UnitUID),'''') AS [u6]
    ,'''' AS [u6_p]
    ,'''' AS [u6_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter7, pun.nUncertaintyParameter7FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter7UnitUID),'''') AS [u7]
    ,'''' AS [u7_p]
    ,'''' AS [u7_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter8, pun.nUncertaintyParameter8FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter8UnitUID),'''') AS [u8]
    ,'''' AS [u8_p]
    ,'''' AS [u8_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter9, pun.nUncertaintyParameter9FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter9UnitUID),'''') AS [u9]
    ,'''' AS [u9_p]
    ,'''' AS [u9_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyParameter10, pun.nUncertaintyParameter10FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyParameter10UnitUID),'''') AS [u10]
    ,'''' AS [u10_p]
    ,'''' AS [u10_u]
    ,COALESCE(pun.cSensitivity1,'''') AS [c1]
    ,COALESCE(pun.cSensitivity2,'''') AS [c2]
    ,COALESCE(pun.cSensitivity3,'''') AS [c3]
    ,COALESCE(pun.cSensitivity4,'''') AS [c4]
    ,COALESCE(pun.cSensitivity5,'''') AS [c5]
    ,COALESCE(pun.cSensitivity6,'''') AS [c6]
    ,COALESCE(pun.cSensitivity7,'''') AS [c7]
    ,COALESCE(pun.cSensitivity8,'''') AS [c8]
    ,COALESCE(pun.cSensitivity9,'''') AS [c9]
    ,COALESCE(pun.cSensitivity10,'''') AS [c10]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nS1, pun.nS1FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nS1UnitUID),'''') AS [s1]
    ,'''' AS [s1_p]
    ,'''' AS [s1_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nS2, pun.nS2FormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nS2UnitUID),'''') AS [s2]
    ,'''' AS [s2_p]
    ,'''' AS [s2_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nUncertaintyDominant, pun.nUncertaintyDominantFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nUncertaintyDominantUnitUID),'''') AS [dom_uncert]
    ,'''' AS [dom_uncert_p]
    ,'''' AS [dom_uncert_u]
    ,COALESCE(pes.cField009,'''') AS [test_step]
    ,COALESCE(p.cFunctionSelectCode,'''') AS [fsc]
    ,COALESCE(p.cPointLabel,'''') AS [result_type]
    ,COALESCE(CONVERT(NVARCHAR,p.lAccredited),'''') AS [accred]
    ,COALESCE(pun.cGuardBandMethod,'''') AS [guardband_meth]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nGuardBandLower, pun.nGuardBandLowerFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nGuardBandLowerUnitUID),'''') AS [guardband_ll]
    ,'''' AS [guardband_ll_p]
    ,'''' AS [guardband_ll_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pun.nGuardBandUpper, pun.nGuardBandUpperFormatUID) + '' '' + [dbo].[udf_GET_Unit](pun.nGuardBandUpperUnitUID),'''') AS [guardband_ul]
    ,'''' AS [guardband_ul_p]
    ,'''' AS [guardband_ul_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](p.nSystemAccuracy, p.nSystemAccuracyFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nSystemAccuracyUnitUID),'''') AS [sys_acc]
    ,'''' AS [sys_acc_p]
    ,'''' AS [sys_acc_u]
    ,COALESCE(CONVERT(NVARCHAR,pun.nSystemCoverageFactor),'''') AS [sys_cov_fac]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](p.nUUTRange, p.nUUTRangeFormatUID) + '' '' + [dbo].[udf_GET_Unit](p.nUUTRangeUnitUID),'''') AS [uut_range]
    ,'''' AS [uut_range_p]
    ,'''' AS [uut_range_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField028, pen.nField028FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField028UnitUID),'''') AS [uut_res]
    ,'''' AS [uut_res_p]
    ,'''' AS [uut_res_u]
    ,COALESCE(pes.cField007,'''') AS [sense]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField014, pen.nField014FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField014UnitUID),'''') AS [i_imped]
    ,'''' AS [i_imped_p]
    ,'''' AS [i_imped_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField016, pen.nField016FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField016UnitUID),'''') AS [o_imped1]
    ,'''' AS [o_imped1_p]
    ,'''' AS [o_imped1_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField017, pen.nField017FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField017UnitUID),'''') AS [o_imped2]
    ,'''' AS [o_imped2_p]
    ,'''' AS [o_imped2_u]
    ,COALESCE(pes.cField013,'''') AS [wave1]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField002, pen.nField002FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField002UnitUID),'''') AS [ampl1]
    ,'''' AS [ampl1_p]
    ,'''' AS [ampl1_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField012, pen.nField012FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField012UnitUID),'''') AS [freq1]
    ,'''' AS [freq1_p]
    ,'''' AS [freq1_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField018, pen.nField018FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField018UnitUID),'''') AS [per1]
    ,'''' AS [per1_p]
    ,'''' AS [per1_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField023, pen.nField023FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField023UnitUID),'''') AS [pulse_width]
    ,'''' AS [pulse_width_p]
    ,'''' AS [pulse_width_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField005, pen.nField005FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField005UnitUID),'''') AS [dc_offset]
    ,'''' AS [dc_offset_p]
    ,'''' AS [dc_offset_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField007, pen.nField007FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField007UnitUID),'''') AS [duty_cycle]
    ,'''' AS [duty_cycle_p]
    ,'''' AS [duty_cycle_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField024, pen.nField024FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField024UnitUID),'''') AS [rise]
    ,'''' AS [rise_p]
    ,'''' AS [rise_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField009, pen.nField009FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField009UnitUID),'''') AS [fall]
    ,'''' AS [fall_p]
    ,'''' AS [fall_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField026, pen.nField026FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField026UnitUID),'''') AS [trigger_skew]
    ,'''' AS [trigger_skew_p]
    ,'''' AS [trigger_skew_u]
    ,COALESCE(pes.cField012,'''') AS [video]
    ,COALESCE(pes.cField005,'''') AS [polarity]
    ,COALESCE(pes.cField006,'''') AS [rtd_type]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField025, pen.nField025FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField025UnitUID),'''') AS [rtd_nom_res]
    ,'''' AS [rtd_nom_res_p]
    ,'''' AS [rtd_nom_res_u]
    ,COALESCE(pes.cField008,'''') AS [tc_type]
    ,COALESCE(pes.cField004,'''') AS [mod_source]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField001, pen.nField001FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField001UnitUID),'''') AS [am_depth]
    ,'''' AS [am_depth_p]
    ,'''' AS [am_depth_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField011, pen.nField011FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField011UnitUID),'''') AS [fm_dev]
    ,'''' AS [fm_dev_p]
    ,'''' AS [fm_dev_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField021, pen.nField021FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField021UnitUID),'''') AS [phase_dev]
    ,'''' AS [phase_dev_p]
    ,'''' AS [phase_dev_u]
    ,COALESCE(pes.cField014,'''') AS [wave2]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField003, pen.nField003FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField003UnitUID),'''') AS [ampl2]
    ,'''' AS [ampl2_p]
    ,'''' AS [ampl2_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField013, pen.nField013FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField013UnitUID),'''') AS [freq2]
    ,'''' AS [freq2_p]
    ,'''' AS [freq2_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField019, pen.nField019FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField019UnitUID),'''') AS [per2]
    ,'''' AS [per2_p]
    ,'''' AS [per2_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField022, pen.nField022FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField022UnitUID),'''') AS [power]
    ,'''' AS [power_p]
    ,'''' AS [power_u]
    ,COALESCE([dbo].[udf_GET_FormattedValueEx](pen.nField020, pen.nField020FormatUID) + '' '' + [dbo].[udf_GET_Unit](pen.nField020UnitUID),'''') AS [phase]
    ,'''' AS [phase_p]
    ,'''' AS [phase_u]
    ,COALESCE(pes.cField002,'''') AS [dpf]
    ,COALESCE(pes.cField003,'''') AS [dpf_polarity]
    ,COALESCE(CONVERT(NVARCHAR(36),cs.nAssetUID),'''') AS [Results_mtag]
    ,p.tAddTime AS [created]
    ,[dbo].[udf_GET_User](p.nAddUserUID) AS [createdby]
    ,p.tUpdateTime AS [editlogtime]
    ,[dbo].[udf_GET_User](p.nUpdateUserUID) AS [modifiedby]
    ,COALESCE(pes.cField010,'''') AS [test_step2]
    ,[dbo].[udf_GET_User](cs.nTechnicianUID) AS [Logon_User]
    ,'''' AS [User_level]
    ,[dbo].[udf_GET_UserFull](cs.nTechnicianUID) AS [User_Full_Name]
    ,'''' AS [User_Segregate]
    ,COALESCE(u.cPayGrade,'''') AS [User_Rate]
    ,COALESCE(csr.cWorkstationName,'''') AS [WorkStation]
    ,COALESCE(csr.cDescription,'''') AS [CSR]
    ,COALESCE(prcsr.cProcedureName,''No Procedure'') AS [Procedure]
    ,COALESCE(CONVERT(NVARCHAR(36), csr.nCallSheetResultUID), '''') AS [ResultUID]
    ,ISNULL(pr.cRevision, '''') AS [cRevision]
    ,ISNULL(pr.cVersion, '''') AS [cVersion]
    ,CONVERT(NVARCHAR(36), csr.nTechnicianUID) AS [nTechnicianUID]
    ,CONVERT(NVARCHAR(36), csr.nRunAtFacilityUID) AS [nRunAtFacilityUID]
    ,csr.nCallSheetResultOrdinal
    ,ISNULL(csr.cDataOrigin,'''') AS [cDataOrigin]
    ,ISNULL(csr.cCallSheetResultType,'''') AS [cCallSheetResultType]
    ,csr.tStartTime
    ,csr.tEndTime
    ,p.nPointUID
    FROM
    [dbo].[CallSheets] cs
        LEFT JOIN [dbo].[CallSheetEx] csx ON csx.nCallSheetUID = cs.nCallSheetUID
        LEFT JOIN [dbo].[users] u ON u.nUserUID = cs.nTechnicianUID
        LEFT JOIN [dbo].[CallSheetResults] csr ON csr.nCallSheetUID = cs.nCallSheetUID AND csr.lDeleted = 0 AND csr.lActive <> 0
        LEFT JOIN [dbo].[Points] p ON p.nCallSheetResultUID = csr.nCallSheetResultUID
        LEFT JOIN [dbo].[facilities] wf ON wf.nFacilityUID = cs.nWorkingFacilityUID
        LEFT JOIN [dbo].[procedures] pr ON pr.nProcedureUID = cs.nProcedureUID
        LEFT JOIN [dbo].[procedures] prcsr ON prcsr.nProcedureUID = csr.nProcedureUID
        LEFT JOIN [dbo].[jobnumbers] jn ON jn.nJobNumberUID = cs.nJobNumberUID
        LEFT JOIN [dbo].[assets] ass ON ass.nAssetUID = cs.nAssetUID
        LEFT JOIN [dbo].[facilities] cust ON COALESCE(cust.lCustomer, 0) = -1 AND cust.nFacilityUID = ass.nFacilityUID
        LEFT JOIN [dbo].[facilityex] custEx ON custEx.nFacilityUID = cust.nFacilityUID
        LEFT JOIN [dbo].[addresses] da ON da.cType = ''Default'' AND da.nFacilityUID = cust.nFacilityUID AND da.lDeleted = 0 AND da.lActive <> 0
        LEFT JOIN [dbo].[AssetEx] assx ON assx.nAssetUID = ass.nAssetUID
        LEFT JOIN [dbo].[facilities] assg ON assg.nFacilityUID = ass.nManufacturerUID
        LEFT JOIN [dbo].[facilities] dept ON dept.nFacilityUID = ass.nDepartmentUID
        LEFT JOIN [dbo].[facilities] lab ON lab.nFacilityUID = ass.nFacilityUID
        LEFT JOIN [dbo].[toolassignments] ta ON ta.lActive <> 0 AND ta.lDeleted = 0 AND ta.tReturnDate IS NULL AND ta.nAssetUID = ass.nAssetUID
        LEFT JOIN [dbo].[toolassignmentex] tax ON tax.nToolAssignmentUID = ta.nToolAssignmentUID
        LEFT JOIN [dbo].[contacts] tac ON tac.nContactUID = ta.nContactUID
        LEFT JOIN [dbo].[PointExNumerics] pen ON pen.nPointUID = p.nPointUID
        LEFT JOIN [dbo].[PointUncertainties] pun ON pun.nPointUID = p.nPointUID
        LEFT JOIN [dbo].[PointExLogicals] pel ON pel.nPointUID = p.nPointUID
        LEFT JOIN [dbo].[PointTolerances] tol ON tol.nPointUID = p.nPointUID
        LEFT JOIN [dbo].[PointExStrings] pes ON pes.nPointUID = p.nPointUID
        LEFT JOIN [dbo].[PointStatistics] stat ON stat.nPointUID = p.nPointUID
    WHERE
        cs.nCallSheetUID = @nCallSheetUID
    AND
        COALESCE(p.lDeleted, 0) = 0
    AND
        COALESCE(p.lActive, -1) <> 0
    ORDER BY
        COALESCE(csr.nCallSheetResultOrdinal, 0), COALESCE(p.nPointOrdinal, 0)
    END

	'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-4660<<--
	IF OBJECT_ID(N'[dbo].[CallSheetResultStandardLink]', 'U') IS NULL
	BEGIN
		PRINT N'Adding table [dbo].[CallSheetResultStandardLink]'

		CREATE TABLE [dbo].[CallSheetResultStandardLink](
			[nCallSheetResultStandardLinkUID] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
			[nCallSheetResultUID] [uniqueidentifier] NOT NULL,
			[nCallSheetStandardLinkUID] [uniqueidentifier] NOT NULL,
			[lActive] [int] NOT NULL,
			[lDeleted] [int] NOT NULL,
			[lApproved] [int] NOT NULL,
			[lAdded] [int] NOT NULL,
			[nAddFacilityUID] [uniqueidentifier] NOT NULL,
			[nAddUserUID] [uniqueidentifier] NOT NULL,
			[tAddTime] [datetime] NOT NULL,
			[nUpdateFacilityUID] [uniqueidentifier] NOT NULL,
			[nUpdateUserUID] [uniqueidentifier] NOT NULL,
			[tUpdateTime] [datetime] NOT NULL,
			[tMobileTime] [datetime] NOT NULL,
			[tSystemUpdateTime] [datetime] NULL,
			[nImportUID] [uniqueidentifier] NULL,
		 CONSTRAINT [PK_CallSheetResultStandardLink] PRIMARY KEY NONCLUSTERED 
		(
			[nCallSheetResultStandardLinkUID] ASC
		)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
		) ON [PRIMARY]


		ALTER TABLE [dbo].[CallSheetResultStandardLink] ADD  CONSTRAINT [DF_CallSheetResultStandardLink_lActive]  DEFAULT (-1) FOR [lActive]


		ALTER TABLE [dbo].[CallSheetResultStandardLink] ADD  CONSTRAINT [DF_CallSheetResultStandardLink_lDeleted]  DEFAULT (0) FOR [lDeleted]


		ALTER TABLE [dbo].[CallSheetResultStandardLink] ADD  CONSTRAINT [DF_CallSheetResultStandardLink_lApproved]  DEFAULT (0) FOR [lApproved]


		ALTER TABLE [dbo].[CallSheetResultStandardLink] ADD  CONSTRAINT [DF_CallSheetResultStandardLink_lAdded]  DEFAULT (-1) FOR [lAdded]


		ALTER TABLE [dbo].[CallSheetResultStandardLink] ADD  CONSTRAINT [DF_CallSheetResultStandardLink_nAddFacilityUID]  DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398') FOR [nAddFacilityUID]


		ALTER TABLE [dbo].[CallSheetResultStandardLink] ADD  CONSTRAINT [DF_CallSheetResultStandardLink_nAddUserUID]  DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172') FOR [nAddUserUID]


		ALTER TABLE [dbo].[CallSheetResultStandardLink] ADD  CONSTRAINT [DF_CallSheetResultStandardLink_tAddTime]  DEFAULT (getutcdate()) FOR [tAddTime]


		ALTER TABLE [dbo].[CallSheetResultStandardLink] ADD  CONSTRAINT [DF_CallSheetResultStandardLink_nUpdateFacilityUID]  DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398') FOR [nUpdateFacilityUID]


		ALTER TABLE [dbo].[CallSheetResultStandardLink] ADD  CONSTRAINT [DF_CallSheetResultStandardLink_nUpdateUserUID]  DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172') FOR [nUpdateUserUID]


		ALTER TABLE [dbo].[CallSheetResultStandardLink] ADD  CONSTRAINT [DF_CallSheetResultStandardLink_tUpdateTime]  DEFAULT (getutcdate()) FOR [tUpdateTime]


		ALTER TABLE [dbo].[CallSheetResultStandardLink] ADD  CONSTRAINT [DF_CallSheetResultStandardLink_tMobileTime]  DEFAULT (getutcdate()) FOR [tMobileTime]


		ALTER TABLE [dbo].[CallSheetResultStandardLink]  WITH CHECK ADD  CONSTRAINT [FK_CallSheetResultStandardLink_CallSheetResults] FOREIGN KEY([nCallSheetResultUID])
		REFERENCES [dbo].[CallSheetResults] ([nCallSheetResultUID])


		ALTER TABLE [dbo].[CallSheetResultStandardLink]  WITH CHECK ADD  CONSTRAINT [FK_CallSheetResultStandardLink_CallSheetStandardLink] FOREIGN KEY([nCallSheetStandardLinkUID])
		REFERENCES [dbo].[CallSheetStandardLink] ([nCallSheetStandardLinkUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Unique system identifier used by the system' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CallSheetResultStandardLink', @level2type=N'COLUMN',@level2name=N'nCallSheetResultStandardLinkUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Relates to the the call sheet result' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CallSheetResultStandardLink', @level2type=N'COLUMN',@level2name=N'nCallSheetResultUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Relates to the the call sheet standard link' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CallSheetResultStandardLink', @level2type=N'COLUMN',@level2name=N'nCallSheetStandardLinkUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=inactive; -1 or 1=active' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CallSheetResultStandardLink', @level2type=N'COLUMN',@level2name=N'lActive'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not deleted; -1 or 1=deleted' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CallSheetResultStandardLink', @level2type=N'COLUMN',@level2name=N'lDeleted'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not approved; -1 or 1=approved' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CallSheetResultStandardLink', @level2type=N'COLUMN',@level2name=N'lApproved'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not added; -1 or 1=added' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CallSheetResultStandardLink', @level2type=N'COLUMN',@level2name=N'lAdded'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the lab that added the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CallSheetResultStandardLink', @level2type=N'COLUMN',@level2name=N'nAddFacilityUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the user that added the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CallSheetResultStandardLink', @level2type=N'COLUMN',@level2name=N'nAddUserUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was added' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CallSheetResultStandardLink', @level2type=N'COLUMN',@level2name=N'tAddTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the lab that last updated the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CallSheetResultStandardLink', @level2type=N'COLUMN',@level2name=N'nUpdateFacilityUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the last user to update the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CallSheetResultStandardLink', @level2type=N'COLUMN',@level2name=N'nUpdateUserUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CallSheetResultStandardLink', @level2type=N'COLUMN',@level2name=N'tUpdateTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated for Mobile mode' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CallSheetResultStandardLink', @level2type=N'COLUMN',@level2name=N'tMobileTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated for the Warehouse' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CallSheetResultStandardLink', @level2type=N'COLUMN',@level2name=N'tSystemUpdateTime'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'If imported, contains UID of the import record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CallSheetResultStandardLink', @level2type=N'COLUMN',@level2name=N'nImportUID'


		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contains information about the standards used by a specific procedure section' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CallSheetResultStandardLink'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[spl_CallSheetResultStandardLink_RETRIEVE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_CallSheetResultStandardLink_RETRIEVE]'
		DROP PROCEDURE [dbo].[spl_CallSheetResultStandardLink_RETRIEVE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_CallSheetResultStandardLink_RETRIEVE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_CallSheetResultStandardLink_RETRIEVE]'

		EXEC sp_executesql N'		
/****************************************************************
	spl_CallSheetResultStandardLink_RETRIEVE
	Retrieves a single record by ID from the CallSheetResultStandardLink table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 7/20/2021 (R)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_CallSheetResultStandardLink_RETRIEVE]
	
@nCallSheetResultStandardLinkUID uniqueidentifier


AS
BEGIN

	SELECT
[nCallSheetResultStandardLinkUID]
		,[nCallSheetResultUID]
		,[nCallSheetStandardLinkUID]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[CallSheetResultStandardLink]
	WHERE
[nCallSheetResultStandardLinkUID] = @nCallSheetResultStandardLinkUID

	
	RETURN
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	IF OBJECT_ID(N'[dbo].[spl_CallSheetResultStandardLink_LIST]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_CallSheetResultStandardLink_LIST]'
		DROP PROCEDURE [dbo].[spl_CallSheetResultStandardLink_LIST]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_CallSheetResultStandardLink_LIST]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_CallSheetResultStandardLink_LIST]'

		EXEC sp_executesql N'		
/****************************************************************
	spl_CallSheetResultStandardLink_LIST
	Retrieves all records from the CallSheetResultStandardLink table
	Optionally includes inactive records
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 7/20/2021 (L)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_CallSheetResultStandardLink_LIST]
	
@includeInactive	INT	= 0

AS
BEGIN

	SELECT
[nCallSheetResultStandardLinkUID]
		,[nCallSheetResultUID]
		,[nCallSheetStandardLinkUID]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[CallSheetResultStandardLink]
	WHERE
		ABS(lActive) + @includeInactive > 0
		AND
		lDeleted = 0
	
	RETURN
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_CallSheetResultStandardLink_INSERT]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_CallSheetResultStandardLink_INSERT]'
		DROP PROCEDURE [dbo].[spl_CallSheetResultStandardLink_INSERT]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_CallSheetResultStandardLink_INSERT]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_CallSheetResultStandardLink_INSERT]'
		
		EXEC sp_executesql N'	
/****************************************************************
	spl_CallSheetResultStandardLink_INSERT
	Inserts a new record into the CallSheetResultStandardLink table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 7/20/2021 (I)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_CallSheetResultStandardLink_INSERT]
	
@nCallSheetResultUID uniqueidentifier 
	,@nCallSheetStandardLinkUID uniqueidentifier 
	,@lActive int  = -1 
	,@lDeleted int  = 0 
	,@lApproved int  = 0 
	,@lAdded int  = -1 
	,@nAddFacilityUID uniqueidentifier  = ''DBA97ADF-F868-459D-8343-DE1DF0FFB398'' 
	,@nAddUserUID uniqueidentifier  = ''915F9722-3175-4E4D-A571-4A478E8E5172'' 
	,@nImportUID uniqueidentifier  = NULL 

	,@nCallSheetResultStandardLinkUID [uniqueidentifier] = NULL OUTPUT

AS
BEGIN

	DECLARE @ID [uniqueidentifier] = NEWID()

	INSERT INTO [dbo].[CallSheetResultStandardLink] (
		[nCallSheetResultStandardLinkUID]
,[nCallSheetResultUID]
		,[nCallSheetStandardLinkUID]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]

		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@ID
,@nCallSheetResultUID
		,@nCallSheetStandardLinkUID
		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@nImportUID

		,GetUTCDate()
		,@nAddUserUID
		,@nAddFacilityUID
		,GetUTCDate()
		,GetUTCDate()
	)

	-- Return the new GUID for the UID of this record to the caller
	SET @nCallSheetResultStandardLinkUID = @ID

	-- Avoids warning in VS2010
	RETURN 1
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	IF OBJECT_ID(N'[dbo].[spl_CallSheetResultStandardLink_DELETE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_CallSheetResultStandardLink_DELETE]'
		DROP PROCEDURE [dbo].[spl_CallSheetResultStandardLink_DELETE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_CallSheetResultStandardLink_DELETE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_CallSheetResultStandardLink_DELETE]'

		EXEC sp_executesql N'	
/****************************************************************
	spl_CallSheetResultStandardLink_DELETE
	Deletes a single record by ID from the CallSheetResultStandardLink table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 7/20/2021 (D)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_CallSheetResultStandardLink_DELETE]

	@nCallSheetResultStandardLinkUID uniqueidentifier,
	@nUpdateUserUID 		[uniqueidentifier],
	@nUpdateFacilityUID		[uniqueidentifier],
	@retMsg					tinyint OUTPUT
	
AS
BEGIN

	DECLARE @recordID nvarchar(50)
	DECLARE @userID nvarchar(50)
	DECLARE @facilityUID nvarchar(50)
	DECLARE @now nvarchar(50)

	SELECT
		@recordID = CONVERT( nvarchar(50), @nCallSheetResultStandardLinkUID ),
		@now = CONVERT( nvarchar(50), GetUTCDate() ),
		@userID = CONVERT( nvarchar(50), @nUpdateUserUID ),
		@facilityUID = CONVERT( nvarchar(50), @nUpdateFacilityUID ) 

	EXEC sp_CheckAndDelete
		1,							-- MarkDeleted
		''CallSheetResultStandardLink'',		-- TableName
		@recordID,					-- PrimaryKeyValue
		1,							-- IsPrimaryKeyString
		'''',	-- TableExceptions
		1,							-- ExceptDeletions
		@facilityUID,				-- FacilityUID
		@userID,					-- UpdateUserUID
		@now,						-- UpdateTime
		@retMsg OUTPUT
	
	RETURN @retMsg
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END



	IF OBJECT_ID(N'[dbo].[spl_CallSheetResultStandardLink_UPDATE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_CallSheetResultStandardLink_UPDATE]'
		DROP PROCEDURE [dbo].[spl_CallSheetResultStandardLink_UPDATE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_CallSheetResultStandardLink_UPDATE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_CallSheetResultStandardLink_UPDATE]'

		EXEC sp_executesql N'		
/****************************************************************
	spl_CallSheetResultStandardLink_UPDATE
	Updates a single record by ID in the CallSheetResultStandardLink table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 7/20/2021 (U)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_CallSheetResultStandardLink_UPDATE]
	
@nCallSheetResultStandardLinkUID uniqueidentifier
	,@nCallSheetResultUID uniqueidentifier
	,@nCallSheetStandardLinkUID uniqueidentifier
	,@lActive int
	,@lDeleted int
	,@lApproved int
	,@lAdded int
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@nImportUID uniqueidentifier


AS
BEGIN
	DECLARE @DateNow datetime = GetUTCDate();

	UPDATE [dbo].[CallSheetResultStandardLink]
	SET
[nCallSheetResultUID] = @nCallSheetResultUID
		,[nCallSheetStandardLinkUID] = @nCallSheetStandardLinkUID
		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[nImportUID] = @nImportUID

		,[tUpdateTime] = @DateNow
		,[tMobileTime] = @DateNow
	WHERE
[nCallSheetResultStandardLinkUID] = @nCallSheetResultStandardLinkUID

	
	RETURN
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


    IF NOT EXISTS(SELECT * FROM [dbo].[AuditTables] WHERE [TableID] = 85)
    BEGIN
        PRINT 'Adding table [CallSheetResultStandardLink] to [AuditTables]'

        SET IDENTITY_INSERT [dbo].[AuditTables] ON
        INSERT INTO [dbo].[AuditTables] ([TableID], [Owner], [TableName], [AuditTable], [AuditInserts], [AuditUpdates], [AuditDeletes], [AuditDeletesAll], [UniqueKeyType], [UserColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID]) 
        VALUES (85, N'dbo', N'CallSheetResultStandardLink', 1, 1, 1, 0, 1, 'P', N' ', -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', '20210720 22:20:31', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditTables] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '70cf71ad-308c-44a3-b060-fd1b6ccf0375')
    BEGIN
        PRINT 'Adding column [CallSheetResultStandardLink].[nCallSheetResultStandardLinkUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('70cf71ad-308c-44a3-b060-fd1b6ccf0375', 85, 3056, N'nCallSheetResultStandardLinkUID', 1, 0, 0, 1, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', '20210720 22:20:31', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'b2fea771-ceaa-4237-bb3c-d36912a25abe')
    BEGIN
        PRINT 'Adding column [CallSheetResultStandardLink].[nCallSheetResultUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('b2fea771-ceaa-4237-bb3c-d36912a25abe', 85, 3057, N'nCallSheetResultUID', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', '20210720 22:20:31', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '6d9aebf1-094f-41de-965a-5c1d36cb2377')
    BEGIN
        PRINT 'Adding column [CallSheetResultStandardLink].[nCallSheetStandardLinkUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('6d9aebf1-094f-41de-965a-5c1d36cb2377', 85, 3058, N'nCallSheetStandardLinkUID', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', '20210720 22:20:31', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '7ef933f4-de0e-4c7c-9a73-fcc79e8d23c0')
    BEGIN
        PRINT 'Adding column [CallSheetResultStandardLink].[lActive] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('7ef933f4-de0e-4c7c-9a73-fcc79e8d23c0', 85, 3059, N'lActive', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', '20210720 22:20:31', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '202d795b-1274-4ac5-b5a1-41dec60be7be')
    BEGIN
        PRINT 'Adding column [CallSheetResultStandardLink].[lDeleted] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('202d795b-1274-4ac5-b5a1-41dec60be7be', 85, 3060, N'lDeleted', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', '20210720 22:20:31', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'da08d379-0346-437c-8cc9-25f13a8d215e')
    BEGIN
        PRINT 'Adding column [CallSheetResultStandardLink].[lApproved] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('da08d379-0346-437c-8cc9-25f13a8d215e', 85, 3061, N'lApproved', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', '20210720 22:20:31', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '2b9dc1e1-4608-4392-9146-59e4991a8a67')
    BEGIN
        PRINT 'Adding column [CallSheetResultStandardLink].[lAdded] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('2b9dc1e1-4608-4392-9146-59e4991a8a67', 85, 3062, N'lAdded', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', '20210720 22:20:31', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'bfc57bcf-dcf0-49bb-8748-4af31f13cebd')
    BEGIN
        PRINT 'Adding column [CallSheetResultStandardLink].[nAddFacilityUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('bfc57bcf-dcf0-49bb-8748-4af31f13cebd', 85, 3063, N'nAddFacilityUID', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', '20210720 22:20:31', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '98030fc2-9093-45f4-9474-f9755410593e')
    BEGIN
        PRINT 'Adding column [CallSheetResultStandardLink].[nAddUserUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('98030fc2-9093-45f4-9474-f9755410593e', 85, 3064, N'nAddUserUID', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', '20210720 22:20:31', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '1c44222b-c6e7-41ef-8a00-e625e6704a5d')
    BEGIN
        PRINT 'Adding column [CallSheetResultStandardLink].[tAddTime] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('1c44222b-c6e7-41ef-8a00-e625e6704a5d', 85, 3065, N'tAddTime', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', '20210720 22:20:31', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '3645187f-b451-4599-bf39-9a7f59434bbf')
    BEGIN
        PRINT 'Adding column [CallSheetResultStandardLink].[nUpdateFacilityUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('3645187f-b451-4599-bf39-9a7f59434bbf', 85, 3066, N'nUpdateFacilityUID', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', '20210720 22:20:31', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'c1d934b7-6ac4-4da2-930f-07875ae201a5')
    BEGIN
        PRINT 'Adding column [CallSheetResultStandardLink].[nUpdateUserUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('c1d934b7-6ac4-4da2-930f-07875ae201a5', 85, 3067, N'nUpdateUserUID', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', '20210720 22:20:31', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '440559ee-8011-44be-86f3-3afe5762e154')
    BEGIN
        PRINT 'Adding column [CallSheetResultStandardLink].[tUpdateTime] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('440559ee-8011-44be-86f3-3afe5762e154', 85, 3068, N'tUpdateTime', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', '20210720 22:20:31', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '2f5e7910-e9de-4c6b-bfad-c5dd9f5d16fe')
    BEGIN
        PRINT 'Adding column [CallSheetResultStandardLink].[tMobileTime] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('2f5e7910-e9de-4c6b-bfad-c5dd9f5d16fe', 85, 3069, N'tMobileTime', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', '20210720 22:20:31', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'afa03623-4b0f-46de-8c3c-42b5937d8eb4')
    BEGIN
        PRINT 'Adding column [CallSheetResultStandardLink].[tSystemUpdateTime] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('afa03623-4b0f-46de-8c3c-42b5937d8eb4', 85, 3070, N'tSystemUpdateTime', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', '20210720 22:20:31', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'fb134289-be60-40cf-ab27-cd3b8326932e')
    BEGIN
        PRINT 'Adding column [CallSheetResultStandardLink].[nImportUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('fb134289-be60-40cf-ab27-cd3b8326932e', 85, 3071, N'nImportUID', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210720 22:20:31', '20210720 22:20:31', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheetResultStandardLink_Del]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_CallSheetResultStandardLink_Del] from [dbo].[CallSheetResultStandardLink]'

    	DROP TRIGGER [dbo].[tr_kr_audit_CallSheetResultStandardLink_Del]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheetResultStandardLink_Del]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_CallSheetResultStandardLink_Del] on [dbo].[CallSheetResultStandardLink]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_CallSheetResultStandardLink_Del] ON [dbo].[CallSheetResultStandardLink] FOR DELETE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20210720 22:20:31

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM DELETED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3059,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3062,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3061,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3060,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3063,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3064,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3056,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetResultStandardLinkUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3057,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetResultUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3058,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetStandardLinkUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3071,
            0,
            CONVERT(NVARCHAR( 36 ), [nImportUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3066,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3067,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3065,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3069,
            0,
            CONVERT( NVARCHAR( 34 ), [tMobileTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3070,
            0,
            CONVERT( NVARCHAR( 34 ), [tSystemUpdateTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3068,
            0,
            CONVERT( NVARCHAR( 34 ), [tUpdateTime], 121 )
        FROM
            DELETED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 85, @RowsAffected, ''D'', @AuditedUser
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_CallSheetResultStandardLink_Del]', 'last', 'delete', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheetResultStandardLink_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_CallSheetResultStandardLink_Ins] from [dbo].[CallSheetResultStandardLink]'

    	DROP TRIGGER [dbo].[tr_kr_audit_CallSheetResultStandardLink_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheetResultStandardLink_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_CallSheetResultStandardLink_Ins] on [dbo].[CallSheetResultStandardLink]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_CallSheetResultStandardLink_Ins] ON [dbo].[CallSheetResultStandardLink] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20210720 22:20:31

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3059,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3062,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3061,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3060,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3063,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3064,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3056,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetResultStandardLinkUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3057,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetResultUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3058,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetStandardLinkUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetResultStandardLinkUID]),
            3065,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 85, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_CallSheetResultStandardLink_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheetResultStandardLink_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_CallSheetResultStandardLink_Upd] from [dbo].[CallSheetResultStandardLink]'

    	DROP TRIGGER [dbo].[tr_kr_audit_CallSheetResultStandardLink_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheetResultStandardLink_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_CallSheetResultStandardLink_Upd] on [dbo].[CallSheetResultStandardLink]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_CallSheetResultStandardLink_Upd] ON [dbo].[CallSheetResultStandardLink] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20210720 22:20:31

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nCallSheetResultStandardLinkUID] = i.[nCallSheetResultStandardLinkUID] )

        -- Populate audit detail records...
        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultStandardLinkUID], d.[nCallSheetResultStandardLinkUID] )),
                3059,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultStandardLinkUID] = i.[nCallSheetResultStandardLinkUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultStandardLinkUID], d.[nCallSheetResultStandardLinkUID] )),
                3062,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultStandardLinkUID] = i.[nCallSheetResultStandardLinkUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultStandardLinkUID], d.[nCallSheetResultStandardLinkUID] )),
                3061,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultStandardLinkUID] = i.[nCallSheetResultStandardLinkUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultStandardLinkUID], d.[nCallSheetResultStandardLinkUID] )),
                3060,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultStandardLinkUID] = i.[nCallSheetResultStandardLinkUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultStandardLinkUID], d.[nCallSheetResultStandardLinkUID] )),
                3063,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultStandardLinkUID] = i.[nCallSheetResultStandardLinkUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultStandardLinkUID], d.[nCallSheetResultStandardLinkUID] )),
                3064,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultStandardLinkUID] = i.[nCallSheetResultStandardLinkUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCallSheetResultStandardLinkUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultStandardLinkUID], d.[nCallSheetResultStandardLinkUID] )),
                3056,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCallSheetResultStandardLinkUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCallSheetResultStandardLinkUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultStandardLinkUID] = i.[nCallSheetResultStandardLinkUID] )
            WHERE
                ( d.[nCallSheetResultStandardLinkUID] <> i.[nCallSheetResultStandardLinkUID] ) OR
                ( d.[nCallSheetResultStandardLinkUID] IS NULL AND i.[nCallSheetResultStandardLinkUID] IS NOT NULL ) OR
                ( i.[nCallSheetResultStandardLinkUID] IS NULL AND d.[nCallSheetResultStandardLinkUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nCallSheetResultUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultStandardLinkUID], d.[nCallSheetResultStandardLinkUID] )),
                3057,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCallSheetResultUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCallSheetResultUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultStandardLinkUID] = i.[nCallSheetResultStandardLinkUID] )
            WHERE
                ( d.[nCallSheetResultUID] <> i.[nCallSheetResultUID] ) OR
                ( d.[nCallSheetResultUID] IS NULL AND i.[nCallSheetResultUID] IS NOT NULL ) OR
                ( i.[nCallSheetResultUID] IS NULL AND d.[nCallSheetResultUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCallSheetStandardLinkUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultStandardLinkUID], d.[nCallSheetResultStandardLinkUID] )),
                3058,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCallSheetStandardLinkUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCallSheetStandardLinkUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultStandardLinkUID] = i.[nCallSheetResultStandardLinkUID] )
            WHERE
                ( d.[nCallSheetStandardLinkUID] <> i.[nCallSheetStandardLinkUID] ) OR
                ( d.[nCallSheetStandardLinkUID] IS NULL AND i.[nCallSheetStandardLinkUID] IS NOT NULL ) OR
                ( i.[nCallSheetStandardLinkUID] IS NULL AND d.[nCallSheetStandardLinkUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetResultStandardLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetResultStandardLinkUID], d.[nCallSheetResultStandardLinkUID] )),
                3065,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetResultStandardLinkUID] = i.[nCallSheetResultStandardLinkUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN
        
            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED
        
            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 85, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_CallSheetResultStandardLink_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


	-->>MTM-4565<<--
	-->>MTM-4565<<--
    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '8d483af6-584c-4d0c-ad2f-04fc40d6b3d0')
    BEGIN
        PRINT 'Adding column [CallSheets].[lOptional1] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('8d483af6-584c-4d0c-ad2f-04fc40d6b3d0', 20, 3072, N'lOptional1', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210726 23:35:51', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210726 23:35:51', '20210726 23:35:51', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'a1823da2-9f67-4eae-80e5-1fd5033d8cd4')
    BEGIN
        PRINT 'Adding column [CallSheets].[lOptional2] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('a1823da2-9f67-4eae-80e5-1fd5033d8cd4', 20, 3073, N'lOptional2', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210726 23:36:42', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210726 23:36:42', '20210726 23:36:42', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'e00d6857-0634-4a82-b7d1-9a9ff237ea86')
	BEGIN 
	    PRINT N'Adding UCI Data Item for lOptional1'

	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('e00d6857-0634-4a82-b7d1-9a9ff237ea86', N'CallSheets', N'lOptional1', N'Label', N'Optional 1',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210729 16:34:38.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210729 16:34:38.000','20210729 16:34:38.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '5758f263-4da8-4a15-ad38-3a4b5ad8e283')
	BEGIN 
	    PRINT N'Adding Context Element for lOptional1'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('5758f263-4da8-4a15-ad38-3a4b5ad8e283','e00d6857-0634-4a82-b7d1-9a9ff237ea86',N'Field',N'lOptional1',N'Optional 1',80,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210729 16:34:38.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210729 16:34:38.000','20210729 16:34:38.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'e253973d-f018-4df6-985e-b4417280b931')
	BEGIN 
	    PRINT N'Adding Context Element Link for lOptional1'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('e253973d-f018-4df6-985e-b4417280b931','339EA3AB-332B-4999-8367-BFFC03A0C2B2','5758f263-4da8-4a15-ad38-3a4b5ad8e283',N'AND',67,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210729 16:34:38.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210729 16:34:38.000','20210729 16:34:38.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '1300eae0-818e-421b-9bb9-695c3dac3c7d')
	BEGIN 
	    PRINT N'Adding UCI Data Item for lOptional2'

	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('1300eae0-818e-421b-9bb9-695c3dac3c7d', N'CallSheets', N'lOptional2', N'Label', N'Optional 2',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210729 16:34:38.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210729 16:34:38.000','20210729 16:34:38.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'f71cd828-309c-47cc-a39a-783b6549ae2b')
	BEGIN 
	    PRINT N'Adding Context Element for lOptional2'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('f71cd828-309c-47cc-a39a-783b6549ae2b','1300eae0-818e-421b-9bb9-695c3dac3c7d',N'Field',N'lOptional2',N'Optional 2',80,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210729 16:34:38.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210729 16:34:38.000','20210729 16:34:38.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'a60ccd44-e070-4b12-b5d8-b2e42dc1b179')
	BEGIN 
	    PRINT N'Adding Context Element Link for lOptional2'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('a60ccd44-e070-4b12-b5d8-b2e42dc1b179','339EA3AB-332B-4999-8367-BFFC03A0C2B2','f71cd828-309c-47cc-a39a-783b6549ae2b',N'AND',68,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210729 16:34:38.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210729 16:34:38.000','20210729 16:34:38.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	 
	
    -->>MTM-4127<<--
	IF EXISTS( SELECT * FROM sysobjects WHERE type='V' AND name='vw_METCAL_DataPoints' )
	BEGIN
		PRINT N'Dropping [dbo].[vw_METCAL_DataPoints]'

		DROP VIEW [dbo].[vw_METCAL_DataPoints]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[vw_METCAL_DataPoints]', 'V') IS NULL
	BEGIN
	PRINT N'Creating [dbo].[vw_METCAL_DataPoints]'

		EXEC sp_executesql N'

	/****************************************************************
		vw_METCAL_DataPoints
		(C) 2013-21 Fluke Calibration
	-----------------------------------------------------------------
		CHANGE HISTORY
		02/12/2013	EdW		Initial development
		07/24/2013  MM      Handle exponential formats
		08/22/2013  MM      Add more fields from CallSheetResults
		08/22/2013  MM      Add procedure used for work order results
		07/18/2019  WJS     Added nPointUID
		09/03/2020  MM      Added nAttTemplateUID
		08/02/2021  KW      Add DUT Resolution and unit
	*****************************************************************/
	CREATE VIEW [dbo].[vw_METCAL_DataPoints]
	AS
	SELECT
	csr.nCallSheetUID
	,csr.nCallSheetResultUID
	,csr.nProcedureUID
	,csr.nTechnicianUID
	,csr.nRunAtFacilityUID
	,csr.nAttTemplateUID
	,csr.nCallSheetResultOrdinal
	,ISNULL(csr.cWorkstationName,'''') AS [cWorkstationName]
	,ISNULL(csr.cDescription,'''') AS[cDescription]
	,ISNULL(csr.cStatus,'''') AS [cStatus]
	,ISNULL(csr.cDataOrigin,'''') AS [cDataOrigin]
	,ISNULL(csr.cCallSheetResultType,'''') AS [cCallSheetResultType]
	,csr.tStartTime
	,csr.tEndTime
	,ISNULL(prcsr.cProcedureName,''No Procedure'') AS [Procedure]
	,ISNULL(p.nPointOrdinal, 0) AS [row_num]
	,ISNULL(p.cPointDescription, '''') AS [test_desc]
	,ISNULL(p.cPointPassFailStatus, '''') AS [PointPassFail]
	,ISNULL([dbo].[udf_get_formattedValue](pen.nField010, pen.nField010FormatUID),'''') AS [fixq]
	,upen010.cUnitSymbol AS [Fixq_u]
	,ISNULL([dbo].[udf_get_formattedValue](pen.nField029, pen.nField029FormatUID),'''') AS [varq]
	,upen029.cUnitSymbol AS [varq_u]
	,ISNULL([dbo].[udf_get_formattedValue](pun.nLowerLimit, pun.nLowerLimitFormatUID),'''') AS [lower_limit]
	,upun1.cUnitSymbol AS [lower_limit_u]
	,ISNULL([dbo].[udf_get_formattedValue](pun.nUpperLimit, pun.nUpperLimitFormatUID),'''') AS [upper_limit]
	,upun2.cUnitSymbol AS [upper_limit_u]
	,ISNULL([dbo].[udf_get_formattedValue](pun.nUncertaintyExpanded, pun.nUncertaintyExpandedFormatUID),'''') AS [exp_uncert]
	,upun3.cUnitSymbol AS [exp_uncert_u]
	,ISNULL([dbo].[udf_get_formattedValue](pun.nUncertaintyStandard, pun.nUncertaintyStandardFormatUID),'''') AS [std_uncert]
	,upun4.cUnitSymbol AS [std_uncert_u]
	,ISNULL(CONVERT(VARCHAR,pun.nCoverageFactor),'''') AS [cov_fac]
	,ISNULL(p.cCondition, '''') AS [condition]
	,ISNULL(p.cRemarks, '''') AS [remark]
	,ISNULL([dbo].[udf_get_formattedValue](p.nCardinalPoint, p.nCardinalPointFormatUID),'''') AS [cpt]
	,up3.cUnitSymbol AS [cpt_u]
	,ISNULL(CONVERT(VARCHAR,p.lUUTIsFixed),'''') AS [fix_flag]
	,ISNULL([dbo].[udf_get_formattedValue](pen.nField015, pen.nField015FormatUID),'''') AS [nominal]
	,upen015.cUnitSymbol AS [nominal_u]
	,ISNULL([dbo].[udf_get_formattedValue](pun.nModifier1, pun.nModifier1FormatUID),'''') AS [mod1]
	,upun5.cUnitSymbol AS [mod1_u]
	,ISNULL([dbo].[udf_get_formattedValue](p.nReference, p.nReferenceFormatUID),'''') AS [sys_actual]
	,up2.cUnitSymbol AS [sys_actual_u]
	,ISNULL(CONVERT(VARCHAR,pel.lField001),'''') AS [corr_flag]
	,ISNULL([dbo].[udf_get_formattedValue](pen.nField027, pen.nField027FormatUID),'''') AS [uut_ind]
	,upen027.cUnitSymbol AS [uut_ind_u]
	,ISNULL([dbo].[udf_get_formattedValue](pen.nField008, pen.nField008FormatUID),'''') AS [expv]
	,upen008.cUnitSymbol AS [expv_u]
	,ISNULL([dbo].[udf_get_formattedValue](p.nUUT, p.nUUTFormatUID),'''') AS [measurement]
	,up1.cUnitSymbol AS [measurement_u]
	,ISNULL(CONVERT(VARCHAR,pel.lField001),'''') AS [meas_flag]
	,ISNULL([dbo].[udf_get_formattedValue](pen.nField006, pen.nField006FormatUID),'''') AS [dev]
	,upen006.cUnitSymbol AS [dev_u]
	,ISNULL([dbo].[udf_get_formattedValue](tol.nError, tol.nErrorFormatUID),'''') AS [error]
	,utol1.cUnitSymbol AS [error_u]
	,ISNULL(CONVERT(VARCHAR,tol.nReadingErrorPercent),'''') AS [rel_err]
	,'''' AS [rel_err_u]
	,ISNULL([dbo].[udf_get_formattedValue](p.nCorrection, p.nCorrectionFormatUID),'''') AS [corr]
	,up4.cUnitSymbol AS [corr_u]
	,ISNULL([dbo].[udf_get_formattedValue](pen.nField004, pen.nField004FormatUID),'''') AS [corr_unc]
	,upen004.cUnitSymbol AS [corr_unc_u]
	,ISNULL([dbo].[udf_get_formattedValue](tol.nReferenceTolerance, tol.nReferenceToleranceFormatUID),'''') AS [tol_ref]
	, utol2.cUnitSymbol AS [tol_ref_u]
	,ISNULL([dbo].[udf_get_formattedValue](tol.nToleranceNegative, tol.nToleranceNegativeFormatUID),'''') AS [tol_neg]
	,utol5.cUnitSymbol AS [tol_neg_u]
	,ISNULL([dbo].[udf_get_formattedValue](tol.nTolerancePositive, tol.nTolerancePositiveFormatUID),'''') AS [tol_pos]
	,utol6.cUnitSymbol AS [tol_pos_u]
	,ISNULL([dbo].[udf_get_formattedValue](tol.nTolerance, tol.nToleranceUnitUID),'''') AS [tol]
	,utol3.cUnitSymbol AS [tol_u]
	,ISNULL(pes.cField011,'''') AS [tur]
	,ISNULL(CONVERT(VARCHAR,tol.nToleranceErrorPercent),'''') AS [tol_err]
	,'''' AS [tol_err_u]
	,ISNULL(pun.cUncertaintyMethod,'''') AS [uncert_method]
	,ISNULL(CONVERT(VARCHAR,stat.nNumberOfSamplesDiscarded),'''') AS [nthrow]
	,ISNULL(CONVERT(VARCHAR,stat.nNumberOfSamplesUUT),'''') AS [num_meas]
	,ISNULL([dbo].[udf_get_formattedValue](stat.nUUTStandardDeviation, stat.nUUTStandardDeviationFormatUID),'''') AS [sdev]
	,ustat11.cUnitSymbol AS [sdev_u]
	,ISNULL([dbo].[udf_get_formattedValue](pun.nS1, pun.nS1FormatUID),'''') AS [s1]
	,upun16.cUnitSymbol AS [s1_u]
	,ISNULL([dbo].[udf_get_formattedValue](pun.nS2, pun.nS2FormatUID),'''') AS [s2]
	,upun17.cUnitSymbol AS [s2_u]
	,ISNULL([dbo].[udf_get_formattedValue](pun.nUncertaintyDominant, pun.nUncertaintyDominantFormatUID),'''') AS [dom_uncert]
	,upun20.cUnitSymbol AS [dom_uncert_u]
	,ISNULL(pes.cField009,'''') AS [test_step]
	,ISNULL(p.cFunctionSelectCode,'''') AS [fsc]
	,ISNULL(p.cPointLabel,'''') AS [result_type]
	,ISNULL(CONVERT(VARCHAR,p.lAccredited),'''') AS [accred]
	,ISNULL(pun.cGuardBandMethod,'''') AS [guardband_meth]
	,ISNULL([dbo].[udf_get_formattedValue](pun.nGuardBandLower, pun.nGuardBandLowerFormatUID),'''') AS [guardband_ll]
	,upun18.cUnitSymbol AS [guardband_ll_u]
	,ISNULL([dbo].[udf_get_formattedValue](pun.nGuardBandUpper, pun.nGuardBandUpperFormatUID),'''') AS [guardband_ul]
	,upun19.cUnitSymbol AS [guardband_ul_u]
	,ISNULL([dbo].[udf_get_formattedValue](p.nSystemAccuracy, p.nSystemAccuracyFormatUID),'''') AS [sys_acc]
	,up6.cUnitSymbol AS [sys_acc_u]
	,ISNULL(CONVERT(VARCHAR,pun.nSystemCoverageFactor),'''') AS [sys_cov_fac]
	,ISNULL([dbo].[udf_get_formattedValue](p.nUUTRange, p.nUUTRangeFormatUID),'''') AS [uut_range]
	,up5.cUnitSymbol AS [uut_range_u]
	,p.tAddTime AS [created]
	,p.tUpdateTime AS [editlogtime]
	,ISNULL(pes.cField010,'''') AS [test_step2]
	,p.nPointUID AS [nPointUID]
	,ISNULL([dbo].[udf_get_formattedValue](pen.nField028, pen.nField028FormatUID),'''') AS [uut_res]
	,upen028.cUnitSymbol AS [uut_res_u]
	FROM
	[dbo].[CallSheetResults] csr
	INNER JOIN [dbo].[Points] p ON p.nCallSheetResultUID = csr.nCallSheetResultUID
	LEFT JOIN [dbo].[procedures] prcsr ON csr.nProcedureUID = prcsr.nProcedureUID
	LEFT JOIN [dbo].[Units] up1 ON up1.nUnitUID = p.nUUTUnitUID
	LEFT JOIN [dbo].[Units] up2 ON up2.nUnitUID = p.nReferenceUnitUID
	LEFT JOIN [dbo].[Units] up3 ON up3.nUnitUID = p.nCardinalPointUnitUID
	LEFT JOIN [dbo].[Units] up4 ON up4.nUnitUID = p.nCorrectionUnitUID
	LEFT JOIN [dbo].[Units] up5 ON up5.nUnitUID = p.nUUTRangeUnitUID
	LEFT JOIN [dbo].[Units] up6 ON up6.nUnitUID = p.nSystemAccuracyUnitUID
	LEFT JOIN [dbo].[PointExNumerics] pen ON pen.nPointUID = p.nPointUID
	LEFT JOIN [dbo].[Units] upen010 ON upen010.nUnitUID = pen.nField010UnitUID
	LEFT JOIN [dbo].[Units] upen029 ON upen029.nUnitUID = pen.nField029UnitUID
	LEFT JOIN [dbo].[Units] upen015 ON upen015.nUnitUID = pen.nField015UnitUID
	LEFT JOIN [dbo].[Units] upen027 ON upen027.nUnitUID = pen.nField027UnitUID
	LEFT JOIN [dbo].[Units] upen008 ON upen008.nUnitUID = pen.nField008UnitUID
	LEFT JOIN [dbo].[Units] upen006 ON upen006.nUnitUID = pen.nField006UnitUID
	LEFT JOIN [dbo].[Units] upen004 ON upen004.nUnitUID = pen.nField004UnitUID
	LEFT JOIN [dbo].[Units] upen028 ON upen028.nUnitUID = pen.nField028UnitUID
	LEFT JOIN [dbo].[PointUncertainties] pun ON pun.nPointUID = p.nPointUID
	LEFT JOIN [dbo].[Units] upun1 ON upun1.nUnitUID = pun.nLowerLimitUnitUID
	LEFT JOIN [dbo].[Units] upun2 ON upun2.nUnitUID = pun.nUpperLimitUnitUID
	LEFT JOIN [dbo].[Units] upun3 ON upun3.nUnitUID = pun.nUncertaintyExpandedUnitUID
	LEFT JOIN [dbo].[Units] upun4 ON upun4.nUnitUID = pun.nUncertaintyStandardUnitUID
	LEFT JOIN [dbo].[Units] upun5 ON upun5.nUnitUID = pun.nModifier1UnitUID
	LEFT JOIN [dbo].[Units] upun16 ON upun16.nUnitUID = pun.nS1UnitUID
	LEFT JOIN [dbo].[Units] upun17 ON upun17.nUnitUID = pun.nS2UnitUID
	LEFT JOIN [dbo].[Units] upun18 ON upun18.nUnitUID = pun.nGuardBandLowerUnitUID
	LEFT JOIN [dbo].[Units] upun19 ON upun19.nUnitUID = pun.nGuardBandUpperUnitUID
	LEFT JOIN [dbo].[Units] upun20 ON upun20.nUnitUID = pun.nUncertaintyDominantUnitUID
	LEFT JOIN [dbo].[PointExLogicals] pel ON pel.nPointUID = p.nPointUID
	LEFT JOIN [dbo].[PointTolerances] tol ON tol.nPointUID = p.nPointUID
	LEFT JOIN [dbo].[Units] utol1 ON utol1.nUnitUID = tol.nErrorUnitUID
	LEFT JOIN [dbo].[Units] utol2 ON utol2.nUnitUID = tol.nReferenceToleranceUnitUID
	LEFT JOIN [dbo].[Units] utol3 ON utol3.nUnitUID = tol.nToleranceFormatUID
	LEFT JOIN [dbo].[Units] utol5 ON utol5.nUnitUID = tol.nToleranceNegativeUnitUID
	LEFT JOIN [dbo].[Units] utol6 ON utol6.nUnitUID = tol.nTolerancePositiveUnitUID
	LEFT JOIN [dbo].[PointExStrings] pes ON pes.nPointUID = p.nPointUID
	LEFT JOIN [dbo].[PointStatistics] stat ON stat.nPointUID = p.nPointUID
	LEFT JOIN [dbo].[Units] ustat11 ON ustat11.nUnitUID = stat.nUUTStandardDeviationUnitUID
	WHERE
		p.lDeleted = 0
	AND
		p.lActive <> 0
	'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END


	-->>MTM-1378<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = 'C335C673-8982-43E2-BCE3-F9A44BB5F4D6')
	BEGIN
		PRINT N'Adding System Default'

		INSERT INTO [dbo].[SystemDefaults] ([nSystemDefaultUID], [cAuthority], [cProperty], [cValue], [nOrder], [cAction], [cGraphic], [mNotes], 
			[lLocal], [lSystemic], [lWarehouse], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], 
			[nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('C335C673-8982-43E2-BCE3-F9A44BB5F4D6', N'Default', N'Ignore time on In Calibration check', N'(none)', 0, NULL, NULL, 
			N'AFFECTS: Checking if an asset is in cal from MET/CAL\nACTION: When Active, MET/CAL will ignore the time component of the calibration due date, when determining if an asset is in cal.', 
			0, 0, 0, 0, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20210804 21:03:32', 
			'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20210804 21:03:32', '20210804 21:03:32', NULL, NULL);

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-1600<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = 'CF5BB0E0-B37C-4110-81AD-254EF7C91722')
	BEGIN
		PRINT N'Adding System Default'

		INSERT INTO [dbo].[SystemDefaults] ([nSystemDefaultUID], [cAuthority], [cProperty], [cValue], [nOrder], [cAction], [cGraphic], [mNotes], 
			[lLocal], [lSystemic], [lWarehouse], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], 
			[nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('CF5BB0E0-B37C-4110-81AD-254EF7C91722', N'Default', N'Download config files from database on startup', N'(none)', 0, NULL, NULL, 
			N'AFFECTS: MET/CAL workstation configuration files\nACTION: When Active, the workstation configuration files metcal.ini and config.dat will be downloaded from the database to the workstation on startup, overwriting the local copies of these files.', 
			0, 0, 0, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20210804 21:03:32', 
			'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20210804 21:03:32', '20210804 21:03:32', NULL, NULL);

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END	


	-->>MTM-4773<<--
	IF EXISTS(SELECT * FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = '9C54CEB5-007F-4C68-9F94-44B99B1C7F56')
	BEGIN

		IF NOT EXISTS(SELECT * FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = '9C54CEB5-007F-4C68-9F94-44B99B1C7F56'
		AND mNotes = N'AFFECTS: Login  ACTION: When Active is not checked, users log in to MET/TEAM and Customer Portal using their MET/TEAM username and password.\nWhen Active and the Value = 1, MET/TEAM uses Windows Authentification and Customer Portal uses MET/TEAM Login.\nWhen Active and the Value = 2, both MET/TEAM and Customer Portal use Windows Authentication.\nWhen Active and the Value = 3, MET/TEAM uses Saml2 Authentication and Customer Portal uses MET/TEAM Login.\nWhen Active and the Value = 4, both MET/TEAM and Customer Portal use Saml2 Authentication.\nWhen Active and any other Value is entered, neither Windows Authentication nor Saml2 Authentication is used. The user is presented with the MET/TEAM Login screen.\n\nATTENTION: If you have activated this System Default, set up a user that matches your domain username (1,2) or domain email (3,4) and verify it has administration rights. Failure to do so may result in being locked out of MET/TEAM!\n\nNOTE: Refer to MET/TEAM help for more information on setting up IIS to support Windows Authentication or Saml2 Authentication mode.')
		BEGIN
			PRINT N'Updating system default'

			UPDATE [dbo].[SystemDefaults] SET
				mNotes = N'AFFECTS: Login  ACTION: When Active is not checked, users log in to MET/TEAM and Customer Portal using their MET/TEAM username and password.\nWhen Active and the Value = 1, MET/TEAM uses Windows Authentification and Customer Portal uses MET/TEAM Login.\nWhen Active and the Value = 2, both MET/TEAM and Customer Portal use Windows Authentication.\nWhen Active and the Value = 3, MET/TEAM uses Saml2 Authentication and Customer Portal uses MET/TEAM Login.\nWhen Active and the Value = 4, both MET/TEAM and Customer Portal use Saml2 Authentication.\nWhen Active and any other Value is entered, neither Windows Authentication nor Saml2 Authentication is used. The user is presented with the MET/TEAM Login screen.\n\nATTENTION: If you have activated this System Default, set up a user that matches your domain username (1,2) or domain email (3,4) and verify it has administration rights. Failure to do so may result in being locked out of MET/TEAM!\n\nNOTE: Refer to MET/TEAM help for more information on setting up IIS to support Windows Authentication or Saml2 Authentication mode.',
				lDeleted = 0,
				tUpdateTime = '20210812 21:08:21.090',
				tMobileTime = '20210812 21:08:21.090',
				tSystemUpdateTime = NULL
			WHERE
				nSystemDefaultUID = '9C54CEB5-007F-4C68-9F94-44B99B1C7F56'

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END


	-->>MTM-5097<<--	
	IF NOT EXISTS(SELECT * FROM syscolumns sc JOIN sysobjects so ON sc.id = so.id WHERE sc.name = 'lLocked' AND so.name = 'ProblemReports')
	BEGIN

	    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'dd081ee6-d13f-47e7-a2f8-e58df9002a74')
	    BEGIN
	        PRINT 'Adding column [ProblemReports].[lLocked] to [AuditColumns]'

	        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
	        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
	        VALUES ('dd081ee6-d13f-47e7-a2f8-e58df9002a74', 46, 3074, N'lLocked', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210901 19:02:49', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210901 19:02:49', '20210901 19:02:49', NULL, NULL)
	        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    END


		PRINT N'Dropping extended properties'

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'lActive'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'lActive'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'lAdded'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'lAdded'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'lApproved'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'lApproved'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'lDeleted'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'lDeleted'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'nAddFacilityUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'nAddFacilityUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'nAddUserUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'nAddUserUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'nUpdateFacilityUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'nUpdateFacilityUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'nUpdateUserUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'nUpdateUserUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'tAddTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'tAddTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'tMobileTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'tMobileTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'tSystemUpdateTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'tSystemUpdateTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'tUpdateTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'tUpdateTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping foreign keys from [dbo].[ProblemReports]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReports_ApprovedBy]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [FK_ProblemReports_ApprovedBy]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReports_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [FK_ProblemReports_CallSheets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReports_Facilities]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [FK_ProblemReports_Facilities]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReports_Facilities_Working]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [FK_ProblemReports_Facilities_Working]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReports_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [FK_ProblemReports_Procedures]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReports_SubmittedBy]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [FK_ProblemReports_SubmittedBy]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReports_TypeProcedureDefaults]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [FK_ProblemReports_TypeProcedureDefaults]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReports_Types]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [FK_ProblemReports_Types]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping foreign keys from [dbo].[ProblemReportEx]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReportEx_ProblemReports]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReportEx]', 'U'))
		ALTER TABLE [dbo].[ProblemReportEx] DROP CONSTRAINT [FK_ProblemReportEx_ProblemReports]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping foreign keys from [dbo].[ProblemReportFiles]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReportFiles_ProblemReports]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReportFiles]', 'U'))
		ALTER TABLE [dbo].[ProblemReportFiles] DROP CONSTRAINT [FK_ProblemReportFiles_ProblemReports]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[ProblemReports]'

		IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PK_ProblemReport]', 'PK') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [PK_ProblemReport]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[ProblemReports]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lActive' AND object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_ProblemReport_lActive]', 'D'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [DF_ProblemReport_lActive]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[ProblemReports]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lDeleted' AND object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_ProblemReports_lDeleted]', 'D'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [DF_ProblemReports_lDeleted]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[ProblemReports]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lApproved' AND object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_ProblemReports_lApproved]', 'D'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [DF_ProblemReports_lApproved]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[ProblemReports]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lAdded' AND object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_ProblemReport_lAdded]', 'D'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [DF_ProblemReport_lAdded]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[ProblemReports]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nAddFacilityUID' AND object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_ProblemReports_nAddFacilityUID]', 'D'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [DF_ProblemReports_nAddFacilityUID]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[ProblemReports]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nAddUserUID' AND object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_ProblemReports_nAddUserUID]', 'D'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [DF_ProblemReports_nAddUserUID]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[ProblemReports]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tAddTime' AND object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_ProblemReport_tAddTime]', 'D'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [DF_ProblemReport_tAddTime]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[ProblemReports]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nUpdateFacilityUID' AND object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_ProblemReports_nUpdateFacilityUID]', 'D'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [DF_ProblemReports_nUpdateFacilityUID]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[ProblemReports]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nUpdateUserUID' AND object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_ProblemReports_nUpdateUserUID]', 'D'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [DF_ProblemReports_nUpdateUserUID]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[ProblemReports]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tUpdateTime' AND object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_ProblemReport_tUpdateTime]', 'D'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [DF_ProblemReport_tUpdateTime]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[ProblemReports]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tMobileTime' AND object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_ProblemReport_tMobileTime]', 'D'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [DF_ProblemReport_tMobileTime]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping index [IDX_ProblemReports_tAddTime] from [dbo].[ProblemReports]'

		IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_ProblemReports_tAddTime' AND object_id = OBJECT_ID(N'[dbo].[ProblemReports]'))
		DROP INDEX [IDX_ProblemReports_tAddTime] ON [dbo].[ProblemReports]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping trigger [dbo].[tr_kr_audit_ProblemReports_Del] from [dbo].[ProblemReports]'

		IF OBJECT_ID(N'[dbo].[tr_kr_audit_ProblemReports_Del]', 'TR') IS NOT NULL
		DROP TRIGGER [dbo].[tr_kr_audit_ProblemReports_Del]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping trigger [dbo].[tr_kr_audit_ProblemReports_Ins] from [dbo].[ProblemReports]'

		IF OBJECT_ID(N'[dbo].[tr_kr_audit_ProblemReports_Ins]', 'TR') IS NOT NULL
		DROP TRIGGER [dbo].[tr_kr_audit_ProblemReports_Ins]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping trigger [dbo].[tr_kr_audit_ProblemReports_Upd] from [dbo].[ProblemReports]'

		IF OBJECT_ID(N'[dbo].[tr_kr_audit_ProblemReports_Upd]', 'TR') IS NOT NULL
		DROP TRIGGER [dbo].[tr_kr_audit_ProblemReports_Upd]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Rebuilding [dbo].[ProblemReports]'
		CREATE TABLE [dbo].[RG_Recovery_1_ProblemReports]
		(
			[nProblemReportsUID] [uniqueidentifier] NOT NULL ROWGUIDCOL,
			[nProcedureUID] [uniqueidentifier] NULL,
			[nTypeProcedureDefaultUID] [uniqueidentifier] NULL,
			[nTypeUID] [uniqueidentifier] NULL,
			[nSubmittedByUID] [uniqueidentifier] NULL,
			[nApprovedByUID] [uniqueidentifier] NULL,
			[nFacilityUID] [uniqueidentifier] NULL,
			[nWorkingFacilityUID] [uniqueidentifier] NULL,
			[nCallSheetUID] [uniqueidentifier] NULL,
			[cAuthority] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[cProblemNumber] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[cReferenceNumber] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[cEngineer] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[cArea] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[cCategory] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[cProblemType] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[cStatus] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[tStatusDate] [datetime] NULL,
			[tIssueDate] [datetime] NULL,
			[tSubmittedDate] [datetime] NULL,
			[tResolvedDate] [datetime] NULL,
			[tClosedDate] [datetime] NULL,
			[mProblem] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[mLocalResponse] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[mTechnicalResponse] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[lSubmitted] [int] NULL,
			[lLocked] [int] NOT NULL CONSTRAINT [DF_ProblemReports_lLocked] DEFAULT ((0)),
			[lActive] [int] NOT NULL CONSTRAINT [DF_ProblemReport_lActive] DEFAULT ((-1)),
			[lDeleted] [int] NOT NULL CONSTRAINT [DF_ProblemReports_lDeleted] DEFAULT ((0)),
			[lApproved] [int] NOT NULL CONSTRAINT [DF_ProblemReports_lApproved] DEFAULT ((0)),
			[lAdded] [int] NOT NULL CONSTRAINT [DF_ProblemReport_lAdded] DEFAULT ((-1)),
			[nAddFacilityUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ProblemReports_nAddFacilityUID] DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398'),
			[nAddUserUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ProblemReports_nAddUserUID] DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172'),
			[tAddTime] [datetime] NOT NULL CONSTRAINT [DF_ProblemReport_tAddTime] DEFAULT (getutcdate()),
			[nUpdateFacilityUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ProblemReports_nUpdateFacilityUID] DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398'),
			[nUpdateUserUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ProblemReports_nUpdateUserUID] DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172'),
			[tUpdateTime] [datetime] NOT NULL CONSTRAINT [DF_ProblemReport_tUpdateTime] DEFAULT (getutcdate()),
			[tMobileTime] [datetime] NOT NULL CONSTRAINT [DF_ProblemReport_tMobileTime] DEFAULT (getutcdate()),
			[tSystemUpdateTime] [datetime] NULL,
			[nImportUID] [uniqueidentifier] NULL,
			CONSTRAINT [RG_Recovery_1061_PK_ProblemReport] PRIMARY KEY NONCLUSTERED ([nProblemReportsUID])
		)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		INSERT INTO [dbo].[RG_Recovery_1_ProblemReports]([nProblemReportsUID], [nProcedureUID], [nTypeProcedureDefaultUID], [nTypeUID], [nSubmittedByUID], [nApprovedByUID], [nFacilityUID], [nWorkingFacilityUID], [nCallSheetUID], [cAuthority], [cProblemNumber], [cReferenceNumber], [cEngineer], [cArea], [cCategory], [cProblemType], [cStatus], [tStatusDate], [tIssueDate], [tSubmittedDate], [tResolvedDate], [tClosedDate], [mProblem], [mLocalResponse], [mTechnicalResponse], [lSubmitted], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID]) SELECT [nProblemReportsUID], [nProcedureUID], [nTypeProcedureDefaultUID], [nTypeUID], [nSubmittedByUID], [nApprovedByUID], [nFacilityUID], [nWorkingFacilityUID], [nCallSheetUID], [cAuthority], [cProblemNumber], [cReferenceNumber], [cEngineer], [cArea], [cCategory], [cProblemType], [cStatus], [tStatusDate], [tIssueDate], [tSubmittedDate], [tResolvedDate], [tClosedDate], [mProblem], [mLocalResponse], [mTechnicalResponse], [lSubmitted], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID] FROM [dbo].[ProblemReports]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		DROP TABLE [dbo].[ProblemReports]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF (OBJECT_ID(N'[dbo].[RG_Recovery_1_ProblemReports]', 'U') IS NOT NULL) AND (OBJECT_ID(N'[dbo].[ProblemReports]', 'U') IS NULL)
		EXEC sp_rename N'[dbo].[RG_Recovery_1_ProblemReports]', N'ProblemReports', N'OBJECT'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		EXEC sp_rename N'[dbo].[ProblemReports].[RG_Recovery_1061_PK_ProblemReport]', N'PK_ProblemReport', N'INDEX'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Creating index [IDX_ProblemReports_tAddTime] on [dbo].[ProblemReports]'

		IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_ProblemReports_tAddTime' AND object_id = OBJECT_ID(N'[dbo].[ProblemReports]'))
		CREATE CLUSTERED INDEX [IDX_ProblemReports_tAddTime] ON [dbo].[ProblemReports] ([tAddTime])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_ProblemReports_Del]', 'TR') IS NOT NULL
	    BEGIN
	    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_ProblemReports_Del] from [dbo].[ProblemReports]'

	    	DROP TRIGGER [dbo].[tr_kr_audit_ProblemReports_Del]


	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_ProblemReports_Del]', 'TR') IS NULL
	    BEGIN
	        PRINT N'Creating trigger [dbo].[tr_kr_audit_ProblemReports_Del] on [dbo].[ProblemReports]'

	        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_ProblemReports_Del] ON [dbo].[ProblemReports] FOR DELETE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20210901 21:01:16

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM DELETED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1374,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cArea], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1375,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cAuthority], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1376,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cCategory], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1377,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cEngineer], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1378,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cProblemNumber], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1379,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cProblemType], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1380,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cReferenceNumber], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1381,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cStatus], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1382,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1383,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1384,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1385,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            3074,
            0,
            CONVERT(NVARCHAR, [lLocked])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1386,
            0,
            CONVERT(NVARCHAR, [lSubmitted])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1387,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mLocalResponse], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1388,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mProblem], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1389,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mTechnicalResponse], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1390,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1391,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1392,
            0,
            CONVERT(NVARCHAR( 36 ), [nApprovedByUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1393,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1394,
            0,
            CONVERT(NVARCHAR( 36 ), [nFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            2938,
            0,
            CONVERT(NVARCHAR( 36 ), [nImportUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1395,
            0,
            CONVERT(NVARCHAR( 36 ), [nProblemReportsUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1396,
            0,
            CONVERT(NVARCHAR( 36 ), [nProcedureUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1397,
            0,
            CONVERT(NVARCHAR( 36 ), [nSubmittedByUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1398,
            0,
            CONVERT(NVARCHAR( 36 ), [nTypeProcedureDefaultUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1399,
            0,
            CONVERT(NVARCHAR( 36 ), [nTypeUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1400,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1401,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1402,
            0,
            CONVERT(NVARCHAR( 36 ), [nWorkingFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1403,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1404,
            0,
            CONVERT( NVARCHAR( 34 ), [tClosedDate], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1405,
            0,
            CONVERT( NVARCHAR( 34 ), [tIssueDate], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1406,
            0,
            CONVERT( NVARCHAR( 34 ), [tMobileTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1407,
            0,
            CONVERT( NVARCHAR( 34 ), [tResolvedDate], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1408,
            0,
            CONVERT( NVARCHAR( 34 ), [tStatusDate], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1409,
            0,
            CONVERT( NVARCHAR( 34 ), [tSubmittedDate], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1410,
            0,
            CONVERT( NVARCHAR( 34 ), [tSystemUpdateTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1411,
            0,
            CONVERT( NVARCHAR( 34 ), [tUpdateTime], 121 )
        FROM
            DELETED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 46, @RowsAffected, ''D'', @AuditedUser
    END
END
'

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_ProblemReports_Del]', 'last', 'delete', null

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_ProblemReports_Ins]', 'TR') IS NOT NULL
	    BEGIN
	    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_ProblemReports_Ins] from [dbo].[ProblemReports]'

	    	DROP TRIGGER [dbo].[tr_kr_audit_ProblemReports_Ins]


	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_ProblemReports_Ins]', 'TR') IS NULL
	    BEGIN
	        PRINT N'Creating trigger [dbo].[tr_kr_audit_ProblemReports_Ins] on [dbo].[ProblemReports]'

	        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_ProblemReports_Ins] ON [dbo].[ProblemReports] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20210901 21:01:16

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1374,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cArea], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1375,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cAuthority], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1376,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cCategory], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1377,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cEngineer], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1378,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cProblemNumber], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1379,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cProblemType], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1380,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cReferenceNumber], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1381,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cStatus], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1382,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1383,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1384,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1385,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            3074,
            0,
            CONVERT(NVARCHAR, [lLocked])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1386,
            0,
            CONVERT(NVARCHAR, [lSubmitted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1387,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mLocalResponse], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1388,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mProblem], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1389,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mTechnicalResponse], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1390,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1391,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1392,
            0,
            CONVERT(NVARCHAR( 36 ), [nApprovedByUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1393,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1394,
            0,
            CONVERT(NVARCHAR( 36 ), [nFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1395,
            0,
            CONVERT(NVARCHAR( 36 ), [nProblemReportsUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1396,
            0,
            CONVERT(NVARCHAR( 36 ), [nProcedureUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1397,
            0,
            CONVERT(NVARCHAR( 36 ), [nSubmittedByUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1398,
            0,
            CONVERT(NVARCHAR( 36 ), [nTypeProcedureDefaultUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1399,
            0,
            CONVERT(NVARCHAR( 36 ), [nTypeUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1402,
            0,
            CONVERT(NVARCHAR( 36 ), [nWorkingFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1403,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1404,
            0,
            CONVERT( NVARCHAR( 34 ), [tClosedDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1405,
            0,
            CONVERT( NVARCHAR( 34 ), [tIssueDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1407,
            0,
            CONVERT( NVARCHAR( 34 ), [tResolvedDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1408,
            0,
            CONVERT( NVARCHAR( 34 ), [tStatusDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), [nProblemReportsUID]),
            1409,
            0,
            CONVERT( NVARCHAR( 34 ), [tSubmittedDate], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 46, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL
    END
END
'

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_ProblemReports_Ins]', 'last', 'insert', null

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_ProblemReports_Upd]', 'TR') IS NOT NULL
	    BEGIN
	    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_ProblemReports_Upd] from [dbo].[ProblemReports]'

	    	DROP TRIGGER [dbo].[tr_kr_audit_ProblemReports_Upd]


	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_ProblemReports_Upd]', 'TR') IS NULL
	    BEGIN
	        PRINT N'Creating trigger [dbo].[tr_kr_audit_ProblemReports_Upd] on [dbo].[ProblemReports]'

	        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_ProblemReports_Upd] ON [dbo].[ProblemReports] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20210901 21:01:16

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cArea] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1374,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cArea], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cArea], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( NULLIF(d.[cArea], '''') <> NULLIF(i.[cArea], '''') ) OR
                ( NULLIF(d.[cArea], '''') IS NULL AND NULLIF(i.[cArea], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cArea], '''') IS NULL AND NULLIF(d.[cArea], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cAuthority] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1375,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cAuthority], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cAuthority], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( NULLIF(d.[cAuthority], '''') <> NULLIF(i.[cAuthority], '''') ) OR
                ( NULLIF(d.[cAuthority], '''') IS NULL AND NULLIF(i.[cAuthority], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cAuthority], '''') IS NULL AND NULLIF(d.[cAuthority], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cCategory] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1376,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cCategory], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cCategory], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( NULLIF(d.[cCategory], '''') <> NULLIF(i.[cCategory], '''') ) OR
                ( NULLIF(d.[cCategory], '''') IS NULL AND NULLIF(i.[cCategory], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cCategory], '''') IS NULL AND NULLIF(d.[cCategory], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cEngineer] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1377,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cEngineer], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cEngineer], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( NULLIF(d.[cEngineer], '''') <> NULLIF(i.[cEngineer], '''') ) OR
                ( NULLIF(d.[cEngineer], '''') IS NULL AND NULLIF(i.[cEngineer], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cEngineer], '''') IS NULL AND NULLIF(d.[cEngineer], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cProblemNumber] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1378,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cProblemNumber], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cProblemNumber], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( NULLIF(d.[cProblemNumber], '''') <> NULLIF(i.[cProblemNumber], '''') ) OR
                ( NULLIF(d.[cProblemNumber], '''') IS NULL AND NULLIF(i.[cProblemNumber], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cProblemNumber], '''') IS NULL AND NULLIF(d.[cProblemNumber], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cProblemType] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1379,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cProblemType], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cProblemType], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( NULLIF(d.[cProblemType], '''') <> NULLIF(i.[cProblemType], '''') ) OR
                ( NULLIF(d.[cProblemType], '''') IS NULL AND NULLIF(i.[cProblemType], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cProblemType], '''') IS NULL AND NULLIF(d.[cProblemType], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cReferenceNumber] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1380,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cReferenceNumber], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cReferenceNumber], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( NULLIF(d.[cReferenceNumber], '''') <> NULLIF(i.[cReferenceNumber], '''') ) OR
                ( NULLIF(d.[cReferenceNumber], '''') IS NULL AND NULLIF(i.[cReferenceNumber], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cReferenceNumber], '''') IS NULL AND NULLIF(d.[cReferenceNumber], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cStatus] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1381,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cStatus], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cStatus], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( NULLIF(d.[cStatus], '''') <> NULLIF(i.[cStatus], '''') ) OR
                ( NULLIF(d.[cStatus], '''') IS NULL AND NULLIF(i.[cStatus], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cStatus], '''') IS NULL AND NULLIF(d.[cStatus], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1382,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1383,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1384,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1385,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lLocked] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                3074,
                0,
                CONVERT(NVARCHAR, d.[lLocked]),
                CONVERT(NVARCHAR, i.[lLocked])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[lLocked] <> i.[lLocked] ) OR
                ( d.[lLocked] IS NULL AND i.[lLocked] IS NOT NULL ) OR
                ( i.[lLocked] IS NULL AND d.[lLocked] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lSubmitted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1386,
                0,
                CONVERT(NVARCHAR, d.[lSubmitted]),
                CONVERT(NVARCHAR, i.[lSubmitted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[lSubmitted] <> i.[lSubmitted] ) OR
                ( d.[lSubmitted] IS NULL AND i.[lSubmitted] IS NOT NULL ) OR
                ( i.[lSubmitted] IS NULL AND d.[lSubmitted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mLocalResponse] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1387,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mLocalResponse], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mLocalResponse], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( NULLIF(d.[mLocalResponse], '''') <> NULLIF(i.[mLocalResponse], '''') ) OR
                ( NULLIF(d.[mLocalResponse], '''') IS NULL AND NULLIF(i.[mLocalResponse], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mLocalResponse], '''') IS NULL AND NULLIF(d.[mLocalResponse], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mProblem] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1388,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mProblem], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mProblem], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( NULLIF(d.[mProblem], '''') <> NULLIF(i.[mProblem], '''') ) OR
                ( NULLIF(d.[mProblem], '''') IS NULL AND NULLIF(i.[mProblem], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mProblem], '''') IS NULL AND NULLIF(d.[mProblem], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mTechnicalResponse] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1389,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mTechnicalResponse], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mTechnicalResponse], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( NULLIF(d.[mTechnicalResponse], '''') <> NULLIF(i.[mTechnicalResponse], '''') ) OR
                ( NULLIF(d.[mTechnicalResponse], '''') IS NULL AND NULLIF(i.[mTechnicalResponse], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mTechnicalResponse], '''') IS NULL AND NULLIF(d.[mTechnicalResponse], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1390,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1391,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nApprovedByUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1392,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nApprovedByUID]),
                CONVERT(NVARCHAR( 36 ), i.[nApprovedByUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[nApprovedByUID] <> i.[nApprovedByUID] ) OR
                ( d.[nApprovedByUID] IS NULL AND i.[nApprovedByUID] IS NOT NULL ) OR
                ( i.[nApprovedByUID] IS NULL AND d.[nApprovedByUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCallSheetUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1393,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCallSheetUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCallSheetUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[nCallSheetUID] <> i.[nCallSheetUID] ) OR
                ( d.[nCallSheetUID] IS NULL AND i.[nCallSheetUID] IS NOT NULL ) OR
                ( i.[nCallSheetUID] IS NULL AND d.[nCallSheetUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1394,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[nFacilityUID] <> i.[nFacilityUID] ) OR
                ( d.[nFacilityUID] IS NULL AND i.[nFacilityUID] IS NOT NULL ) OR
                ( i.[nFacilityUID] IS NULL AND d.[nFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nProblemReportsUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1395,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nProblemReportsUID]),
                CONVERT(NVARCHAR( 36 ), i.[nProblemReportsUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[nProblemReportsUID] <> i.[nProblemReportsUID] ) OR
                ( d.[nProblemReportsUID] IS NULL AND i.[nProblemReportsUID] IS NOT NULL ) OR
                ( i.[nProblemReportsUID] IS NULL AND d.[nProblemReportsUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nProcedureUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1396,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nProcedureUID]),
                CONVERT(NVARCHAR( 36 ), i.[nProcedureUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[nProcedureUID] <> i.[nProcedureUID] ) OR
                ( d.[nProcedureUID] IS NULL AND i.[nProcedureUID] IS NOT NULL ) OR
                ( i.[nProcedureUID] IS NULL AND d.[nProcedureUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nSubmittedByUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1397,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nSubmittedByUID]),
                CONVERT(NVARCHAR( 36 ), i.[nSubmittedByUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[nSubmittedByUID] <> i.[nSubmittedByUID] ) OR
                ( d.[nSubmittedByUID] IS NULL AND i.[nSubmittedByUID] IS NOT NULL ) OR
                ( i.[nSubmittedByUID] IS NULL AND d.[nSubmittedByUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nTypeProcedureDefaultUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1398,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nTypeProcedureDefaultUID]),
                CONVERT(NVARCHAR( 36 ), i.[nTypeProcedureDefaultUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[nTypeProcedureDefaultUID] <> i.[nTypeProcedureDefaultUID] ) OR
                ( d.[nTypeProcedureDefaultUID] IS NULL AND i.[nTypeProcedureDefaultUID] IS NOT NULL ) OR
                ( i.[nTypeProcedureDefaultUID] IS NULL AND d.[nTypeProcedureDefaultUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nTypeUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1399,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nTypeUID]),
                CONVERT(NVARCHAR( 36 ), i.[nTypeUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[nTypeUID] <> i.[nTypeUID] ) OR
                ( d.[nTypeUID] IS NULL AND i.[nTypeUID] IS NOT NULL ) OR
                ( i.[nTypeUID] IS NULL AND d.[nTypeUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nWorkingFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1402,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nWorkingFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nWorkingFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[nWorkingFacilityUID] <> i.[nWorkingFacilityUID] ) OR
                ( d.[nWorkingFacilityUID] IS NULL AND i.[nWorkingFacilityUID] IS NOT NULL ) OR
                ( i.[nWorkingFacilityUID] IS NULL AND d.[nWorkingFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1403,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tClosedDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1404,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tClosedDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tClosedDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[tClosedDate] <> i.[tClosedDate] ) OR
                ( d.[tClosedDate] IS NULL AND i.[tClosedDate] IS NOT NULL ) OR
                ( i.[tClosedDate] IS NULL AND d.[tClosedDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tIssueDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1405,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tIssueDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tIssueDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[tIssueDate] <> i.[tIssueDate] ) OR
                ( d.[tIssueDate] IS NULL AND i.[tIssueDate] IS NOT NULL ) OR
                ( i.[tIssueDate] IS NULL AND d.[tIssueDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tResolvedDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1407,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tResolvedDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tResolvedDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[tResolvedDate] <> i.[tResolvedDate] ) OR
                ( d.[tResolvedDate] IS NULL AND i.[tResolvedDate] IS NOT NULL ) OR
                ( i.[tResolvedDate] IS NULL AND d.[tResolvedDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tStatusDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1408,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tStatusDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tStatusDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[tStatusDate] <> i.[tStatusDate] ) OR
                ( d.[tStatusDate] IS NULL AND i.[tStatusDate] IS NOT NULL ) OR
                ( i.[tStatusDate] IS NULL AND d.[tStatusDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tSubmittedDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nProblemReportsUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nProblemReportsUID], d.[nProblemReportsUID] )),
                1409,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tSubmittedDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tSubmittedDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nProblemReportsUID] = i.[nProblemReportsUID] )
            WHERE
                ( d.[tSubmittedDate] <> i.[tSubmittedDate] ) OR
                ( d.[tSubmittedDate] IS NULL AND i.[tSubmittedDate] IS NOT NULL ) OR
                ( i.[tSubmittedDate] IS NULL AND d.[tSubmittedDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN
        
            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED
        
            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 46, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID
        END
    END
END
'

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_ProblemReports_Upd]', 'last', 'update', null

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	    END
	    
	    
		PRINT N'Adding foreign keys to [dbo].[ProblemReports]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReports_ApprovedBy]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] ADD CONSTRAINT [FK_ProblemReports_ApprovedBy] FOREIGN KEY ([nApprovedByUID]) REFERENCES [dbo].[Users] ([nUserUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReports_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] ADD CONSTRAINT [FK_ProblemReports_CallSheets] FOREIGN KEY ([nCallSheetUID]) REFERENCES [dbo].[CallSheets] ([nCallSheetUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReports_Facilities]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] ADD CONSTRAINT [FK_ProblemReports_Facilities] FOREIGN KEY ([nFacilityUID]) REFERENCES [dbo].[Facilities] ([nFacilityUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReports_Facilities_Working]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] ADD CONSTRAINT [FK_ProblemReports_Facilities_Working] FOREIGN KEY ([nWorkingFacilityUID]) REFERENCES [dbo].[Facilities] ([nFacilityUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReports_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] ADD CONSTRAINT [FK_ProblemReports_Procedures] FOREIGN KEY ([nProcedureUID]) REFERENCES [dbo].[Procedures] ([nProcedureUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReports_SubmittedBy]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] ADD CONSTRAINT [FK_ProblemReports_SubmittedBy] FOREIGN KEY ([nSubmittedByUID]) REFERENCES [dbo].[Users] ([nUserUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReports_TypeProcedureDefaults]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] ADD CONSTRAINT [FK_ProblemReports_TypeProcedureDefaults] FOREIGN KEY ([nTypeProcedureDefaultUID]) REFERENCES [dbo].[TypeProcedureDefaults] ([nTypeProcedureDefaultUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReports_Types]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] ADD CONSTRAINT [FK_ProblemReports_Types] FOREIGN KEY ([nTypeUID]) REFERENCES [dbo].[Types] ([nTypeUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    

		PRINT N'Adding foreign keys to [dbo].[ProblemReportEx]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReportEx_ProblemReports]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReportEx]', 'U'))
		ALTER TABLE [dbo].[ProblemReportEx] ADD CONSTRAINT [FK_ProblemReportEx_ProblemReports] FOREIGN KEY ([nProblemReportsUID]) REFERENCES [dbo].[ProblemReports] ([nProblemReportsUID])

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Adding foreign keys to [dbo].[ProblemReportFiles]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReportFiles_ProblemReports]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReportFiles]', 'U'))
		ALTER TABLE [dbo].[ProblemReportFiles] ADD CONSTRAINT [FK_ProblemReportFiles_ProblemReports] FOREIGN KEY ([nProblemReportsUID]) REFERENCES [dbo].[ProblemReports] ([nProblemReportsUID])

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Creating extended properties'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'lActive'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=inactive; -1 or 1=active', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'lActive'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'lAdded'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not added; -1 or 1=added', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'lAdded'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'lApproved'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not approved; -1 or 1=approved', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'lApproved'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'lDeleted'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not deleted; -1 or 1=deleted', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'lDeleted'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'nAddFacilityUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the server that added the record', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'nAddFacilityUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'nAddUserUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the user that added the record', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'nAddUserUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'nUpdateFacilityUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the server that last updated the record', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'nUpdateFacilityUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'nUpdateUserUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the last user to update the record', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'nUpdateUserUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'tAddTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was added', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'tAddTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'tMobileTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated for Mobile mode', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'tMobileTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'tSystemUpdateTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated for the Warehouse', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'tSystemUpdateTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'tUpdateTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'tUpdateTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF EXISTS( SELECT * FROM sysobjects WHERE type='V' AND name='vw_ProblemReportsWithEx' )
		BEGIN
			PRINT N'Dropping [dbo].[vw_ProblemReportsWithEx]'

			DROP VIEW [dbo].[vw_ProblemReportsWithEx]

			IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

			IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

		IF OBJECT_ID(N'[dbo].[vw_ProblemReportsWithEx]', 'V') IS NULL
		BEGIN
			PRINT N'Creating [dbo].[vw_ProblemReportsWithEx]'

			EXEC sp_executesql N'
/*****************************************************************************************************************
	vw_ProblemReportsWithEx

	(C) 2021 Fluke Calibration
------------------------------------------------------------------------------------------------------------------
	CHANGE HISTORY
	01/05/2021  MM  Initial Version
	09/01/2021  MM  Add lLocked
*****************************************************************************************************************/
CREATE VIEW [dbo].[vw_ProblemReportsWithEx]
AS
SELECT
	pr.[nProblemReportsUID],
	pr.[nProcedureUID],
	pr.[nTypeProcedureDefaultUID],
	pr.[nTypeUID],
	pr.[nSubmittedByUID],
	pr.[nApprovedByUID],
	pr.[nFacilityUID],
	pr.[nWorkingFacilityUID],
	pr.[nCallSheetUID],
	pr.[cAuthority],
	pr.[cProblemNumber],
	pr.[cReferenceNumber],
	pr.[cEngineer],
	pr.[cArea],
	pr.[cCategory],
	pr.[cProblemType],
	pr.[cStatus],
	pr.[tStatusDate],
	pr.[tIssueDate],
	pr.[tSubmittedDate],
	pr.[tResolvedDate],
	pr.[tClosedDate],
	pr.[mProblem],
	pr.[mLocalResponse],
	pr.[mTechnicalResponse],
	pr.[lSubmitted],
	pr.[lActive],
	pr.[lDeleted],
	pr.[lApproved],
	pr.[lAdded],
	pr.[lLocked],
	pr.[nAddFacilityUID],
	pr.[nAddUserUID],
	pr.[tAddTime],
	pr.[nUpdateFacilityUID],
	pr.[nUpdateUserUID],
	pr.[tUpdateTime],
	pr.[tMobileTime],
	pr.[tSystemUpdateTime],
	pr.[nImportUID],
	p.[cProcedureName],
	t.[cDescription],
	t.[cModelNumber],
	f1.[cFacilityName] AS [cManufacturer],
	f2.[cFacilityName] AS [cLab],
	f3.[cFacilityName] AS [cOwner],
	f3.[cFacilityNumber] AS [cOwnerNumber],
	u.[cFirstName] + '' '' + u.[cLastName] AS [cName],
	u1.[cFirstName] + '' '' + u1.[cLastName] AS [cApprovedBy],
	cs.[cCallSheetNumber] AS [cWorkOrderNumber],
	cs.[cCertificationNumber],
	cs.[cID] AS [cAssetID],
	cs.[cBarcode] AS [cBarcode],
	cs.[cModelNumber] AS [cAssetModelNumber],
	cs.[cDescription] AS [cAssetDescription],
	cs.[cManufacturer] AS [cAssetManufacturer],
	cs.[cTechnician] AS [cTechnician],
	prx.[cField1],
	prx.[cField2],
	prx.[cField3],
	prx.[cField4],
	prx.[cField5],
	prx.[cField6],
	prx.[cField7],
	prx.[cField8],
	prx.[cField9],
	prx.[cField10],
	prx.[cField11],
	prx.[cField12],
	prx.[cField13],
	prx.[cField14],
	prx.[cField15],
	prx.[cField16],
	prx.[cField17],
	prx.[cField18],
	prx.[cField19],
	prx.[cField20],
	prx.[cField21],
	prx.[cField22],
	prx.[cField23],
	prx.[cField24],
	prx.[cField25],
	prx.[tField1],
	prx.[tField2],
	prx.[tField3],
	prx.[tField4],
	prx.[tField5],
	prx.[tField6],
	prx.[tField7],
	prx.[tField8],
	prx.[tField9],
	prx.[tField10],
	prx.[nField1],
	prx.[nField2],
	prx.[nField3],
	prx.[nField4],
	prx.[nField5],
	prx.[nField6],
	prx.[nField7],
	prx.[nField8],
	prx.[nField9],
	prx.[nField10],
	COALESCE(prx.[lField1], 0) AS [lField1],
	COALESCE(prx.[lField2], 0) AS [lField2],
	COALESCE(prx.[lField3], 0) AS [lField3],
	COALESCE(prx.[lField4], 0) AS [lField4],
	COALESCE(prx.[lField5], 0) AS [lField5],
	COALESCE(prx.[lField6], 0) AS [lField6],
	COALESCE(prx.[lField7], 0) AS [lField7],
	COALESCE(prx.[lField8], 0) AS [lField8],
	COALESCE(prx.[lField9], 0) AS [lField9],
	COALESCE(prx.[lField10], 0) AS [lField10],
	prx.[mField1],
	prx.[mField2],
	prx.[lActive] AS [lPrxActive]
FROM ProblemReports	pr
LEFT JOIN Procedures p ON p.nProcedureUID = pr.nProcedureUID
LEFT JOIN Types t ON t.nTypeUID = pr.nTypeUID
LEFT JOIN Facilities f1 ON f1.nFacilityUID = t.nManufacturerUID
LEFT JOIN Facilities f2 ON f2.nFacilityUID = pr.nWorkingFacilityUID
LEFT JOIN Facilities f3 ON f3.nFacilityUID = pr.nFacilityUID
LEFT JOIN Users u ON u.nUserUID = pr.nSubmittedByUID
LEFT JOIN Users u1 ON u1.nUserUID = pr.nApprovedByUID
LEFT JOIN vw_CallSheets cs ON pr.nCallSheetUID = cs.nCallSheetUID
LEFT JOIN ProblemReportEx prx ON pr.nProblemReportsUID = prx.nProblemReportsUID
WHERE
	pr.lDeleted = 0	'

		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END


		IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'DB22E700-1016-4D15-94C8-546C2BD4A4B9')
		BEGIN
		    PRINT N'Adding UCI Data Item for lLocked'
		    
		    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		    VALUES('DB22E700-1016-4D15-94C8-546C2BD4A4B9', N'ProblemReports', N'lLocked', N'Label', N'Locked',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210901 22:13:10.627', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210901 22:13:10.627', '20210901 22:13:10.627', NULL, NULL)

		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

		IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'E07C0760-3032-437A-8AC0-8BCD777D71F3')
		BEGIN
		    PRINT N'Adding Context Element for lLocked'

		    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
		    VALUES ('E07C0760-3032-437A-8AC0-8BCD777D71F3','DB22E700-1016-4D15-94C8-546C2BD4A4B9',N'Field',N'lLocked',N'Locked',96,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210901 22:13:10.627','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210901 22:13:10.627','20210901 22:13:10.627')

		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

		IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '9FD9950F-7CB9-461E-A68D-42E8D6C0148E')
		BEGIN
		    PRINT N'Adding Context Element Link for lLocked'

		    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
		    VALUES('9FD9950F-7CB9-461E-A68D-42E8D6C0148E','E8A8AFA7-B2E1-4575-B22A-BDDBA5EE2D2B','E07C0760-3032-437A-8AC0-8BCD777D71F3',N'AND',81,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210901 22:13:10.627','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210901 22:13:10.627','20210901 22:13:10.627')

		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
	END


	IF OBJECT_ID(N'[dbo].[spl_ProblemReports_RETRIEVE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_ProblemReports_RETRIEVE]'
		DROP PROCEDURE [dbo].[spl_ProblemReports_RETRIEVE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_ProblemReports_RETRIEVE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_ProblemReports_RETRIEVE]'

		EXEC sp_executesql N'		
/****************************************************************
	spl_ProblemReports_RETRIEVE
	Retrieves a single record by ID from the ProblemReports table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 9/1/2021 (R)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_ProblemReports_RETRIEVE]
	
@nProblemReportsUID uniqueidentifier


AS
BEGIN

	SELECT
[nProblemReportsUID]
		,[nProcedureUID]
		,[nTypeProcedureDefaultUID]
		,[nTypeUID]
		,[nSubmittedByUID]
		,[nApprovedByUID]
		,[nFacilityUID]
		,[nWorkingFacilityUID]
		,[nCallSheetUID]
		,[cAuthority]
		,[cProblemNumber]
		,[cReferenceNumber]
		,[cEngineer]
		,[cArea]
		,[cCategory]
		,[cProblemType]
		,[cStatus]
		,[tStatusDate]
		,[tIssueDate]
		,[tSubmittedDate]
		,[tResolvedDate]
		,[tClosedDate]
		,[mProblem]
		,[mLocalResponse]
		,[mTechnicalResponse]
		,[lSubmitted]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[lLocked]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[ProblemReports]
	WHERE
[nProblemReportsUID] = @nProblemReportsUID

	
	RETURN
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	IF OBJECT_ID(N'[dbo].[spl_ProblemReports_LIST]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_ProblemReports_LIST]'
		DROP PROCEDURE [dbo].[spl_ProblemReports_LIST]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_ProblemReports_LIST]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_ProblemReports_LIST]'

		EXEC sp_executesql N'		
/****************************************************************
	spl_ProblemReports_LIST
	Retrieves all records from the ProblemReports table
	Optionally includes inactive records
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 9/1/2021 (L)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_ProblemReports_LIST]
	
@includeInactive	INT	= 0

AS
BEGIN

	SELECT
[nProblemReportsUID]
		,[nProcedureUID]
		,[nTypeProcedureDefaultUID]
		,[nTypeUID]
		,[nSubmittedByUID]
		,[nApprovedByUID]
		,[nFacilityUID]
		,[nWorkingFacilityUID]
		,[nCallSheetUID]
		,[cAuthority]
		,[cProblemNumber]
		,[cReferenceNumber]
		,[cEngineer]
		,[cArea]
		,[cCategory]
		,[cProblemType]
		,[cStatus]
		,[tStatusDate]
		,[tIssueDate]
		,[tSubmittedDate]
		,[tResolvedDate]
		,[tClosedDate]
		,[mProblem]
		,[mLocalResponse]
		,[mTechnicalResponse]
		,[lSubmitted]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[lLocked]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[ProblemReports]
	WHERE
		ABS(lActive) + @includeInactive > 0
		AND
		lDeleted = 0
	
	RETURN
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_ProblemReports_INSERT]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_ProblemReports_INSERT]'
		DROP PROCEDURE [dbo].[spl_ProblemReports_INSERT]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_ProblemReports_INSERT]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_ProblemReports_INSERT]'
		
		EXEC sp_executesql N'	
/****************************************************************
	spl_ProblemReports_INSERT
	Inserts a new record into the ProblemReports table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 9/1/2021 (I)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_ProblemReports_INSERT]
	
@nProcedureUID uniqueidentifier  = NULL 
	,@nTypeProcedureDefaultUID uniqueidentifier  = NULL 
	,@nTypeUID uniqueidentifier  = NULL 
	,@nSubmittedByUID uniqueidentifier  = NULL 
	,@nApprovedByUID uniqueidentifier  = NULL 
	,@nFacilityUID uniqueidentifier  = NULL 
	,@nWorkingFacilityUID uniqueidentifier  = NULL 
	,@nCallSheetUID uniqueidentifier  = NULL 
	,@cAuthority nvarchar(50)  = NULL 
	,@cProblemNumber nvarchar(50)  = NULL 
	,@cReferenceNumber nvarchar(50)  = NULL 
	,@cEngineer nvarchar(50)  = NULL 
	,@cArea nvarchar(50)  = NULL 
	,@cCategory nvarchar(50)  = NULL 
	,@cProblemType nvarchar(50)  = NULL 
	,@cStatus nvarchar(50)  = NULL 
	,@tStatusDate datetime  = NULL 
	,@tIssueDate datetime  = NULL 
	,@tSubmittedDate datetime  = NULL 
	,@tResolvedDate datetime  = NULL 
	,@tClosedDate datetime  = NULL 
	,@mProblem nvarchar(max)  = NULL 
	,@mLocalResponse nvarchar(max)  = NULL 
	,@mTechnicalResponse nvarchar(max)  = NULL 
	,@lSubmitted int  = NULL 
	,@lActive int  = -1 
	,@lDeleted int  = 0 
	,@lApproved int  = 0 
	,@lAdded int  = -1 
	,@lLocked int  = 0 
	,@nAddFacilityUID uniqueidentifier  = ''DBA97ADF-F868-459D-8343-DE1DF0FFB398'' 
	,@nAddUserUID uniqueidentifier  = ''915F9722-3175-4E4D-A571-4A478E8E5172'' 
	,@nImportUID uniqueidentifier  = NULL 

	,@nProblemReportsUID [uniqueidentifier] = NULL OUTPUT

AS
BEGIN

	DECLARE @ID [uniqueidentifier] = NEWID()

	INSERT INTO [dbo].[ProblemReports] (
		[nProblemReportsUID]
,[nProcedureUID]
		,[nTypeProcedureDefaultUID]
		,[nTypeUID]
		,[nSubmittedByUID]
		,[nApprovedByUID]
		,[nFacilityUID]
		,[nWorkingFacilityUID]
		,[nCallSheetUID]
		,[cAuthority]
		,[cProblemNumber]
		,[cReferenceNumber]
		,[cEngineer]
		,[cArea]
		,[cCategory]
		,[cProblemType]
		,[cStatus]
		,[tStatusDate]
		,[tIssueDate]
		,[tSubmittedDate]
		,[tResolvedDate]
		,[tClosedDate]
		,[mProblem]
		,[mLocalResponse]
		,[mTechnicalResponse]
		,[lSubmitted]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[lLocked]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]

		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@ID
,@nProcedureUID
		,@nTypeProcedureDefaultUID
		,@nTypeUID
		,@nSubmittedByUID
		,@nApprovedByUID
		,@nFacilityUID
		,@nWorkingFacilityUID
		,@nCallSheetUID
		,@cAuthority
		,@cProblemNumber
		,@cReferenceNumber
		,@cEngineer
		,@cArea
		,@cCategory
		,@cProblemType
		,@cStatus
		,@tStatusDate
		,@tIssueDate
		,@tSubmittedDate
		,@tResolvedDate
		,@tClosedDate
		,@mProblem
		,@mLocalResponse
		,@mTechnicalResponse
		,@lSubmitted
		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@lLocked
		,@nAddFacilityUID
		,@nAddUserUID
		,@nImportUID

		,GetUTCDate()
		,@nAddUserUID
		,@nAddFacilityUID
		,GetUTCDate()
		,GetUTCDate()
	)

	-- Return the new GUID for the UID of this record to the caller
	SET @nProblemReportsUID = @ID

	-- Avoids warning in VS2010
	RETURN 1
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	IF OBJECT_ID(N'[dbo].[spl_ProblemReports_DELETE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_ProblemReports_DELETE]'
		DROP PROCEDURE [dbo].[spl_ProblemReports_DELETE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_ProblemReports_DELETE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_ProblemReports_DELETE]'

		EXEC sp_executesql N'	
/****************************************************************
	spl_ProblemReports_DELETE
	Deletes a single record by ID from the ProblemReports table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 9/1/2021 (D)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_ProblemReports_DELETE]

	@nProblemReportsUID uniqueidentifier,
	@nUpdateUserUID 		[uniqueidentifier],
	@nUpdateFacilityUID		[uniqueidentifier],
	@retMsg					tinyint OUTPUT
	
AS
BEGIN

	DECLARE @recordID nvarchar(50)
	DECLARE @userID nvarchar(50)
	DECLARE @facilityUID nvarchar(50)
	DECLARE @now nvarchar(50)

	SELECT
		@recordID = CONVERT( nvarchar(50), @nProblemReportsUID ),
		@now = CONVERT( nvarchar(50), GetUTCDate() ),
		@userID = CONVERT( nvarchar(50), @nUpdateUserUID ),
		@facilityUID = CONVERT( nvarchar(50), @nUpdateFacilityUID ) 

	EXEC sp_CheckAndDelete
		1,							-- MarkDeleted
		''ProblemReports'',		-- TableName
		@recordID,					-- PrimaryKeyValue
		1,							-- IsPrimaryKeyString
		''ProblemReportEx '',	-- TableExceptions
		1,							-- ExceptDeletions
		@facilityUID,				-- FacilityUID
		@userID,					-- UpdateUserUID
		@now,						-- UpdateTime
		@retMsg OUTPUT
	
	RETURN @retMsg
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END



	IF OBJECT_ID(N'[dbo].[spl_ProblemReports_UPDATE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_ProblemReports_UPDATE]'
		DROP PROCEDURE [dbo].[spl_ProblemReports_UPDATE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_ProblemReports_UPDATE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_ProblemReports_UPDATE]'

		EXEC sp_executesql N'		
/****************************************************************
	spl_ProblemReports_UPDATE
	Updates a single record by ID in the ProblemReports table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 9/1/2021 (U)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_ProblemReports_UPDATE]
	
@nProblemReportsUID uniqueidentifier
	,@nProcedureUID uniqueidentifier
	,@nTypeProcedureDefaultUID uniqueidentifier
	,@nTypeUID uniqueidentifier
	,@nSubmittedByUID uniqueidentifier
	,@nApprovedByUID uniqueidentifier
	,@nFacilityUID uniqueidentifier
	,@nWorkingFacilityUID uniqueidentifier
	,@nCallSheetUID uniqueidentifier
	,@cAuthority nvarchar(50)
	,@cProblemNumber nvarchar(50)
	,@cReferenceNumber nvarchar(50)
	,@cEngineer nvarchar(50)
	,@cArea nvarchar(50)
	,@cCategory nvarchar(50)
	,@cProblemType nvarchar(50)
	,@cStatus nvarchar(50)
	,@tStatusDate datetime
	,@tIssueDate datetime
	,@tSubmittedDate datetime
	,@tResolvedDate datetime
	,@tClosedDate datetime
	,@mProblem nvarchar(max)
	,@mLocalResponse nvarchar(max)
	,@mTechnicalResponse nvarchar(max)
	,@lSubmitted int
	,@lActive int
	,@lDeleted int
	,@lApproved int
	,@lAdded int
	,@lLocked int
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@nImportUID uniqueidentifier


AS
BEGIN
	DECLARE @DateNow datetime = GetUTCDate();

	UPDATE [dbo].[ProblemReports]
	SET
[nProcedureUID] = @nProcedureUID
		,[nTypeProcedureDefaultUID] = @nTypeProcedureDefaultUID
		,[nTypeUID] = @nTypeUID
		,[nSubmittedByUID] = @nSubmittedByUID
		,[nApprovedByUID] = @nApprovedByUID
		,[nFacilityUID] = @nFacilityUID
		,[nWorkingFacilityUID] = @nWorkingFacilityUID
		,[nCallSheetUID] = @nCallSheetUID
		,[cAuthority] = @cAuthority
		,[cProblemNumber] = @cProblemNumber
		,[cReferenceNumber] = @cReferenceNumber
		,[cEngineer] = @cEngineer
		,[cArea] = @cArea
		,[cCategory] = @cCategory
		,[cProblemType] = @cProblemType
		,[cStatus] = @cStatus
		,[tStatusDate] = @tStatusDate
		,[tIssueDate] = @tIssueDate
		,[tSubmittedDate] = @tSubmittedDate
		,[tResolvedDate] = @tResolvedDate
		,[tClosedDate] = @tClosedDate
		,[mProblem] = @mProblem
		,[mLocalResponse] = @mLocalResponse
		,[mTechnicalResponse] = @mTechnicalResponse
		,[lSubmitted] = @lSubmitted
		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[lLocked] = @lLocked
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[nImportUID] = @nImportUID

		,[tUpdateTime] = @DateNow
		,[tMobileTime] = @DateNow
	WHERE
[nProblemReportsUID] = @nProblemReportsUID

	
	RETURN
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'lLocked'))
	EXEC sp_addextendedproperty N'MS_Description', N'Locked indicator flag', 'SCHEMA', N'dbo', 'TABLE', N'Procedures', 'COLUMN', N'lLocked'

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END		
	
	
	IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'lLocked'))
	EXEC sp_addextendedproperty N'MS_Description', N'Locked indicator flag', 'SCHEMA', N'dbo', 'TABLE', N'ProblemReports', 'COLUMN', N'lLocked'

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'lUrl'))
	EXEC sp_addextendedproperty N'MS_Description', N'URL based file indicator flag', 'SCHEMA', N'dbo', 'TABLE', N'Files', 'COLUMN', N'lUrl'

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	-->>MTM-5137<<--
	IF NOT EXISTS(SELECT * FROM syscolumns sc JOIN sysobjects so ON sc.id = so.id WHERE sc.name = 'cReturnedTo' AND so.name = 'CallSheets')
	BEGIN

	    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'ba7aa91b-38c4-4732-a5fb-da033d08858e')
	    BEGIN
	        PRINT 'Adding column [CallSheets].[cReturnedTo] to [AuditColumns]'

	        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
	        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
	        VALUES ('ba7aa91b-38c4-4732-a5fb-da033d08858e', 20, 3075, N'cReturnedTo', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210917 22:22:56', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210917 22:22:56', '20210917 22:22:56', NULL, NULL)
	        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', NULL, NULL))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', NULL, NULL


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cArea'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cArea'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cCallSheetNumber'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cCallSheetNumber'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cCallSheetStatus'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cCallSheetStatus'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cCallSheetType'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cCallSheetType'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cCertFormat'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cCertFormat'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cCertificationNumber'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cCertificationNumber'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cContactInfo'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cContactInfo'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cHumidity'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cHumidity'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cHumidityUOM'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cHumidityUOM'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cInitialCondition'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cInitialCondition'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cInterval'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cInterval'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cIntervalUOM'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cIntervalUOM'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cLocation'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cLocation'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cPressure'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cPressure'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cPressureUOM'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cPressureUOM'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cServiceReason'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cServiceReason'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cStickerType'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cStickerType'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cTemperature'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cTemperature'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cTemperatureUOM'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cTemperatureUOM'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lActive'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lActive'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lAdded'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lAdded'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lApproved'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lApproved'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lCancelled'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lCancelled'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lClosed'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lClosed'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lDelayed'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lDelayed'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lDeleted'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lDeleted'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lExpedite'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lExpedite'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lISOCert'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lISOCert'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lOnSite'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lOnSite'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lOOT'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lOOT'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lOptional1'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lOptional1'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lOptional2'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lOptional2'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lReturnNoMaint'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lReturnNoMaint'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lSubContracted'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lSubContracted'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mAccuracyNotes'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mAccuracyNotes'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mCallSheetNotes'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mCallSheetNotes'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mOOTNotes'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mOOTNotes'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mStickerNotes'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mStickerNotes'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mSubContractorNotes'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mSubContractorNotes'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mUncertaintyNotes'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mUncertaintyNotes'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAddFacilityUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAddFacilityUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAddUserUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAddUserUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAllocated'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAllocated'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAllocatedParts'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAllocatedParts'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAssetUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAssetUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAssignedTechUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAssignedTechUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nCalendarUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nCalendarUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nCallSheetAttributeUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nCallSheetAttributeUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nCallSheetUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nCallSheetUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nCategoryUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nCategoryUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nCost'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nCost'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nDepartmentUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nDepartmentUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nFacilityUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nFacilityUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nGroupUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nGroupUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nImportUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nImportUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nInvoiceUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nInvoiceUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nJobNumberUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nJobNumberUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nOwningLabUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nOwningLabUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nPriority'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nPriority'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nProcedureUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nProcedureUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nQCApprovedByUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nQCApprovedByUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nQuantity'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nQuantity'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nReturnedByUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nReturnedByUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nSubCategoryUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nSubCategoryUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nSubContCost'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nSubContCost'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nSubContHours'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nSubContHours'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nSubContLabCost'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nSubContLabCost'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nSubContractorUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nSubContractorUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nTechnicianPriority'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nTechnicianPriority'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nTechnicianUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nTechnicianUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nTypeProcedureDefaultUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nTypeProcedureDefaultUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nTypeUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nTypeUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nUpdateFacilityUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nUpdateFacilityUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nUpdateUserUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nUpdateUserUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nWorkingFacilityUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nWorkingFacilityUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tAddTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tAddTime'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tClosedDate'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tClosedDate'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tDelayDate'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tDelayDate'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tMaintDate'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tMaintDate'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tMaintNextDate'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tMaintNextDate'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tMobileTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tMobileTime'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tOpenDate'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tOpenDate'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tQCApprovedDate'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tQCApprovedDate'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tRequiredDate'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tRequiredDate'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tReturnedDate'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tReturnedDate'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tSystemUpdateTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tSystemUpdateTime'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tUpdateTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tUpdateTime'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cReturnedTo'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cReturnedTo'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cWorkOrderResults'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cWorkOrderResults'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping foreign keys from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_Assets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Calendar]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_Calendar]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_CallSheetAttributes]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_CallSheetAttributes]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Category]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_Category]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Facilities]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_Facilities]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Facilities_nOwningLabUID]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_Facilities_nOwningLabUID]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_FacilitiesDepartment]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_FacilitiesDepartment]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_FacilitiesSubContractor]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_FacilitiesSubContractor]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_FacilitiesWorkingFacility]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_FacilitiesWorkingFacility]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Invoices]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_Invoices]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_JobNumbers]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_JobNumbers]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_Procedures]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_SubCategory]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_SubCategory]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_TypeProcedureDefaults]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_TypeProcedureDefaults]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Types]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_Types]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Users]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_Users]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_UsersAssignedTech]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_UsersAssignedTech]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_UsersQCApprovedBy]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_UsersQCApprovedBy]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_UsersReturnedBy]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_UsersReturnedBy]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping foreign keys from [dbo].[CallSheetAccreditationLink]'


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetAccreditationLink_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetAccreditationLink]', 'U'))
		ALTER TABLE [dbo].[CallSheetAccreditationLink] DROP CONSTRAINT [FK_CallSheetAccreditationLink_CallSheets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping foreign keys from [dbo].[CallSheetEx]'


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetEx_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetEx]', 'U'))
		ALTER TABLE [dbo].[CallSheetEx] DROP CONSTRAINT [FK_CallSheetEx_CallSheets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping foreign keys from [dbo].[CallSheetFiles]'


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetFiles_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetFiles]', 'U'))
		ALTER TABLE [dbo].[CallSheetFiles] DROP CONSTRAINT [FK_CallSheetFiles_CallSheets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping foreign keys from [dbo].[CallSheetLog]'


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetLog_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetLog]', 'U'))
		ALTER TABLE [dbo].[CallSheetLog] DROP CONSTRAINT [FK_CallSheetLog_CallSheets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping foreign keys from [dbo].[CallSheetPartsLink]'


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetPartsLink_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetPartsLink]', 'U'))
		ALTER TABLE [dbo].[CallSheetPartsLink] DROP CONSTRAINT [FK_CallSheetPartsLink_CallSheets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping foreign keys from [dbo].[CallSheetReadings]'


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetReadings_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetReadings]', 'U'))
		ALTER TABLE [dbo].[CallSheetReadings] DROP CONSTRAINT [FK_CallSheetReadings_CallSheets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping foreign keys from [dbo].[CallSheetResults]'


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetResults_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U'))
		ALTER TABLE [dbo].[CallSheetResults] DROP CONSTRAINT [FK_CallSheetResults_CallSheets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping foreign keys from [dbo].[CallSheetStandardLink]'


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetStandardLink_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetStandardLink]', 'U'))
		ALTER TABLE [dbo].[CallSheetStandardLink] DROP CONSTRAINT [FK_CallSheetStandardLink_CallSheets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping foreign keys from [dbo].[Estimates]'


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Estimates_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Estimates]', 'U'))
		ALTER TABLE [dbo].[Estimates] DROP CONSTRAINT [FK_Estimates_CallSheets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping foreign keys from [dbo].[InvoiceItemDetails]'


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_InvoiceItemDetails_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[InvoiceItemDetails]', 'U'))
		ALTER TABLE [dbo].[InvoiceItemDetails] DROP CONSTRAINT [FK_InvoiceItemDetails_CallSheets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping foreign keys from [dbo].[InvoiceItems]'


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_InvoiceItems_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[InvoiceItems]', 'U'))
		ALTER TABLE [dbo].[InvoiceItems] DROP CONSTRAINT [FK_InvoiceItems_CallSheets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping foreign keys from [dbo].[Labor]'


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Labor_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Labor]', 'U'))
		ALTER TABLE [dbo].[Labor] DROP CONSTRAINT [FK_Labor_CallSheets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping foreign keys from [dbo].[ProblemReports]'


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReports_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] DROP CONSTRAINT [FK_ProblemReports_CallSheets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PK_CallSheets]', 'PK') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [PK_CallSheets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nSubContHours' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_nSubContHours]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_nSubContHours]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nSubContCost' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_nSubContCost]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_nSubContCost]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nSubContLabCost' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_nSubContLabCost]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_nSubContLabCost]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nCost' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_nCost]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_nCost]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nAllocated' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_nAllocated]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_nAllocated]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nAllocatedParts' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_nAllocated1]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_nAllocated1]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lClosed' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_lClosed]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_lClosed]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lDelayed' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_lDelayed]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_lDelayed]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lCancelled' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_lCancelled]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_lCancelled]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lOptional1' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_lOptional1]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_lOptional1]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lOptional2' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_lOptional2]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_lOptional2]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lActive' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_lActive]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_lActive]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lDeleted' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_lDeleted]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_lDeleted]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lApproved' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_lApproved]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_lApproved]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lAdded' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_lAdded]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_lAdded]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nAddFacilityUID' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_nAddFacilityUID]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_nAddFacilityUID]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nAddUserUID' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_nAddUserUID]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_nAddUserUID]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tAddTime' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_tAddTime]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_tAddTime]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nUpdateFacilityUID' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_nUpdateFacilityUID]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_nUpdateFacilityUID]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nUpdateUserUID' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_nUpdateUserUID]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_nUpdateUserUID]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tUpdateTime' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_tUpdateTime]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_tUpdateTime]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping constraints from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tMobileTime' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_CallSheets_tMobileTime]', 'D'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [DF_CallSheets_tMobileTime]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping index [IDX_CallSheets_04_2] from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_CallSheets_04_2' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]'))
		DROP INDEX [IDX_CallSheets_04_2] ON [dbo].[CallSheets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping index [IDX_CallSheets_06] from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_CallSheets_06' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]'))
		DROP INDEX [IDX_CallSheets_06] ON [dbo].[CallSheets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping index [IDX_CallSheets_04] from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_CallSheets_04' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]'))
		DROP INDEX [IDX_CallSheets_04] ON [dbo].[CallSheets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping index [IDX_CallSheets_tAddTime] from [dbo].[CallSheets]'


		IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_CallSheets_tAddTime' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]'))
		DROP INDEX [IDX_CallSheets_tAddTime] ON [dbo].[CallSheets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping trigger [dbo].[tr_kr_audit_CallSheets_Del] from [dbo].[CallSheets]'


		IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheets_Del]', 'TR') IS NOT NULL
		DROP TRIGGER [dbo].[tr_kr_audit_CallSheets_Del]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping trigger [dbo].[tr_kr_audit_CallSheets_Ins] from [dbo].[CallSheets]'


		IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheets_Ins]', 'TR') IS NOT NULL
		DROP TRIGGER [dbo].[tr_kr_audit_CallSheets_Ins]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Dropping trigger [dbo].[tr_kr_audit_CallSheets_Upd] from [dbo].[CallSheets]'


		IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheets_Upd]', 'TR') IS NOT NULL
		DROP TRIGGER [dbo].[tr_kr_audit_CallSheets_Upd]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Rebuilding [dbo].[CallSheets]'


		SET QUOTED_IDENTIFIER ON


		SET ANSI_NULLS ON


		CREATE TABLE [dbo].[RG_Recovery_1_CallSheets]
		(
		[nCallSheetUID] [uniqueidentifier] NOT NULL ROWGUIDCOL,
		[nGroupUID] [uniqueidentifier] NULL,
		[nAssetUID] [uniqueidentifier] NOT NULL,
		[nTypeUID] [uniqueidentifier] NOT NULL,
		[nFacilityUID] [uniqueidentifier] NOT NULL,
		[nDepartmentUID] [uniqueidentifier] NULL,
		[nWorkingFacilityUID] [uniqueidentifier] NULL,
		[nOwningLabUID] [uniqueidentifier] NULL,
		[nCategoryUID] [uniqueidentifier] NULL,
		[nSubCategoryUID] [uniqueidentifier] NULL,
		[nProcedureUID] [uniqueidentifier] NULL,
		[nTypeProcedureDefaultUID] [uniqueidentifier] NULL,
		[nAssignedTechUID] [uniqueidentifier] NULL,
		[nTechnicianUID] [uniqueidentifier] NULL,
		[nQCApprovedByUID] [uniqueidentifier] NULL,
		[nReturnedByUID] [uniqueidentifier] NULL,
		[nSubContractorUID] [uniqueidentifier] NULL,
		[nJobNumberUID] [uniqueidentifier] NULL,
		[nCalendarUID] [uniqueidentifier] NULL,
		[nInvoiceUID] [uniqueidentifier] NULL,
		[nCallSheetAttributeUID] [uniqueidentifier] NULL,
		[nSubContHours] [numeric] (18, 2) NULL CONSTRAINT [DF_CallSheets_nSubContHours] DEFAULT ((0)),
		[nSubContCost] [numeric] (18, 2) NULL CONSTRAINT [DF_CallSheets_nSubContCost] DEFAULT ((0)),
		[nSubContLabCost] [numeric] (18, 2) NULL CONSTRAINT [DF_CallSheets_nSubContLabCost] DEFAULT ((0)),
		[nCost] [numeric] (18, 2) NULL CONSTRAINT [DF_CallSheets_nCost] DEFAULT ((0)),
		[nAllocated] [numeric] (18, 2) NULL CONSTRAINT [DF_CallSheets_nAllocated] DEFAULT ((0)),
		[nAllocatedParts] [numeric] (18, 2) NULL CONSTRAINT [DF_CallSheets_nAllocated1] DEFAULT ((0)),
		[cContactInfo] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cInitialCondition] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cServiceReason] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cCallSheetType] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cStickerType] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cCallSheetStatus] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cCallSheetNumber] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cCertificationNumber] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cInterval] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cIntervalUOM] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cTemperature] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cTemperatureUOM] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cHumidity] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cHumidityUOM] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cPressure] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cPressureUOM] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cLocation] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cArea] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cCertFormat] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cWorkOrderResults] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cReturnedTo] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[tOpenDate] [datetime] NULL,
		[tRequiredDate] [datetime] NULL,
		[tDelayDate] [datetime] NULL,
		[tMaintDate] [datetime] NULL,
		[tMaintNextDate] [datetime] NULL,
		[tQCApprovedDate] [datetime] NULL,
		[tClosedDate] [datetime] NULL,
		[tReturnedDate] [datetime] NULL,
		[nQuantity] [int] NULL,
		[nPriority] [int] NULL,
		[nTechnicianPriority] [int] NULL,
		[nRevision] [int] NULL,
		[lExpedite] [int] NULL,
		[lISOCert] [int] NULL,
		[lOnSite] [int] NULL,
		[lReturnNoMaint] [int] NULL,
		[lSubContracted] [int] NULL,
		[lOOT] [int] NULL,
		[lClosed] [int] NULL CONSTRAINT [DF_CallSheets_lClosed] DEFAULT ((0)),
		[lDelayed] [int] NULL CONSTRAINT [DF_CallSheets_lDelayed] DEFAULT ((0)),
		[lCancelled] [int] NULL CONSTRAINT [DF_CallSheets_lCancelled] DEFAULT ((0)),
		[lOptional1] [int] NOT NULL CONSTRAINT [DF_CallSheets_lOptional1] DEFAULT ((0)),
		[lOptional2] [int] NOT NULL CONSTRAINT [DF_CallSheets_lOptional2] DEFAULT ((0)),
		[mCallSheetNotes] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[mAccuracyNotes] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[mUncertaintyNotes] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[mSubContractorNotes] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[mOOTNotes] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[mStickerNotes] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[lActive] [int] NOT NULL CONSTRAINT [DF_CallSheets_lActive] DEFAULT ((-1)),
		[lDeleted] [int] NOT NULL CONSTRAINT [DF_CallSheets_lDeleted] DEFAULT ((0)),
		[lApproved] [int] NOT NULL CONSTRAINT [DF_CallSheets_lApproved] DEFAULT ((0)),
		[lAdded] [int] NOT NULL CONSTRAINT [DF_CallSheets_lAdded] DEFAULT ((-1)),
		[nAddFacilityUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_CallSheets_nAddFacilityUID] DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398'),
		[nAddUserUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_CallSheets_nAddUserUID] DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172'),
		[tAddTime] [datetime] NOT NULL CONSTRAINT [DF_CallSheets_tAddTime] DEFAULT (getutcdate()),
		[nUpdateFacilityUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_CallSheets_nUpdateFacilityUID] DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398'),
		[nUpdateUserUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_CallSheets_nUpdateUserUID] DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172'),
		[tUpdateTime] [datetime] NOT NULL CONSTRAINT [DF_CallSheets_tUpdateTime] DEFAULT (getutcdate()),
		[tMobileTime] [datetime] NOT NULL CONSTRAINT [DF_CallSheets_tMobileTime] DEFAULT (getutcdate()),
		[tSystemUpdateTime] [datetime] NULL,
		[nImportUID] [uniqueidentifier] NULL,
		CONSTRAINT [RG_Recovery_b874_PK_CallSheets] PRIMARY KEY NONCLUSTERED ([nCallSheetUID])
		)


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		INSERT INTO [dbo].[RG_Recovery_1_CallSheets]([nCallSheetUID], [nGroupUID], [nAssetUID], [nTypeUID], [nFacilityUID], [nDepartmentUID], [nWorkingFacilityUID], [nOwningLabUID], [nCategoryUID], [nSubCategoryUID], [nProcedureUID], [nTypeProcedureDefaultUID], [nAssignedTechUID], [nTechnicianUID], [nQCApprovedByUID], [nReturnedByUID], [nSubContractorUID], [nJobNumberUID], [nCalendarUID], [nInvoiceUID], [nCallSheetAttributeUID], [nSubContHours], [nSubContCost], [nSubContLabCost], [nCost], [nAllocated], [nAllocatedParts], [cContactInfo], [cInitialCondition], [cServiceReason], [cCallSheetType], [cStickerType], [cCallSheetStatus], [cCallSheetNumber], [cCertificationNumber], [cInterval], [cIntervalUOM], [cTemperature], [cTemperatureUOM], [cHumidity], [cHumidityUOM], [cPressure], [cPressureUOM], [cLocation], [cArea], [cCertFormat], [cWorkOrderResults], [tOpenDate], [tRequiredDate], [tDelayDate], [tMaintDate], [tMaintNextDate], [tQCApprovedDate], [tClosedDate], [tReturnedDate], [nQuantity], [nPriority], [nTechnicianPriority], [nRevision], [lExpedite], [lISOCert], [lOnSite], [lReturnNoMaint], [lSubContracted], [lOOT], [lClosed], [lDelayed], [lCancelled], [mCallSheetNotes], [mAccuracyNotes], [mUncertaintyNotes], [mSubContractorNotes], [mOOTNotes], [mStickerNotes], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID]) SELECT [nCallSheetUID], [nGroupUID], [nAssetUID], [nTypeUID], [nFacilityUID], [nDepartmentUID], [nWorkingFacilityUID], [nOwningLabUID], [nCategoryUID], [nSubCategoryUID], [nProcedureUID], [nTypeProcedureDefaultUID], [nAssignedTechUID], [nTechnicianUID], [nQCApprovedByUID], [nReturnedByUID], [nSubContractorUID], [nJobNumberUID], [nCalendarUID], [nInvoiceUID], [nCallSheetAttributeUID], [nSubContHours], [nSubContCost], [nSubContLabCost], [nCost], [nAllocated], [nAllocatedParts], [cContactInfo], [cInitialCondition], [cServiceReason], [cCallSheetType], [cStickerType], [cCallSheetStatus], [cCallSheetNumber], [cCertificationNumber], [cInterval], [cIntervalUOM], [cTemperature], [cTemperatureUOM], [cHumidity], [cHumidityUOM], [cPressure], [cPressureUOM], [cLocation], [cArea], [cCertFormat], [cWorkOrderResults], [tOpenDate], [tRequiredDate], [tDelayDate], [tMaintDate], [tMaintNextDate], [tQCApprovedDate], [tClosedDate], [tReturnedDate], [nQuantity], [nPriority], [nTechnicianPriority], [nRevision], [lExpedite], [lISOCert], [lOnSite], [lReturnNoMaint], [lSubContracted], [lOOT], [lClosed], [lDelayed], [lCancelled], [mCallSheetNotes], [mAccuracyNotes], [mUncertaintyNotes], [mSubContractorNotes], [mOOTNotes], [mStickerNotes], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID] FROM [dbo].[CallSheets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		DROP TABLE [dbo].[CallSheets]


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		IF (OBJECT_ID(N'[dbo].[RG_Recovery_1_CallSheets]', 'U') IS NOT NULL) AND (OBJECT_ID(N'[dbo].[CallSheets]', 'U') IS NULL)
		EXEC sp_rename N'[dbo].[RG_Recovery_1_CallSheets]', N'CallSheets', N'OBJECT'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		EXEC sp_rename N'[dbo].[CallSheets].[RG_Recovery_b874_PK_CallSheets]', N'PK_CallSheets', N'INDEX'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Creating index [IDX_CallSheets_tAddTime] on [dbo].[CallSheets]'


		IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_CallSheets_tAddTime' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]'))
		CREATE CLUSTERED INDEX [IDX_CallSheets_tAddTime] ON [dbo].[CallSheets] ([tAddTime])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Creating index [IDX_CallSheets_06] on [dbo].[CallSheets]'


		IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_CallSheets_06' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]'))
		CREATE NONCLUSTERED INDEX [IDX_CallSheets_06] ON [dbo].[CallSheets] ([lClosed], [lDeleted], [lActive], [nFacilityUID], [nTypeUID], [nAssetUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Creating index [IDX_CallSheets_04] on [dbo].[CallSheets]'


		IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_CallSheets_04' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]'))
		CREATE NONCLUSTERED INDEX [IDX_CallSheets_04] ON [dbo].[CallSheets] ([nAssetUID], [lClosed], [lDeleted], [lActive])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Creating index [IDX_CallSheets_04_2] on [dbo].[CallSheets]'


		IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_CallSheets_04_2' AND object_id = OBJECT_ID(N'[dbo].[CallSheets]'))
		CREATE NONCLUSTERED INDEX [IDX_CallSheets_04_2] ON [dbo].[CallSheets] ([tOpenDate], [lClosed], [lDeleted], [lActive]) INCLUDE ([cArea], [cCallSheetNumber], [nAssetUID], [nAssignedTechUID], [nJobNumberUID], [nOwningLabUID], [cCallSheetStatus], [cCallSheetType], [cCertificationNumber], [lExpedite], [nWorkingFacilityUID], [tMaintDate], [nCallSheetUID], [nCategoryUID], [nDepartmentUID], [nFacilityUID], [tMaintNextDate], [tRequiredDate], [nPriority], [nSubCategoryUID], [nTechnicianUID], [nTypeUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheets_Del]', 'TR') IS NOT NULL
	    BEGIN
	    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_CallSheets_Del] from [dbo].[CallSheets]'

	    	DROP TRIGGER [dbo].[tr_kr_audit_CallSheets_Del]


	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheets_Del]', 'TR') IS NULL
	    BEGIN
	        PRINT N'Creating trigger [dbo].[tr_kr_audit_CallSheets_Del] on [dbo].[CallSheets]'

	        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_CallSheets_Del] ON [dbo].[CallSheets] FOR DELETE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20210917 22:27:07

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM DELETED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            558,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cArea], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            559,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cCallSheetNumber], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            560,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cCallSheetStatus], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            561,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cCallSheetType], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            562,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cCertFormat], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            563,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cCertificationNumber], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            564,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cContactInfo], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            565,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cHumidity], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            566,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cHumidityUOM], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            567,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cInitialCondition], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            568,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cInterval], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            569,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cIntervalUOM], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            570,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cLocation], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            571,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cPressure], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            572,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cPressureUOM], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            3075,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cReturnedTo], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            573,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cServiceReason], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            574,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cStickerType], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            575,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cTemperature], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            576,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cTemperatureUOM], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            577,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cWorkOrderResults], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            578,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            579,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            580,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            581,
            0,
            CONVERT(NVARCHAR, [lCancelled])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            582,
            0,
            CONVERT(NVARCHAR, [lClosed])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            583,
            0,
            CONVERT(NVARCHAR, [lDelayed])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            584,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            585,
            0,
            CONVERT(NVARCHAR, [lExpedite])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            586,
            0,
            CONVERT(NVARCHAR, [lISOCert])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            587,
            0,
            CONVERT(NVARCHAR, [lOnSite])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            588,
            0,
            CONVERT(NVARCHAR, [lOOT])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            3072,
            0,
            CONVERT(NVARCHAR, [lOptional1])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            3073,
            0,
            CONVERT(NVARCHAR, [lOptional2])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            589,
            0,
            CONVERT(NVARCHAR, [lReturnNoMaint])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            590,
            0,
            CONVERT(NVARCHAR, [lSubContracted])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            591,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mAccuracyNotes], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            592,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mCallSheetNotes], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            593,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mOOTNotes], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            594,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mStickerNotes], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            595,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mSubContractorNotes], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            596,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mUncertaintyNotes], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            597,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            598,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            599,
            0,
            CONVERT( NVARCHAR( 41 ), [nAllocated], 2 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            600,
            0,
            CONVERT( NVARCHAR( 41 ), [nAllocatedParts], 2 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            601,
            0,
            CONVERT(NVARCHAR( 36 ), [nAssetUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            602,
            0,
            CONVERT(NVARCHAR( 36 ), [nAssignedTechUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            603,
            0,
            CONVERT(NVARCHAR( 36 ), [nCalendarUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            604,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetAttributeUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            605,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            606,
            0,
            CONVERT(NVARCHAR( 36 ), [nCategoryUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            607,
            0,
            CONVERT( NVARCHAR( 41 ), [nCost], 2 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            608,
            0,
            CONVERT(NVARCHAR( 36 ), [nDepartmentUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            609,
            0,
            CONVERT(NVARCHAR( 36 ), [nFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            610,
            0,
            CONVERT(NVARCHAR( 36 ), [nGroupUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            611,
            0,
            CONVERT(NVARCHAR( 36 ), [nImportUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            612,
            0,
            CONVERT(NVARCHAR( 36 ), [nInvoiceUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            613,
            0,
            CONVERT(NVARCHAR( 36 ), [nJobNumberUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            614,
            0,
            CONVERT(NVARCHAR( 36 ), [nOwningLabUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            615,
            0,
            CONVERT(NVARCHAR, [nPriority])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            616,
            0,
            CONVERT(NVARCHAR( 36 ), [nProcedureUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            617,
            0,
            CONVERT(NVARCHAR( 36 ), [nQCApprovedByUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            618,
            0,
            CONVERT(NVARCHAR, [nQuantity])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            619,
            0,
            CONVERT(NVARCHAR( 36 ), [nReturnedByUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            620,
            0,
            CONVERT(NVARCHAR, [nRevision])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            621,
            0,
            CONVERT(NVARCHAR( 36 ), [nSubCategoryUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            622,
            0,
            CONVERT( NVARCHAR( 41 ), [nSubContCost], 2 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            623,
            0,
            CONVERT( NVARCHAR( 41 ), [nSubContHours], 2 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            624,
            0,
            CONVERT( NVARCHAR( 41 ), [nSubContLabCost], 2 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            625,
            0,
            CONVERT(NVARCHAR( 36 ), [nSubContractorUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            626,
            0,
            CONVERT(NVARCHAR, [nTechnicianPriority])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            627,
            0,
            CONVERT(NVARCHAR( 36 ), [nTechnicianUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            628,
            0,
            CONVERT(NVARCHAR( 36 ), [nTypeProcedureDefaultUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            629,
            0,
            CONVERT(NVARCHAR( 36 ), [nTypeUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            630,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            631,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            632,
            0,
            CONVERT(NVARCHAR( 36 ), [nWorkingFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            633,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            634,
            0,
            CONVERT( NVARCHAR( 34 ), [tClosedDate], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            635,
            0,
            CONVERT( NVARCHAR( 34 ), [tDelayDate], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            636,
            0,
            CONVERT( NVARCHAR( 34 ), [tMaintDate], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            637,
            0,
            CONVERT( NVARCHAR( 34 ), [tMaintNextDate], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            638,
            0,
            CONVERT( NVARCHAR( 34 ), [tMobileTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            639,
            0,
            CONVERT( NVARCHAR( 34 ), [tOpenDate], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            640,
            0,
            CONVERT( NVARCHAR( 34 ), [tQCApprovedDate], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            641,
            0,
            CONVERT( NVARCHAR( 34 ), [tRequiredDate], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            642,
            0,
            CONVERT( NVARCHAR( 34 ), [tReturnedDate], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            643,
            0,
            CONVERT( NVARCHAR( 34 ), [tSystemUpdateTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            644,
            0,
            CONVERT( NVARCHAR( 34 ), [tUpdateTime], 121 )
        FROM
            DELETED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 20, @RowsAffected, ''D'', @AuditedUser
    END
END
'

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_CallSheets_Del]', 'last', 'delete', null

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheets_Ins]', 'TR') IS NOT NULL
	    BEGIN
	    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_CallSheets_Ins] from [dbo].[CallSheets]'

	    	DROP TRIGGER [dbo].[tr_kr_audit_CallSheets_Ins]


	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheets_Ins]', 'TR') IS NULL
	    BEGIN
	        PRINT N'Creating trigger [dbo].[tr_kr_audit_CallSheets_Ins] on [dbo].[CallSheets]'

	        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_CallSheets_Ins] ON [dbo].[CallSheets] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20210917 22:27:07

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            558,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cArea], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            559,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cCallSheetNumber], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            560,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cCallSheetStatus], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            561,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cCallSheetType], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            562,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cCertFormat], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            563,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cCertificationNumber], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            564,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cContactInfo], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            565,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cHumidity], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            566,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cHumidityUOM], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            567,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cInitialCondition], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            568,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cInterval], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            569,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cIntervalUOM], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            570,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cLocation], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            571,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cPressure], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            572,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cPressureUOM], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            3075,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cReturnedTo], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            573,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cServiceReason], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            574,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cStickerType], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            575,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cTemperature], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            576,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cTemperatureUOM], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            577,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cWorkOrderResults], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            578,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            579,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            580,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            581,
            0,
            CONVERT(NVARCHAR, [lCancelled])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            582,
            0,
            CONVERT(NVARCHAR, [lClosed])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            583,
            0,
            CONVERT(NVARCHAR, [lDelayed])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            584,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            585,
            0,
            CONVERT(NVARCHAR, [lExpedite])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            586,
            0,
            CONVERT(NVARCHAR, [lISOCert])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            587,
            0,
            CONVERT(NVARCHAR, [lOnSite])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            588,
            0,
            CONVERT(NVARCHAR, [lOOT])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            3072,
            0,
            CONVERT(NVARCHAR, [lOptional1])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            3073,
            0,
            CONVERT(NVARCHAR, [lOptional2])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            589,
            0,
            CONVERT(NVARCHAR, [lReturnNoMaint])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            590,
            0,
            CONVERT(NVARCHAR, [lSubContracted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            591,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mAccuracyNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            592,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mCallSheetNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            593,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mOOTNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            594,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mStickerNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            595,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mSubContractorNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            596,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mUncertaintyNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            597,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            598,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            599,
            0,
            CONVERT( NVARCHAR( 41 ), [nAllocated], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            600,
            0,
            CONVERT( NVARCHAR( 41 ), [nAllocatedParts], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            601,
            0,
            CONVERT(NVARCHAR( 36 ), [nAssetUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            602,
            0,
            CONVERT(NVARCHAR( 36 ), [nAssignedTechUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            603,
            0,
            CONVERT(NVARCHAR( 36 ), [nCalendarUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            604,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetAttributeUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            605,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            606,
            0,
            CONVERT(NVARCHAR( 36 ), [nCategoryUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            607,
            0,
            CONVERT( NVARCHAR( 41 ), [nCost], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            608,
            0,
            CONVERT(NVARCHAR( 36 ), [nDepartmentUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            609,
            0,
            CONVERT(NVARCHAR( 36 ), [nFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            610,
            0,
            CONVERT(NVARCHAR( 36 ), [nGroupUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            612,
            0,
            CONVERT(NVARCHAR( 36 ), [nInvoiceUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            613,
            0,
            CONVERT(NVARCHAR( 36 ), [nJobNumberUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            614,
            0,
            CONVERT(NVARCHAR( 36 ), [nOwningLabUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            615,
            0,
            CONVERT(NVARCHAR, [nPriority])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            616,
            0,
            CONVERT(NVARCHAR( 36 ), [nProcedureUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            617,
            0,
            CONVERT(NVARCHAR( 36 ), [nQCApprovedByUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            618,
            0,
            CONVERT(NVARCHAR, [nQuantity])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            619,
            0,
            CONVERT(NVARCHAR( 36 ), [nReturnedByUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            620,
            0,
            CONVERT(NVARCHAR, [nRevision])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            621,
            0,
            CONVERT(NVARCHAR( 36 ), [nSubCategoryUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            622,
            0,
            CONVERT( NVARCHAR( 41 ), [nSubContCost], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            623,
            0,
            CONVERT( NVARCHAR( 41 ), [nSubContHours], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            624,
            0,
            CONVERT( NVARCHAR( 41 ), [nSubContLabCost], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            625,
            0,
            CONVERT(NVARCHAR( 36 ), [nSubContractorUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            626,
            0,
            CONVERT(NVARCHAR, [nTechnicianPriority])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            627,
            0,
            CONVERT(NVARCHAR( 36 ), [nTechnicianUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            628,
            0,
            CONVERT(NVARCHAR( 36 ), [nTypeProcedureDefaultUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            629,
            0,
            CONVERT(NVARCHAR( 36 ), [nTypeUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            632,
            0,
            CONVERT(NVARCHAR( 36 ), [nWorkingFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            633,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            634,
            0,
            CONVERT( NVARCHAR( 34 ), [tClosedDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            635,
            0,
            CONVERT( NVARCHAR( 34 ), [tDelayDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            636,
            0,
            CONVERT( NVARCHAR( 34 ), [tMaintDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            637,
            0,
            CONVERT( NVARCHAR( 34 ), [tMaintNextDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            639,
            0,
            CONVERT( NVARCHAR( 34 ), [tOpenDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            640,
            0,
            CONVERT( NVARCHAR( 34 ), [tQCApprovedDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            641,
            0,
            CONVERT( NVARCHAR( 34 ), [tRequiredDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            642,
            0,
            CONVERT( NVARCHAR( 34 ), [tReturnedDate], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 20, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL
    END
END
'

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_CallSheets_Ins]', 'last', 'insert', null

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheets_Upd]', 'TR') IS NOT NULL
	    BEGIN
	    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_CallSheets_Upd] from [dbo].[CallSheets]'

	    	DROP TRIGGER [dbo].[tr_kr_audit_CallSheets_Upd]


	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheets_Upd]', 'TR') IS NULL
	    BEGIN
	        PRINT N'Creating trigger [dbo].[tr_kr_audit_CallSheets_Upd] on [dbo].[CallSheets]'

	        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_CallSheets_Upd] ON [dbo].[CallSheets] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20210917 22:27:07

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cArea] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                558,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cArea], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cArea], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cArea], '''') <> NULLIF(i.[cArea], '''') ) OR
                ( NULLIF(d.[cArea], '''') IS NULL AND NULLIF(i.[cArea], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cArea], '''') IS NULL AND NULLIF(d.[cArea], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cCallSheetNumber] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                559,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cCallSheetNumber], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cCallSheetNumber], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cCallSheetNumber], '''') <> NULLIF(i.[cCallSheetNumber], '''') ) OR
                ( NULLIF(d.[cCallSheetNumber], '''') IS NULL AND NULLIF(i.[cCallSheetNumber], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cCallSheetNumber], '''') IS NULL AND NULLIF(d.[cCallSheetNumber], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cCallSheetStatus] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                560,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cCallSheetStatus], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cCallSheetStatus], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cCallSheetStatus], '''') <> NULLIF(i.[cCallSheetStatus], '''') ) OR
                ( NULLIF(d.[cCallSheetStatus], '''') IS NULL AND NULLIF(i.[cCallSheetStatus], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cCallSheetStatus], '''') IS NULL AND NULLIF(d.[cCallSheetStatus], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cCallSheetType] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                561,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cCallSheetType], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cCallSheetType], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cCallSheetType], '''') <> NULLIF(i.[cCallSheetType], '''') ) OR
                ( NULLIF(d.[cCallSheetType], '''') IS NULL AND NULLIF(i.[cCallSheetType], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cCallSheetType], '''') IS NULL AND NULLIF(d.[cCallSheetType], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cCertFormat] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                562,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cCertFormat], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cCertFormat], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cCertFormat], '''') <> NULLIF(i.[cCertFormat], '''') ) OR
                ( NULLIF(d.[cCertFormat], '''') IS NULL AND NULLIF(i.[cCertFormat], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cCertFormat], '''') IS NULL AND NULLIF(d.[cCertFormat], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cCertificationNumber] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                563,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cCertificationNumber], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cCertificationNumber], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cCertificationNumber], '''') <> NULLIF(i.[cCertificationNumber], '''') ) OR
                ( NULLIF(d.[cCertificationNumber], '''') IS NULL AND NULLIF(i.[cCertificationNumber], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cCertificationNumber], '''') IS NULL AND NULLIF(d.[cCertificationNumber], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cContactInfo] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                564,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cContactInfo], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cContactInfo], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cContactInfo], '''') <> NULLIF(i.[cContactInfo], '''') ) OR
                ( NULLIF(d.[cContactInfo], '''') IS NULL AND NULLIF(i.[cContactInfo], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cContactInfo], '''') IS NULL AND NULLIF(d.[cContactInfo], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cHumidity] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                565,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cHumidity], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cHumidity], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cHumidity], '''') <> NULLIF(i.[cHumidity], '''') ) OR
                ( NULLIF(d.[cHumidity], '''') IS NULL AND NULLIF(i.[cHumidity], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cHumidity], '''') IS NULL AND NULLIF(d.[cHumidity], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cHumidityUOM] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                566,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cHumidityUOM], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cHumidityUOM], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cHumidityUOM], '''') <> NULLIF(i.[cHumidityUOM], '''') ) OR
                ( NULLIF(d.[cHumidityUOM], '''') IS NULL AND NULLIF(i.[cHumidityUOM], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cHumidityUOM], '''') IS NULL AND NULLIF(d.[cHumidityUOM], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cInitialCondition] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                567,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cInitialCondition], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cInitialCondition], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cInitialCondition], '''') <> NULLIF(i.[cInitialCondition], '''') ) OR
                ( NULLIF(d.[cInitialCondition], '''') IS NULL AND NULLIF(i.[cInitialCondition], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cInitialCondition], '''') IS NULL AND NULLIF(d.[cInitialCondition], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cInterval] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                568,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cInterval], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cInterval], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cInterval], '''') <> NULLIF(i.[cInterval], '''') ) OR
                ( NULLIF(d.[cInterval], '''') IS NULL AND NULLIF(i.[cInterval], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cInterval], '''') IS NULL AND NULLIF(d.[cInterval], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cIntervalUOM] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                569,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cIntervalUOM], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cIntervalUOM], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cIntervalUOM], '''') <> NULLIF(i.[cIntervalUOM], '''') ) OR
                ( NULLIF(d.[cIntervalUOM], '''') IS NULL AND NULLIF(i.[cIntervalUOM], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cIntervalUOM], '''') IS NULL AND NULLIF(d.[cIntervalUOM], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cLocation] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                570,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cLocation], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cLocation], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cLocation], '''') <> NULLIF(i.[cLocation], '''') ) OR
                ( NULLIF(d.[cLocation], '''') IS NULL AND NULLIF(i.[cLocation], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cLocation], '''') IS NULL AND NULLIF(d.[cLocation], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cPressure] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                571,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cPressure], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cPressure], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cPressure], '''') <> NULLIF(i.[cPressure], '''') ) OR
                ( NULLIF(d.[cPressure], '''') IS NULL AND NULLIF(i.[cPressure], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cPressure], '''') IS NULL AND NULLIF(d.[cPressure], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cPressureUOM] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                572,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cPressureUOM], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cPressureUOM], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cPressureUOM], '''') <> NULLIF(i.[cPressureUOM], '''') ) OR
                ( NULLIF(d.[cPressureUOM], '''') IS NULL AND NULLIF(i.[cPressureUOM], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cPressureUOM], '''') IS NULL AND NULLIF(d.[cPressureUOM], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cReturnedTo] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                3075,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cReturnedTo], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cReturnedTo], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cReturnedTo], '''') <> NULLIF(i.[cReturnedTo], '''') ) OR
                ( NULLIF(d.[cReturnedTo], '''') IS NULL AND NULLIF(i.[cReturnedTo], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cReturnedTo], '''') IS NULL AND NULLIF(d.[cReturnedTo], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cServiceReason] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                573,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cServiceReason], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cServiceReason], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cServiceReason], '''') <> NULLIF(i.[cServiceReason], '''') ) OR
                ( NULLIF(d.[cServiceReason], '''') IS NULL AND NULLIF(i.[cServiceReason], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cServiceReason], '''') IS NULL AND NULLIF(d.[cServiceReason], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cStickerType] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                574,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cStickerType], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cStickerType], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cStickerType], '''') <> NULLIF(i.[cStickerType], '''') ) OR
                ( NULLIF(d.[cStickerType], '''') IS NULL AND NULLIF(i.[cStickerType], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cStickerType], '''') IS NULL AND NULLIF(d.[cStickerType], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cTemperature] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                575,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cTemperature], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cTemperature], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cTemperature], '''') <> NULLIF(i.[cTemperature], '''') ) OR
                ( NULLIF(d.[cTemperature], '''') IS NULL AND NULLIF(i.[cTemperature], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cTemperature], '''') IS NULL AND NULLIF(d.[cTemperature], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cTemperatureUOM] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                576,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cTemperatureUOM], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cTemperatureUOM], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cTemperatureUOM], '''') <> NULLIF(i.[cTemperatureUOM], '''') ) OR
                ( NULLIF(d.[cTemperatureUOM], '''') IS NULL AND NULLIF(i.[cTemperatureUOM], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cTemperatureUOM], '''') IS NULL AND NULLIF(d.[cTemperatureUOM], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cWorkOrderResults] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                577,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cWorkOrderResults], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cWorkOrderResults], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cWorkOrderResults], '''') <> NULLIF(i.[cWorkOrderResults], '''') ) OR
                ( NULLIF(d.[cWorkOrderResults], '''') IS NULL AND NULLIF(i.[cWorkOrderResults], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cWorkOrderResults], '''') IS NULL AND NULLIF(d.[cWorkOrderResults], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                578,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                579,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                580,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lCancelled] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                581,
                0,
                CONVERT(NVARCHAR, d.[lCancelled]),
                CONVERT(NVARCHAR, i.[lCancelled])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lCancelled] <> i.[lCancelled] ) OR
                ( d.[lCancelled] IS NULL AND i.[lCancelled] IS NOT NULL ) OR
                ( i.[lCancelled] IS NULL AND d.[lCancelled] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lClosed] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                582,
                0,
                CONVERT(NVARCHAR, d.[lClosed]),
                CONVERT(NVARCHAR, i.[lClosed])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lClosed] <> i.[lClosed] ) OR
                ( d.[lClosed] IS NULL AND i.[lClosed] IS NOT NULL ) OR
                ( i.[lClosed] IS NULL AND d.[lClosed] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDelayed] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                583,
                0,
                CONVERT(NVARCHAR, d.[lDelayed]),
                CONVERT(NVARCHAR, i.[lDelayed])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lDelayed] <> i.[lDelayed] ) OR
                ( d.[lDelayed] IS NULL AND i.[lDelayed] IS NOT NULL ) OR
                ( i.[lDelayed] IS NULL AND d.[lDelayed] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                584,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lExpedite] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                585,
                0,
                CONVERT(NVARCHAR, d.[lExpedite]),
                CONVERT(NVARCHAR, i.[lExpedite])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lExpedite] <> i.[lExpedite] ) OR
                ( d.[lExpedite] IS NULL AND i.[lExpedite] IS NOT NULL ) OR
                ( i.[lExpedite] IS NULL AND d.[lExpedite] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lISOCert] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                586,
                0,
                CONVERT(NVARCHAR, d.[lISOCert]),
                CONVERT(NVARCHAR, i.[lISOCert])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lISOCert] <> i.[lISOCert] ) OR
                ( d.[lISOCert] IS NULL AND i.[lISOCert] IS NOT NULL ) OR
                ( i.[lISOCert] IS NULL AND d.[lISOCert] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lOnSite] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                587,
                0,
                CONVERT(NVARCHAR, d.[lOnSite]),
                CONVERT(NVARCHAR, i.[lOnSite])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lOnSite] <> i.[lOnSite] ) OR
                ( d.[lOnSite] IS NULL AND i.[lOnSite] IS NOT NULL ) OR
                ( i.[lOnSite] IS NULL AND d.[lOnSite] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lOOT] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                588,
                0,
                CONVERT(NVARCHAR, d.[lOOT]),
                CONVERT(NVARCHAR, i.[lOOT])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lOOT] <> i.[lOOT] ) OR
                ( d.[lOOT] IS NULL AND i.[lOOT] IS NOT NULL ) OR
                ( i.[lOOT] IS NULL AND d.[lOOT] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lOptional1] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                3072,
                0,
                CONVERT(NVARCHAR, d.[lOptional1]),
                CONVERT(NVARCHAR, i.[lOptional1])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lOptional1] <> i.[lOptional1] ) OR
                ( d.[lOptional1] IS NULL AND i.[lOptional1] IS NOT NULL ) OR
                ( i.[lOptional1] IS NULL AND d.[lOptional1] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lOptional2] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                3073,
                0,
                CONVERT(NVARCHAR, d.[lOptional2]),
                CONVERT(NVARCHAR, i.[lOptional2])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lOptional2] <> i.[lOptional2] ) OR
                ( d.[lOptional2] IS NULL AND i.[lOptional2] IS NOT NULL ) OR
                ( i.[lOptional2] IS NULL AND d.[lOptional2] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lReturnNoMaint] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                589,
                0,
                CONVERT(NVARCHAR, d.[lReturnNoMaint]),
                CONVERT(NVARCHAR, i.[lReturnNoMaint])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lReturnNoMaint] <> i.[lReturnNoMaint] ) OR
                ( d.[lReturnNoMaint] IS NULL AND i.[lReturnNoMaint] IS NOT NULL ) OR
                ( i.[lReturnNoMaint] IS NULL AND d.[lReturnNoMaint] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lSubContracted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                590,
                0,
                CONVERT(NVARCHAR, d.[lSubContracted]),
                CONVERT(NVARCHAR, i.[lSubContracted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lSubContracted] <> i.[lSubContracted] ) OR
                ( d.[lSubContracted] IS NULL AND i.[lSubContracted] IS NOT NULL ) OR
                ( i.[lSubContracted] IS NULL AND d.[lSubContracted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mAccuracyNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                591,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mAccuracyNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mAccuracyNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[mAccuracyNotes], '''') <> NULLIF(i.[mAccuracyNotes], '''') ) OR
                ( NULLIF(d.[mAccuracyNotes], '''') IS NULL AND NULLIF(i.[mAccuracyNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mAccuracyNotes], '''') IS NULL AND NULLIF(d.[mAccuracyNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mCallSheetNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                592,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mCallSheetNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mCallSheetNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[mCallSheetNotes], '''') <> NULLIF(i.[mCallSheetNotes], '''') ) OR
                ( NULLIF(d.[mCallSheetNotes], '''') IS NULL AND NULLIF(i.[mCallSheetNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mCallSheetNotes], '''') IS NULL AND NULLIF(d.[mCallSheetNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mOOTNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                593,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mOOTNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mOOTNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[mOOTNotes], '''') <> NULLIF(i.[mOOTNotes], '''') ) OR
                ( NULLIF(d.[mOOTNotes], '''') IS NULL AND NULLIF(i.[mOOTNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mOOTNotes], '''') IS NULL AND NULLIF(d.[mOOTNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mStickerNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                594,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mStickerNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mStickerNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[mStickerNotes], '''') <> NULLIF(i.[mStickerNotes], '''') ) OR
                ( NULLIF(d.[mStickerNotes], '''') IS NULL AND NULLIF(i.[mStickerNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mStickerNotes], '''') IS NULL AND NULLIF(d.[mStickerNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mSubContractorNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                595,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mSubContractorNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mSubContractorNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[mSubContractorNotes], '''') <> NULLIF(i.[mSubContractorNotes], '''') ) OR
                ( NULLIF(d.[mSubContractorNotes], '''') IS NULL AND NULLIF(i.[mSubContractorNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mSubContractorNotes], '''') IS NULL AND NULLIF(d.[mSubContractorNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mUncertaintyNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                596,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mUncertaintyNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mUncertaintyNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[mUncertaintyNotes], '''') <> NULLIF(i.[mUncertaintyNotes], '''') ) OR
                ( NULLIF(d.[mUncertaintyNotes], '''') IS NULL AND NULLIF(i.[mUncertaintyNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mUncertaintyNotes], '''') IS NULL AND NULLIF(d.[mUncertaintyNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                597,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                598,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAllocated] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                599,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nAllocated], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nAllocated], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nAllocated] <> i.[nAllocated] ) OR
                ( d.[nAllocated] IS NULL AND i.[nAllocated] IS NOT NULL ) OR
                ( i.[nAllocated] IS NULL AND d.[nAllocated] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAllocatedParts] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                600,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nAllocatedParts], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nAllocatedParts], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nAllocatedParts] <> i.[nAllocatedParts] ) OR
                ( d.[nAllocatedParts] IS NULL AND i.[nAllocatedParts] IS NOT NULL ) OR
                ( i.[nAllocatedParts] IS NULL AND d.[nAllocatedParts] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAssetUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                601,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAssetUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAssetUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nAssetUID] <> i.[nAssetUID] ) OR
                ( d.[nAssetUID] IS NULL AND i.[nAssetUID] IS NOT NULL ) OR
                ( i.[nAssetUID] IS NULL AND d.[nAssetUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAssignedTechUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                602,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAssignedTechUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAssignedTechUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nAssignedTechUID] <> i.[nAssignedTechUID] ) OR
                ( d.[nAssignedTechUID] IS NULL AND i.[nAssignedTechUID] IS NOT NULL ) OR
                ( i.[nAssignedTechUID] IS NULL AND d.[nAssignedTechUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCalendarUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                603,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCalendarUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCalendarUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nCalendarUID] <> i.[nCalendarUID] ) OR
                ( d.[nCalendarUID] IS NULL AND i.[nCalendarUID] IS NOT NULL ) OR
                ( i.[nCalendarUID] IS NULL AND d.[nCalendarUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCallSheetAttributeUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                604,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCallSheetAttributeUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCallSheetAttributeUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nCallSheetAttributeUID] <> i.[nCallSheetAttributeUID] ) OR
                ( d.[nCallSheetAttributeUID] IS NULL AND i.[nCallSheetAttributeUID] IS NOT NULL ) OR
                ( i.[nCallSheetAttributeUID] IS NULL AND d.[nCallSheetAttributeUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCallSheetUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                605,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCallSheetUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCallSheetUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nCallSheetUID] <> i.[nCallSheetUID] ) OR
                ( d.[nCallSheetUID] IS NULL AND i.[nCallSheetUID] IS NOT NULL ) OR
                ( i.[nCallSheetUID] IS NULL AND d.[nCallSheetUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nCategoryUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                606,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCategoryUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCategoryUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nCategoryUID] <> i.[nCategoryUID] ) OR
                ( d.[nCategoryUID] IS NULL AND i.[nCategoryUID] IS NOT NULL ) OR
                ( i.[nCategoryUID] IS NULL AND d.[nCategoryUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCost] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                607,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nCost], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nCost], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nCost] <> i.[nCost] ) OR
                ( d.[nCost] IS NULL AND i.[nCost] IS NOT NULL ) OR
                ( i.[nCost] IS NULL AND d.[nCost] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nDepartmentUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                608,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nDepartmentUID]),
                CONVERT(NVARCHAR( 36 ), i.[nDepartmentUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nDepartmentUID] <> i.[nDepartmentUID] ) OR
                ( d.[nDepartmentUID] IS NULL AND i.[nDepartmentUID] IS NOT NULL ) OR
                ( i.[nDepartmentUID] IS NULL AND d.[nDepartmentUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                609,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nFacilityUID] <> i.[nFacilityUID] ) OR
                ( d.[nFacilityUID] IS NULL AND i.[nFacilityUID] IS NOT NULL ) OR
                ( i.[nFacilityUID] IS NULL AND d.[nFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nGroupUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                610,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nGroupUID]),
                CONVERT(NVARCHAR( 36 ), i.[nGroupUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nGroupUID] <> i.[nGroupUID] ) OR
                ( d.[nGroupUID] IS NULL AND i.[nGroupUID] IS NOT NULL ) OR
                ( i.[nGroupUID] IS NULL AND d.[nGroupUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nInvoiceUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                612,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nInvoiceUID]),
                CONVERT(NVARCHAR( 36 ), i.[nInvoiceUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nInvoiceUID] <> i.[nInvoiceUID] ) OR
                ( d.[nInvoiceUID] IS NULL AND i.[nInvoiceUID] IS NOT NULL ) OR
                ( i.[nInvoiceUID] IS NULL AND d.[nInvoiceUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nJobNumberUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                613,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nJobNumberUID]),
                CONVERT(NVARCHAR( 36 ), i.[nJobNumberUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nJobNumberUID] <> i.[nJobNumberUID] ) OR
                ( d.[nJobNumberUID] IS NULL AND i.[nJobNumberUID] IS NOT NULL ) OR
                ( i.[nJobNumberUID] IS NULL AND d.[nJobNumberUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nOwningLabUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                614,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nOwningLabUID]),
                CONVERT(NVARCHAR( 36 ), i.[nOwningLabUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nOwningLabUID] <> i.[nOwningLabUID] ) OR
                ( d.[nOwningLabUID] IS NULL AND i.[nOwningLabUID] IS NOT NULL ) OR
                ( i.[nOwningLabUID] IS NULL AND d.[nOwningLabUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nPriority] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                615,
                0,
                CONVERT(NVARCHAR, d.[nPriority]),
                CONVERT(NVARCHAR, i.[nPriority])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nPriority] <> i.[nPriority] ) OR
                ( d.[nPriority] IS NULL AND i.[nPriority] IS NOT NULL ) OR
                ( i.[nPriority] IS NULL AND d.[nPriority] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nProcedureUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                616,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nProcedureUID]),
                CONVERT(NVARCHAR( 36 ), i.[nProcedureUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nProcedureUID] <> i.[nProcedureUID] ) OR
                ( d.[nProcedureUID] IS NULL AND i.[nProcedureUID] IS NOT NULL ) OR
                ( i.[nProcedureUID] IS NULL AND d.[nProcedureUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nQCApprovedByUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                617,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nQCApprovedByUID]),
                CONVERT(NVARCHAR( 36 ), i.[nQCApprovedByUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nQCApprovedByUID] <> i.[nQCApprovedByUID] ) OR
                ( d.[nQCApprovedByUID] IS NULL AND i.[nQCApprovedByUID] IS NOT NULL ) OR
                ( i.[nQCApprovedByUID] IS NULL AND d.[nQCApprovedByUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nQuantity] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                618,
                0,
                CONVERT(NVARCHAR, d.[nQuantity]),
                CONVERT(NVARCHAR, i.[nQuantity])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nQuantity] <> i.[nQuantity] ) OR
                ( d.[nQuantity] IS NULL AND i.[nQuantity] IS NOT NULL ) OR
                ( i.[nQuantity] IS NULL AND d.[nQuantity] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nReturnedByUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                619,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nReturnedByUID]),
                CONVERT(NVARCHAR( 36 ), i.[nReturnedByUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nReturnedByUID] <> i.[nReturnedByUID] ) OR
                ( d.[nReturnedByUID] IS NULL AND i.[nReturnedByUID] IS NOT NULL ) OR
                ( i.[nReturnedByUID] IS NULL AND d.[nReturnedByUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nRevision] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                620,
                0,
                CONVERT(NVARCHAR, d.[nRevision]),
                CONVERT(NVARCHAR, i.[nRevision])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nRevision] <> i.[nRevision] ) OR
                ( d.[nRevision] IS NULL AND i.[nRevision] IS NOT NULL ) OR
                ( i.[nRevision] IS NULL AND d.[nRevision] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nSubCategoryUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                621,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nSubCategoryUID]),
                CONVERT(NVARCHAR( 36 ), i.[nSubCategoryUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nSubCategoryUID] <> i.[nSubCategoryUID] ) OR
                ( d.[nSubCategoryUID] IS NULL AND i.[nSubCategoryUID] IS NOT NULL ) OR
                ( i.[nSubCategoryUID] IS NULL AND d.[nSubCategoryUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nSubContCost] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                622,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nSubContCost], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nSubContCost], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nSubContCost] <> i.[nSubContCost] ) OR
                ( d.[nSubContCost] IS NULL AND i.[nSubContCost] IS NOT NULL ) OR
                ( i.[nSubContCost] IS NULL AND d.[nSubContCost] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nSubContHours] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                623,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nSubContHours], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nSubContHours], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nSubContHours] <> i.[nSubContHours] ) OR
                ( d.[nSubContHours] IS NULL AND i.[nSubContHours] IS NOT NULL ) OR
                ( i.[nSubContHours] IS NULL AND d.[nSubContHours] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nSubContLabCost] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                624,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nSubContLabCost], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nSubContLabCost], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nSubContLabCost] <> i.[nSubContLabCost] ) OR
                ( d.[nSubContLabCost] IS NULL AND i.[nSubContLabCost] IS NOT NULL ) OR
                ( i.[nSubContLabCost] IS NULL AND d.[nSubContLabCost] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nSubContractorUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                625,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nSubContractorUID]),
                CONVERT(NVARCHAR( 36 ), i.[nSubContractorUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nSubContractorUID] <> i.[nSubContractorUID] ) OR
                ( d.[nSubContractorUID] IS NULL AND i.[nSubContractorUID] IS NOT NULL ) OR
                ( i.[nSubContractorUID] IS NULL AND d.[nSubContractorUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nTechnicianPriority] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                626,
                0,
                CONVERT(NVARCHAR, d.[nTechnicianPriority]),
                CONVERT(NVARCHAR, i.[nTechnicianPriority])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nTechnicianPriority] <> i.[nTechnicianPriority] ) OR
                ( d.[nTechnicianPriority] IS NULL AND i.[nTechnicianPriority] IS NOT NULL ) OR
                ( i.[nTechnicianPriority] IS NULL AND d.[nTechnicianPriority] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nTechnicianUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                627,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nTechnicianUID]),
                CONVERT(NVARCHAR( 36 ), i.[nTechnicianUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nTechnicianUID] <> i.[nTechnicianUID] ) OR
                ( d.[nTechnicianUID] IS NULL AND i.[nTechnicianUID] IS NOT NULL ) OR
                ( i.[nTechnicianUID] IS NULL AND d.[nTechnicianUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nTypeProcedureDefaultUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                628,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nTypeProcedureDefaultUID]),
                CONVERT(NVARCHAR( 36 ), i.[nTypeProcedureDefaultUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nTypeProcedureDefaultUID] <> i.[nTypeProcedureDefaultUID] ) OR
                ( d.[nTypeProcedureDefaultUID] IS NULL AND i.[nTypeProcedureDefaultUID] IS NOT NULL ) OR
                ( i.[nTypeProcedureDefaultUID] IS NULL AND d.[nTypeProcedureDefaultUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nTypeUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                629,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nTypeUID]),
                CONVERT(NVARCHAR( 36 ), i.[nTypeUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nTypeUID] <> i.[nTypeUID] ) OR
                ( d.[nTypeUID] IS NULL AND i.[nTypeUID] IS NOT NULL ) OR
                ( i.[nTypeUID] IS NULL AND d.[nTypeUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nWorkingFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                632,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nWorkingFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nWorkingFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nWorkingFacilityUID] <> i.[nWorkingFacilityUID] ) OR
                ( d.[nWorkingFacilityUID] IS NULL AND i.[nWorkingFacilityUID] IS NOT NULL ) OR
                ( i.[nWorkingFacilityUID] IS NULL AND d.[nWorkingFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                633,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tClosedDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                634,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tClosedDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tClosedDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[tClosedDate] <> i.[tClosedDate] ) OR
                ( d.[tClosedDate] IS NULL AND i.[tClosedDate] IS NOT NULL ) OR
                ( i.[tClosedDate] IS NULL AND d.[tClosedDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tDelayDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                635,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tDelayDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tDelayDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[tDelayDate] <> i.[tDelayDate] ) OR
                ( d.[tDelayDate] IS NULL AND i.[tDelayDate] IS NOT NULL ) OR
                ( i.[tDelayDate] IS NULL AND d.[tDelayDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tMaintDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                636,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tMaintDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tMaintDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[tMaintDate] <> i.[tMaintDate] ) OR
                ( d.[tMaintDate] IS NULL AND i.[tMaintDate] IS NOT NULL ) OR
                ( i.[tMaintDate] IS NULL AND d.[tMaintDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tMaintNextDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                637,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tMaintNextDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tMaintNextDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[tMaintNextDate] <> i.[tMaintNextDate] ) OR
                ( d.[tMaintNextDate] IS NULL AND i.[tMaintNextDate] IS NOT NULL ) OR
                ( i.[tMaintNextDate] IS NULL AND d.[tMaintNextDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tOpenDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                639,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tOpenDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tOpenDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[tOpenDate] <> i.[tOpenDate] ) OR
                ( d.[tOpenDate] IS NULL AND i.[tOpenDate] IS NOT NULL ) OR
                ( i.[tOpenDate] IS NULL AND d.[tOpenDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tQCApprovedDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                640,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tQCApprovedDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tQCApprovedDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[tQCApprovedDate] <> i.[tQCApprovedDate] ) OR
                ( d.[tQCApprovedDate] IS NULL AND i.[tQCApprovedDate] IS NOT NULL ) OR
                ( i.[tQCApprovedDate] IS NULL AND d.[tQCApprovedDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tRequiredDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                641,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tRequiredDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tRequiredDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[tRequiredDate] <> i.[tRequiredDate] ) OR
                ( d.[tRequiredDate] IS NULL AND i.[tRequiredDate] IS NOT NULL ) OR
                ( i.[tRequiredDate] IS NULL AND d.[tRequiredDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tReturnedDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                642,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tReturnedDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tReturnedDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[tReturnedDate] <> i.[tReturnedDate] ) OR
                ( d.[tReturnedDate] IS NULL AND i.[tReturnedDate] IS NOT NULL ) OR
                ( i.[tReturnedDate] IS NULL AND d.[tReturnedDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN
        
            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED
        
            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 20, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID
        END
    END
END
'

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_CallSheets_Upd]', 'last', 'update', null

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	    END



		PRINT N'Adding foreign keys to [dbo].[CallSheets]'


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_Assets] FOREIGN KEY ([nAssetUID]) REFERENCES [dbo].[Assets] ([nAssetUID])


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Calendar]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_Calendar] FOREIGN KEY ([nCalendarUID]) REFERENCES [dbo].[Calendar] ([nCalendarUID])


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_CallSheetAttributes]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_CallSheetAttributes] FOREIGN KEY ([nCallSheetAttributeUID]) REFERENCES [dbo].[CallSheetAttributes] ([nCallSheetAttributeUID])


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Category]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_Category] FOREIGN KEY ([nCategoryUID]) REFERENCES [dbo].[Category] ([nCategoryUID])


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Facilities]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_Facilities] FOREIGN KEY ([nFacilityUID]) REFERENCES [dbo].[Facilities] ([nFacilityUID])


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Facilities_nOwningLabUID]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_Facilities_nOwningLabUID] FOREIGN KEY ([nOwningLabUID]) REFERENCES [dbo].[Facilities] ([nFacilityUID])


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_FacilitiesDepartment]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_FacilitiesDepartment] FOREIGN KEY ([nDepartmentUID]) REFERENCES [dbo].[Facilities] ([nFacilityUID])


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_FacilitiesSubContractor]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_FacilitiesSubContractor] FOREIGN KEY ([nSubContractorUID]) REFERENCES [dbo].[Facilities] ([nFacilityUID])


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_FacilitiesWorkingFacility]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_FacilitiesWorkingFacility] FOREIGN KEY ([nWorkingFacilityUID]) REFERENCES [dbo].[Facilities] ([nFacilityUID])


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Invoices]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_Invoices] FOREIGN KEY ([nInvoiceUID]) REFERENCES [dbo].[Invoices] ([nInvoiceUID])


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_JobNumbers]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_JobNumbers] FOREIGN KEY ([nJobNumberUID]) REFERENCES [dbo].[JobNumbers] ([nJobNumberUID])


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Procedures]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_Procedures] FOREIGN KEY ([nProcedureUID]) REFERENCES [dbo].[Procedures] ([nProcedureUID])


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_SubCategory]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_SubCategory] FOREIGN KEY ([nSubCategoryUID]) REFERENCES [dbo].[SubCategory] ([nSubCategoryUID])


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_TypeProcedureDefaults]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_TypeProcedureDefaults] FOREIGN KEY ([nTypeProcedureDefaultUID]) REFERENCES [dbo].[TypeProcedureDefaults] ([nTypeProcedureDefaultUID])


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Types]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_Types] FOREIGN KEY ([nTypeUID]) REFERENCES [dbo].[Types] ([nTypeUID])


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Users]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_Users] FOREIGN KEY ([nTechnicianUID]) REFERENCES [dbo].[Users] ([nUserUID])


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_UsersAssignedTech]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_UsersAssignedTech] FOREIGN KEY ([nAssignedTechUID]) REFERENCES [dbo].[Users] ([nUserUID])


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_UsersQCApprovedBy]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_UsersQCApprovedBy] FOREIGN KEY ([nQCApprovedByUID]) REFERENCES [dbo].[Users] ([nUserUID])


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_UsersReturnedBy]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_UsersReturnedBy] FOREIGN KEY ([nReturnedByUID]) REFERENCES [dbo].[Users] ([nUserUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Adding foreign keys to [dbo].[CallSheetAccreditationLink]'


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetAccreditationLink_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetAccreditationLink]', 'U'))
		ALTER TABLE [dbo].[CallSheetAccreditationLink] ADD CONSTRAINT [FK_CallSheetAccreditationLink_CallSheets] FOREIGN KEY ([nCallSheetUID]) REFERENCES [dbo].[CallSheets] ([nCallSheetUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Adding foreign keys to [dbo].[CallSheetEx]'


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetEx_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetEx]', 'U'))
		ALTER TABLE [dbo].[CallSheetEx] ADD CONSTRAINT [FK_CallSheetEx_CallSheets] FOREIGN KEY ([nCallSheetUID]) REFERENCES [dbo].[CallSheets] ([nCallSheetUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Adding foreign keys to [dbo].[CallSheetFiles]'


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetFiles_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetFiles]', 'U'))
		ALTER TABLE [dbo].[CallSheetFiles] ADD CONSTRAINT [FK_CallSheetFiles_CallSheets] FOREIGN KEY ([nCallSheetUID]) REFERENCES [dbo].[CallSheets] ([nCallSheetUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Adding foreign keys to [dbo].[CallSheetLog]'


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetLog_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetLog]', 'U'))
		ALTER TABLE [dbo].[CallSheetLog] ADD CONSTRAINT [FK_CallSheetLog_CallSheets] FOREIGN KEY ([nCallSheetUID]) REFERENCES [dbo].[CallSheets] ([nCallSheetUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Adding foreign keys to [dbo].[CallSheetPartsLink]'


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetPartsLink_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetPartsLink]', 'U'))
		ALTER TABLE [dbo].[CallSheetPartsLink] ADD CONSTRAINT [FK_CallSheetPartsLink_CallSheets] FOREIGN KEY ([nCallSheetUID]) REFERENCES [dbo].[CallSheets] ([nCallSheetUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Adding foreign keys to [dbo].[CallSheetReadings]'


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetReadings_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetReadings]', 'U'))
		ALTER TABLE [dbo].[CallSheetReadings] ADD CONSTRAINT [FK_CallSheetReadings_CallSheets] FOREIGN KEY ([nCallSheetUID]) REFERENCES [dbo].[CallSheets] ([nCallSheetUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Adding foreign keys to [dbo].[CallSheetResults]'


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetResults_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetResults]', 'U'))
		ALTER TABLE [dbo].[CallSheetResults] ADD CONSTRAINT [FK_CallSheetResults_CallSheets] FOREIGN KEY ([nCallSheetUID]) REFERENCES [dbo].[CallSheets] ([nCallSheetUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Adding foreign keys to [dbo].[CallSheetStandardLink]'


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetStandardLink_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetStandardLink]', 'U'))
		ALTER TABLE [dbo].[CallSheetStandardLink] ADD CONSTRAINT [FK_CallSheetStandardLink_CallSheets] FOREIGN KEY ([nCallSheetUID]) REFERENCES [dbo].[CallSheets] ([nCallSheetUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Adding foreign keys to [dbo].[Estimates]'


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Estimates_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Estimates]', 'U'))
		ALTER TABLE [dbo].[Estimates] ADD CONSTRAINT [FK_Estimates_CallSheets] FOREIGN KEY ([nCallSheetUID]) REFERENCES [dbo].[CallSheets] ([nCallSheetUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Adding foreign keys to [dbo].[InvoiceItemDetails]'


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_InvoiceItemDetails_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[InvoiceItemDetails]', 'U'))
		ALTER TABLE [dbo].[InvoiceItemDetails] ADD CONSTRAINT [FK_InvoiceItemDetails_CallSheets] FOREIGN KEY ([nCallSheetUID]) REFERENCES [dbo].[CallSheets] ([nCallSheetUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Adding foreign keys to [dbo].[InvoiceItems]'


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_InvoiceItems_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[InvoiceItems]', 'U'))
		ALTER TABLE [dbo].[InvoiceItems] ADD CONSTRAINT [FK_InvoiceItems_CallSheets] FOREIGN KEY ([nCallSheetUID]) REFERENCES [dbo].[CallSheets] ([nCallSheetUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Adding foreign keys to [dbo].[Labor]'


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Labor_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Labor]', 'U'))
		ALTER TABLE [dbo].[Labor] ADD CONSTRAINT [FK_Labor_CallSheets] FOREIGN KEY ([nCallSheetUID]) REFERENCES [dbo].[CallSheets] ([nCallSheetUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Adding foreign keys to [dbo].[ProblemReports]'


		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ProblemReports_CallSheets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ProblemReports]', 'U'))
		ALTER TABLE [dbo].[ProblemReports] ADD CONSTRAINT [FK_ProblemReports_CallSheets] FOREIGN KEY ([nCallSheetUID]) REFERENCES [dbo].[CallSheets] ([nCallSheetUID])


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Creating extended properties'


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', NULL, NULL))
		EXEC sp_addextendedproperty N'MS_Description', N'Contains all the work order information', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', NULL, NULL


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cArea'))
		EXEC sp_addextendedproperty N'MS_Description', N'The area of the lab scheduled to perform work', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cArea'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cCallSheetNumber'))
		EXEC sp_addextendedproperty N'MS_Description', N'Incrementing number for this call sheet', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cCallSheetNumber'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cCallSheetStatus'))
		EXEC sp_addextendedproperty N'MS_Description', N'Status of the maintenance', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cCallSheetStatus'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cCallSheetType'))
		EXEC sp_addextendedproperty N'MS_Description', N'Call Sheet Type ', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cCallSheetType'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cCertFormat'))
		EXEC sp_addextendedproperty N'MS_Description', N'Custom Cert format if any', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cCertFormat'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cCertificationNumber'))
		EXEC sp_addextendedproperty N'MS_Description', N'Cert number for maintenance', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cCertificationNumber'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cContactInfo'))
		EXEC sp_addextendedproperty N'MS_Description', N'Information stored for contacting someone with questions', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cContactInfo'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cHumidity'))
		EXEC sp_addextendedproperty N'MS_Description', N'Humidity recorded during maintenance', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cHumidity'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cHumidityUOM'))
		EXEC sp_addextendedproperty N'MS_Description', N'Unit of measure for the humidity', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cHumidityUOM'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cInitialCondition'))
		EXEC sp_addextendedproperty N'MS_Description', N'The Initial Condition of the Asset', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cInitialCondition'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cInterval'))
		EXEC sp_addextendedproperty N'MS_Description', N'Interval of maintenance', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cInterval'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cIntervalUOM'))
		EXEC sp_addextendedproperty N'MS_Description', N'Unit of measure for the interval', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cIntervalUOM'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cLocation'))
		EXEC sp_addextendedproperty N'MS_Description', N'Location for call sheet', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cLocation'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cPressure'))
		EXEC sp_addextendedproperty N'MS_Description', N'Pressure recorded during maintenance', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cPressure'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cPressureUOM'))
		EXEC sp_addextendedproperty N'MS_Description', N'Unit of measure for the pressure', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cPressureUOM'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cReturnedTo'))
		EXEC sp_addextendedproperty N'MS_Description', N'The person the asset was returned to', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cReturnedTo'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cServiceReason'))
		EXEC sp_addextendedproperty N'MS_Description', N'The Reason for Service of the Asset', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cServiceReason'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cStickerType'))
		EXEC sp_addextendedproperty N'MS_Description', N'Sticker Type --ties to notes', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cStickerType'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cTemperature'))
		EXEC sp_addextendedproperty N'MS_Description', N'Temperature recorded during maintenance', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cTemperature'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cTemperatureUOM'))
		EXEC sp_addextendedproperty N'MS_Description', N'Unit of measure for the temperature', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cTemperatureUOM'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cWorkOrderResults'))
		EXEC sp_addextendedproperty N'MS_Description', N'The overall Pass / Fail Result of the work order', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'cWorkOrderResults'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lActive'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=inactive; -1 or 1=active', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lActive'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lAdded'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not added; -1 or 1=added', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lAdded'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lApproved'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not approved; -1 or 1=approved', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lApproved'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lCancelled'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates if the call sheet has been cancelled', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lCancelled'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lClosed'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates if the call sheet has been closed', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lClosed'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lDelayed'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates of the call sheet has been delayed (often used as rejected indicator)', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lDelayed'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lDeleted'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not deleted; -1 or 1=deleted', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lDeleted'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lExpedite'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates if customer needs this event expidited', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lExpedite'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lISOCert'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates if accredited calibration was performed', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lISOCert'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lOnSite'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates if the maintenance must be performed onsite', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lOnSite'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lOOT'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates if the asset was Out Of Tolerance', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lOOT'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lOptional1'))
		EXEC sp_addextendedproperty N'MS_Description', N'Customizable indicator flag', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lOptional1'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lOptional2'))
		EXEC sp_addextendedproperty N'MS_Description', N'Customizable indicator flag', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lOptional2'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lReturnNoMaint'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates if the asset has been returned without any maintenance', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lReturnNoMaint'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lSubContracted'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates if the maintenance has been subcontracted', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'lSubContracted'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mAccuracyNotes'))
		EXEC sp_addextendedproperty N'MS_Description', N'Notes about the accuracy ', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mAccuracyNotes'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mCallSheetNotes'))
		EXEC sp_addextendedproperty N'MS_Description', N'Call sheet notes', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mCallSheetNotes'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mOOTNotes'))
		EXEC sp_addextendedproperty N'MS_Description', N'Notes for Out of Tolerance', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mOOTNotes'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mStickerNotes'))
		EXEC sp_addextendedproperty N'MS_Description', N'Notes for sticker', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mStickerNotes'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mSubContractorNotes'))
		EXEC sp_addextendedproperty N'MS_Description', N'Notes about the Subcontractor', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mSubContractorNotes'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mUncertaintyNotes'))
		EXEC sp_addextendedproperty N'MS_Description', N'Notes about uncertainty', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'mUncertaintyNotes'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAddFacilityUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the server that added the record', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAddFacilityUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAddUserUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the user that added the record', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAddUserUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAllocated'))
		EXEC sp_addextendedproperty N'MS_Description', N'Amount of allocated labor', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAllocated'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAllocatedParts'))
		EXEC sp_addextendedproperty N'MS_Description', N'Dollar amount of allocated parts', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAllocatedParts'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAssetUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the Asset the maintenance is for', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAssetUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAssignedTechUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the technician assigned from the users table', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nAssignedTechUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nCalendarUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicated the calendar event for followup', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nCalendarUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nCallSheetAttributeUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates attributes related to the record', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nCallSheetAttributeUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nCallSheetUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Unique system identifier used by the system', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nCallSheetUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nCategoryUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the category of the maintenance', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nCategoryUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nCost'))
		EXEC sp_addextendedproperty N'MS_Description', N'Total costs for maintenance', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nCost'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nDepartmentUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the department responsible for the asset', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nDepartmentUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nFacilityUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the owner of the asset', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nFacilityUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nGroupUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'The number used to group items together during the returning process', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nGroupUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nImportUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'If imported, contains UID of the import record', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nImportUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nInvoiceUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the invoice used for the Call Sheet', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nInvoiceUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nJobNumberUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the job number charged for the maintenance', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nJobNumberUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nOwningLabUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the facility (lab) that opened the call sheet and is administratively responsible', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nOwningLabUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nPriority'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates priority of Item', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nPriority'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nProcedureUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the procudure being used to perform the maintenance', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nProcedureUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nQCApprovedByUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the person approving the record', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nQCApprovedByUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nQuantity'))
		EXEC sp_addextendedproperty N'MS_Description', N'The quantity of pieces received', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nQuantity'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nReturnedByUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the person who returned the asset', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nReturnedByUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nSubCategoryUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the sub category of the maintenance', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nSubCategoryUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nSubContCost'))
		EXEC sp_addextendedproperty N'MS_Description', N'Cost associated with using the subcontractor', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nSubContCost'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nSubContHours'))
		EXEC sp_addextendedproperty N'MS_Description', N'Hours used by the subcontractor', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nSubContHours'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nSubContLabCost'))
		EXEC sp_addextendedproperty N'MS_Description', N'Expenses paid by lab for subcontract work', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nSubContLabCost'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nSubContractorUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the subcontractor used - if needed', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nSubContractorUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nTechnicianPriority'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates Priority for Technician', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nTechnicianPriority'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nTechnicianUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the technician that performed the maintenance', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nTechnicianUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nTypeProcedureDefaultUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the Link record for interval and procedure', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nTypeProcedureDefaultUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nTypeUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Relates to the type table', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nTypeUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nUpdateFacilityUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the server that last updated the record', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nUpdateFacilityUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nUpdateUserUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the last user to update the record', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nUpdateUserUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nWorkingFacilityUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates the facility that did the work', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'nWorkingFacilityUID'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tAddTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was added', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tAddTime'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tClosedDate'))
		EXEC sp_addextendedproperty N'MS_Description', N'Date the maintenance was concluded', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tClosedDate'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tDelayDate'))
		EXEC sp_addextendedproperty N'MS_Description', N'Date it has been delayed to', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tDelayDate'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tMaintDate'))
		EXEC sp_addextendedproperty N'MS_Description', N'Date maintenance was actually done', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tMaintDate'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tMaintNextDate'))
		EXEC sp_addextendedproperty N'MS_Description', N'Date next maintenance is due', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tMaintNextDate'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tMobileTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated for Mobile mode', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tMobileTime'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tOpenDate'))
		EXEC sp_addextendedproperty N'MS_Description', N'Date the call sheet was created', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tOpenDate'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tQCApprovedDate'))
		EXEC sp_addextendedproperty N'MS_Description', N'Date the QC approved the maintenance', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tQCApprovedDate'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tRequiredDate'))
		EXEC sp_addextendedproperty N'MS_Description', N'Date customer needs it done', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tRequiredDate'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tReturnedDate'))
		EXEC sp_addextendedproperty N'MS_Description', N'Date the asset was returned to the customer', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tReturnedDate'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tSystemUpdateTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated for the Warehouse', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tSystemUpdateTime'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tUpdateTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated', 'SCHEMA', N'dbo', 'TABLE', N'CallSheets', 'COLUMN', N'tUpdateTime'


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END


	IF OBJECT_ID(N'[dbo].[spl_CallSheets_RETRIEVE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_CallSheets_RETRIEVE]'
		DROP PROCEDURE [dbo].[spl_CallSheets_RETRIEVE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_CallSheets_RETRIEVE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_CallSheets_RETRIEVE]'

		EXEC sp_executesql N'		
/****************************************************************
	spl_CallSheets_RETRIEVE
	Retrieves a single record by ID from the CallSheets table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 9/17/2021 (R)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_CallSheets_RETRIEVE]
	
@nCallSheetUID uniqueidentifier


AS
BEGIN

	SELECT
[nCallSheetUID]
		,[nGroupUID]
		,[nAssetUID]
		,[nTypeUID]
		,[nFacilityUID]
		,[nDepartmentUID]
		,[nWorkingFacilityUID]
		,[nOwningLabUID]
		,[nCategoryUID]
		,[nSubCategoryUID]
		,[nProcedureUID]
		,[nTypeProcedureDefaultUID]
		,[nAssignedTechUID]
		,[nTechnicianUID]
		,[nQCApprovedByUID]
		,[nReturnedByUID]
		,[nSubContractorUID]
		,[nJobNumberUID]
		,[nCalendarUID]
		,[nInvoiceUID]
		,[nCallSheetAttributeUID]
		,[nSubContHours]
		,[nSubContCost]
		,[nSubContLabCost]
		,[nCost]
		,[nAllocated]
		,[nAllocatedParts]
		,[cContactInfo]
		,[cInitialCondition]
		,[cServiceReason]
		,[cCallSheetType]
		,[cStickerType]
		,[cCallSheetStatus]
		,[cCallSheetNumber]
		,[cCertificationNumber]
		,[cInterval]
		,[cIntervalUOM]
		,[cTemperature]
		,[cTemperatureUOM]
		,[cHumidity]
		,[cHumidityUOM]
		,[cPressure]
		,[cPressureUOM]
		,[cLocation]
		,[cArea]
		,[cCertFormat]
		,[cWorkOrderResults]
		,[cReturnedTo]
		,[tOpenDate]
		,[tRequiredDate]
		,[tDelayDate]
		,[tMaintDate]
		,[tMaintNextDate]
		,[tQCApprovedDate]
		,[tClosedDate]
		,[tReturnedDate]
		,[nQuantity]
		,[nPriority]
		,[nTechnicianPriority]
		,[nRevision]
		,[lExpedite]
		,[lISOCert]
		,[lOnSite]
		,[lReturnNoMaint]
		,[lSubContracted]
		,[lOOT]
		,[lClosed]
		,[lDelayed]
		,[lCancelled]
		,[lOptional1]
		,[lOptional2]
		,[mCallSheetNotes]
		,[mAccuracyNotes]
		,[mUncertaintyNotes]
		,[mSubContractorNotes]
		,[mOOTNotes]
		,[mStickerNotes]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[CallSheets]
	WHERE
[nCallSheetUID] = @nCallSheetUID

	
	RETURN
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	IF OBJECT_ID(N'[dbo].[spl_CallSheets_LIST]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_CallSheets_LIST]'
		DROP PROCEDURE [dbo].[spl_CallSheets_LIST]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_CallSheets_LIST]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_CallSheets_LIST]'

		EXEC sp_executesql N'		
/****************************************************************
	spl_CallSheets_LIST
	Retrieves all records from the CallSheets table
	Optionally includes inactive records
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 9/17/2021 (L)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_CallSheets_LIST]
	
@includeInactive	INT	= 0

AS
BEGIN

	SELECT
[nCallSheetUID]
		,[nGroupUID]
		,[nAssetUID]
		,[nTypeUID]
		,[nFacilityUID]
		,[nDepartmentUID]
		,[nWorkingFacilityUID]
		,[nOwningLabUID]
		,[nCategoryUID]
		,[nSubCategoryUID]
		,[nProcedureUID]
		,[nTypeProcedureDefaultUID]
		,[nAssignedTechUID]
		,[nTechnicianUID]
		,[nQCApprovedByUID]
		,[nReturnedByUID]
		,[nSubContractorUID]
		,[nJobNumberUID]
		,[nCalendarUID]
		,[nInvoiceUID]
		,[nCallSheetAttributeUID]
		,[nSubContHours]
		,[nSubContCost]
		,[nSubContLabCost]
		,[nCost]
		,[nAllocated]
		,[nAllocatedParts]
		,[cContactInfo]
		,[cInitialCondition]
		,[cServiceReason]
		,[cCallSheetType]
		,[cStickerType]
		,[cCallSheetStatus]
		,[cCallSheetNumber]
		,[cCertificationNumber]
		,[cInterval]
		,[cIntervalUOM]
		,[cTemperature]
		,[cTemperatureUOM]
		,[cHumidity]
		,[cHumidityUOM]
		,[cPressure]
		,[cPressureUOM]
		,[cLocation]
		,[cArea]
		,[cCertFormat]
		,[cWorkOrderResults]
		,[cReturnedTo]
		,[tOpenDate]
		,[tRequiredDate]
		,[tDelayDate]
		,[tMaintDate]
		,[tMaintNextDate]
		,[tQCApprovedDate]
		,[tClosedDate]
		,[tReturnedDate]
		,[nQuantity]
		,[nPriority]
		,[nTechnicianPriority]
		,[nRevision]
		,[lExpedite]
		,[lISOCert]
		,[lOnSite]
		,[lReturnNoMaint]
		,[lSubContracted]
		,[lOOT]
		,[lClosed]
		,[lDelayed]
		,[lCancelled]
		,[lOptional1]
		,[lOptional2]
		,[mCallSheetNotes]
		,[mAccuracyNotes]
		,[mUncertaintyNotes]
		,[mSubContractorNotes]
		,[mOOTNotes]
		,[mStickerNotes]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[CallSheets]
	WHERE
		ABS(lActive) + @includeInactive > 0
		AND
		lDeleted = 0
	
	RETURN
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_CallSheets_INSERT]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_CallSheets_INSERT]'
		DROP PROCEDURE [dbo].[spl_CallSheets_INSERT]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_CallSheets_INSERT]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_CallSheets_INSERT]'
		
		EXEC sp_executesql N'	
/****************************************************************
	spl_CallSheets_INSERT
	Inserts a new record into the CallSheets table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 9/17/2021 (I)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_CallSheets_INSERT]
	
@nGroupUID uniqueidentifier  = NULL 
	,@nAssetUID uniqueidentifier 
	,@nTypeUID uniqueidentifier 
	,@nFacilityUID uniqueidentifier 
	,@nDepartmentUID uniqueidentifier  = NULL 
	,@nWorkingFacilityUID uniqueidentifier  = NULL 
	,@nOwningLabUID uniqueidentifier  = NULL 
	,@nCategoryUID uniqueidentifier  = NULL 
	,@nSubCategoryUID uniqueidentifier  = NULL 
	,@nProcedureUID uniqueidentifier  = NULL 
	,@nTypeProcedureDefaultUID uniqueidentifier  = NULL 
	,@nAssignedTechUID uniqueidentifier  = NULL 
	,@nTechnicianUID uniqueidentifier  = NULL 
	,@nQCApprovedByUID uniqueidentifier  = NULL 
	,@nReturnedByUID uniqueidentifier  = NULL 
	,@nSubContractorUID uniqueidentifier  = NULL 
	,@nJobNumberUID uniqueidentifier  = NULL 
	,@nCalendarUID uniqueidentifier  = NULL 
	,@nInvoiceUID uniqueidentifier  = NULL 
	,@nCallSheetAttributeUID uniqueidentifier  = NULL 
	,@nSubContHours numeric(18, 2)  = 0 
	,@nSubContCost numeric(18, 2)  = 0 
	,@nSubContLabCost numeric(18, 2)  = 0 
	,@nCost numeric(18, 2)  = 0 
	,@nAllocated numeric(18, 2)  = 0 
	,@nAllocatedParts numeric(18, 2)  = 0 
	,@cContactInfo nvarchar(50)  = NULL 
	,@cInitialCondition nvarchar(50)  = NULL 
	,@cServiceReason nvarchar(50)  = NULL 
	,@cCallSheetType nvarchar(50)  = NULL 
	,@cStickerType nvarchar(50)  = NULL 
	,@cCallSheetStatus nvarchar(50)  = NULL 
	,@cCallSheetNumber nvarchar(50)  = NULL 
	,@cCertificationNumber nvarchar(50)  = NULL 
	,@cInterval nvarchar(50)  = NULL 
	,@cIntervalUOM nvarchar(50)  = NULL 
	,@cTemperature nvarchar(50)  = NULL 
	,@cTemperatureUOM nvarchar(50)  = NULL 
	,@cHumidity nvarchar(50)  = NULL 
	,@cHumidityUOM nvarchar(50)  = NULL 
	,@cPressure nvarchar(50)  = NULL 
	,@cPressureUOM nvarchar(50)  = NULL 
	,@cLocation nvarchar(50)  = NULL 
	,@cArea nvarchar(50)  = NULL 
	,@cCertFormat nvarchar(50)  = NULL 
	,@cWorkOrderResults nvarchar(50)  = NULL 
	,@cReturnedTo nvarchar(150)  = NULL 
	,@tOpenDate datetime  = NULL 
	,@tRequiredDate datetime  = NULL 
	,@tDelayDate datetime  = NULL 
	,@tMaintDate datetime  = NULL 
	,@tMaintNextDate datetime  = NULL 
	,@tQCApprovedDate datetime  = NULL 
	,@tClosedDate datetime  = NULL 
	,@tReturnedDate datetime  = NULL 
	,@nQuantity int  = NULL 
	,@nPriority int  = NULL 
	,@nTechnicianPriority int  = NULL 
	,@nRevision int  = NULL 
	,@lExpedite int  = NULL 
	,@lISOCert int  = NULL 
	,@lOnSite int  = NULL 
	,@lReturnNoMaint int  = NULL 
	,@lSubContracted int  = NULL 
	,@lOOT int  = NULL 
	,@lClosed int  = 0 
	,@lDelayed int  = 0 
	,@lCancelled int  = 0 
	,@lOptional1 int  = 0 
	,@lOptional2 int  = 0 
	,@mCallSheetNotes nvarchar(max)  = NULL 
	,@mAccuracyNotes nvarchar(max)  = NULL 
	,@mUncertaintyNotes nvarchar(max)  = NULL 
	,@mSubContractorNotes nvarchar(max)  = NULL 
	,@mOOTNotes nvarchar(max)  = NULL 
	,@mStickerNotes nvarchar(max)  = NULL 
	,@lActive int  = -1 
	,@lDeleted int  = 0 
	,@lApproved int  = 0 
	,@lAdded int  = -1 
	,@nAddFacilityUID uniqueidentifier  = ''DBA97ADF-F868-459D-8343-DE1DF0FFB398'' 
	,@nAddUserUID uniqueidentifier  = ''915F9722-3175-4E4D-A571-4A478E8E5172'' 
	,@nImportUID uniqueidentifier  = NULL 

	,@nCallSheetUID [uniqueidentifier] = NULL OUTPUT

AS
BEGIN

	DECLARE @ID [uniqueidentifier] = NEWID()

	INSERT INTO [dbo].[CallSheets] (
		[nCallSheetUID]
,[nGroupUID]
		,[nAssetUID]
		,[nTypeUID]
		,[nFacilityUID]
		,[nDepartmentUID]
		,[nWorkingFacilityUID]
		,[nOwningLabUID]
		,[nCategoryUID]
		,[nSubCategoryUID]
		,[nProcedureUID]
		,[nTypeProcedureDefaultUID]
		,[nAssignedTechUID]
		,[nTechnicianUID]
		,[nQCApprovedByUID]
		,[nReturnedByUID]
		,[nSubContractorUID]
		,[nJobNumberUID]
		,[nCalendarUID]
		,[nInvoiceUID]
		,[nCallSheetAttributeUID]
		,[nSubContHours]
		,[nSubContCost]
		,[nSubContLabCost]
		,[nCost]
		,[nAllocated]
		,[nAllocatedParts]
		,[cContactInfo]
		,[cInitialCondition]
		,[cServiceReason]
		,[cCallSheetType]
		,[cStickerType]
		,[cCallSheetStatus]
		,[cCallSheetNumber]
		,[cCertificationNumber]
		,[cInterval]
		,[cIntervalUOM]
		,[cTemperature]
		,[cTemperatureUOM]
		,[cHumidity]
		,[cHumidityUOM]
		,[cPressure]
		,[cPressureUOM]
		,[cLocation]
		,[cArea]
		,[cCertFormat]
		,[cWorkOrderResults]
		,[cReturnedTo]
		,[tOpenDate]
		,[tRequiredDate]
		,[tDelayDate]
		,[tMaintDate]
		,[tMaintNextDate]
		,[tQCApprovedDate]
		,[tClosedDate]
		,[tReturnedDate]
		,[nQuantity]
		,[nPriority]
		,[nTechnicianPriority]
		,[nRevision]
		,[lExpedite]
		,[lISOCert]
		,[lOnSite]
		,[lReturnNoMaint]
		,[lSubContracted]
		,[lOOT]
		,[lClosed]
		,[lDelayed]
		,[lCancelled]
		,[lOptional1]
		,[lOptional2]
		,[mCallSheetNotes]
		,[mAccuracyNotes]
		,[mUncertaintyNotes]
		,[mSubContractorNotes]
		,[mOOTNotes]
		,[mStickerNotes]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]

		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@ID
,@nGroupUID
		,@nAssetUID
		,@nTypeUID
		,@nFacilityUID
		,@nDepartmentUID
		,@nWorkingFacilityUID
		,@nOwningLabUID
		,@nCategoryUID
		,@nSubCategoryUID
		,@nProcedureUID
		,@nTypeProcedureDefaultUID
		,@nAssignedTechUID
		,@nTechnicianUID
		,@nQCApprovedByUID
		,@nReturnedByUID
		,@nSubContractorUID
		,@nJobNumberUID
		,@nCalendarUID
		,@nInvoiceUID
		,@nCallSheetAttributeUID
		,@nSubContHours
		,@nSubContCost
		,@nSubContLabCost
		,@nCost
		,@nAllocated
		,@nAllocatedParts
		,@cContactInfo
		,@cInitialCondition
		,@cServiceReason
		,@cCallSheetType
		,@cStickerType
		,@cCallSheetStatus
		,@cCallSheetNumber
		,@cCertificationNumber
		,@cInterval
		,@cIntervalUOM
		,@cTemperature
		,@cTemperatureUOM
		,@cHumidity
		,@cHumidityUOM
		,@cPressure
		,@cPressureUOM
		,@cLocation
		,@cArea
		,@cCertFormat
		,@cWorkOrderResults
		,@cReturnedTo
		,@tOpenDate
		,@tRequiredDate
		,@tDelayDate
		,@tMaintDate
		,@tMaintNextDate
		,@tQCApprovedDate
		,@tClosedDate
		,@tReturnedDate
		,@nQuantity
		,@nPriority
		,@nTechnicianPriority
		,@nRevision
		,@lExpedite
		,@lISOCert
		,@lOnSite
		,@lReturnNoMaint
		,@lSubContracted
		,@lOOT
		,@lClosed
		,@lDelayed
		,@lCancelled
		,@lOptional1
		,@lOptional2
		,@mCallSheetNotes
		,@mAccuracyNotes
		,@mUncertaintyNotes
		,@mSubContractorNotes
		,@mOOTNotes
		,@mStickerNotes
		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@nImportUID

		,GetUTCDate()
		,@nAddUserUID
		,@nAddFacilityUID
		,GetUTCDate()
		,GetUTCDate()
	)

	-- Return the new GUID for the UID of this record to the caller
	SET @nCallSheetUID = @ID

	-- Avoids warning in VS2010
	RETURN 1
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	IF OBJECT_ID(N'[dbo].[spl_CallSheets_DELETE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_CallSheets_DELETE]'
		DROP PROCEDURE [dbo].[spl_CallSheets_DELETE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_CallSheets_DELETE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_CallSheets_DELETE]'

		EXEC sp_executesql N'	
/****************************************************************
	spl_CallSheets_DELETE
	Deletes a single record by ID from the CallSheets table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 9/17/2021 (D)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_CallSheets_DELETE]

	@nCallSheetUID uniqueidentifier,
	@nUpdateUserUID 		[uniqueidentifier],
	@nUpdateFacilityUID		[uniqueidentifier],
	@retMsg					tinyint OUTPUT
	
AS
BEGIN

	DECLARE @recordID nvarchar(50)
	DECLARE @userID nvarchar(50)
	DECLARE @facilityUID nvarchar(50)
	DECLARE @now nvarchar(50)

	SELECT
		@recordID = CONVERT( nvarchar(50), @nCallSheetUID ),
		@now = CONVERT( nvarchar(50), GetUTCDate() ),
		@userID = CONVERT( nvarchar(50), @nUpdateUserUID ),
		@facilityUID = CONVERT( nvarchar(50), @nUpdateFacilityUID ) 

	EXEC sp_CheckAndDelete
		1,							-- MarkDeleted
		''CallSheets'',		-- TableName
		@recordID,					-- PrimaryKeyValue
		1,							-- IsPrimaryKeyString
		''CallSheetEx CallSheetFiles CallSheetLog CallSheetPartsLink CallSheetReadings CallSheetStandardLink Labor Estimates CallSheetAccreditationLink '',	-- TableExceptions
		1,							-- ExceptDeletions
		@facilityUID,				-- FacilityUID
		@userID,					-- UpdateUserUID
		@now,						-- UpdateTime
		@retMsg OUTPUT
	
	RETURN @retMsg
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END



	IF OBJECT_ID(N'[dbo].[spl_CallSheets_UPDATE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_CallSheets_UPDATE]'
		DROP PROCEDURE [dbo].[spl_CallSheets_UPDATE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_CallSheets_UPDATE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_CallSheets_UPDATE]'

		EXEC sp_executesql N'		
/****************************************************************
	spl_CallSheets_UPDATE
	Updates a single record by ID in the CallSheets table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 9/17/2021 (U)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_CallSheets_UPDATE]
	
@nCallSheetUID uniqueidentifier
	,@nGroupUID uniqueidentifier
	,@nAssetUID uniqueidentifier
	,@nTypeUID uniqueidentifier
	,@nFacilityUID uniqueidentifier
	,@nDepartmentUID uniqueidentifier
	,@nWorkingFacilityUID uniqueidentifier
	,@nOwningLabUID uniqueidentifier
	,@nCategoryUID uniqueidentifier
	,@nSubCategoryUID uniqueidentifier
	,@nProcedureUID uniqueidentifier
	,@nTypeProcedureDefaultUID uniqueidentifier
	,@nAssignedTechUID uniqueidentifier
	,@nTechnicianUID uniqueidentifier
	,@nQCApprovedByUID uniqueidentifier
	,@nReturnedByUID uniqueidentifier
	,@nSubContractorUID uniqueidentifier
	,@nJobNumberUID uniqueidentifier
	,@nCalendarUID uniqueidentifier
	,@nInvoiceUID uniqueidentifier
	,@nCallSheetAttributeUID uniqueidentifier
	,@nSubContHours numeric(18, 2)
	,@nSubContCost numeric(18, 2)
	,@nSubContLabCost numeric(18, 2)
	,@nCost numeric(18, 2)
	,@nAllocated numeric(18, 2)
	,@nAllocatedParts numeric(18, 2)
	,@cContactInfo nvarchar(50)
	,@cInitialCondition nvarchar(50)
	,@cServiceReason nvarchar(50)
	,@cCallSheetType nvarchar(50)
	,@cStickerType nvarchar(50)
	,@cCallSheetStatus nvarchar(50)
	,@cCallSheetNumber nvarchar(50)
	,@cCertificationNumber nvarchar(50)
	,@cInterval nvarchar(50)
	,@cIntervalUOM nvarchar(50)
	,@cTemperature nvarchar(50)
	,@cTemperatureUOM nvarchar(50)
	,@cHumidity nvarchar(50)
	,@cHumidityUOM nvarchar(50)
	,@cPressure nvarchar(50)
	,@cPressureUOM nvarchar(50)
	,@cLocation nvarchar(50)
	,@cArea nvarchar(50)
	,@cCertFormat nvarchar(50)
	,@cWorkOrderResults nvarchar(50)
	,@cReturnedTo nvarchar(150)
	,@tOpenDate datetime
	,@tRequiredDate datetime
	,@tDelayDate datetime
	,@tMaintDate datetime
	,@tMaintNextDate datetime
	,@tQCApprovedDate datetime
	,@tClosedDate datetime
	,@tReturnedDate datetime
	,@nQuantity int
	,@nPriority int
	,@nTechnicianPriority int
	,@nRevision int
	,@lExpedite int
	,@lISOCert int
	,@lOnSite int
	,@lReturnNoMaint int
	,@lSubContracted int
	,@lOOT int
	,@lClosed int
	,@lDelayed int
	,@lCancelled int
	,@lOptional1 int
	,@lOptional2 int
	,@mCallSheetNotes nvarchar(max)
	,@mAccuracyNotes nvarchar(max)
	,@mUncertaintyNotes nvarchar(max)
	,@mSubContractorNotes nvarchar(max)
	,@mOOTNotes nvarchar(max)
	,@mStickerNotes nvarchar(max)
	,@lActive int
	,@lDeleted int
	,@lApproved int
	,@lAdded int
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@nImportUID uniqueidentifier


AS
BEGIN
	DECLARE @DateNow datetime = GetUTCDate();

	UPDATE [dbo].[CallSheets]
	SET
[nGroupUID] = @nGroupUID
		,[nAssetUID] = @nAssetUID
		,[nTypeUID] = @nTypeUID
		,[nFacilityUID] = @nFacilityUID
		,[nDepartmentUID] = @nDepartmentUID
		,[nWorkingFacilityUID] = @nWorkingFacilityUID
		,[nOwningLabUID] = @nOwningLabUID
		,[nCategoryUID] = @nCategoryUID
		,[nSubCategoryUID] = @nSubCategoryUID
		,[nProcedureUID] = @nProcedureUID
		,[nTypeProcedureDefaultUID] = @nTypeProcedureDefaultUID
		,[nAssignedTechUID] = @nAssignedTechUID
		,[nTechnicianUID] = @nTechnicianUID
		,[nQCApprovedByUID] = @nQCApprovedByUID
		,[nReturnedByUID] = @nReturnedByUID
		,[nSubContractorUID] = @nSubContractorUID
		,[nJobNumberUID] = @nJobNumberUID
		,[nCalendarUID] = @nCalendarUID
		,[nInvoiceUID] = @nInvoiceUID
		,[nCallSheetAttributeUID] = @nCallSheetAttributeUID
		,[nSubContHours] = @nSubContHours
		,[nSubContCost] = @nSubContCost
		,[nSubContLabCost] = @nSubContLabCost
		,[nCost] = @nCost
		,[nAllocated] = @nAllocated
		,[nAllocatedParts] = @nAllocatedParts
		,[cContactInfo] = @cContactInfo
		,[cInitialCondition] = @cInitialCondition
		,[cServiceReason] = @cServiceReason
		,[cCallSheetType] = @cCallSheetType
		,[cStickerType] = @cStickerType
		,[cCallSheetStatus] = @cCallSheetStatus
		,[cCallSheetNumber] = @cCallSheetNumber
		,[cCertificationNumber] = @cCertificationNumber
		,[cInterval] = @cInterval
		,[cIntervalUOM] = @cIntervalUOM
		,[cTemperature] = @cTemperature
		,[cTemperatureUOM] = @cTemperatureUOM
		,[cHumidity] = @cHumidity
		,[cHumidityUOM] = @cHumidityUOM
		,[cPressure] = @cPressure
		,[cPressureUOM] = @cPressureUOM
		,[cLocation] = @cLocation
		,[cArea] = @cArea
		,[cCertFormat] = @cCertFormat
		,[cWorkOrderResults] = @cWorkOrderResults
		,[cReturnedTo] = @cReturnedTo
		,[tOpenDate] = @tOpenDate
		,[tRequiredDate] = @tRequiredDate
		,[tDelayDate] = @tDelayDate
		,[tMaintDate] = @tMaintDate
		,[tMaintNextDate] = @tMaintNextDate
		,[tQCApprovedDate] = @tQCApprovedDate
		,[tClosedDate] = @tClosedDate
		,[tReturnedDate] = @tReturnedDate
		,[nQuantity] = @nQuantity
		,[nPriority] = @nPriority
		,[nTechnicianPriority] = @nTechnicianPriority
		,[nRevision] = @nRevision
		,[lExpedite] = @lExpedite
		,[lISOCert] = @lISOCert
		,[lOnSite] = @lOnSite
		,[lReturnNoMaint] = @lReturnNoMaint
		,[lSubContracted] = @lSubContracted
		,[lOOT] = @lOOT
		,[lClosed] = @lClosed
		,[lDelayed] = @lDelayed
		,[lCancelled] = @lCancelled
		,[lOptional1] = @lOptional1
		,[lOptional2] = @lOptional2
		,[mCallSheetNotes] = @mCallSheetNotes
		,[mAccuracyNotes] = @mAccuracyNotes
		,[mUncertaintyNotes] = @mUncertaintyNotes
		,[mSubContractorNotes] = @mSubContractorNotes
		,[mOOTNotes] = @mOOTNotes
		,[mStickerNotes] = @mStickerNotes
		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[nImportUID] = @nImportUID

		,[tUpdateTime] = @DateNow
		,[tMobileTime] = @DateNow
	WHERE
[nCallSheetUID] = @nCallSheetUID

	
	RETURN
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	
	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'FE9DA0B0-2723-489F-B125-9ECA997FE8E8')
	BEGIN 
	    PRINT N'Adding UCI Data Item for cReturnedTo'

	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('FE9DA0B0-2723-489F-B125-9ECA997FE8E8', N'CallSheets', N'cReturnedTo', N'Label', N'Returned To',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210917 23:39:57.643','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210917 23:39:57.643','20210917 23:39:57.643')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'C97D0125-33A5-42ED-B501-B14870D5CF13')
	BEGIN 
	    PRINT N'Adding Context Element for cReturnedTo'
	    
	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('C97D0125-33A5-42ED-B501-B14870D5CF13','FE9DA0B0-2723-489F-B125-9ECA997FE8E8',N'Field',N'cReturnedTo',N'Returned To',300,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210917 23:39:57.643','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210917 23:39:57.643','20210917 23:39:57.643')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '65EF2A90-4E90-4DB7-9AB3-FBF3526ADE6E')
	BEGIN 
	    PRINT N'Adding Context Element Link for cReturnedTo'
	    
	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('65EF2A90-4E90-4DB7-9AB3-FBF3526ADE6E','339EA3AB-332B-4999-8367-BFFC03A0C2B2','C97D0125-33A5-42ED-B501-B14870D5CF13',N'AND',195,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210917 23:39:57.643','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210917 23:39:57.643','20210917 23:39:57.643')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 
	
	IF EXISTS( SELECT * FROM sysobjects WHERE type='V' AND name='vw_WorkOrdersWithEx' )
	BEGIN
		PRINT N'Dropping [dbo].[vw_WorkOrdersWithEx]'

		DROP VIEW [dbo].[vw_WorkOrdersWithEx]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[vw_WorkOrdersWithEx]', 'V') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[vw_WorkOrdersWithEx]'

		EXEC sp_executesql N'
/******************************************************************************************
	vw_WorkOrdersWithEx
	(C) 2014-21 Fluke Calibration
-------------------------------------------------------------------------------------------
	CHANGE HISTORY
	05/13/2014  MM      Initial version
	07/22/2014  MM      Added nOwningLabUID
	03/11/2015  MM      Exclude inactive and deleted EX records
	04/09/2015  MM      Include all fields from CallSheets but nAssetUID and nFacilityUID
	12/08/2015  MM      Get latest work order location from CallSheetLog
	06/25/2020  MM      Coalesce nullable flags
	07/26/2021  MM      Add new optional flags
	08/26/2021  KW      Coalesce EX active flag
	09/23/2021  MM      Add cReturnedTo
*******************************************************************************************/
CREATE VIEW [dbo].[vw_WorkOrdersWithEx]
AS SELECT
	cs.[nCallSheetUID],
	cs.[nGroupUID],
	cs.[nTypeUID],
	cs.[nDepartmentUID],
	cs.[nWorkingFacilityUID],
	cs.[nOwningLabUID],
	cs.[nCategoryUID],
	cs.[nSubCategoryUID],
	cs.[nProcedureUID],
	cs.[nTypeProcedureDefaultUID],
	cs.[nAssignedTechUID],
	cs.[nTechnicianUID],
	cs.[nQCApprovedByUID],
	cs.[nReturnedByUID],
	cs.[nSubContractorUID],
	cs.[nJobNumberUID],
	cs.[nCalendarUID],
	cs.[nInvoiceUID],
	cs.[nCallSheetAttributeUID],
	cs.[nSubContHours],
	cs.[nSubContCost],
	cs.[nSubContLabCost],
	cs.[nCost],
	cs.[nAllocated],
	cs.[nAllocatedParts],
	cs.[cContactInfo],
	cs.[cInitialCondition],
	cs.[cServiceReason],
	cs.[cCallSheetType],
	cs.[cStickerType],
	cs.[cCallSheetStatus],
	cs.[cCallSheetNumber],
	cs.[cCertificationNumber],
	cs.[cInterval],
	cs.[cIntervalUOM],
	cs.[cTemperature],
	cs.[cTemperatureUOM],
	cs.[cHumidity],
	cs.[cHumidityUOM],
	cs.[cPressure],
	cs.[cPressureUOM],
	cs.[cLocation],
	cs.[cArea],
	cs.[cCertFormat],
	cs.[cWorkOrderResults],
	cs.[cReturnedTo],	
	cs.[tOpenDate],
	cs.[tRequiredDate],
	cs.[tDelayDate],
	cs.[tMaintDate],
	cs.[tMaintNextDate],
	cs.[tQCApprovedDate],
	cs.[tClosedDate],
	cs.[tReturnedDate],
	cs.[nQuantity],
	cs.[nPriority],
	cs.[nTechnicianPriority],
	cs.[nRevision],
	COALESCE(cs.[lExpedite], 0) AS [lExpedite],
	COALESCE(cs.[lISOCert], 0) AS [lISOCert],
	COALESCE(cs.[lOnSite], 0) AS [lOnSite],
	COALESCE(cs.[lReturnNoMaint], 0) AS [lReturnNoMaint],
	COALESCE(cs.[lSubContracted], 0) AS [lSubContracted],
	COALESCE(cs.[lOOT], 0) AS [lOOT],
	COALESCE(cs.[lClosed], 0) AS [lClosed],
	COALESCE(cs.[lDelayed], 0) AS [lDelayed],
	COALESCE(cs.[lCancelled], 0) AS [lCancelled],
	cs.[lOptional1],
	cs.[lOptional2],
	cs.[mCallSheetNotes],
	cs.[mAccuracyNotes],
	cs.[mUncertaintyNotes],
	cs.[mSubContractorNotes],
	cs.[mOOTNotes],
	cs.[mStickerNotes],
	cs.[lActive],
	cs.[lDeleted],
	cs.[lApproved],
	cs.[lAdded],
	cs.[nAddFacilityUID],
	cs.[nAddUserUID],
	cs.[tAddTime],
	cs.[nUpdateFacilityUID],
	cs.[nUpdateUserUID],
	cs.[tUpdateTime],
	cs.[tMobileTime],
	cs.[tSystemUpdateTime],
	cs.[nImportUID],
	ass.nAssetUID AS [nAssetUID],
	ass.cID AS [cAssetID],
	ass.cBarcode AS [cAssetBarcode],
	ass.cModelNumber AS [cAssetModelNumber],
	ass.cSerialNumber AS [cAssetSerialNumber],
	ass.cDescription AS [cAssetDescription],
	ass.cPhysicalLocation AS [cAssetPhysicalLocation],
	ass.nQuantity AS [nAssetQuantity],
	ass.cPartNumber AS [cAssetPartNumber],
	ass.lActive AS [lAssetActive],
	ass.nFacilityUID AS [nFacilityUID],
	asspar.cID AS [cAssetParentID],
	asspar.cBarcode AS [cAssetParentBarcode],
	assfac.cFacilityName AS [cAssetManufacturerName],
	typ.cDescription AS [cCsTypeDescription],
	typ.cAuthority AS [cCsTypeAuthority],
	fac.cFacilityName AS [cCsCustomerName],
	fac.cFacilityNumber AS [cCsCustomerNumber],
	fac.cDistrict  AS [cCsCustomerRecallRule],
	dep.cFacilityName AS [cCsDepartmentName],
	dep.cFacilityNumber AS [cCsDepartmentNumber],
	wfc.cFacilityName AS [cCsWorkingFacilityName],
	wfc.cFacilityNumber AS [cCsWorkingFacilityNumber],
	ofc.cFacilityName AS [cCsOwningLabName],
	ofc.cFacilityNumber AS [cCsOwningLabNumber],
	cat.cDescription AS [cCsCategory],
	scat.cDescription AS [cCsSubCategory],
	pro.cProcedureName AS [cCsProcedureName],
	pro.cProcedureNumber AS [cCsProcedureNumber],
	pro.cAuthority AS [cCsProcedureAuthority],
	tpd.cInterval AS [cCsTpdInterval],
	tpd.cIntervalUOM AS [cCsTpdIntervalUOM],
	tpd.cMaintenanceType AS [cCsTpdMaintenanceType],
	tpd.nStandardTime AS [cCsTpdStandardTime],
	tpd.nStandardPrice AS [cCsTpdStandardPrice],
	ausr.cFirstName + '' '' + ausr.cLastName AS [cCsAssignedTechnician],
	usr.cFirstName + '' '' + usr.cLastName AS [cCsTechnician],
	QCusr.cFirstName + '' '' + QCusr.cLastName AS [cCsQCApprovedByUser],
	rusr.cFirstName + '' '' + rusr.cLastName AS [cCsReturnedByUser],
	sub.cFacilityName AS [cCsSubContractorName],
	sub.cFacilityNumber AS [cCsSubContractorNumber],
	COALESCE(job.[cJobOrderNumber],'''') AS [cCsJobOrderNumber],
	COALESCE(job.[lLevelOfEffort], 0) AS [lCsJobLevelOfEffort],
	inv.cInvoiceNo AS [cCsInvoiceNumber],
	inv.tInvoicedate AS [tCsInvoiceDate],
	csx.[cField1],
	csx.[cField2],
	csx.[cField3],
	csx.[cField4],
	csx.[cField5],
	csx.[cField6],
	csx.[cField7],
	csx.[cField8],
	csx.[cField9],
	csx.[cField10],
	csx.[cField11],
	csx.[cField12],
	csx.[cField13],
	csx.[cField14],
	csx.[cField15],
	csx.[cField16],
	csx.[cField17],
	csx.[cField18],
	csx.[cField19],
	csx.[cField20],
	csx.[cField21],
	csx.[cField22],
	csx.[cField23],
	csx.[cField24],
	csx.[cField25],
	csx.[cField26],
	csx.[tField1],
	csx.[tField2],
	csx.[tField3],
	csx.[tField4],
	csx.[tField5],
	csx.[tField6],
	csx.[tField7],
	csx.[tField8],
	csx.[tField9],
	csx.[tField10],
	csx.[nField1],
	csx.[nField2],
	csx.[nField3],
	csx.[nField4],
	csx.[nField5],
	csx.[nField6],
	csx.[nField7],
	csx.[nField8],
	csx.[nField9],
	csx.[nField10],
	csx.[nField11],
	csx.[nField12],
	csx.[nField13],
	csx.[nField14],
	csx.[nField15],
	csx.[nField16],
	csx.[nField17],
	csx.[nField18],
	csx.[nField19],
	csx.[nField20],
	csx.[nField21],
	csx.[nField22],
	csx.[nField23],
	csx.[nField24],
	csx.[nField25],
	csx.[nField26],
	csx.[nField27],
	csx.[nField28],
	csx.[nField29],
	csx.[nField30],
	csx.[nField31],
	csx.[nField32],
	csx.[nField33],
	csx.[nField34],
	csx.[nField35],
	COALESCE(csx.[lField1], 0) AS [lField1],
	COALESCE(csx.[lField2], 0) AS [lField2],
	COALESCE(csx.[lField3], 0) AS [lField3],
	COALESCE(csx.[lField4], 0) AS [lField4],
	COALESCE(csx.[lField5], 0) AS [lField5],
	COALESCE(csx.[lField6], 0) AS [lField6],
	COALESCE(csx.[lField7], 0) AS [lField7],
	COALESCE(csx.[lField8], 0) AS [lField8],
	COALESCE(csx.[lField9], 0) AS [lField9],
	COALESCE(csx.[lField10], 0) AS [lField10],
	csx.[mField1],
	csx.[mField2],
	csx.[mField3],
	COALESCE(csx.[lActive], 0) AS [lCsxActive],
	cslog.[cLocation] AS [CurrentLocation]
FROM
CallSheets cs
	INNER JOIN Assets ass ON ass.nAssetUID = cs.nAssetUID
	INNER JOIN Types typ ON cs.nTypeUID = typ.nTypeUID
	INNER JOIN Facilities fac ON cs.nFacilityUID = fac.nFacilityUID
	LEFT JOIN Facilities dep ON cs.nDepartmentUID = dep.nFacilityUID
	LEFT JOIN Facilities wfc ON cs.nWorkingFacilityUID = wfc.nFacilityUID
	LEFT JOIN Facilities ofc ON cs.nOwningLabUID = ofc.nFacilityUID
	LEFT JOIN Category cat ON cs.nCategoryUID = cat.nCategoryUID
	LEFT JOIN SubCategory scat ON cs.nSubCategoryUID = scat.nSubCategoryUID
	LEFT JOIN Procedures pro ON cs.nProcedureUID = pro.nProcedureUID
	LEFT JOIN TypeProcedureDefaults tpd ON cs.nTypeProcedureDefaultUID = tpd.nTypeProcedureDefaultUID
	LEFT JOIN Users ausr ON cs.nAssignedTechUID = ausr.nUserUID
	LEFT JOIN Users usr ON cs.nTechnicianUID = usr.nUserUID
	LEFT JOIN Users QCusr ON cs.nQCApprovedByUID = QCusr.nUserUID
	LEFT JOIN Users rusr ON cs.nReturnedByUID = rusr.nUserUID
	LEFT JOIN Facilities sub ON cs.nSubContractorUID = sub.nFacilityUID
	LEFT JOIN JobNumbers job ON cs.nJobNumberUID = job.nJobNumberUID
	LEFT JOIN Invoices inv ON cs.nInvoiceUID = inv.nInvoiceUID
	LEFT JOIN Assets asspar ON ass.nParentUID = asspar.nAssetUID
	LEFT JOIN Facilities assfac ON ass.nManufacturerUID = assfac.nFacilityUID
	LEFT JOIN CallSheetEx csx ON cs.nCallSheetUID = csx.nCallSheetUID AND csx.lActive <> 0 AND csx.lDeleted = 0
OUTER APPLY (SELECT TOP 1 cLocation
				FROM [dbo].[CallSheetLog]
				WHERE CallSheetLog.nCallSheetUID = cs.[nCallSheetUID] AND CallSheetLog.lActive <> 0 AND CallSheetLog.lDeleted = 0
				ORDER BY tDate DESC) cslog
WHERE
	cs.lDeleted = 0	'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END	


	-->>MTM-3964<<--
	IF(SELECT COUNT(*) FROM syscolumns sc JOIN sysobjects so ON sc.id = so.id WHERE so.type = 'U' AND sc.name = 'mNotes' AND so.name = 'ManualTemplates' AND sc.xtype = 231) = 0
	BEGIN
		ALTER TABLE [dbo].[ManualTemplates] ALTER COLUMN [mNotes] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
		

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END



    IF OBJECT_ID(N'[dbo].[tr_kr_audit_ManualTemplates_Del]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_ManualTemplates_Del] from [dbo].[ManualTemplates]'

    	DROP TRIGGER [dbo].[tr_kr_audit_ManualTemplates_Del]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_ManualTemplates_Del]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_ManualTemplates_Del] on [dbo].[ManualTemplates]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_ManualTemplates_Del] ON [dbo].[ManualTemplates] FOR DELETE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20210929 20:28:54

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM DELETED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2161,
            0,
            CONVERT( NVARCHAR(max), [cTemplateName] )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2162,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2163,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2164,
            0,
            CONVERT(NVARCHAR, [lAllowActual])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2165,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2166,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2167,
            0,
            CONVERT(NVARCHAR, [lIsTransducer])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2168,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mNotes], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2169,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2170,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2171,
            0,
            CONVERT(NVARCHAR( 36 ), [nImportUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2172,
            0,
            CONVERT(NVARCHAR( 36 ), [nManualTemplateUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2173,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2174,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2175,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2176,
            0,
            CONVERT( NVARCHAR( 34 ), [tMobileTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2177,
            0,
            CONVERT( NVARCHAR( 34 ), [tSystemUpdateTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2178,
            0,
            CONVERT( NVARCHAR( 34 ), [tUpdateTime], 121 )
        FROM
            DELETED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 66, @RowsAffected, ''D'', @AuditedUser
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_ManualTemplates_Del]', 'last', 'delete', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_ManualTemplates_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_ManualTemplates_Ins] from [dbo].[ManualTemplates]'

    	DROP TRIGGER [dbo].[tr_kr_audit_ManualTemplates_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_ManualTemplates_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_ManualTemplates_Ins] on [dbo].[ManualTemplates]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_ManualTemplates_Ins] ON [dbo].[ManualTemplates] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20210929 20:28:54

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2161,
            0,
            CONVERT( NVARCHAR(max), [cTemplateName] )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2162,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2163,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2164,
            0,
            CONVERT(NVARCHAR, [lAllowActual])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2165,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2166,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2167,
            0,
            CONVERT(NVARCHAR, [lIsTransducer])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2168,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2169,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2170,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2172,
            0,
            CONVERT(NVARCHAR( 36 ), [nManualTemplateUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), [nManualTemplateUID]),
            2175,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 66, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_ManualTemplates_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_ManualTemplates_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_ManualTemplates_Upd] from [dbo].[ManualTemplates]'

    	DROP TRIGGER [dbo].[tr_kr_audit_ManualTemplates_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_ManualTemplates_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_ManualTemplates_Upd] on [dbo].[ManualTemplates]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_ManualTemplates_Upd] ON [dbo].[ManualTemplates] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20210929 20:28:54

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nManualTemplateUID] = i.[nManualTemplateUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cTemplateName] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nManualTemplateUID], d.[nManualTemplateUID] )),
                2161,
                0,
                CONVERT( NVARCHAR(max), d.[cTemplateName] ),
                CONVERT( NVARCHAR(max), i.[cTemplateName] )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nManualTemplateUID] = i.[nManualTemplateUID] )
            WHERE
                ( d.[cTemplateName] <> i.[cTemplateName] ) OR
                ( d.[cTemplateName] IS NULL AND i.[cTemplateName] IS NOT NULL ) OR
                ( i.[cTemplateName] IS NULL AND d.[cTemplateName] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nManualTemplateUID], d.[nManualTemplateUID] )),
                2162,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nManualTemplateUID] = i.[nManualTemplateUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nManualTemplateUID], d.[nManualTemplateUID] )),
                2163,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nManualTemplateUID] = i.[nManualTemplateUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAllowActual] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nManualTemplateUID], d.[nManualTemplateUID] )),
                2164,
                0,
                CONVERT(NVARCHAR, d.[lAllowActual]),
                CONVERT(NVARCHAR, i.[lAllowActual])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nManualTemplateUID] = i.[nManualTemplateUID] )
            WHERE
                ( d.[lAllowActual] <> i.[lAllowActual] ) OR
                ( d.[lAllowActual] IS NULL AND i.[lAllowActual] IS NOT NULL ) OR
                ( i.[lAllowActual] IS NULL AND d.[lAllowActual] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nManualTemplateUID], d.[nManualTemplateUID] )),
                2165,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nManualTemplateUID] = i.[nManualTemplateUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nManualTemplateUID], d.[nManualTemplateUID] )),
                2166,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nManualTemplateUID] = i.[nManualTemplateUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lIsTransducer] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nManualTemplateUID], d.[nManualTemplateUID] )),
                2167,
                0,
                CONVERT(NVARCHAR, d.[lIsTransducer]),
                CONVERT(NVARCHAR, i.[lIsTransducer])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nManualTemplateUID] = i.[nManualTemplateUID] )
            WHERE
                ( d.[lIsTransducer] <> i.[lIsTransducer] ) OR
                ( d.[lIsTransducer] IS NULL AND i.[lIsTransducer] IS NOT NULL ) OR
                ( i.[lIsTransducer] IS NULL AND d.[lIsTransducer] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nManualTemplateUID], d.[nManualTemplateUID] )),
                2168,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nManualTemplateUID] = i.[nManualTemplateUID] )
            WHERE
                ( NULLIF(d.[mNotes], '''') <> NULLIF(i.[mNotes], '''') ) OR
                ( NULLIF(d.[mNotes], '''') IS NULL AND NULLIF(i.[mNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mNotes], '''') IS NULL AND NULLIF(d.[mNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nManualTemplateUID], d.[nManualTemplateUID] )),
                2169,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nManualTemplateUID] = i.[nManualTemplateUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nManualTemplateUID], d.[nManualTemplateUID] )),
                2170,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nManualTemplateUID] = i.[nManualTemplateUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nManualTemplateUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nManualTemplateUID], d.[nManualTemplateUID] )),
                2172,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nManualTemplateUID]),
                CONVERT(NVARCHAR( 36 ), i.[nManualTemplateUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nManualTemplateUID] = i.[nManualTemplateUID] )
            WHERE
                ( d.[nManualTemplateUID] <> i.[nManualTemplateUID] ) OR
                ( d.[nManualTemplateUID] IS NULL AND i.[nManualTemplateUID] IS NOT NULL ) OR
                ( i.[nManualTemplateUID] IS NULL AND d.[nManualTemplateUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nManualTemplateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nManualTemplateUID], d.[nManualTemplateUID] )),
                2175,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nManualTemplateUID] = i.[nManualTemplateUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN
        
            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED
        
            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 66, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_ManualTemplates_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '2FDEAA34-3B62-4FB9-886E-8FA4D5B0FA16')
	BEGIN
	    PRINT N'Adding UCI Data Item'

	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('2FDEAA34-3B62-4FB9-886E-8FA4D5B0FA16', N'ManualTemplates', N'mNotes', N'Label', N'Notes',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210929 23:10:34.423', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210929 23:10:34.423', '20210929 23:10:34.423', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'CCC84EC3-BD58-491B-B908-878C977089B2')
	BEGIN
	    PRINT N'Adding Context Element for mNotes'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('CCC84EC3-BD58-491B-B908-878C977089B2','2FDEAA34-3B62-4FB9-886E-8FA4D5B0FA16',N'Field',N'mNotes',N'Notes',250,NULL,NULL,NULL,1,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210929 23:10:34.423','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210929 23:10:34.423','20210929 23:10:34.423')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '580F6E7A-56C7-4E33-9558-C9CB9AB3FF4B')
	BEGIN
	    PRINT N'Adding Context Element Link for mNotes'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('580F6E7A-56C7-4E33-9558-C9CB9AB3FF4B','8CAC4C68-D6AE-47E8-94F0-AA96556A1D92','CCC84EC3-BD58-491B-B908-878C977089B2',N'AND',2,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210929 23:10:34.423','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210929 23:10:34.423','20210929 23:10:34.423')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '48B665EA-DDBD-4976-9A31-3C63F207D1B0')
	BEGIN
	    PRINT N'Adding UCI Data Item'

	    INSERT INTO [dbo].UCIData([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
	    VALUES('48B665EA-DDBD-4976-9A31-3C63F207D1B0', N'Procedures', N'lLocked', N'Label', N'Locked',-1,0,0,0,'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210929 23:10:34.423', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20210929 23:10:34.423', '20210929 23:10:34.423', NULL, NULL)

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '608F5E64-45E9-4057-8FE4-3E7FDCB7591A')
	BEGIN
	    PRINT N'Adding Context Element for lLocked'

	    INSERT INTO [dbo].[ContextElements]([nContextElementUID],[nUCIDataUID],[cProperty],[cValue],[cDefaultLabel],[nWidth],[cForm],[cControl],[cFormat],[nStyle],[nTextAlign],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES ('608F5E64-45E9-4057-8FE4-3E7FDCB7591A','48B665EA-DDBD-4976-9A31-3C63F207D1B0',N'Field',N'lLocked',N'Locked',50,NULL,NULL,NULL,3,NULL,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210929 23:10:34.423','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210929 23:10:34.423','20210929 23:10:34.423')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '8ACA5730-D600-4D14-AB75-DACA3CE78992')
	BEGIN
	    PRINT N'Adding Context Element Link for lLocked'

	    INSERT INTO [dbo].[ContextElementLink]([nContextElementLinkUID],[nContextUID],[nContextElementUID],[cOperator],[nOrder],[lHidden],[nActivation],[lDefault],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('8ACA5730-D600-4D14-AB75-DACA3CE78992','FCC69069-493A-4B2A-8E0F-2346F7AC319A','608F5E64-45E9-4057-8FE4-3E7FDCB7591A',N'AND',10,0,NULL,0,-1,0,-1,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210929 23:10:34.423','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20210929 23:10:34.423','20210929 23:10:34.423')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END




	-->>MTM-5157<<--		
	IF NOT EXISTS(SELECT * FROM syscolumns sc JOIN sysobjects so ON sc.id = so.id WHERE sc.name = 'cAssignedContact' AND so.name = 'Assets')
	BEGIN

		PRINT N'Dropping extended properties'

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', NULL, NULL))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', NULL, NULL

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cAssignedGroup'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cAssignedGroup'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cBarcode'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cBarcode'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cClass'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cClass'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cDescription'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cDescription'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cDimension'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cDimension'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cDisposition'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cDisposition'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cFamily'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cFamily'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cGroup'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cGroup'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cModelNumber'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cModelNumber'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cPartNumber'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cPartNumber'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cPhysicalLocation'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cPhysicalLocation'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cSerialNumber'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cSerialNumber'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cStandardType'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cStandardType'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cStatus'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cStatus'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cStockNumber'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cStockNumber'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cWeight'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cWeight'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cWeightUOM'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cWeightUOM'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lActive'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lActive'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lAdded'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lAdded'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lApproved'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lApproved'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lDeleted'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lDeleted'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lInAbeyance'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lInAbeyance'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lNonTracked'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lNonTracked'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lOnSite'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lOnSite'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lRecallMaintenanceType'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lRecallMaintenanceType'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lStandard'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lStandard'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'mAccuracy'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'mAccuracy'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'mNotes'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'mNotes'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'mUncertaintyNotes'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'mUncertaintyNotes'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'mWarrantyInfo'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'mWarrantyInfo'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAbeyanceInterval'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAbeyanceInterval'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAddFacilityUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAddFacilityUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAddUserUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAddUserUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAssetUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAssetUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAssignedFacUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAssignedFacUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAuthorizedFacUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAuthorizedFacUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nCategoryUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nCategoryUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nDepartmentUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nDepartmentUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nFacilityUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nFacilityUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nImportUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nImportUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nInventoryByUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nInventoryByUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nItemCost'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nItemCost'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nMaintenanceFacUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nMaintenanceFacUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nManufacturerUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nManufacturerUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nParentUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nParentUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nQuantity'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nQuantity'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nReplacementCost'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nReplacementCost'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nSubCategoryUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nSubCategoryUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nTypeUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nTypeUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nUpdateFacilityUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nUpdateFacilityUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nUpdateUserUID'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nUpdateUserUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nUseCount'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nUseCount'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tAddTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tAddTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tAssignedGroupDate'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tAssignedGroupDate'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tInServiceDate'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tInServiceDate'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tInventoryDate'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tInventoryDate'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tMobileTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tMobileTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tPurchaseDate'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tPurchaseDate'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tStatusDate'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tStatusDate'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tSystemUpdateTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tSystemUpdateTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tUpdateTime'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tUpdateTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tWarrantyDate'))
		EXEC sp_dropextendedproperty N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tWarrantyDate'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping foreign keys from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [FK_Assets_Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_Category]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [FK_Assets_Category]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_Facilities]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [FK_Assets_Facilities]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_FacilitiesAssignedFac]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [FK_Assets_FacilitiesAssignedFac]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_FacilitiesAuthorizedFac]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [FK_Assets_FacilitiesAuthorizedFac]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_FacilitiesDepartment]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [FK_Assets_FacilitiesDepartment]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_FacilitiesMaintenanceFac]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [FK_Assets_FacilitiesMaintenanceFac]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_FacilitiesManufacturer]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [FK_Assets_FacilitiesManufacturer]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_SubCategory]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [FK_Assets_SubCategory]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_Types]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [FK_Assets_Types]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_Users]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [FK_Assets_Users]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping foreign keys from [dbo].[AssetEx]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AssetEx_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[AssetEx]', 'U'))
		ALTER TABLE [dbo].[AssetEx] DROP CONSTRAINT [FK_AssetEx_Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping foreign keys from [dbo].[AssetFiles]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AssetFiles_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[AssetFiles]', 'U'))
		ALTER TABLE [dbo].[AssetFiles] DROP CONSTRAINT [FK_AssetFiles_Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping foreign keys from [dbo].[AssetLog]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AssetLog_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[AssetLog]', 'U'))
		ALTER TABLE [dbo].[AssetLog] DROP CONSTRAINT [FK_AssetLog_Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping foreign keys from [dbo].[AssetServices]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AssetServices_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[AssetServices]', 'U'))
		ALTER TABLE [dbo].[AssetServices] DROP CONSTRAINT [FK_AssetServices_Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping foreign keys from [dbo].[CallSheets]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] DROP CONSTRAINT [FK_CallSheets_Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping foreign keys from [dbo].[CallSheetStandardLink]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetStandardLink_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetStandardLink]', 'U'))
		ALTER TABLE [dbo].[CallSheetStandardLink] DROP CONSTRAINT [FK_CallSheetStandardLink_Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping foreign keys from [dbo].[PointReadings]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PointReadings_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[PointReadings]', 'U'))
		ALTER TABLE [dbo].[PointReadings] DROP CONSTRAINT [FK_PointReadings_Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping foreign keys from [dbo].[PointStandardReadings]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PointStandardReadings_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[PointStandardReadings]', 'U'))
		ALTER TABLE [dbo].[PointStandardReadings] DROP CONSTRAINT [FK_PointStandardReadings_Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping foreign keys from [dbo].[PointStandards]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PointStandards_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[PointStandards]', 'U'))
		ALTER TABLE [dbo].[PointStandards] DROP CONSTRAINT [FK_PointStandards_Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping foreign keys from [dbo].[ToolAssignments]'

		IF EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ToolAssignment_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ToolAssignments]', 'U'))
		ALTER TABLE [dbo].[ToolAssignments] DROP CONSTRAINT [FK_ToolAssignment_Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PK_Assets]', 'PK') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [PK_Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nReplacementCost' AND object_id = OBJECT_ID(N'[dbo].[Assets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Assets_nReplacementCost]', 'D'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [DF_Assets_nReplacementCost]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nItemCost' AND object_id = OBJECT_ID(N'[dbo].[Assets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Assets_nItemCost]', 'D'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [DF_Assets_nItemCost]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lRecallMaintenanceType' AND object_id = OBJECT_ID(N'[dbo].[Assets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Assets_lRecallMaintenanceType]', 'D'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [DF_Assets_lRecallMaintenanceType]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nUseCount' AND object_id = OBJECT_ID(N'[dbo].[Assets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Assets_nUseCount]', 'D'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [DF_Assets_nUseCount]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nQuantity' AND object_id = OBJECT_ID(N'[dbo].[Assets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Assets_nQuantity]', 'D'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [DF_Assets_nQuantity]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lActive' AND object_id = OBJECT_ID(N'[dbo].[Assets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Assets_lActive]', 'D'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [DF_Assets_lActive]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lDeleted' AND object_id = OBJECT_ID(N'[dbo].[Assets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Assets_lDeleted]', 'D'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [DF_Assets_lDeleted]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lApproved' AND object_id = OBJECT_ID(N'[dbo].[Assets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Assets_lApproved]', 'D'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [DF_Assets_lApproved]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'lAdded' AND object_id = OBJECT_ID(N'[dbo].[Assets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Assets_lAdded]', 'D'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [DF_Assets_lAdded]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nAddFacilityUID' AND object_id = OBJECT_ID(N'[dbo].[Assets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Assets_nAddFacilityUID]', 'D'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [DF_Assets_nAddFacilityUID]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nAddUserUID' AND object_id = OBJECT_ID(N'[dbo].[Assets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Assets_nAddUserUID]', 'D'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [DF_Assets_nAddUserUID]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tAddTime' AND object_id = OBJECT_ID(N'[dbo].[Assets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Assets_tAddTime]', 'D'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [DF_Assets_tAddTime]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nUpdateFacilityUID' AND object_id = OBJECT_ID(N'[dbo].[Assets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Assets_nUpdateFacilityUID]', 'D'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [DF_Assets_nUpdateFacilityUID]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'nUpdateUserUID' AND object_id = OBJECT_ID(N'[dbo].[Assets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Assets_nUpdateUserUID]', 'D'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [DF_Assets_nUpdateUserUID]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tUpdateTime' AND object_id = OBJECT_ID(N'[dbo].[Assets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Assets_tUpdateTime]', 'D'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [DF_Assets_tUpdateTime]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping constraints from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.columns WHERE name = N'tMobileTime' AND object_id = OBJECT_ID(N'[dbo].[Assets]', 'U') AND default_object_id = OBJECT_ID(N'[dbo].[DF_Assets_tMobileTime]', 'D'))
		ALTER TABLE [dbo].[Assets] DROP CONSTRAINT [DF_Assets_tMobileTime]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping index [IDX_Assets_04] from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Assets_04' AND object_id = OBJECT_ID(N'[dbo].[Assets]'))
		DROP INDEX [IDX_Assets_04] ON [dbo].[Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping index [IDX_Assets_10] from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Assets_10' AND object_id = OBJECT_ID(N'[dbo].[Assets]'))
		DROP INDEX [IDX_Assets_10] ON [dbo].[Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping index [IDX_Assets_03] from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Assets_03' AND object_id = OBJECT_ID(N'[dbo].[Assets]'))
		DROP INDEX [IDX_Assets_03] ON [dbo].[Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping index [IDX_Assets_04_2] from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Assets_04_2' AND object_id = OBJECT_ID(N'[dbo].[Assets]'))
		DROP INDEX [IDX_Assets_04_2] ON [dbo].[Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping index [IDX_Assets_03_2] from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Assets_03_2' AND object_id = OBJECT_ID(N'[dbo].[Assets]'))
		DROP INDEX [IDX_Assets_03_2] ON [dbo].[Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping index [IDX_Assets_nInventoryByUID] from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Assets_nInventoryByUID' AND object_id = OBJECT_ID(N'[dbo].[Assets]'))
		DROP INDEX [IDX_Assets_nInventoryByUID] ON [dbo].[Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping index [IDX_Assets_cBarcode] from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Assets_cBarcode' AND object_id = OBJECT_ID(N'[dbo].[Assets]'))
		DROP INDEX [IDX_Assets_cBarcode] ON [dbo].[Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping index [IDX_Assets_tAddTime] from [dbo].[Assets]'

		IF EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Assets_tAddTime' AND object_id = OBJECT_ID(N'[dbo].[Assets]'))
		DROP INDEX [IDX_Assets_tAddTime] ON [dbo].[Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping trigger [dbo].[tr_kr_audit_Assets_Del] from [dbo].[Assets]'

		IF OBJECT_ID(N'[dbo].[tr_kr_audit_Assets_Del]', 'TR') IS NOT NULL
		DROP TRIGGER [dbo].[tr_kr_audit_Assets_Del]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping trigger [dbo].[tr_kr_audit_Assets_Ins] from [dbo].[Assets]'

		IF OBJECT_ID(N'[dbo].[tr_kr_audit_Assets_Ins]', 'TR') IS NOT NULL
		DROP TRIGGER [dbo].[tr_kr_audit_Assets_Ins]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Dropping trigger [dbo].[tr_kr_audit_Assets_Upd] from [dbo].[Assets]'

		IF OBJECT_ID(N'[dbo].[tr_kr_audit_Assets_Upd]', 'TR') IS NOT NULL
		DROP TRIGGER [dbo].[tr_kr_audit_Assets_Upd]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		PRINT N'Rebuilding [dbo].[Assets]'

		CREATE TABLE [dbo].[RG_Recovery_1_Assets]
		(
		[nAssetUID] [uniqueidentifier] NOT NULL ROWGUIDCOL,
		[nFacilityUID] [uniqueidentifier] NOT NULL,
		[nDepartmentUID] [uniqueidentifier] NULL,
		[nTypeUID] [uniqueidentifier] NOT NULL,
		[nManufacturerUID] [uniqueidentifier] NULL,
		[nCategoryUID] [uniqueidentifier] NULL,
		[nSubCategoryUID] [uniqueidentifier] NULL,
		[nInventoryByUID] [uniqueidentifier] NULL,
		[nParentUID] [uniqueidentifier] NULL,
		[nMaintenanceFacUID] [uniqueidentifier] NULL,
		[nAssignedFacUID] [uniqueidentifier] NULL,
		[nAuthorizedFacUID] [uniqueidentifier] NULL,
		[cBarcode] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cID] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cSerialNumber] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cModelNumber] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cPartNumber] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cStockNumber] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cStatus] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cDisposition] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cAssignedGroup] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cClass] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cGroup] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cFamily] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cStandardType] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cDescription] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cPhysicalLocation] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cWeightUOM] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cWeight] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cDimension] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cAssignedContact] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[cOptional1] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[nReplacementCost] [numeric] (18, 2) NULL CONSTRAINT [DF_Assets_nReplacementCost] DEFAULT ((0)),
		[nItemCost] [numeric] (18, 2) NULL CONSTRAINT [DF_Assets_nItemCost] DEFAULT ((0)),
		[tInventoryDate] [datetime] NULL,
		[tInServiceDate] [datetime] NULL,
		[tStatusDate] [datetime] NULL,
		[tPurchaseDate] [datetime] NULL,
		[tAssignedGroupDate] [datetime] NULL,
		[tWarrantyDate] [datetime] NULL,
		[mWarrantyInfo] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[mAccuracy] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[mUncertaintyNotes] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[mNotes] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
		[lStandard] [int] NULL,
		[lRecallMaintenanceType] [int] NULL CONSTRAINT [DF_Assets_lRecallMaintenanceType] DEFAULT ((-1)),
		[lInAbeyance] [int] NULL,
		[nAbeyanceInterval] [int] NULL,
		[nUseCount] [int] NULL CONSTRAINT [DF_Assets_nUseCount] DEFAULT ((0)),
		[nQuantity] [int] NULL CONSTRAINT [DF_Assets_nQuantity] DEFAULT ((1)),
		[lOnSite] [int] NULL,
		[lNonTracked] [int] NULL,
		[lOptional] [int] NOT NULL CONSTRAINT [DF_Assets_lOptional] DEFAULT ((0)),
		[lActive] [int] NOT NULL CONSTRAINT [DF_Assets_lActive] DEFAULT ((-1)),
		[lDeleted] [int] NOT NULL CONSTRAINT [DF_Assets_lDeleted] DEFAULT ((0)),
		[lApproved] [int] NOT NULL CONSTRAINT [DF_Assets_lApproved] DEFAULT ((0)),
		[lAdded] [int] NOT NULL CONSTRAINT [DF_Assets_lAdded] DEFAULT ((-1)),
		[nAddFacilityUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Assets_nAddFacilityUID] DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398'),
		[nAddUserUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Assets_nAddUserUID] DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172'),
		[tAddTime] [datetime] NOT NULL CONSTRAINT [DF_Assets_tAddTime] DEFAULT (getutcdate()),
		[nUpdateFacilityUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Assets_nUpdateFacilityUID] DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398'),
		[nUpdateUserUID] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Assets_nUpdateUserUID] DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172'),
		[tUpdateTime] [datetime] NOT NULL CONSTRAINT [DF_Assets_tUpdateTime] DEFAULT (getutcdate()),
		[tMobileTime] [datetime] NOT NULL CONSTRAINT [DF_Assets_tMobileTime] DEFAULT (getutcdate()),
		[tSystemUpdateTime] [datetime] NULL,
		[nImportUID] [uniqueidentifier] NULL,
		CONSTRAINT [RG_Recovery_68b5_PK_Assets] PRIMARY KEY NONCLUSTERED ([nAssetUID])
		)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		INSERT INTO [dbo].[RG_Recovery_1_Assets]([nAssetUID], [nFacilityUID], [nDepartmentUID], [nTypeUID], [nManufacturerUID], [nCategoryUID], [nSubCategoryUID], [nInventoryByUID], [nParentUID], [nMaintenanceFacUID], [nAssignedFacUID], [nAuthorizedFacUID], [cBarcode], [cID], [cSerialNumber], [cModelNumber], [cPartNumber], [cStockNumber], [cStatus], [cDisposition], [cAssignedGroup], [cClass], [cGroup], [cFamily], [cStandardType], [cDescription], [cPhysicalLocation], [cWeightUOM], [cWeight], [cDimension], [nReplacementCost], [nItemCost], [tInventoryDate], [tInServiceDate], [tStatusDate], [tPurchaseDate], [tAssignedGroupDate], [tWarrantyDate], [mWarrantyInfo], [mAccuracy], [mUncertaintyNotes], [mNotes], [lStandard], [lRecallMaintenanceType], [lInAbeyance], [nAbeyanceInterval], [nUseCount], [nQuantity], [lOnSite], [lNonTracked], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID]) SELECT [nAssetUID], [nFacilityUID], [nDepartmentUID], [nTypeUID], [nManufacturerUID], [nCategoryUID], [nSubCategoryUID], [nInventoryByUID], [nParentUID], [nMaintenanceFacUID], [nAssignedFacUID], [nAuthorizedFacUID], [cBarcode], [cID], [cSerialNumber], [cModelNumber], [cPartNumber], [cStockNumber], [cStatus], [cDisposition], [cAssignedGroup], [cClass], [cGroup], [cFamily], [cStandardType], [cDescription], [cPhysicalLocation], [cWeightUOM], [cWeight], [cDimension], [nReplacementCost], [nItemCost], [tInventoryDate], [tInServiceDate], [tStatusDate], [tPurchaseDate], [tAssignedGroupDate], [tWarrantyDate], [mWarrantyInfo], [mAccuracy], [mUncertaintyNotes], [mNotes], [lStandard], [lRecallMaintenanceType], [lInAbeyance], [nAbeyanceInterval], [nUseCount], [nQuantity], [lOnSite], [lNonTracked], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID] FROM [dbo].[Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		DROP TABLE [dbo].[Assets]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		IF (OBJECT_ID(N'[dbo].[RG_Recovery_1_Assets]', 'U') IS NOT NULL) AND (OBJECT_ID(N'[dbo].[Assets]', 'U') IS NULL)
		EXEC sp_rename N'[dbo].[RG_Recovery_1_Assets]', N'Assets', N'OBJECT'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		EXEC sp_rename N'[dbo].[Assets].[RG_Recovery_68b5_PK_Assets]', N'PK_Assets', N'INDEX'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Creating index [IDX_Assets_tAddTime] on [dbo].[Assets]'

		IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Assets_tAddTime' AND object_id = OBJECT_ID(N'[dbo].[Assets]'))
		CREATE CLUSTERED INDEX [IDX_Assets_tAddTime] ON [dbo].[Assets] ([tAddTime])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Creating index [IDX_Assets_cBarcode] on [dbo].[Assets]'

		IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Assets_cBarcode' AND object_id = OBJECT_ID(N'[dbo].[Assets]'))
		CREATE NONCLUSTERED INDEX [IDX_Assets_cBarcode] ON [dbo].[Assets] ([cBarcode])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Creating index [IDX_Assets_04] on [dbo].[Assets]'

		IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Assets_04' AND object_id = OBJECT_ID(N'[dbo].[Assets]'))
		CREATE NONCLUSTERED INDEX [IDX_Assets_04] ON [dbo].[Assets] ([nAssetUID], [lDeleted], [lActive], [nInventoryByUID]) INCLUDE ([cAssignedGroup], [cBarcode], [tSystemUpdateTime], [tUpdateTime], [tWarrantyDate], [tAssignedGroupDate], [tInServiceDate], [tInventoryDate], [tMobileTime], [tPurchaseDate], [tStatusDate], [nSubCategoryUID], [nTypeUID], [nUpdateFacilityUID], [nUpdateUserUID], [nUseCount], [tAddTime], [nItemCost], [nMaintenanceFacUID], [nManufacturerUID], [nParentUID], [nQuantity], [nReplacementCost], [nAssignedFacUID], [nAuthorizedFacUID], [nCategoryUID], [nDepartmentUID], [nFacilityUID], [nImportUID], [mNotes], [mUncertaintyNotes], [mWarrantyInfo], [nAbeyanceInterval], [nAddFacilityUID], [nAddUserUID], [lInAbeyance], [lNonTracked], [lOnSite], [lRecallMaintenanceType], [lStandard], [mAccuracy], [cStatus], [cStockNumber], [cWeight], [cWeightUOM], [lAdded], [lApproved], [cID], [cModelNumber], [cPartNumber], [cPhysicalLocation], [cSerialNumber], [cStandardType], [cClass], [cDescription], [cDimension], [cDisposition], [cFamily], [cGroup])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Creating index [IDX_Assets_10] on [dbo].[Assets]'

		IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Assets_10' AND object_id = OBJECT_ID(N'[dbo].[Assets]'))
		CREATE NONCLUSTERED INDEX [IDX_Assets_10] ON [dbo].[Assets] ([nAssetUID], [lDeleted], [lActive], [nParentUID], [nSubCategoryUID], [nCategoryUID], [nFacilityUID], [nManufacturerUID], [nDepartmentUID], [cBarcode]) INCLUDE ([lNonTracked], [lRecallMaintenanceType], [lStandard], [cGroup], [cID], [cModelNumber], [cPartNumber], [cPhysicalLocation], [cSerialNumber], [cDescription], [cDisposition])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Creating index [IDX_Assets_03] on [dbo].[Assets]'

		IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Assets_03' AND object_id = OBJECT_ID(N'[dbo].[Assets]'))
		CREATE NONCLUSTERED INDEX [IDX_Assets_03] ON [dbo].[Assets] ([nAssetUID], [nInventoryByUID], [cBarcode])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Creating index [IDX_Assets_04_2] on [dbo].[Assets]'

		IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Assets_04_2' AND object_id = OBJECT_ID(N'[dbo].[Assets]'))
		CREATE NONCLUSTERED INDEX [IDX_Assets_04_2] ON [dbo].[Assets] ([nAssetUID], [nInventoryByUID], [cBarcode], [nManufacturerUID]) INCLUDE ([cDescription], [cID], [cModelNumber], [cSerialNumber])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Creating index [IDX_Assets_03_2] on [dbo].[Assets]'

		IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Assets_03_2' AND object_id = OBJECT_ID(N'[dbo].[Assets]'))
		CREATE NONCLUSTERED INDEX [IDX_Assets_03_2] ON [dbo].[Assets] ([nAssetUID], [nParentUID], [nManufacturerUID]) INCLUDE ([cBarcode], [cDescription], [cID], [cModelNumber], [cPartNumber], [cPhysicalLocation], [cSerialNumber], [nQuantity], [nTypeUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Creating index [IDX_Assets_nInventoryByUID] on [dbo].[Assets]'

		IF NOT EXISTS (SELECT 1 FROM sys.indexes WHERE name = N'IDX_Assets_nInventoryByUID' AND object_id = OBJECT_ID(N'[dbo].[Assets]'))
		CREATE NONCLUSTERED INDEX [IDX_Assets_nInventoryByUID] ON [dbo].[Assets] ([nInventoryByUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END



		PRINT N'Adding foreign keys to [dbo].[AssetFiles]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AssetFiles_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[AssetFiles]', 'U'))
		ALTER TABLE [dbo].[AssetFiles] ADD CONSTRAINT [FK_AssetFiles_Assets] FOREIGN KEY ([nAssetUID]) REFERENCES [dbo].[Assets] ([nAssetUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Adding foreign keys to [dbo].[Assets]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] ADD CONSTRAINT [FK_Assets_Assets] FOREIGN KEY ([nParentUID]) REFERENCES [dbo].[Assets] ([nAssetUID])

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_Category]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] ADD CONSTRAINT [FK_Assets_Category] FOREIGN KEY ([nCategoryUID]) REFERENCES [dbo].[Category] ([nCategoryUID])

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_Facilities]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] ADD CONSTRAINT [FK_Assets_Facilities] FOREIGN KEY ([nFacilityUID]) REFERENCES [dbo].[Facilities] ([nFacilityUID])

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_FacilitiesAssignedFac]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] ADD CONSTRAINT [FK_Assets_FacilitiesAssignedFac] FOREIGN KEY ([nAssignedFacUID]) REFERENCES [dbo].[Facilities] ([nFacilityUID])

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_FacilitiesAuthorizedFac]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] ADD CONSTRAINT [FK_Assets_FacilitiesAuthorizedFac] FOREIGN KEY ([nAuthorizedFacUID]) REFERENCES [dbo].[Facilities] ([nFacilityUID])

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_FacilitiesDepartment]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] ADD CONSTRAINT [FK_Assets_FacilitiesDepartment] FOREIGN KEY ([nDepartmentUID]) REFERENCES [dbo].[Facilities] ([nFacilityUID])

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_FacilitiesMaintenanceFac]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] ADD CONSTRAINT [FK_Assets_FacilitiesMaintenanceFac] FOREIGN KEY ([nMaintenanceFacUID]) REFERENCES [dbo].[Facilities] ([nFacilityUID])

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_FacilitiesManufacturer]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] ADD CONSTRAINT [FK_Assets_FacilitiesManufacturer] FOREIGN KEY ([nManufacturerUID]) REFERENCES [dbo].[Facilities] ([nFacilityUID])

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_SubCategory]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] ADD CONSTRAINT [FK_Assets_SubCategory] FOREIGN KEY ([nSubCategoryUID]) REFERENCES [dbo].[SubCategory] ([nSubCategoryUID])

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_Types]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] ADD CONSTRAINT [FK_Assets_Types] FOREIGN KEY ([nTypeUID]) REFERENCES [dbo].[Types] ([nTypeUID])

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_Assets_Users]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[Assets]', 'U'))
		ALTER TABLE [dbo].[Assets] ADD CONSTRAINT [FK_Assets_Users] FOREIGN KEY ([nInventoryByUID]) REFERENCES [dbo].[Users] ([nUserUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Adding foreign keys to [dbo].[AssetEx]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AssetEx_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[AssetEx]', 'U'))
		ALTER TABLE [dbo].[AssetEx] ADD CONSTRAINT [FK_AssetEx_Assets] FOREIGN KEY ([nAssetUID]) REFERENCES [dbo].[Assets] ([nAssetUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Adding foreign keys to [dbo].[AssetLog]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AssetLog_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[AssetLog]', 'U'))
		ALTER TABLE [dbo].[AssetLog] ADD CONSTRAINT [FK_AssetLog_Assets] FOREIGN KEY ([nAssetUID]) REFERENCES [dbo].[Assets] ([nAssetUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Adding foreign keys to [dbo].[AssetServices]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_AssetServices_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[AssetServices]', 'U'))
		ALTER TABLE [dbo].[AssetServices] ADD CONSTRAINT [FK_AssetServices_Assets] FOREIGN KEY ([nAssetUID]) REFERENCES [dbo].[Assets] ([nAssetUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Adding foreign keys to [dbo].[CallSheets]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheets_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheets]', 'U'))
		ALTER TABLE [dbo].[CallSheets] ADD CONSTRAINT [FK_CallSheets_Assets] FOREIGN KEY ([nAssetUID]) REFERENCES [dbo].[Assets] ([nAssetUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Adding foreign keys to [dbo].[CallSheetStandardLink]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_CallSheetStandardLink_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[CallSheetStandardLink]', 'U'))
		ALTER TABLE [dbo].[CallSheetStandardLink] ADD CONSTRAINT [FK_CallSheetStandardLink_Assets] FOREIGN KEY ([nAssetUID]) REFERENCES [dbo].[Assets] ([nAssetUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Adding foreign keys to [dbo].[PointReadings]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PointReadings_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[PointReadings]', 'U'))
		ALTER TABLE [dbo].[PointReadings] ADD CONSTRAINT [FK_PointReadings_Assets] FOREIGN KEY ([nAssetUID]) REFERENCES [dbo].[Assets] ([nAssetUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Adding foreign keys to [dbo].[PointStandardReadings]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PointStandardReadings_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[PointStandardReadings]', 'U'))
		ALTER TABLE [dbo].[PointStandardReadings] ADD CONSTRAINT [FK_PointStandardReadings_Assets] FOREIGN KEY ([nAssetUID]) REFERENCES [dbo].[Assets] ([nAssetUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Adding foreign keys to [dbo].[PointStandards]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PointStandards_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[PointStandards]', 'U'))
		ALTER TABLE [dbo].[PointStandards] ADD CONSTRAINT [FK_PointStandards_Assets] FOREIGN KEY ([nAssetUID]) REFERENCES [dbo].[Assets] ([nAssetUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Adding foreign keys to [dbo].[ToolAssignments]'

		IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_ToolAssignment_Assets]','F') AND parent_object_id = OBJECT_ID(N'[dbo].[ToolAssignments]', 'U'))
		ALTER TABLE [dbo].[ToolAssignments] ADD CONSTRAINT [FK_ToolAssignment_Assets] FOREIGN KEY ([nAssetUID]) REFERENCES [dbo].[Assets] ([nAssetUID])

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


		PRINT N'Creating extended properties'

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', NULL, NULL))
		EXEC sp_addextendedproperty N'MS_Description', N'Contains information about assets in the system that maintenance is performed against', 'SCHEMA', N'dbo', 'TABLE', N'Assets', NULL, NULL

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cAssignedGroup'))
		EXEC sp_addextendedproperty N'MS_Description', N'Customer assigned grouping - used for such things as tool rooms, ship board assignments, syscal, etc.', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cAssignedGroup'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cBarcode'))
		EXEC sp_addextendedproperty N'MS_Description', N'Unique Barcode assigned to this asset', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cBarcode'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cClass'))
		EXEC sp_addextendedproperty N'MS_Description', N'Customer defined class of asset - may indicate funding type, usage, etc.', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cClass'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cDescription'))
		EXEC sp_addextendedproperty N'MS_Description', N'Description of asset - originally brought forward from the type table', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cDescription'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cDimension'))
		EXEC sp_addextendedproperty N'MS_Description', N'Dimensions of Asset', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cDimension'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cDisposition'))
		EXEC sp_addextendedproperty N'MS_Description', N'Customer disposition of Asset - Active, Lost, DRMO, Inactive, etc.', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cDisposition'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cFamily'))
		EXEC sp_addextendedproperty N'MS_Description', N'Customer defined grouping mechanism', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cFamily'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cGroup'))
		EXEC sp_addextendedproperty N'MS_Description', N'Customer defined group - Electronic, Dimenstional, Flow, etc.', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cGroup'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Customer ID number', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cModelNumber'))
		EXEC sp_addextendedproperty N'MS_Description', N'Manufacturers model number', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cModelNumber'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cPartNumber'))
		EXEC sp_addextendedproperty N'MS_Description', N'Manufacturers or customers part number', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cPartNumber'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cPhysicalLocation'))
		EXEC sp_addextendedproperty N'MS_Description', N'Physical location at the facility site', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cPhysicalLocation'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cSerialNumber'))
		EXEC sp_addextendedproperty N'MS_Description', N'Manufacturers or customers serial number', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cSerialNumber'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cStandardType'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates type of standard - Critical, high use, reference, type one, type two, etc.', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cStandardType'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cStatus'))
		EXEC sp_addextendedproperty N'MS_Description', N'Status from any open call sheets.', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cStatus'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cStockNumber'))
		EXEC sp_addextendedproperty N'MS_Description', N'Customer Stock number (NSN)', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cStockNumber'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cWeight'))
		EXEC sp_addextendedproperty N'MS_Description', N'Weight of asset', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cWeight'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cWeightUOM'))
		EXEC sp_addextendedproperty N'MS_Description', N'Unit of measure for weight', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'cWeightUOM'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lActive'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=inactive; -1 or 1=active', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lActive'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lAdded'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not added; -1 or 1=added', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lAdded'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lApproved'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not approved; -1 or 1=approved', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lApproved'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lDeleted'))
		EXEC sp_addextendedproperty N'MS_Description', N'0=not deleted; -1 or 1=deleted', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lDeleted'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lInAbeyance'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates if this asset is in abeyance', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lInAbeyance'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lNonTracked'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates if the asset is to be ignored by the system for maintenance', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lNonTracked'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lOnSite'))
		EXEC sp_addextendedproperty N'MS_Description', N'Determines if asset maintenance has to be done on site', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lOnSite'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lRecallMaintenanceType'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates if this asset is to be considered for recall (-1), if skipped on recal report value will be (0)', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lRecallMaintenanceType'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lStandard'))
		EXEC sp_addextendedproperty N'MS_Description', N'Indicates if this asset is a standard.', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'lStandard'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'mAccuracy'))
		EXEC sp_addextendedproperty N'MS_Description', N'Accuracy information', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'mAccuracy'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'mNotes'))
		EXEC sp_addextendedproperty N'MS_Description', N'Notes about the asset', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'mNotes'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'mUncertaintyNotes'))
		EXEC sp_addextendedproperty N'MS_Description', N'Uncertainty information.', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'mUncertaintyNotes'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'mWarrantyInfo'))
		EXEC sp_addextendedproperty N'MS_Description', N'Information about the warrenty', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'mWarrantyInfo'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAbeyanceInterval'))
		EXEC sp_addextendedproperty N'MS_Description', N'Abeyance interval set up value', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAbeyanceInterval'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAddFacilityUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the server that added the record', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAddFacilityUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAddUserUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the user that added the record', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAddUserUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAssetUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Unique identifier for the asset used only by the system', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAssetUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAssignedFacUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Relates to facilities - indicates the facility that assigns maintenance for this asset', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAssignedFacUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAuthorizedFacUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Relates to facilities - indicates the facility that is authorizing maintenance for this asset', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nAuthorizedFacUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nCategoryUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Relates to category table - indicates asset category', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nCategoryUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nDepartmentUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Relates to Facility table - indicates the department responsible for the asset', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nDepartmentUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nFacilityUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Relates to Facility table - indicates the owner of the asset', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nFacilityUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nImportUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'If imported, contains UID of the import record', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nImportUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nInventoryByUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Relates to Users - indicates who last inventoried this asset', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nInventoryByUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nItemCost'))
		EXEC sp_addextendedproperty N'MS_Description', N'Cost of the item', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nItemCost'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nMaintenanceFacUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Relates to facilities - indicates the facility that is supposed to perform maintenance on this asset', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nMaintenanceFacUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nManufacturerUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Relates to Facilities table to indicate asset manufacturer', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nManufacturerUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nParentUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Relates to asset table - indicates UID of asset''s parent', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nParentUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nQuantity'))
		EXEC sp_addextendedproperty N'MS_Description', N'Quantity of pieces in asset', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nQuantity'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nReplacementCost'))
		EXEC sp_addextendedproperty N'MS_Description', N'Cost to replace the asset - today', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nReplacementCost'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nSubCategoryUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Relates to sub category table - indicates sub category of asset', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nSubCategoryUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nTypeUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'Relates to the type table - UID of record used to create the asset when the asset was entered into the system', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nTypeUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nUpdateFacilityUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the server that last updated the record', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nUpdateFacilityUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nUpdateUserUID'))
		EXEC sp_addextendedproperty N'MS_Description', N'UID of the last user to update the record', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nUpdateUserUID'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nUseCount'))
		EXEC sp_addextendedproperty N'MS_Description', N'Times the asset has been used', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'nUseCount'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tAddTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was added', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tAddTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tAssignedGroupDate'))
		EXEC sp_addextendedproperty N'MS_Description', N'Date the item was assigned to a group ties to cAssignedGroup', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tAssignedGroupDate'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tInServiceDate'))
		EXEC sp_addextendedproperty N'MS_Description', N'Date item was placed into service', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tInServiceDate'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tInventoryDate'))
		EXEC sp_addextendedproperty N'MS_Description', N'Date the item was inventoried', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tInventoryDate'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tMobileTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated for Mobile mode', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tMobileTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tPurchaseDate'))
		EXEC sp_addextendedproperty N'MS_Description', N'Date the item was purchased', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tPurchaseDate'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tStatusDate'))
		EXEC sp_addextendedproperty N'MS_Description', N'Date of the last status - ties to cStatus', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tStatusDate'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tSystemUpdateTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated for the Warehouse', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tSystemUpdateTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tUpdateTime'))
		EXEC sp_addextendedproperty N'MS_Description', N'Time the record was last updated', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tUpdateTime'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

		IF NOT EXISTS (SELECT 1 FROM fn_listextendedproperty(N'MS_Description', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tWarrantyDate'))
		EXEC sp_addextendedproperty N'MS_Description', N'Date the warrenty expires', 'SCHEMA', N'dbo', 'TABLE', N'Assets', 'COLUMN', N'tWarrantyDate'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '30712e1a-2ef0-49a7-8b3f-5a17a13936cf')
	    BEGIN
	        PRINT 'Adding column [Assets].[cAssignedContact] to [AuditColumns]'

	        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
	        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
	        VALUES ('30712e1a-2ef0-49a7-8b3f-5a17a13936cf', 3, 3076, N'cAssignedContact', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20211005 16:35:49', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20211005 16:35:49', '20211005 16:35:49', NULL, NULL)
	        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    END

	    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '5bfbf37e-3fbd-4b18-a15a-354e7d370de5')
	    BEGIN
	        PRINT 'Adding column [Assets].[cOptional1] to [AuditColumns]'

	        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
	        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
	        VALUES ('5bfbf37e-3fbd-4b18-a15a-354e7d370de5', 3, 3077, N'cOptional1', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20211005 16:39:19', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20211005 16:39:19', '20211005 16:39:19', NULL, NULL)
	        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    END

	    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '2b060d94-572c-46a1-ba73-c669f1469db2')
	    BEGIN
	        PRINT 'Adding column [Assets].[lOptional] to [AuditColumns]'

	        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
	        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
	        VALUES ('2b060d94-572c-46a1-ba73-c669f1469db2', 3, 3078, N'lOptional', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20211005 16:39:50', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20211005 16:39:50', '20211005 16:39:50', NULL, NULL)
	        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    END

	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Assets_Del]', 'TR') IS NOT NULL
	    BEGIN
	    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Assets_Del] from [dbo].[Assets]'

	    	DROP TRIGGER [dbo].[tr_kr_audit_Assets_Del]


	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Assets_Del]', 'TR') IS NULL
	    BEGIN
	        PRINT N'Creating trigger [dbo].[tr_kr_audit_Assets_Del] on [dbo].[Assets]'

	        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Assets_Del] ON [dbo].[Assets] FOR DELETE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20211005 16:40:27

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM DELETED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            3076,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cAssignedContact], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            3,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cAssignedGroup], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            4,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cBarcode], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            5,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cClass], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            6,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cDescription], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            7,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cDimension], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            8,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cDisposition], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            9,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFamily], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            10,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cGroup], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            11,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cID], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            14,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cModelNumber], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            3077,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cOptional1], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            16,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cPartNumber], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            17,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cPhysicalLocation], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            18,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cSerialNumber], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            19,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cStandardType], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            20,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cStatus], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            21,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cStockNumber], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            22,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cWeight], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            23,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cWeightUOM], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            24,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            25,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            26,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            27,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            28,
            0,
            CONVERT(NVARCHAR, [lInAbeyance])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            29,
            0,
            CONVERT(NVARCHAR, [lNonTracked])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            30,
            0,
            CONVERT(NVARCHAR, [lOnSite])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            3078,
            0,
            CONVERT(NVARCHAR, [lOptional])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            31,
            0,
            CONVERT(NVARCHAR, [lRecallMaintenanceType])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            32,
            0,
            CONVERT(NVARCHAR, [lStandard])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            33,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mAccuracy], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            34,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mNotes], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            35,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mUncertaintyNotes], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            36,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mWarrantyInfo], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            37,
            0,
            CONVERT(NVARCHAR, [nAbeyanceInterval])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            38,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            39,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            40,
            0,
            CONVERT(NVARCHAR( 36 ), [nAssetUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            41,
            0,
            CONVERT(NVARCHAR( 36 ), [nAssignedFacUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            42,
            0,
            CONVERT(NVARCHAR( 36 ), [nAuthorizedFacUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            43,
            0,
            CONVERT(NVARCHAR( 36 ), [nCategoryUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            44,
            0,
            CONVERT(NVARCHAR( 36 ), [nDepartmentUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            45,
            0,
            CONVERT(NVARCHAR( 36 ), [nFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            367,
            0,
            CONVERT(NVARCHAR( 36 ), [nImportUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            46,
            0,
            CONVERT(NVARCHAR( 36 ), [nInventoryByUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            47,
            0,
            CONVERT( NVARCHAR( 41 ), [nItemCost], 2 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            48,
            0,
            CONVERT(NVARCHAR( 36 ), [nMaintenanceFacUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            49,
            0,
            CONVERT(NVARCHAR( 36 ), [nManufacturerUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            50,
            0,
            CONVERT(NVARCHAR( 36 ), [nParentUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            51,
            0,
            CONVERT(NVARCHAR, [nQuantity])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            52,
            0,
            CONVERT( NVARCHAR( 41 ), [nReplacementCost], 2 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            53,
            0,
            CONVERT(NVARCHAR( 36 ), [nSubCategoryUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            54,
            0,
            CONVERT(NVARCHAR( 36 ), [nTypeUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            55,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            56,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            57,
            0,
            CONVERT(NVARCHAR, [nUseCount])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            58,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            59,
            0,
            CONVERT( NVARCHAR( 34 ), [tAssignedGroupDate], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            60,
            0,
            CONVERT( NVARCHAR( 34 ), [tInServiceDate], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            61,
            0,
            CONVERT( NVARCHAR( 34 ), [tInventoryDate], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            62,
            0,
            CONVERT( NVARCHAR( 34 ), [tMobileTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            64,
            0,
            CONVERT( NVARCHAR( 34 ), [tPurchaseDate], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            65,
            0,
            CONVERT( NVARCHAR( 34 ), [tStatusDate], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            66,
            0,
            CONVERT( NVARCHAR( 34 ), [tSystemUpdateTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            67,
            0,
            CONVERT( NVARCHAR( 34 ), [tUpdateTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            68,
            0,
            CONVERT( NVARCHAR( 34 ), [tWarrantyDate], 121 )
        FROM
            DELETED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 3, @RowsAffected, ''D'', @AuditedUser
    END
END
'

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Assets_Del]', 'last', 'delete', null

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Assets_Ins]', 'TR') IS NOT NULL
	    BEGIN
	    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Assets_Ins] from [dbo].[Assets]'

	    	DROP TRIGGER [dbo].[tr_kr_audit_Assets_Ins]


	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Assets_Ins]', 'TR') IS NULL
	    BEGIN
	        PRINT N'Creating trigger [dbo].[tr_kr_audit_Assets_Ins] on [dbo].[Assets]'

	        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Assets_Ins] ON [dbo].[Assets] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20211005 16:40:27

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            3076,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cAssignedContact], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            3,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cAssignedGroup], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            4,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cBarcode], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            5,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cClass], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            6,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cDescription], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            7,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cDimension], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            8,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cDisposition], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            9,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFamily], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            10,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cGroup], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            11,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cID], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            14,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cModelNumber], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            3077,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cOptional1], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            16,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cPartNumber], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            17,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cPhysicalLocation], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            18,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cSerialNumber], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            19,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cStandardType], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            20,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cStatus], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            21,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cStockNumber], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            22,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cWeight], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            23,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cWeightUOM], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            24,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            25,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            26,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            27,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            28,
            0,
            CONVERT(NVARCHAR, [lInAbeyance])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            29,
            0,
            CONVERT(NVARCHAR, [lNonTracked])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            30,
            0,
            CONVERT(NVARCHAR, [lOnSite])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            3078,
            0,
            CONVERT(NVARCHAR, [lOptional])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            31,
            0,
            CONVERT(NVARCHAR, [lRecallMaintenanceType])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            32,
            0,
            CONVERT(NVARCHAR, [lStandard])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            33,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mAccuracy], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            34,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            35,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mUncertaintyNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            36,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mWarrantyInfo], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            37,
            0,
            CONVERT(NVARCHAR, [nAbeyanceInterval])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            38,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            39,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            40,
            0,
            CONVERT(NVARCHAR( 36 ), [nAssetUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            41,
            0,
            CONVERT(NVARCHAR( 36 ), [nAssignedFacUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            42,
            0,
            CONVERT(NVARCHAR( 36 ), [nAuthorizedFacUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            43,
            0,
            CONVERT(NVARCHAR( 36 ), [nCategoryUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            44,
            0,
            CONVERT(NVARCHAR( 36 ), [nDepartmentUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            45,
            0,
            CONVERT(NVARCHAR( 36 ), [nFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            46,
            0,
            CONVERT(NVARCHAR( 36 ), [nInventoryByUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            47,
            0,
            CONVERT( NVARCHAR( 41 ), [nItemCost], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            48,
            0,
            CONVERT(NVARCHAR( 36 ), [nMaintenanceFacUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            49,
            0,
            CONVERT(NVARCHAR( 36 ), [nManufacturerUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            50,
            0,
            CONVERT(NVARCHAR( 36 ), [nParentUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            51,
            0,
            CONVERT(NVARCHAR, [nQuantity])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            52,
            0,
            CONVERT( NVARCHAR( 41 ), [nReplacementCost], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            53,
            0,
            CONVERT(NVARCHAR( 36 ), [nSubCategoryUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            54,
            0,
            CONVERT(NVARCHAR( 36 ), [nTypeUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            57,
            0,
            CONVERT(NVARCHAR, [nUseCount])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            58,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            59,
            0,
            CONVERT( NVARCHAR( 34 ), [tAssignedGroupDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            60,
            0,
            CONVERT( NVARCHAR( 34 ), [tInServiceDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            61,
            0,
            CONVERT( NVARCHAR( 34 ), [tInventoryDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            64,
            0,
            CONVERT( NVARCHAR( 34 ), [tPurchaseDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            65,
            0,
            CONVERT( NVARCHAR( 34 ), [tStatusDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            68,
            0,
            CONVERT( NVARCHAR( 34 ), [tWarrantyDate], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 3, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL
    END
END
'

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Assets_Ins]', 'last', 'insert', null

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Assets_Upd]', 'TR') IS NOT NULL
	    BEGIN
	    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Assets_Upd] from [dbo].[Assets]'

	    	DROP TRIGGER [dbo].[tr_kr_audit_Assets_Upd]


	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	    END


	    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Assets_Upd]', 'TR') IS NULL
	    BEGIN
	        PRINT N'Creating trigger [dbo].[tr_kr_audit_Assets_Upd] on [dbo].[Assets]'

	        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Assets_Upd] ON [dbo].[Assets] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20211005 16:40:27

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cAssignedContact] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                3076,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cAssignedContact], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cAssignedContact], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cAssignedContact], '''') <> NULLIF(i.[cAssignedContact], '''') ) OR
                ( NULLIF(d.[cAssignedContact], '''') IS NULL AND NULLIF(i.[cAssignedContact], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cAssignedContact], '''') IS NULL AND NULLIF(d.[cAssignedContact], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cAssignedGroup] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                3,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cAssignedGroup], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cAssignedGroup], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cAssignedGroup], '''') <> NULLIF(i.[cAssignedGroup], '''') ) OR
                ( NULLIF(d.[cAssignedGroup], '''') IS NULL AND NULLIF(i.[cAssignedGroup], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cAssignedGroup], '''') IS NULL AND NULLIF(d.[cAssignedGroup], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cBarcode] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                4,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cBarcode], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cBarcode], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cBarcode], '''') <> NULLIF(i.[cBarcode], '''') ) OR
                ( NULLIF(d.[cBarcode], '''') IS NULL AND NULLIF(i.[cBarcode], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cBarcode], '''') IS NULL AND NULLIF(d.[cBarcode], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cClass] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                5,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cClass], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cClass], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cClass], '''') <> NULLIF(i.[cClass], '''') ) OR
                ( NULLIF(d.[cClass], '''') IS NULL AND NULLIF(i.[cClass], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cClass], '''') IS NULL AND NULLIF(d.[cClass], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cDescription] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                6,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cDescription], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cDescription], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cDescription], '''') <> NULLIF(i.[cDescription], '''') ) OR
                ( NULLIF(d.[cDescription], '''') IS NULL AND NULLIF(i.[cDescription], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cDescription], '''') IS NULL AND NULLIF(d.[cDescription], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cDimension] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                7,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cDimension], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cDimension], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cDimension], '''') <> NULLIF(i.[cDimension], '''') ) OR
                ( NULLIF(d.[cDimension], '''') IS NULL AND NULLIF(i.[cDimension], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cDimension], '''') IS NULL AND NULLIF(d.[cDimension], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cDisposition] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                8,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cDisposition], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cDisposition], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cDisposition], '''') <> NULLIF(i.[cDisposition], '''') ) OR
                ( NULLIF(d.[cDisposition], '''') IS NULL AND NULLIF(i.[cDisposition], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cDisposition], '''') IS NULL AND NULLIF(d.[cDisposition], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cFamily] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                9,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cFamily], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cFamily], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cFamily], '''') <> NULLIF(i.[cFamily], '''') ) OR
                ( NULLIF(d.[cFamily], '''') IS NULL AND NULLIF(i.[cFamily], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cFamily], '''') IS NULL AND NULLIF(d.[cFamily], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cGroup] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                10,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cGroup], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cGroup], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cGroup], '''') <> NULLIF(i.[cGroup], '''') ) OR
                ( NULLIF(d.[cGroup], '''') IS NULL AND NULLIF(i.[cGroup], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cGroup], '''') IS NULL AND NULLIF(d.[cGroup], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                11,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cID], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cID], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cID], '''') <> NULLIF(i.[cID], '''') ) OR
                ( NULLIF(d.[cID], '''') IS NULL AND NULLIF(i.[cID], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cID], '''') IS NULL AND NULLIF(d.[cID], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cModelNumber] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                14,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cModelNumber], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cModelNumber], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cModelNumber], '''') <> NULLIF(i.[cModelNumber], '''') ) OR
                ( NULLIF(d.[cModelNumber], '''') IS NULL AND NULLIF(i.[cModelNumber], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cModelNumber], '''') IS NULL AND NULLIF(d.[cModelNumber], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cOptional1] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                3077,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cOptional1], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cOptional1], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cOptional1], '''') <> NULLIF(i.[cOptional1], '''') ) OR
                ( NULLIF(d.[cOptional1], '''') IS NULL AND NULLIF(i.[cOptional1], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cOptional1], '''') IS NULL AND NULLIF(d.[cOptional1], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cPartNumber] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                16,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cPartNumber], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cPartNumber], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cPartNumber], '''') <> NULLIF(i.[cPartNumber], '''') ) OR
                ( NULLIF(d.[cPartNumber], '''') IS NULL AND NULLIF(i.[cPartNumber], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cPartNumber], '''') IS NULL AND NULLIF(d.[cPartNumber], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cPhysicalLocation] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                17,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cPhysicalLocation], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cPhysicalLocation], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cPhysicalLocation], '''') <> NULLIF(i.[cPhysicalLocation], '''') ) OR
                ( NULLIF(d.[cPhysicalLocation], '''') IS NULL AND NULLIF(i.[cPhysicalLocation], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cPhysicalLocation], '''') IS NULL AND NULLIF(d.[cPhysicalLocation], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cSerialNumber] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                18,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cSerialNumber], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cSerialNumber], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cSerialNumber], '''') <> NULLIF(i.[cSerialNumber], '''') ) OR
                ( NULLIF(d.[cSerialNumber], '''') IS NULL AND NULLIF(i.[cSerialNumber], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cSerialNumber], '''') IS NULL AND NULLIF(d.[cSerialNumber], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cStandardType] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                19,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cStandardType], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cStandardType], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cStandardType], '''') <> NULLIF(i.[cStandardType], '''') ) OR
                ( NULLIF(d.[cStandardType], '''') IS NULL AND NULLIF(i.[cStandardType], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cStandardType], '''') IS NULL AND NULLIF(d.[cStandardType], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cStatus] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                20,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cStatus], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cStatus], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cStatus], '''') <> NULLIF(i.[cStatus], '''') ) OR
                ( NULLIF(d.[cStatus], '''') IS NULL AND NULLIF(i.[cStatus], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cStatus], '''') IS NULL AND NULLIF(d.[cStatus], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cStockNumber] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                21,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cStockNumber], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cStockNumber], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cStockNumber], '''') <> NULLIF(i.[cStockNumber], '''') ) OR
                ( NULLIF(d.[cStockNumber], '''') IS NULL AND NULLIF(i.[cStockNumber], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cStockNumber], '''') IS NULL AND NULLIF(d.[cStockNumber], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cWeight] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                22,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cWeight], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cWeight], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cWeight], '''') <> NULLIF(i.[cWeight], '''') ) OR
                ( NULLIF(d.[cWeight], '''') IS NULL AND NULLIF(i.[cWeight], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cWeight], '''') IS NULL AND NULLIF(d.[cWeight], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cWeightUOM] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                23,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cWeightUOM], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cWeightUOM], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cWeightUOM], '''') <> NULLIF(i.[cWeightUOM], '''') ) OR
                ( NULLIF(d.[cWeightUOM], '''') IS NULL AND NULLIF(i.[cWeightUOM], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cWeightUOM], '''') IS NULL AND NULLIF(d.[cWeightUOM], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                24,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                25,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                26,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                27,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lInAbeyance] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                28,
                0,
                CONVERT(NVARCHAR, d.[lInAbeyance]),
                CONVERT(NVARCHAR, i.[lInAbeyance])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[lInAbeyance] <> i.[lInAbeyance] ) OR
                ( d.[lInAbeyance] IS NULL AND i.[lInAbeyance] IS NOT NULL ) OR
                ( i.[lInAbeyance] IS NULL AND d.[lInAbeyance] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lNonTracked] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                29,
                0,
                CONVERT(NVARCHAR, d.[lNonTracked]),
                CONVERT(NVARCHAR, i.[lNonTracked])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[lNonTracked] <> i.[lNonTracked] ) OR
                ( d.[lNonTracked] IS NULL AND i.[lNonTracked] IS NOT NULL ) OR
                ( i.[lNonTracked] IS NULL AND d.[lNonTracked] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lOnSite] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                30,
                0,
                CONVERT(NVARCHAR, d.[lOnSite]),
                CONVERT(NVARCHAR, i.[lOnSite])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[lOnSite] <> i.[lOnSite] ) OR
                ( d.[lOnSite] IS NULL AND i.[lOnSite] IS NOT NULL ) OR
                ( i.[lOnSite] IS NULL AND d.[lOnSite] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lOptional] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                3078,
                0,
                CONVERT(NVARCHAR, d.[lOptional]),
                CONVERT(NVARCHAR, i.[lOptional])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[lOptional] <> i.[lOptional] ) OR
                ( d.[lOptional] IS NULL AND i.[lOptional] IS NOT NULL ) OR
                ( i.[lOptional] IS NULL AND d.[lOptional] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lRecallMaintenanceType] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                31,
                0,
                CONVERT(NVARCHAR, d.[lRecallMaintenanceType]),
                CONVERT(NVARCHAR, i.[lRecallMaintenanceType])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[lRecallMaintenanceType] <> i.[lRecallMaintenanceType] ) OR
                ( d.[lRecallMaintenanceType] IS NULL AND i.[lRecallMaintenanceType] IS NOT NULL ) OR
                ( i.[lRecallMaintenanceType] IS NULL AND d.[lRecallMaintenanceType] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lStandard] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                32,
                0,
                CONVERT(NVARCHAR, d.[lStandard]),
                CONVERT(NVARCHAR, i.[lStandard])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[lStandard] <> i.[lStandard] ) OR
                ( d.[lStandard] IS NULL AND i.[lStandard] IS NOT NULL ) OR
                ( i.[lStandard] IS NULL AND d.[lStandard] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mAccuracy] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                33,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mAccuracy], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mAccuracy], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[mAccuracy], '''') <> NULLIF(i.[mAccuracy], '''') ) OR
                ( NULLIF(d.[mAccuracy], '''') IS NULL AND NULLIF(i.[mAccuracy], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mAccuracy], '''') IS NULL AND NULLIF(d.[mAccuracy], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                34,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[mNotes], '''') <> NULLIF(i.[mNotes], '''') ) OR
                ( NULLIF(d.[mNotes], '''') IS NULL AND NULLIF(i.[mNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mNotes], '''') IS NULL AND NULLIF(d.[mNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mUncertaintyNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                35,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mUncertaintyNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mUncertaintyNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[mUncertaintyNotes], '''') <> NULLIF(i.[mUncertaintyNotes], '''') ) OR
                ( NULLIF(d.[mUncertaintyNotes], '''') IS NULL AND NULLIF(i.[mUncertaintyNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mUncertaintyNotes], '''') IS NULL AND NULLIF(d.[mUncertaintyNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mWarrantyInfo] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                36,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mWarrantyInfo], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mWarrantyInfo], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[mWarrantyInfo], '''') <> NULLIF(i.[mWarrantyInfo], '''') ) OR
                ( NULLIF(d.[mWarrantyInfo], '''') IS NULL AND NULLIF(i.[mWarrantyInfo], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mWarrantyInfo], '''') IS NULL AND NULLIF(d.[mWarrantyInfo], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAbeyanceInterval] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                37,
                0,
                CONVERT(NVARCHAR, d.[nAbeyanceInterval]),
                CONVERT(NVARCHAR, i.[nAbeyanceInterval])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nAbeyanceInterval] <> i.[nAbeyanceInterval] ) OR
                ( d.[nAbeyanceInterval] IS NULL AND i.[nAbeyanceInterval] IS NOT NULL ) OR
                ( i.[nAbeyanceInterval] IS NULL AND d.[nAbeyanceInterval] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                38,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                39,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAssetUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                40,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAssetUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAssetUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nAssetUID] <> i.[nAssetUID] ) OR
                ( d.[nAssetUID] IS NULL AND i.[nAssetUID] IS NOT NULL ) OR
                ( i.[nAssetUID] IS NULL AND d.[nAssetUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nAssignedFacUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                41,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAssignedFacUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAssignedFacUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nAssignedFacUID] <> i.[nAssignedFacUID] ) OR
                ( d.[nAssignedFacUID] IS NULL AND i.[nAssignedFacUID] IS NOT NULL ) OR
                ( i.[nAssignedFacUID] IS NULL AND d.[nAssignedFacUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAuthorizedFacUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                42,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAuthorizedFacUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAuthorizedFacUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nAuthorizedFacUID] <> i.[nAuthorizedFacUID] ) OR
                ( d.[nAuthorizedFacUID] IS NULL AND i.[nAuthorizedFacUID] IS NOT NULL ) OR
                ( i.[nAuthorizedFacUID] IS NULL AND d.[nAuthorizedFacUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCategoryUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                43,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCategoryUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCategoryUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nCategoryUID] <> i.[nCategoryUID] ) OR
                ( d.[nCategoryUID] IS NULL AND i.[nCategoryUID] IS NOT NULL ) OR
                ( i.[nCategoryUID] IS NULL AND d.[nCategoryUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nDepartmentUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                44,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nDepartmentUID]),
                CONVERT(NVARCHAR( 36 ), i.[nDepartmentUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nDepartmentUID] <> i.[nDepartmentUID] ) OR
                ( d.[nDepartmentUID] IS NULL AND i.[nDepartmentUID] IS NOT NULL ) OR
                ( i.[nDepartmentUID] IS NULL AND d.[nDepartmentUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                45,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nFacilityUID] <> i.[nFacilityUID] ) OR
                ( d.[nFacilityUID] IS NULL AND i.[nFacilityUID] IS NOT NULL ) OR
                ( i.[nFacilityUID] IS NULL AND d.[nFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nInventoryByUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                46,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nInventoryByUID]),
                CONVERT(NVARCHAR( 36 ), i.[nInventoryByUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nInventoryByUID] <> i.[nInventoryByUID] ) OR
                ( d.[nInventoryByUID] IS NULL AND i.[nInventoryByUID] IS NOT NULL ) OR
                ( i.[nInventoryByUID] IS NULL AND d.[nInventoryByUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nItemCost] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                47,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nItemCost], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nItemCost], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nItemCost] <> i.[nItemCost] ) OR
                ( d.[nItemCost] IS NULL AND i.[nItemCost] IS NOT NULL ) OR
                ( i.[nItemCost] IS NULL AND d.[nItemCost] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nMaintenanceFacUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                48,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nMaintenanceFacUID]),
                CONVERT(NVARCHAR( 36 ), i.[nMaintenanceFacUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nMaintenanceFacUID] <> i.[nMaintenanceFacUID] ) OR
                ( d.[nMaintenanceFacUID] IS NULL AND i.[nMaintenanceFacUID] IS NOT NULL ) OR
                ( i.[nMaintenanceFacUID] IS NULL AND d.[nMaintenanceFacUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nManufacturerUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                49,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nManufacturerUID]),
                CONVERT(NVARCHAR( 36 ), i.[nManufacturerUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nManufacturerUID] <> i.[nManufacturerUID] ) OR
                ( d.[nManufacturerUID] IS NULL AND i.[nManufacturerUID] IS NOT NULL ) OR
                ( i.[nManufacturerUID] IS NULL AND d.[nManufacturerUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nParentUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                50,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nParentUID]),
                CONVERT(NVARCHAR( 36 ), i.[nParentUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nParentUID] <> i.[nParentUID] ) OR
                ( d.[nParentUID] IS NULL AND i.[nParentUID] IS NOT NULL ) OR
                ( i.[nParentUID] IS NULL AND d.[nParentUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nQuantity] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                51,
                0,
                CONVERT(NVARCHAR, d.[nQuantity]),
                CONVERT(NVARCHAR, i.[nQuantity])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nQuantity] <> i.[nQuantity] ) OR
                ( d.[nQuantity] IS NULL AND i.[nQuantity] IS NOT NULL ) OR
                ( i.[nQuantity] IS NULL AND d.[nQuantity] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nReplacementCost] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                52,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nReplacementCost], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nReplacementCost], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nReplacementCost] <> i.[nReplacementCost] ) OR
                ( d.[nReplacementCost] IS NULL AND i.[nReplacementCost] IS NOT NULL ) OR
                ( i.[nReplacementCost] IS NULL AND d.[nReplacementCost] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nSubCategoryUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                53,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nSubCategoryUID]),
                CONVERT(NVARCHAR( 36 ), i.[nSubCategoryUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nSubCategoryUID] <> i.[nSubCategoryUID] ) OR
                ( d.[nSubCategoryUID] IS NULL AND i.[nSubCategoryUID] IS NOT NULL ) OR
                ( i.[nSubCategoryUID] IS NULL AND d.[nSubCategoryUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nTypeUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                54,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nTypeUID]),
                CONVERT(NVARCHAR( 36 ), i.[nTypeUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nTypeUID] <> i.[nTypeUID] ) OR
                ( d.[nTypeUID] IS NULL AND i.[nTypeUID] IS NOT NULL ) OR
                ( i.[nTypeUID] IS NULL AND d.[nTypeUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nUseCount] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                57,
                0,
                CONVERT(NVARCHAR, d.[nUseCount]),
                CONVERT(NVARCHAR, i.[nUseCount])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nUseCount] <> i.[nUseCount] ) OR
                ( d.[nUseCount] IS NULL AND i.[nUseCount] IS NOT NULL ) OR
                ( i.[nUseCount] IS NULL AND d.[nUseCount] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                58,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAssignedGroupDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                59,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAssignedGroupDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAssignedGroupDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[tAssignedGroupDate] <> i.[tAssignedGroupDate] ) OR
                ( d.[tAssignedGroupDate] IS NULL AND i.[tAssignedGroupDate] IS NOT NULL ) OR
                ( i.[tAssignedGroupDate] IS NULL AND d.[tAssignedGroupDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tInServiceDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                60,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tInServiceDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tInServiceDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[tInServiceDate] <> i.[tInServiceDate] ) OR
                ( d.[tInServiceDate] IS NULL AND i.[tInServiceDate] IS NOT NULL ) OR
                ( i.[tInServiceDate] IS NULL AND d.[tInServiceDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tInventoryDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                61,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tInventoryDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tInventoryDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[tInventoryDate] <> i.[tInventoryDate] ) OR
                ( d.[tInventoryDate] IS NULL AND i.[tInventoryDate] IS NOT NULL ) OR
                ( i.[tInventoryDate] IS NULL AND d.[tInventoryDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tPurchaseDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                64,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tPurchaseDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tPurchaseDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[tPurchaseDate] <> i.[tPurchaseDate] ) OR
                ( d.[tPurchaseDate] IS NULL AND i.[tPurchaseDate] IS NOT NULL ) OR
                ( i.[tPurchaseDate] IS NULL AND d.[tPurchaseDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tStatusDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                65,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tStatusDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tStatusDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[tStatusDate] <> i.[tStatusDate] ) OR
                ( d.[tStatusDate] IS NULL AND i.[tStatusDate] IS NOT NULL ) OR
                ( i.[tStatusDate] IS NULL AND d.[tStatusDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tWarrantyDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                68,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tWarrantyDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tWarrantyDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[tWarrantyDate] <> i.[tWarrantyDate] ) OR
                ( d.[tWarrantyDate] IS NULL AND i.[tWarrantyDate] IS NOT NULL ) OR
                ( i.[tWarrantyDate] IS NULL AND d.[tWarrantyDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN
        
            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED
        
            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 3, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID
        END
    END
END
'

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Assets_Upd]', 'last', 'update', null

	        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	    END

		IF OBJECT_ID(N'[dbo].[spl_Assets_RETRIEVE]', 'P') IS NOT NULL
		BEGIN
			PRINT N'Dropping [dbo].[spl_Assets_RETRIEVE]'
			DROP PROCEDURE [dbo].[spl_Assets_RETRIEVE]

		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
		
		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

		IF OBJECT_ID(N'[dbo].[spl_Assets_RETRIEVE]', 'P') IS NULL
		BEGIN
			PRINT N'Creating [dbo].[spl_Assets_RETRIEVE]'

			EXEC sp_executesql N'		
/****************************************************************
	spl_Assets_RETRIEVE
	Retrieves a single record by ID from the Assets table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 10/5/2021 (R)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_Assets_RETRIEVE]
	
@nAssetUID uniqueidentifier


AS
BEGIN

	SELECT
[nAssetUID]
		,[nFacilityUID]
		,[nDepartmentUID]
		,[nTypeUID]
		,[nManufacturerUID]
		,[nCategoryUID]
		,[nSubCategoryUID]
		,[nInventoryByUID]
		,[nParentUID]
		,[nMaintenanceFacUID]
		,[nAssignedFacUID]
		,[nAuthorizedFacUID]
		,[cBarcode]
		,[cID]
		,[cSerialNumber]
		,[cModelNumber]
		,[cPartNumber]
		,[cStockNumber]
		,[cStatus]
		,[cDisposition]
		,[cAssignedGroup]
		,[cClass]
		,[cGroup]
		,[cFamily]
		,[cStandardType]
		,[cDescription]
		,[cPhysicalLocation]
		,[cWeightUOM]
		,[cWeight]
		,[cDimension]
		,[cAssignedContact]
		,[cOptional1]
		,[nReplacementCost]
		,[nItemCost]
		,[tInventoryDate]
		,[tInServiceDate]
		,[tStatusDate]
		,[tPurchaseDate]
		,[tAssignedGroupDate]
		,[tWarrantyDate]
		,[mWarrantyInfo]
		,[mAccuracy]
		,[mUncertaintyNotes]
		,[mNotes]
		,[lStandard]
		,[lRecallMaintenanceType]
		,[lInAbeyance]
		,[nAbeyanceInterval]
		,[nUseCount]
		,[nQuantity]
		,[lOnSite]
		,[lNonTracked]
		,[lOptional]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[Assets]
	WHERE
[nAssetUID] = @nAssetUID

	
	RETURN
		
END
'
		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
		
		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END
		
		IF OBJECT_ID(N'[dbo].[spl_Assets_LIST]', 'P') IS NOT NULL
		BEGIN
			PRINT N'Dropping [dbo].[spl_Assets_LIST]'
			DROP PROCEDURE [dbo].[spl_Assets_LIST]

		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
		
		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

		IF OBJECT_ID(N'[dbo].[spl_Assets_LIST]', 'P') IS NULL
		BEGIN
			PRINT N'Creating [dbo].[spl_Assets_LIST]'

			EXEC sp_executesql N'		
/****************************************************************
	spl_Assets_LIST
	Retrieves all records from the Assets table
	Optionally includes inactive records
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 10/5/2021 (L)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_Assets_LIST]
	
@includeInactive	INT	= 0

AS
BEGIN

	SELECT
[nAssetUID]
		,[nFacilityUID]
		,[nDepartmentUID]
		,[nTypeUID]
		,[nManufacturerUID]
		,[nCategoryUID]
		,[nSubCategoryUID]
		,[nInventoryByUID]
		,[nParentUID]
		,[nMaintenanceFacUID]
		,[nAssignedFacUID]
		,[nAuthorizedFacUID]
		,[cBarcode]
		,[cID]
		,[cSerialNumber]
		,[cModelNumber]
		,[cPartNumber]
		,[cStockNumber]
		,[cStatus]
		,[cDisposition]
		,[cAssignedGroup]
		,[cClass]
		,[cGroup]
		,[cFamily]
		,[cStandardType]
		,[cDescription]
		,[cPhysicalLocation]
		,[cWeightUOM]
		,[cWeight]
		,[cDimension]
		,[cAssignedContact]
		,[cOptional1]
		,[nReplacementCost]
		,[nItemCost]
		,[tInventoryDate]
		,[tInServiceDate]
		,[tStatusDate]
		,[tPurchaseDate]
		,[tAssignedGroupDate]
		,[tWarrantyDate]
		,[mWarrantyInfo]
		,[mAccuracy]
		,[mUncertaintyNotes]
		,[mNotes]
		,[lStandard]
		,[lRecallMaintenanceType]
		,[lInAbeyance]
		,[nAbeyanceInterval]
		,[nUseCount]
		,[nQuantity]
		,[lOnSite]
		,[lNonTracked]
		,[lOptional]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[Assets]
	WHERE
		ABS(lActive) + @includeInactive > 0
		AND
		lDeleted = 0
	
	RETURN
		
END
'
		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
		
		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

		IF OBJECT_ID(N'[dbo].[spl_Assets_INSERT]', 'P') IS NOT NULL
		BEGIN
			PRINT N'Dropping [dbo].[spl_Assets_INSERT]'
			DROP PROCEDURE [dbo].[spl_Assets_INSERT]

		    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
		
		    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		END

		IF OBJECT_ID(N'[dbo].[spl_Assets_INSERT]', 'P') IS NULL
		BEGIN
			PRINT N'Creating [dbo].[spl_Assets_INSERT]'
			
			EXEC sp_executesql N'	
/****************************************************************
	spl_Assets_INSERT
	Inserts a new record into the Assets table
	(c) 2011-2021 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 10/5/2021 (I)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_Assets_INSERT]
	
@nFacilityUID uniqueidentifier 
	,@nDepartmentUID uniqueidentifier  = NULL 
	,@nTypeUID uniqueidentifier 
	,@nManufacturerUID uniqueidentifier  = NULL 
	,@nCategoryUID uniqueidentifier  = NULL 
	,@nSubCategoryUID uniqueidentifier  = NULL 
	,@nInventoryByUID uniqueidentifier  = NULL 
	,@nParentUID uniqueidentifier  = NULL 
	,@nMaintenanceFacUID uniqueidentifier  = NULL 
	,@nAssignedFacUID uniqueidentifier  = NULL 
	,@nAuthorizedFacUID uniqueidentifier  = NULL 
	,@cBarcode nvarchar(100)  = NULL 
	,@cID nvarchar(100)  = NULL 
	,@cSerialNumber nvarchar(50)  = NULL 
	,@cModelNumber nvarchar(100)  = NULL 
	,@cPartNumber nvarchar(50)  = NULL 
	,@cStockNumber nvarchar(50)  = NULL 
	,@cStatus nvarchar(50)  = NULL 
	,@cDisposition nvarchar(50)  = NULL 
	,@cAssignedGroup nvarchar(50)  = NULL 
	,@cClass nvarchar(50)  = NULL 
	,@cGroup nvarchar(50)  = NULL 
	,@cFamily nvarchar(50)  = NULL 
	,@cStandardType nvarchar(50)  = NULL 
	,@cDescription nvarchar(100)  = NULL 
	,@cPhysicalLocation nvarchar(50)  = NULL 
	,@cWeightUOM nvarchar(50)  = NULL 
	,@cWeight nvarchar(50)  = NULL 
	,@cDimension nvarchar(50)  = NULL 
	,@cAssignedContact nvarchar(150)  = NULL 
	,@cOptional1 nvarchar(150)  = NULL 
	,@nReplacementCost numeric(18, 2)  = 0 
	,@nItemCost numeric(18, 2)  = 0 
	,@tInventoryDate datetime  = NULL 
	,@tInServiceDate datetime  = NULL 
	,@tStatusDate datetime  = NULL 
	,@tPurchaseDate datetime  = NULL 
	,@tAssignedGroupDate datetime  = NULL 
	,@tWarrantyDate datetime  = NULL 
	,@mWarrantyInfo nvarchar(max)  = NULL 
	,@mAccuracy nvarchar(max)  = NULL 
	,@mUncertaintyNotes nvarchar(max)  = NULL 
	,@mNotes nvarchar(max)  = NULL 
	,@lStandard int  = NULL 
	,@lRecallMaintenanceType int  = -1 
	,@lInAbeyance int  = NULL 
	,@nAbeyanceInterval int  = NULL 
	,@nUseCount int  = 0 
	,@nQuantity int  = 1 
	,@lOnSite int  = NULL 
	,@lNonTracked int  = NULL 
	,@lOptional int  = 0 
	,@lActive int  = -1 
	,@lDeleted int  = 0 
	,@lApproved int  = 0 
	,@lAdded int  = -1 
	,@nAddFacilityUID uniqueidentifier  = ''DBA97ADF-F868-459D-8343-DE1DF0FFB398'' 
	,@nAddUserUID uniqueidentifier  = ''915F9722-3175-4E4D-A571-4A478E8E5172'' 
	,@nImportUID uniqueidentifier  = NULL 

	,@nAssetUID [uniqueidentifier] = NULL OUTPUT

AS
BEGIN

	DECLARE @ID [uniqueidentifier] = NEWID()

	INSERT INTO [dbo].[Assets] (
		[nAssetUID]
,[nFacilityUID]
		,[nDepartmentUID]
		,[nTypeUID]
		,[nManufacturerUID]
		,[nCategoryU